/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import org.eclipse.jetty.server.resource.RangeWriter;
import org.eclipse.jetty.util.BufferUtil;

public class SeekableByteChannelRangeWriter
implements RangeWriter {
    public static final int NO_PROGRESS_LIMIT = 3;
    private final ChannelSupplier channelSupplier;
    private final int bufSize;
    private final ByteBuffer buffer;
    private SeekableByteChannel channel;
    private long pos;
    private boolean defaultSeekMode = true;

    /*
     * WARNING - void declaration
     */
    public SeekableByteChannelRangeWriter(ChannelSupplier channelSupplier) {
        this(null, (ChannelSupplier)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SeekableByteChannelRangeWriter(SeekableByteChannel initialChannel, ChannelSupplier channelSupplier) {
        void var2_2;
        void var1_1;
        this.channel = var1_1;
        this.channelSupplier = var2_2;
        this.bufSize = 65536;
        this.buffer = BufferUtil.allocate((int)this.bufSize);
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeTo(OutputStream outputStream, long skipTo, long length) throws IOException {
        this.skipTo(skipTo);
        long readTotal = 0L;
        while (readTotal < length) {
            void var2_3;
            BufferUtil.clearToFill((ByteBuffer)this.buffer);
            int size = (int)Math.min((long)this.bufSize, length - readTotal);
            this.buffer.limit(size);
            int readLen = this.channel.read(this.buffer);
            BufferUtil.flipToFlush((ByteBuffer)this.buffer, (int)0);
            BufferUtil.writeTo((ByteBuffer)this.buffer, (OutputStream)outputStream);
            readTotal += (long)readLen;
            this.pos += (long)var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void skipTo(long skipTo) throws IOException {
        void var1_1;
        if (this.channel == null) {
            this.channel = this.channelSupplier.newSeekableByteChannel();
            this.pos = 0L;
        }
        if (this.defaultSeekMode) {
            try {
                if (this.channel.position() != skipTo) {
                    this.channel.position(skipTo);
                    this.pos = skipTo;
                    return;
                }
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.defaultSeekMode = false;
            }
        }
        this.fallbackSkipTo((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void fallbackSkipTo(long skipTo) throws IOException {
        if (skipTo < this.pos) {
            this.channel.close();
            this.channel = this.channelSupplier.newSeekableByteChannel();
            this.pos = 0L;
        }
        if (this.pos < skipTo) {
            void var1_1;
            long skipSoFar = this.pos;
            int noProgressLoopLimit = 3;
            while (noProgressLoopLimit > 0 && skipSoFar < skipTo) {
                BufferUtil.clearToFill((ByteBuffer)this.buffer);
                int len = (int)Math.min((long)this.bufSize, skipTo - skipSoFar);
                this.buffer.limit(len);
                long actualSkipped = this.channel.read(this.buffer);
                if (actualSkipped == 0L) {
                    --noProgressLoopLimit;
                    continue;
                }
                if (actualSkipped > 0L) {
                    skipSoFar += actualSkipped;
                    noProgressLoopLimit = 3;
                    continue;
                }
                throw new IOException("EOF reached before SeekableByteChannel skip destination");
            }
            if (noProgressLoopLimit <= 0) {
                throw new IOException("No progress made to reach SeekableByteChannel skip position " + (skipTo - this.pos));
            }
            this.pos = var1_1;
        }
    }

    public static interface ChannelSupplier {
        public SeekableByteChannel newSeekableByteChannel() throws IOException;
    }
}

