/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.gzip;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.gzip.GzipFactory;
import org.eclipse.jetty.server.handler.gzip.GzipHttpInputInterceptor;
import org.eclipse.jetty.server.handler.gzip.GzipHttpOutputInterceptor;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.RegexSet;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class GzipHandler
extends HandlerWrapper
implements GzipFactory {
    public static final String GZIP_HANDLER_ETAGS = "o.e.j.s.h.gzip.GzipHandler.etag";
    public static final String GZIP = "gzip";
    public static final String DEFLATE = "deflate";
    public static final int DEFAULT_MIN_GZIP_SIZE = 32;
    public static final int BREAK_EVEN_GZIP_SIZE = 23;
    private static final Logger LOG = Log.getLogger(GzipHandler.class);
    private static final HttpField X_CE_GZIP = new PreEncodedHttpField("X-Content-Encoding", "gzip");
    private static final Pattern COMMA_GZIP = Pattern.compile(".*, *gzip");
    private int _poolCapacity = -1;
    private DeflaterPool _deflaterPool = null;
    private int _minGzipSize = 32;
    private int _compressionLevel = -1;
    @Deprecated
    private boolean _checkGzExists = false;
    private boolean _syncFlush = false;
    private int _inflateBufferSize = -1;
    private EnumSet<DispatcherType> _dispatchers = EnumSet.of(DispatcherType.REQUEST);
    private final IncludeExclude<String> _agentPatterns = new IncludeExclude(RegexSet.class);
    private final IncludeExclude<String> _methods = new IncludeExclude();
    private final IncludeExclude<String> _paths = new IncludeExclude(PathSpecSet.class);
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude();
    private HttpField _vary;

    /*
     * WARNING - void declaration
     */
    public GzipHandler() {
        this._methods.include((Object)HttpMethod.GET.asString());
        for (String type : MimeTypes.getKnownMimeTypes()) {
            void var2_2;
            if ("image/svg+xml".equals(type)) {
                this._paths.exclude((Object)"*.svgz");
                continue;
            }
            if (!type.startsWith("image/") && !type.startsWith("audio/") && !type.startsWith("video/")) continue;
            this._mimeTypes.exclude((Object)var2_2);
        }
        this._mimeTypes.exclude((Object)"application/compress");
        this._mimeTypes.exclude((Object)"application/zip");
        this._mimeTypes.exclude((Object)"application/gzip");
        this._mimeTypes.exclude((Object)"application/bzip2");
        this._mimeTypes.exclude((Object)"application/brotli");
        this._mimeTypes.exclude((Object)"application/x-xz");
        this._mimeTypes.exclude((Object)"application/x-rar-compressed");
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} mime types {}", new Object[]{this, this._mimeTypes});
        }
        this._agentPatterns.exclude((Object)".*MSIE 6.0.*");
    }

    /*
     * WARNING - void declaration
     */
    public void addExcludedAgentPatterns(String ... patterns) {
        void var1_1;
        this._agentPatterns.exclude((Object[])var1_1);
    }

    public void addExcludedMethods(String ... methods) {
        String[] stringArray = methods;
        int n = methods.length;
        for (int i = 0; i < n; ++i) {
            String m = stringArray[i];
            this._methods.exclude((Object)m);
        }
    }

    public EnumSet<DispatcherType> getDispatcherTypes() {
        return this._dispatchers;
    }

    /*
     * WARNING - void declaration
     */
    public void setDispatcherTypes(EnumSet<DispatcherType> dispatchers) {
        void var1_1;
        this._dispatchers = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setDispatcherTypes(DispatcherType ... dispatchers) {
        void var1_1;
        this._dispatchers = EnumSet.copyOf(Arrays.asList(var1_1));
    }

    public void addExcludedMimeTypes(String ... types) {
        String[] stringArray = types;
        int n = types.length;
        for (int i = 0; i < n; ++i) {
            String t = stringArray[i];
            this._mimeTypes.exclude((Object[])StringUtil.csvSplit((String)t));
        }
    }

    public void addExcludedPaths(String ... pathspecs) {
        String[] stringArray = pathspecs;
        int n = pathspecs.length;
        for (int i = 0; i < n; ++i) {
            String p = stringArray[i];
            this._paths.exclude((Object[])StringUtil.csvSplit((String)p));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addIncludedAgentPatterns(String ... patterns) {
        void var1_1;
        this._agentPatterns.include((Object[])var1_1);
    }

    public void addIncludedMethods(String ... methods) {
        String[] stringArray = methods;
        int n = methods.length;
        for (int i = 0; i < n; ++i) {
            String m = stringArray[i];
            this._methods.include((Object)m);
        }
    }

    public boolean isSyncFlush() {
        return this._syncFlush;
    }

    /*
     * WARNING - void declaration
     */
    public void setSyncFlush(boolean syncFlush) {
        void var1_1;
        this._syncFlush = var1_1;
    }

    public void addIncludedMimeTypes(String ... types) {
        String[] stringArray = types;
        int n = types.length;
        for (int i = 0; i < n; ++i) {
            String t = stringArray[i];
            this._mimeTypes.include((Object[])StringUtil.csvSplit((String)t));
        }
    }

    public void addIncludedPaths(String ... pathspecs) {
        String[] stringArray = pathspecs;
        int n = pathspecs.length;
        for (int i = 0; i < n; ++i) {
            String p = stringArray[i];
            this._paths.include((Object[])StringUtil.csvSplit((String)p));
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._deflaterPool = this.newDeflaterPool(this._poolCapacity);
        GzipHandler gzipHandler = this;
        gzipHandler.addBean(gzipHandler._deflaterPool);
        this._vary = this._agentPatterns.size() > 0 ? GzipHttpOutputInterceptor.VARY_ACCEPT_ENCODING_USER_AGENT : GzipHttpOutputInterceptor.VARY_ACCEPT_ENCODING;
        super.doStart();
    }

    @Deprecated
    public boolean getCheckGzExists() {
        return this._checkGzExists;
    }

    public int getCompressionLevel() {
        return this._compressionLevel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Deflater getDeflater(Request request, long contentLength) {
        void var2_2;
        HttpFields httpFields = request.getHttpFields();
        String ua = httpFields.get(HttpHeader.USER_AGENT);
        if (ua != null && !this.isAgentGzipable(ua)) {
            LOG.debug("{} excluded user agent {}", new Object[]{this, request});
            return null;
        }
        if (contentLength >= 0L && var2_2 < (long)this._minGzipSize) {
            LOG.debug("{} excluded minGzipSize {}", new Object[]{this, request});
            return null;
        }
        if (!httpFields.contains(HttpHeader.ACCEPT_ENCODING, GZIP)) {
            void var1_1;
            LOG.debug("{} excluded not gzip accept {}", new Object[]{this, var1_1});
            return null;
        }
        return (Deflater)this._deflaterPool.acquire();
    }

    public String[] getExcludedAgentPatterns() {
        Set set = this._agentPatterns.getExcluded();
        return set.toArray(new String[0]);
    }

    public String[] getExcludedMethods() {
        Set set = this._methods.getExcluded();
        return set.toArray(new String[0]);
    }

    public String[] getExcludedMimeTypes() {
        Set set = this._mimeTypes.getExcluded();
        return set.toArray(new String[0]);
    }

    public String[] getExcludedPaths() {
        Set set = this._paths.getExcluded();
        return set.toArray(new String[0]);
    }

    public String[] getIncludedAgentPatterns() {
        Set set = this._agentPatterns.getIncluded();
        return set.toArray(new String[0]);
    }

    public String[] getIncludedMethods() {
        Set set = this._methods.getIncluded();
        return set.toArray(new String[0]);
    }

    public String[] getIncludedMimeTypes() {
        Set set = this._mimeTypes.getIncluded();
        return set.toArray(new String[0]);
    }

    public String[] getIncludedPaths() {
        Set set = this._paths.getIncluded();
        return set.toArray(new String[0]);
    }

    @Deprecated
    public String[] getMethods() {
        return this.getIncludedMethods();
    }

    public int getMinGzipSize() {
        return this._minGzipSize;
    }

    protected HttpField getVaryField() {
        return this._vary;
    }

    public int getInflateBufferSize() {
        return this._inflateBufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setInflateBufferSize(int size) {
        void var1_1;
        this._inflateBufferSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        File file;
        String realpath;
        ServletContext context = baseRequest.getServletContext();
        String path = context == null ? baseRequest.getRequestURI() : URIUtil.addPaths((String)baseRequest.getServletPath(), (String)baseRequest.getPathInfo());
        LOG.debug("{} handle {} in {}", new Object[]{this, baseRequest, context});
        if (!this._dispatchers.contains(baseRequest.getDispatcherType())) {
            LOG.debug("{} excluded by dispatcherType {}", new Object[]{this, baseRequest.getDispatcherType()});
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        if (this._inflateBufferSize > 0 && !baseRequest.isHandled()) {
            boolean inflate = false;
            ListIterator i = baseRequest.getHttpFields().listIterator();
            while (i.hasNext()) {
                HttpField field = (HttpField)i.next();
                if (field.getHeader() != HttpHeader.CONTENT_ENCODING) continue;
                if (field.getValue().equalsIgnoreCase(GZIP)) {
                    i.set(X_CE_GZIP);
                    inflate = true;
                    break;
                }
                if (!COMMA_GZIP.matcher(field.getValue()).matches()) continue;
                String v = field.getValue();
                v = v.substring(0, v.lastIndexOf(44));
                i.set(new HttpField(HttpHeader.CONTENT_ENCODING, v));
                i.add(X_CE_GZIP);
                inflate = true;
                break;
            }
            if (inflate) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} inflate {}", new Object[]{this, request});
                }
                baseRequest.getHttpInput().addInterceptor(new GzipHttpInputInterceptor(baseRequest.getHttpChannel().getByteBufferPool(), this._inflateBufferSize));
                baseRequest.getHttpFields().computeField(HttpHeader.CONTENT_LENGTH, (header, fields) -> {
                    Object object;
                    void var1_1;
                    if (fields == null) {
                        return null;
                    }
                    Object length = var1_1.stream().map(HttpField::getValue).findAny().orElse("0");
                    return new HttpField("X-Content-Length", (String)object);
                });
            }
        }
        if (response.isCommitted()) {
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        HttpOutput out = baseRequest.getResponse().getHttpOutput();
        for (HttpOutput.Interceptor interceptor = out.getInterceptor(); interceptor != null; interceptor = interceptor.getNextInterceptor()) {
            if (!(interceptor instanceof GzipHttpOutputInterceptor)) continue;
            LOG.debug("{} already intercepting {}", new Object[]{this, request});
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        if (!StringUtil.isEmpty((String)CompressedContentFormat.ETAG_SEPARATOR)) {
            ListIterator fields2 = baseRequest.getHttpFields().listIterator();
            while (fields2.hasNext()) {
                String etags;
                String etagsNoSuffix;
                HttpField field = (HttpField)fields2.next();
                if (field.getHeader() != HttpHeader.IF_NONE_MATCH && field.getHeader() != HttpHeader.IF_MATCH || (etagsNoSuffix = CompressedContentFormat.GZIP.stripSuffixes(etags = field.getValue())).equals(etags)) continue;
                fields2.set(new HttpField(field.getHeader(), etagsNoSuffix));
                baseRequest.setAttribute(GZIP_HANDLER_ETAGS, etags);
            }
        }
        if (!this._methods.test((Object)baseRequest.getMethod())) {
            LOG.debug("{} excluded by method {}", new Object[]{this, request});
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        if (!this.isPathGzipable(path)) {
            LOG.debug("{} excluded by path {}", new Object[]{this, request});
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        String mimeType = context == null ? MimeTypes.getDefaultMimeByExtension((String)path) : context.getMimeType(path);
        if (mimeType != null && !this.isMimeTypeGzipable(mimeType = HttpFields.valueParameters((String)mimeType, null))) {
            LOG.debug("{} excluded by path suffix mime type {}", new Object[]{this, request});
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        if (this._checkGzExists && context != null && (realpath = request.getServletContext().getRealPath(path)) != null && (file = new File(realpath + ".gz")).exists()) {
            LOG.debug("{} gzip exists {}", new Object[]{this, request});
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        HttpOutput.Interceptor origInterceptor = out.getInterceptor();
        try {
            GzipHandler gzipHandler = this;
            out.setInterceptor(new GzipHttpOutputInterceptor(gzipHandler, gzipHandler.getVaryField(), baseRequest.getHttpChannel(), origInterceptor, this.isSyncFlush()));
            if (this._handler != null) {
                void var3_4;
                void var1_1;
                this._handler.handle((String)var1_1, baseRequest, (HttpServletRequest)var3_4, response);
            }
            if (!baseRequest.isHandled() && !baseRequest.isAsyncStarted()) {
                out.setInterceptor(origInterceptor);
                return;
            }
        }
        catch (Throwable throwable) {
            void var2_3;
            if (!baseRequest.isHandled() && !var2_3.isAsyncStarted()) {
                out.setInterceptor(origInterceptor);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isAgentGzipable(String ua) {
        void var1_1;
        if (ua == null) {
            return false;
        }
        return this._agentPatterns.test((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isMimeTypeGzipable(String mimetype) {
        void var1_1;
        return this._mimeTypes.test((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isPathGzipable(String requestURI) {
        void var1_1;
        if (requestURI == null) {
            return true;
        }
        return this._paths.test((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void recycle(Deflater deflater) {
        void var1_1;
        this._deflaterPool.release((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setCheckGzExists(boolean checkGzExists) {
        void var1_1;
        this._checkGzExists = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setCompressionLevel(int compressionLevel) {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._compressionLevel = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludedAgentPatterns(String ... patterns) {
        void var1_1;
        this._agentPatterns.getExcluded().clear();
        this.addExcludedAgentPatterns((String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludedMethods(String ... methods) {
        void var1_1;
        this._methods.getExcluded().clear();
        this._methods.exclude((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludedMimeTypes(String ... types) {
        void var1_1;
        this._mimeTypes.getExcluded().clear();
        this._mimeTypes.exclude((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludedPaths(String ... pathspecs) {
        void var1_1;
        this._paths.getExcluded().clear();
        this._paths.exclude((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludedAgentPatterns(String ... patterns) {
        void var1_1;
        this._agentPatterns.getIncluded().clear();
        this.addIncludedAgentPatterns((String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludedMethods(String ... methods) {
        void var1_1;
        this._methods.getIncluded().clear();
        this._methods.include((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludedMimeTypes(String ... types) {
        void var1_1;
        this._mimeTypes.getIncluded().clear();
        this._mimeTypes.include((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludedPaths(String ... pathspecs) {
        void var1_1;
        this._paths.getIncluded().clear();
        this._paths.include((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMinGzipSize(int minGzipSize) {
        void var1_1;
        if (minGzipSize < 23) {
            LOG.warn("minGzipSize of {} is inefficient for short content, break even is size {}", new Object[]{minGzipSize, 23});
        }
        this._minGzipSize = Math.max(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludedMethodList(String csvMethods) {
        void var1_1;
        this.setIncludedMethods(StringUtil.csvSplit((String)var1_1));
    }

    public String getIncludedMethodList() {
        return String.join((CharSequence)",", this.getIncludedMethods());
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludedMethodList(String csvMethods) {
        void var1_1;
        this.setExcludedMethods(StringUtil.csvSplit((String)var1_1));
    }

    public String getExcludedMethodList() {
        return String.join((CharSequence)",", this.getExcludedMethods());
    }

    public int getDeflaterPoolCapacity() {
        return this._poolCapacity;
    }

    /*
     * WARNING - void declaration
     */
    public void setDeflaterPoolCapacity(int capacity) {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._poolCapacity = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected DeflaterPool newDeflaterPool(int capacity) {
        void var1_1;
        return new DeflaterPool((int)var1_1, this.getCompressionLevel(), true);
    }

    public String toString() {
        return String.format("%s@%x{%s,min=%s,inflate=%s}", this.getClass().getSimpleName(), this.hashCode(), this.getState(), this._minGzipSize, this._inflateBufferSize);
    }
}

