/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.InetAddressSet;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;

public class ThreadLimitHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(ThreadLimitHandler.class);
    private static final String REMOTE = "o.e.j.s.h.TLH.REMOTE";
    private static final String PERMIT = "o.e.j.s.h.TLH.PASS";
    private final boolean _rfc7239;
    private final String _forwardedHeader;
    private final IncludeExcludeSet<String, InetAddress> _includeExcludeSet = new IncludeExcludeSet(InetAddressSet.class);
    private final ConcurrentMap<String, Remote> _remotes = new ConcurrentHashMap<String, Remote>();
    private volatile boolean _enabled;
    private int _threadLimit = 10;

    public ThreadLimitHandler() {
        this(null, false);
    }

    /*
     * WARNING - void declaration
     */
    public ThreadLimitHandler(@Name(value="forwardedHeader") String forwardedHeader) {
        this(forwardedHeader, HttpHeader.FORWARDED.is((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ThreadLimitHandler(@Name(value="forwardedHeader") String forwardedHeader, @Name(value="rfc7239") boolean rfc7239) {
        void var1_1;
        void var2_2;
        this._rfc7239 = var2_2;
        this._forwardedHeader = var1_1;
        this._enabled = true;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        LOG.info(String.format("ThreadLimitHandler enable=%b limit=%d include=%s", this._enabled, this._threadLimit, this._includeExcludeSet), new Object[0]);
    }

    @ManagedAttribute(value="true if this handler is enabled")
    public boolean isEnabled() {
        return this._enabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabled(boolean enabled) {
        void var1_1;
        this._enabled = var1_1;
        LOG.info(String.format("ThreadLimitHandler enable=%b limit=%d include=%s", this._enabled, this._threadLimit, this._includeExcludeSet), new Object[0]);
    }

    @ManagedAttribute(value="The maximum threads that can be dispatched per remote IP")
    public int getThreadLimit() {
        return this._threadLimit;
    }

    /*
     * WARNING - void declaration
     */
    public void setThreadLimit(int threadLimit) {
        void var1_1;
        if (threadLimit <= 0) {
            throw new IllegalArgumentException("limit must be >0");
        }
        this._threadLimit = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @ManagedOperation(value="Include IP in thread limits")
    public void include(String inetAddressPattern) {
        void var1_1;
        this._includeExcludeSet.include((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ManagedOperation(value="Exclude IP from thread limits")
    public void exclude(String inetAddressPattern) {
        void var1_1;
        this._includeExcludeSet.exclude((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this._enabled) {
            super.handle(target, baseRequest, request, response);
            return;
        }
        Remote remote = this.getRemote(baseRequest);
        if (remote == null) {
            super.handle(target, baseRequest, request, response);
            return;
        }
        try (Closeable permit = (Closeable)baseRequest.getAttribute(PERMIT);){
            void var3_4;
            void var2_3;
            void var1_1;
            if (permit != null) {
                baseRequest.removeAttribute(PERMIT);
            } else {
                CompletableFuture<Closeable> futurePermit = remote.acquire();
                if (futurePermit.isDone()) {
                    permit = futurePermit.get();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Threadlimited {} {}", new Object[]{remote, target});
                    }
                    AsyncContext async = baseRequest.startAsync();
                    async.setTimeout(0L);
                    futurePermit.thenAccept(arg_0 -> ThreadLimitHandler.lambda$handle$0(baseRequest, (AsyncContext)var1_1, arg_0));
                    return;
                }
            }
            super.handle((String)var1_1, (Request)var2_3, (HttpServletRequest)var3_4, response);
            if (permit != null) {
                permit.close();
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int getThreadLimit(String ip) {
        if (!this._includeExcludeSet.isEmpty()) {
            try {
                if (!this._includeExcludeSet.test((Object)InetAddress.getByName(ip))) {
                    LOG.debug("excluded {}", new Object[]{ip});
                    return 0;
                }
            }
            catch (Exception e) {
                void var1_2;
                LOG.ignore((Throwable)var1_2);
            }
        }
        return this._threadLimit;
    }

    /*
     * WARNING - void declaration
     */
    protected Remote getRemote(Request baseRequest) {
        void var2_2;
        void var1_1;
        Remote r;
        void var3_3;
        Remote remote = (Remote)baseRequest.getAttribute(REMOTE);
        if (remote != null) {
            return remote;
        }
        String ip = this.getRemoteIP(baseRequest);
        LOG.debug("ip={}", new Object[]{ip});
        if (ip == null) {
            return null;
        }
        int limit = this.getThreadLimit(ip);
        if (limit <= 0) {
            return null;
        }
        remote = (Remote)this._remotes.get(ip);
        if (remote == null && (remote = this._remotes.putIfAbsent((String)var3_3, r = new Remote(ip, limit))) == null) {
            remote = r;
        }
        var1_1.setAttribute(REMOTE, remote);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected String getRemoteIP(Request baseRequest) {
        void var1_1;
        String remote;
        if (this._forwardedHeader != null && !this._forwardedHeader.isEmpty() && (remote = this._rfc7239 ? this.getForwarded(baseRequest) : this.getXForwardedFor(baseRequest)) != null && !remote.isEmpty()) {
            return remote;
        }
        InetSocketAddress inetAddr = var1_1.getHttpChannel().getRemoteAddress();
        if (inetAddr != null && inetAddr.getAddress() != null) {
            void var2_2;
            return var2_2.getAddress().getHostAddress();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getForwarded(Request request) {
        Object object;
        RFC7239 rfc7239 = new RFC7239();
        object = ((Request)object).getHttpFields();
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            HttpField field = (HttpField)object.next();
            if (!this._forwardedHeader.equalsIgnoreCase(field.getName())) continue;
            rfc7239.addValue(var3_3.getValue());
        }
        if (rfc7239.getFor() != null) {
            void var2_2;
            return new HostPortHttpField(var2_2.getFor()).getHost();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getXForwardedFor(Request request) {
        void var2_3;
        String forwardedFor = null;
        request = ((Request)request).getHttpFields();
        request = request.iterator();
        while (request.hasNext()) {
            void var3_4;
            HttpField field = (HttpField)request.next();
            if (!this._forwardedHeader.equalsIgnoreCase(field.getName())) continue;
            forwardedFor = var3_4.getValue();
        }
        if (forwardedFor == null || forwardedFor.isEmpty()) {
            return null;
        }
        int comma = forwardedFor.lastIndexOf(44);
        if (comma >= 0) {
            void var1_2;
            return forwardedFor.substring((int)(var1_2 + true)).trim();
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$handle$0(Request baseRequest, AsyncContext async, Closeable c) {
        void var1_1;
        void var2_2;
        baseRequest.setAttribute(PERMIT, var2_2);
        var1_1.dispatch();
    }

    private final class RFC7239
    extends QuotedCSV {
        String _for;

        private RFC7239() {
            super(false, new String[0]);
        }

        final String getFor() {
            return this._for;
        }

        /*
         * WARNING - void declaration
         */
        protected final void parsedParam(StringBuffer buffer, int valueLength, int paramName, int paramValue) {
            if (valueLength == 0 && paramValue > paramName) {
                void var2_3;
                void var3_4;
                String name = StringUtil.asciiToLowerCase((String)buffer.substring((int)var3_4, paramValue - 1));
                if ("for".equalsIgnoreCase((String)var2_3)) {
                    void var1_1;
                    String value = buffer.substring(paramValue);
                    if ("unknown".equalsIgnoreCase(value)) {
                        this._for = null;
                        return;
                    }
                    this._for = var1_1;
                }
            }
        }
    }

    private final class Remote
    implements Closeable {
        private final String _ip;
        private final int _limit;
        private final Locker _locker = new Locker();
        private int _permits;
        private Deque<CompletableFuture<Closeable>> _queue = new ArrayDeque<CompletableFuture<Closeable>>();
        private final CompletableFuture<Closeable> _permitted = CompletableFuture.completedFuture(this);

        /*
         * WARNING - void declaration
         */
        public Remote(String ip, int limit) {
            void var3_3;
            void var2_2;
            this._ip = var2_2;
            this._limit = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public final CompletableFuture<Closeable> acquire() {
            void var3_5;
            block8: {
                void var2_3;
                Locker.Lock lock;
                block6: {
                    CompletableFuture<Closeable> completableFuture;
                    block7: {
                        lock = this._locker.lock();
                        try {
                            if (this._permits >= this._limit) break block6;
                            ++this._permits;
                            completableFuture = this._permitted;
                            if (lock == null) break block7;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    void var1_1;
                                    var1_1.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        lock.close();
                    }
                    return completableFuture;
                }
                CompletableFuture pass = new CompletableFuture();
                this._queue.addLast(pass);
                var3_5 = var2_3;
                if (lock == null) break block8;
                lock.close();
            }
            return var3_5;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void close() throws IOException {
            Locker.Lock lock = this._locker.lock();
            try {
                CompletableFuture<Closeable> permit;
                --this._permits;
                while ((permit = this._queue.pollFirst()) != null) {
                    void var2_3;
                    if (!var2_3.complete(this)) continue;
                    ++this._permits;
                    break;
                }
                if (lock == null) return;
            }
            catch (Throwable throwable) {
                if (lock == null) throw throwable;
                try {
                    void var1_1;
                    var1_1.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            lock.close();
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            String string;
            block5: {
                Locker.Lock lock = this._locker.lock();
                try {
                    string = String.format("R[ip=%s,p=%d,l=%d,q=%d]", this._ip, this._permits, this._limit, this._queue.size());
                    if (lock == null) break block5;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            void var1_1;
                            var1_1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                lock.close();
            }
            return string;
        }
    }
}

