/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.Callback;

public class SizeLimitHandler
extends HandlerWrapper {
    private final long _requestLimit;
    private final long _responseLimit;

    /*
     * WARNING - void declaration
     */
    public SizeLimitHandler(long requestLimit, long responseLimit) {
        void var3_2;
        void var1_1;
        this._requestLimit = var1_1;
        this._responseLimit = var3_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkRequestLimit(long size) {
        if (this._requestLimit >= 0L && size > this._requestLimit) {
            void var1_1;
            throw new BadMessageException(413, "Request body is too large: " + (long)var1_1 + ">" + this._requestLimit);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkResponseLimit(long size) {
        if (this._responseLimit >= 0L && size > this._responseLimit) {
            void var1_1;
            throw new BadMessageException(500, "Response body is too large: " + (long)var1_1 + ">" + this._responseLimit);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this._requestLimit >= 0L || this._responseLimit >= 0L) {
            HttpOutput httpOutput = baseRequest.getResponse().getHttpOutput();
            HttpOutput.Interceptor interceptor = httpOutput.getInterceptor();
            LimitInterceptor limit = new LimitInterceptor(interceptor);
            if (this._requestLimit >= 0L) {
                long contentLength = baseRequest.getContentLengthLong();
                this.checkRequestLimit(contentLength);
                if (contentLength < 0L) {
                    baseRequest.getHttpInput().addInterceptor(limit);
                }
            }
            if (this._responseLimit >= 0L) {
                httpOutput.setInterceptor(limit);
                response = new LimitResponse((HttpServletResponse)response);
            }
        }
        super.handle((String)var1_1, (Request)var2_2, (HttpServletRequest)var3_3, (HttpServletResponse)response);
    }

    private class LimitResponse
    extends HttpServletResponseWrapper {
        /*
         * WARNING - void declaration
         */
        public LimitResponse(HttpServletResponse response) {
            void var2_2;
            super((HttpServletResponse)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void setContentLength(int len) {
            void var1_1;
            SizeLimitHandler.this.checkResponseLimit(len);
            super.setContentLength((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setContentLengthLong(long len) {
            void var1_1;
            SizeLimitHandler.this.checkResponseLimit(len);
            super.setContentLengthLong((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setHeader(String name, String value) {
            void var2_2;
            void var1_1;
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                SizeLimitHandler.this.checkResponseLimit(Long.parseLong(value));
            }
            super.setHeader((String)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void addHeader(String name, String value) {
            void var2_2;
            void var1_1;
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                SizeLimitHandler.this.checkResponseLimit(Long.parseLong(value));
            }
            super.addHeader((String)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void setIntHeader(String name, int value) {
            void var2_2;
            void var1_1;
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                SizeLimitHandler.this.checkResponseLimit(value);
            }
            super.setIntHeader((String)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void addIntHeader(String name, int value) {
            void var2_2;
            void var1_1;
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                SizeLimitHandler.this.checkResponseLimit(value);
            }
            super.addIntHeader((String)var1_1, (int)var2_2);
        }
    }

    private class LimitInterceptor
    implements HttpInput.Interceptor,
    HttpOutput.Interceptor {
        private final HttpOutput.Interceptor _nextOutput;
        long _read;
        long _written;

        /*
         * WARNING - void declaration
         */
        public LimitInterceptor(HttpOutput.Interceptor nextOutput) {
            void var2_2;
            this._nextOutput = var2_2;
        }

        @Override
        public HttpOutput.Interceptor getNextInterceptor() {
            return this._nextOutput;
        }

        @Override
        public boolean isOptimizedForDirectBuffers() {
            return this._nextOutput.isOptimizedForDirectBuffers();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public HttpInput.Content readFrom(HttpInput.Content content) {
            void var1_1;
            if (content == null) {
                return null;
            }
            if (content.hasContent()) {
                this._read += (long)content.remaining();
                SizeLimitHandler.this.checkRequestLimit(this._read);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(ByteBuffer content, boolean last, Callback callback) {
            void var3_4;
            void var2_3;
            void var1_1;
            if (content.hasRemaining()) {
                this._written += (long)content.remaining();
                try {
                    SizeLimitHandler.this.checkResponseLimit(this._written);
                }
                catch (Throwable t) {
                    void var1_2;
                    callback.failed((Throwable)var1_2);
                    return;
                }
            }
            this.getNextInterceptor().write((ByteBuffer)var1_1, (boolean)var2_3, (Callback)var3_4);
        }

        @Override
        public void resetBuffer() {
            this._written = 0L;
            this.getNextInterceptor().resetBuffer();
        }
    }
}

