/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ShutdownHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(ShutdownHandler.class);
    private final String _shutdownToken;
    private boolean _sendShutdownAtStart;
    private boolean _exitJvm = false;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ShutdownHandler(Server server, String shutdownToken) {
        this((String)var2_2);
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ShutdownHandler(String shutdownToken) {
        this((String)var1_1, false, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ShutdownHandler(String shutdownToken, boolean exitJVM, boolean sendShutdownAtStart) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._shutdownToken = var1_1;
        this.setExitJvm((boolean)var2_2);
        this.setSendShutdownAtStart((boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void sendShutdown() throws IOException {
        URL url = new URL(this.getServerUrl() + "/shutdown?token=" + this._shutdownToken);
        try {
            void var1_1;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.getResponseCode();
            LOG.info("Shutting down " + var1_1 + ": " + connection.getResponseCode() + " " + connection.getResponseMessage(), new Object[0]);
            return;
        }
        catch (SocketException socketException) {
            LOG.debug("Not running", new Object[0]);
            return;
        }
        catch (IOException e) {
            void var2_3;
            throw new RuntimeException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getServerUrl() {
        void var1_1;
        NetworkConnector connector = null;
        for (Connector c : this.getServer().getConnectors()) {
            if (!(c instanceof NetworkConnector)) continue;
            connector = (NetworkConnector)c;
            break;
        }
        if (connector == null) {
            return "http://localhost";
        }
        return "http://localhost:" + var1_1.getPort();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this._sendShutdownAtStart) {
            this.sendShutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        void var2_2;
        void var3_3;
        if (!target.equals("/shutdown")) {
            void var1_1;
            super.handle((String)var1_1, baseRequest, request, response);
            return;
        }
        if (!request.getMethod().equals("POST")) {
            response.sendError(400);
            return;
        }
        if (!this.hasCorrectSecurityToken(request)) {
            LOG.warn("Unauthorized tokenless shutdown attempt from " + request.getRemoteAddr(), new Object[0]);
            response.sendError(401);
            return;
        }
        if (!this.requestFromLocalhost(baseRequest)) {
            LOG.warn("Unauthorized non-loopback shutdown attempt from " + request.getRemoteAddr(), new Object[0]);
            response.sendError(401);
            return;
        }
        LOG.info("Shutting down by request from " + var3_3.getRemoteAddr(), new Object[0]);
        this.doShutdown((Request)var2_2, response);
    }

    /*
     * WARNING - void declaration
     */
    protected void doShutdown(Request baseRequest, HttpServletResponse response) throws IOException {
        void var2_2;
        void var1_1;
        Connector[] connectorArray = this.getServer().getConnectors();
        int n = connectorArray.length;
        for (int i = 0; i < n; ++i) {
            Connector connector = connectorArray[i];
            connector.shutdown();
        }
        var1_1.setHandled(true);
        response.setStatus(200);
        var2_2.flushBuffer();
        Server server = this.getServer();
        new Thread(this, (Server)connectorArray){
            final /* synthetic */ Server val$server;
            final /* synthetic */ ShutdownHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$server = server;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                try {
                    ShutdownHandler.access$000(this.this$0, this.val$server);
                    return;
                }
                catch (InterruptedException e) {
                    LOG.ignore((Throwable)e);
                    return;
                }
                catch (Exception e) {
                    void var1_2;
                    throw new RuntimeException("Shutting down server", (Throwable)var1_2);
                }
            }
        }.start();
    }

    /*
     * WARNING - void declaration
     */
    private boolean requestFromLocalhost(Request request) {
        void var1_1;
        InetSocketAddress addr = request.getRemoteInetSocketAddress();
        if (addr == null) {
            return false;
        }
        return var1_1.getAddress().isLoopbackAddress();
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasCorrectSecurityToken(HttpServletRequest request) {
        void var1_1;
        String tok = request.getParameter("token");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Token: {}", new Object[]{tok});
        }
        return this._shutdownToken.equals(var1_1);
    }

    private void shutdownServer(Server server) throws Exception {
        server.stop();
        if (this._exitJvm) {
            System.exit(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setExitJvm(boolean exitJvm) {
        void var1_1;
        this._exitJvm = var1_1;
    }

    public boolean isSendShutdownAtStart() {
        return this._sendShutdownAtStart;
    }

    /*
     * WARNING - void declaration
     */
    public void setSendShutdownAtStart(boolean sendShutdownAtStart) {
        void var1_1;
        this._sendShutdownAtStart = var1_1;
    }

    public String getShutdownToken() {
        return this._shutdownToken;
    }

    public boolean isExitJvm() {
        return this._exitJvm;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(ShutdownHandler x0, Server x1) throws Exception {
        void var1_1;
        x0.shutdownServer((Server)var1_1);
    }
}

