/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ResourceContentFactory;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceHandler
extends HandlerWrapper
implements ResourceService.WelcomeFactory,
ResourceFactory {
    private static final Logger LOG = Log.getLogger(ResourceHandler.class);
    Resource _baseResource;
    ContextHandler _context;
    Resource _defaultStylesheet;
    MimeTypes _mimeTypes;
    private final ResourceService _resourceService;
    Resource _stylesheet;
    String[] _welcomes = new String[]{"index.html"};

    /*
     * WARNING - void declaration
     */
    public ResourceHandler(ResourceService resourceService) {
        void var1_1;
        this._resourceService = var1_1;
    }

    public ResourceHandler() {
        this(new ResourceService(){

            @Override
            protected void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
            }
        });
        this._resourceService.setGzipEquivalentFileExtensions(new ArrayList<String>(Arrays.asList(".svgz")));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getWelcomeFile(String pathInContext) {
        if (this._welcomes == null) {
            return null;
        }
        for (int i = 0; i < this._welcomes.length; ++i) {
            void var3_3;
            String welcomeInContext = URIUtil.addPaths((String)pathInContext, (String)this._welcomes[i]);
            Resource welcome = this.getResource(welcomeInContext);
            if (welcome == null || !welcome.exists()) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doStart() throws Exception {
        void var1_1;
        ContextHandler.Context scontext = ContextHandler.getCurrentContext();
        ContextHandler contextHandler = this._context = scontext == null ? null : var1_1.getContextHandler();
        if (this._mimeTypes == null) {
            this._mimeTypes = this._context == null ? new MimeTypes() : this._context.getMimeTypes();
        }
        ResourceHandler resourceHandler = this;
        this._resourceService.setContentFactory(new ResourceContentFactory(resourceHandler, resourceHandler._mimeTypes, this._resourceService.getPrecompressedFormats()));
        this._resourceService.setWelcomeFactory(this);
        super.doStart();
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getCacheControl() {
        return this._resourceService.getCacheControl().getValue();
    }

    public List<String> getGzipEquivalentFileExtensions() {
        return this._resourceService.getGzipEquivalentFileExtensions();
    }

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    @Deprecated
    public int getMinAsyncContentLength() {
        return -1;
    }

    @Deprecated
    public int getMinMemoryMappedContentLength() {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public Resource getResource(String path) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} getResource({})", new Object[]{this._context == null ? this._baseResource : this._context, this._baseResource, path});
        }
        if (path == null || !path.startsWith("/")) {
            return null;
        }
        try {
            void var1_1;
            Resource r = null;
            if (this._baseResource != null) {
                r = this._baseResource.addPath(path);
                if (r != null && r.isAlias() && (this._context == null || !this._context.checkAlias(path, r))) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("resource={} alias={}", new Object[]{r, r.getAlias()});
                    }
                    return null;
                }
            } else if (this._context != null) {
                r = this._context.getResource(path);
            }
            if ((r == null || !r.exists()) && var1_1.endsWith("/jetty-dir.css")) {
                r = this.getStylesheet();
            }
            return r;
        }
        catch (Exception e) {
            void var2_3;
            LOG.debug((Throwable)var2_3);
            return null;
        }
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public Resource getStylesheet() {
        if (this._stylesheet != null) {
            return this._stylesheet;
        }
        if (this._defaultStylesheet == null) {
            this._defaultStylesheet = ResourceHandler.getDefaultStylesheet();
        }
        return this._defaultStylesheet;
    }

    public static Resource getDefaultStylesheet() {
        return Resource.newResource((URL)ResourceHandler.class.getResource("/jetty-dir.css"));
    }

    public String[] getWelcomeFiles() {
        return this._welcomes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (baseRequest.isHandled()) {
            return;
        }
        if (!HttpMethod.GET.is(request.getMethod()) && !HttpMethod.HEAD.is(request.getMethod())) {
            super.handle(target, baseRequest, request, response);
            return;
        }
        if (this._resourceService.doGet(request, response)) {
            baseRequest.setHandled(true);
            return;
        }
        super.handle((String)var1_1, (Request)var2_2, (HttpServletRequest)var3_3, response);
    }

    public boolean isAcceptRanges() {
        return this._resourceService.isAcceptRanges();
    }

    public boolean isDirAllowed() {
        return this._resourceService.isDirAllowed();
    }

    public boolean isDirectoriesListed() {
        return this._resourceService.isDirAllowed();
    }

    public boolean isEtags() {
        return this._resourceService.isEtags();
    }

    @Deprecated
    public boolean isGzip() {
        for (CompressedContentFormat formats : this._resourceService.getPrecompressedFormats()) {
            if (!CompressedContentFormat.GZIP.getEncoding().equals(formats.getEncoding())) continue;
            return true;
        }
        return false;
    }

    public CompressedContentFormat[] getPrecompressedFormats() {
        return this._resourceService.getPrecompressedFormats();
    }

    public boolean isPathInfoOnly() {
        return this._resourceService.isPathInfoOnly();
    }

    public boolean isRedirectWelcome() {
        return this._resourceService.isRedirectWelcome();
    }

    /*
     * WARNING - void declaration
     */
    public void setAcceptRanges(boolean acceptRanges) {
        void var1_1;
        this._resourceService.setAcceptRanges((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setBaseResource(Resource base) {
        void var1_1;
        this._baseResource = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setCacheControl(String cacheControl) {
        void var1_1;
        this._resourceService.setCacheControl((HttpField)new PreEncodedHttpField(HttpHeader.CACHE_CONTROL, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDirAllowed(boolean dirAllowed) {
        void var1_1;
        this._resourceService.setDirAllowed((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setDirectoriesListed(boolean directory) {
        void var1_1;
        this._resourceService.setDirAllowed((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setEtags(boolean etags) {
        void var1_1;
        this._resourceService.setEtags((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setGzip(boolean gzip) {
        CompressedContentFormat[] compressedContentFormatArray;
        void var1_1;
        if (var1_1 != false) {
            CompressedContentFormat[] compressedContentFormatArray2 = new CompressedContentFormat[1];
            compressedContentFormatArray = compressedContentFormatArray2;
            compressedContentFormatArray2[0] = CompressedContentFormat.GZIP;
        } else {
            compressedContentFormatArray = new CompressedContentFormat[]{};
        }
        this.setPrecompressedFormats(compressedContentFormatArray);
    }

    /*
     * WARNING - void declaration
     */
    public void setGzipEquivalentFileExtensions(List<String> gzipEquivalentFileExtensions) {
        void var1_1;
        this._resourceService.setGzipEquivalentFileExtensions((List<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPrecompressedFormats(CompressedContentFormat[] precompressedFormats) {
        void var1_1;
        this._resourceService.setPrecompressedFormats((CompressedContentFormat[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMimeTypes(MimeTypes mimeTypes) {
        void var1_1;
        this._mimeTypes = var1_1;
    }

    @Deprecated
    public void setMinAsyncContentLength(int minAsyncContentLength) {
    }

    @Deprecated
    public void setMinMemoryMappedContentLength(int minMemoryMappedFileSize) {
    }

    /*
     * WARNING - void declaration
     */
    public void setPathInfoOnly(boolean pathInfoOnly) {
        void var1_1;
        this._resourceService.setPathInfoOnly((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setRedirectWelcome(boolean redirectWelcome) {
        void var1_1;
        this._resourceService.setRedirectWelcome((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(Resource.newResource((String)resourceBase));
            return;
        }
        catch (Exception e) {
            void var1_1;
            void var2_2;
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug((Throwable)var2_2);
            throw new IllegalArgumentException((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setStylesheet(String stylesheet) {
        try {
            this._stylesheet = Resource.newResource((String)stylesheet);
            if (!this._stylesheet.exists()) {
                LOG.warn("unable to find custom stylesheet: " + stylesheet, new Object[0]);
                this._stylesheet = null;
            }
            return;
        }
        catch (Exception e) {
            void var1_1;
            void var2_2;
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug((Throwable)var2_2);
            throw new IllegalArgumentException((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setWelcomeFiles(String[] welcomeFiles) {
        void var1_1;
        this._welcomes = var1_1;
    }
}

