/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.URIUtil;

public class MovedContextHandler
extends ContextHandler {
    final Redirector _redirector;
    String _newContextURL;
    boolean _discardPathInfo;
    boolean _discardQuery;
    boolean _permanent;
    String _expires;

    public MovedContextHandler() {
        this._redirector = new Redirector();
        MovedContextHandler movedContextHandler = this;
        movedContextHandler.setHandler(movedContextHandler._redirector);
        this.setAllowNullPathInfo(true);
    }

    /*
     * WARNING - void declaration
     */
    public MovedContextHandler(HandlerContainer parent, String contextPath, String newContextURL) {
        super((HandlerContainer)var1_1, (String)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this._newContextURL = var3_3;
        this._redirector = new Redirector();
        MovedContextHandler movedContextHandler = this;
        movedContextHandler.setHandler(movedContextHandler._redirector);
    }

    public boolean isDiscardPathInfo() {
        return this._discardPathInfo;
    }

    /*
     * WARNING - void declaration
     */
    public void setDiscardPathInfo(boolean discardPathInfo) {
        void var1_1;
        this._discardPathInfo = var1_1;
    }

    public String getNewContextURL() {
        return this._newContextURL;
    }

    /*
     * WARNING - void declaration
     */
    public void setNewContextURL(String newContextURL) {
        void var1_1;
        this._newContextURL = var1_1;
    }

    public boolean isPermanent() {
        return this._permanent;
    }

    /*
     * WARNING - void declaration
     */
    public void setPermanent(boolean permanent) {
        void var1_1;
        this._permanent = var1_1;
    }

    public boolean isDiscardQuery() {
        return this._discardQuery;
    }

    /*
     * WARNING - void declaration
     */
    public void setDiscardQuery(boolean discardQuery) {
        void var1_1;
        this._discardQuery = var1_1;
    }

    public String getExpires() {
        return this._expires;
    }

    /*
     * WARNING - void declaration
     */
    public void setExpires(String expires) {
        void var1_1;
        this._expires = var1_1;
    }

    private class Redirector
    extends AbstractHandler {
        private Redirector() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            void var2_2;
            if (MovedContextHandler.this._newContextURL == null) {
                return;
            }
            String path = MovedContextHandler.this._newContextURL;
            if (!MovedContextHandler.this._discardPathInfo && request.getPathInfo() != null) {
                path = URIUtil.addPaths((String)path, (String)request.getPathInfo());
            }
            StringBuilder location = URIUtil.hasScheme((String)path) ? new StringBuilder() : baseRequest.getRootURL();
            location.append(path);
            if (!MovedContextHandler.this._discardQuery && request.getQueryString() != null) {
                void var1_1;
                void var3_3;
                location.append('?');
                path = var3_3.getQueryString();
                String q = path.replaceAll("\r\n?&=", "!");
                location.append((String)var1_1);
            }
            response.setHeader(HttpHeader.LOCATION.asString(), location.toString());
            if (MovedContextHandler.this._expires != null) {
                response.setHeader(HttpHeader.EXPIRES.asString(), MovedContextHandler.this._expires);
            }
            response.setStatus(MovedContextHandler.this._permanent ? 301 : 302);
            response.setContentLength(0);
            var2_2.setHandled(true);
        }
    }
}

