/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ManagedAttributeListener
implements ServletContextAttributeListener,
ServletContextListener {
    private static final Logger LOG = Log.getLogger(ManagedAttributeListener.class);
    final Set<String> _managedAttributes = new HashSet<String>();
    final ContextHandler _context;

    /*
     * WARNING - void declaration
     */
    public ManagedAttributeListener(ContextHandler context, String ... managedAttributes) {
        void var2_2;
        void var1_1;
        this._context = var1_1;
        for (void attr : var2_2) {
            this._managedAttributes.add((String)attr);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("managedAttributes {}", new Object[]{this._managedAttributes});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void attributeReplaced(ServletContextAttributeEvent event) {
        if (this._managedAttributes.contains(event.getName())) {
            void var1_1;
            this.updateBean(event.getName(), event.getValue(), event.getServletContext().getAttribute(var1_1.getName()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void attributeRemoved(ServletContextAttributeEvent event) {
        if (this._managedAttributes.contains(event.getName())) {
            void var1_1;
            this.updateBean(event.getName(), var1_1.getValue(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void attributeAdded(ServletContextAttributeEvent event) {
        if (this._managedAttributes.contains(event.getName())) {
            void var1_1;
            this.updateBean(event.getName(), null, var1_1.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void contextInitialized(ServletContextEvent event) {
        for (String name : this._context.getServletContext().getAttributeNameSet()) {
            void var3_3;
            if (!this._managedAttributes.contains(name)) continue;
            this.updateBean(name, null, event.getServletContext().getAttribute((String)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void contextDestroyed(ServletContextEvent event) {
        for (String name : this._context.getServletContext().getAttributeNameSet()) {
            void var3_3;
            if (!this._managedAttributes.contains(name)) continue;
            this.updateBean(name, event.getServletContext().getAttribute((String)var3_3), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void updateBean(String name, Object oldBean, Object newBean) {
        void var3_3;
        void var2_2;
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("update {} {}->{} on {}", new Object[]{var1_1, oldBean, newBean, this._context});
        }
        this._context.updateBean(var2_2, var3_3, false);
    }
}

