/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.InetAddressSet;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InetAccessHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(InetAccessHandler.class);
    private final IncludeExcludeSet<String, InetAddress> _addrs = new IncludeExcludeSet(InetAddressSet.class);
    private final IncludeExclude<String> _names = new IncludeExclude();

    public void clear() {
        this._addrs.clear();
        this._names.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void include(String pattern) {
        void var1_1;
        this._addrs.include((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void include(String ... patterns) {
        void var1_1;
        this._addrs.include((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void exclude(String pattern) {
        void var1_1;
        this._addrs.exclude((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void exclude(String ... patterns) {
        void var1_1;
        this._addrs.exclude((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void includeConnector(String name) {
        void var1_1;
        this._names.include((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void excludeConnector(String name) {
        void var1_1;
        this._names.exclude((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void includeConnectors(String ... names) {
        void var1_1;
        this._names.include((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void excludeConnectors(String ... names) {
        void var1_1;
        this._names.exclude((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        void var3_3;
        void var2_2;
        void var1_1;
        InetSocketAddress address;
        EndPoint endp;
        HttpChannel channel = baseRequest.getHttpChannel();
        if (channel != null && (endp = channel.getEndPoint()) != null && (address = endp.getRemoteAddress()) != null && !this.isAllowed(address.getAddress(), baseRequest, request)) {
            response.sendError(403);
            baseRequest.setHandled(true);
            return;
        }
        this.getHandler().handle((String)var1_1, (Request)var2_2, (HttpServletRequest)var3_3, response);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isAllowed(InetAddress addr, Request baseRequest, HttpServletRequest request) {
        void var3_4;
        String name = baseRequest.getHttpChannel().getConnector().getName();
        boolean filterAppliesToConnector = this._names.test((Object)name);
        boolean allowedByAddr = this._addrs.test((Object)addr);
        if (LOG.isDebugEnabled()) {
            void var1_1;
            void var2_2;
            LOG.debug("name = {}/{} addr={}/{} appliesToConnector={} allowedByAddr={}", new Object[]{var2_2, this._names, var1_1, this._addrs, filterAppliesToConnector, allowedByAddr});
        }
        if (var3_4 == false) {
            return true;
        }
        return allowedByAddr;
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        this.dumpObjects((Appendable)var1_1, (String)var2_2, new Object[]{new DumpableCollection("included", (Collection)this._addrs.getIncluded()), new DumpableCollection("excluded", (Collection)this._addrs.getExcluded()), new DumpableCollection("includedConnector", (Collection)this._names.getIncluded()), new DumpableCollection("excludedConnector", (Collection)this._names.getExcluded())});
    }
}

