/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class IdleTimeoutHandler
extends HandlerWrapper {
    private long _idleTimeoutMs = 1000L;
    private boolean _applyToAsync = false;

    public boolean isApplyToAsync() {
        return this._applyToAsync;
    }

    /*
     * WARNING - void declaration
     */
    public void setApplyToAsync(boolean applyToAsync) {
        void var1_1;
        this._applyToAsync = var1_1;
    }

    public long getIdleTimeoutMs() {
        return this._idleTimeoutMs;
    }

    /*
     * WARNING - void declaration
     */
    public void setIdleTimeoutMs(long idleTimeoutMs) {
        void var1_1;
        this._idleTimeoutMs = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpChannel channel = baseRequest.getHttpChannel();
        long idle_timeout = baseRequest.getHttpChannel().getIdleTimeout();
        channel.setIdleTimeout(this._idleTimeoutMs);
        try {
            void var2_3;
            void var1_1;
            super.handle((String)var1_1, (Request)var2_3, request, response);
        }
        catch (Throwable throwable) {
            if (this._applyToAsync && request.isAsyncStarted()) {
                void var3_4;
                var3_4.getAsyncContext().addListener(new AsyncListener(this, channel, idle_timeout){
                    final /* synthetic */ HttpChannel val$channel;
                    final /* synthetic */ long val$idle_timeout;
                    final /* synthetic */ IdleTimeoutHandler this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$channel = httpChannel;
                        this.val$idle_timeout = l;
                    }

                    public void onTimeout(AsyncEvent event) throws IOException {
                    }

                    public void onStartAsync(AsyncEvent event) throws IOException {
                    }

                    public void onError(AsyncEvent event) throws IOException {
                        this.val$channel.setIdleTimeout(this.val$idle_timeout);
                    }

                    public void onComplete(AsyncEvent event) throws IOException {
                        this.val$channel.setIdleTimeout(this.val$idle_timeout);
                    }
                });
            } else {
                channel.setIdleTimeout(idle_timeout);
            }
            throw throwable;
        }
        if (this._applyToAsync && request.isAsyncStarted()) {
            request.getAsyncContext().addListener(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        channel.setIdleTimeout(idle_timeout);
    }
}

