/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.IPAddressMap;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@Deprecated
public class IPAccessHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(IPAccessHandler.class);
    PathMap<IPAddressMap<Boolean>> _white = new PathMap(true);
    PathMap<IPAddressMap<Boolean>> _black = new PathMap(true);
    boolean _whiteListByPath = false;

    public IPAccessHandler() {
    }

    /*
     * WARNING - void declaration
     */
    public IPAccessHandler(String[] white, String[] black) {
        if (white != null && white.length > 0) {
            void var1_1;
            this.setWhite((String[])var1_1);
        }
        if (black != null && black.length > 0) {
            void var2_2;
            this.setBlack((String[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addWhite(String entry) {
        void var1_1;
        this.add((String)var1_1, this._white);
    }

    /*
     * WARNING - void declaration
     */
    public void addBlack(String entry) {
        void var1_1;
        this.add((String)var1_1, this._black);
    }

    /*
     * WARNING - void declaration
     */
    public void setWhite(String[] entries) {
        void var1_1;
        this.set((String[])var1_1, this._white);
    }

    /*
     * WARNING - void declaration
     */
    public void setBlack(String[] entries) {
        void var1_1;
        this.set((String[])var1_1, this._black);
    }

    /*
     * WARNING - void declaration
     */
    public void setWhiteListByPath(boolean whiteListByPath) {
        void var1_1;
        this._whiteListByPath = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        void var3_3;
        void var2_2;
        void var1_1;
        InetSocketAddress address;
        EndPoint endp;
        HttpChannel channel = baseRequest.getHttpChannel();
        if (channel != null && (endp = channel.getEndPoint()) != null && (address = endp.getRemoteAddress()) != null && !this.isAddrUriAllowed(address.getHostString(), baseRequest.getMetaData().getURI().getDecodedPath())) {
            response.sendError(403);
            baseRequest.setHandled(true);
            return;
        }
        this.getHandler().handle((String)var1_1, (Request)var2_2, (HttpServletRequest)var3_3, response);
    }

    /*
     * WARNING - void declaration
     */
    protected void add(String entry, PathMap<IPAddressMap<Boolean>> patternMap) {
        if (entry != null && entry.length() > 0) {
            void var3_3;
            IPAddressMap addrMap;
            String path;
            int idx;
            boolean deprecated = false;
            if (entry.indexOf(124) > 0) {
                idx = entry.indexOf(124);
            } else {
                idx = entry.indexOf(47);
                deprecated = idx >= 0;
            }
            String addr = idx > 0 ? entry.substring(0, idx) : entry;
            String string = path = idx > 0 ? entry.substring(idx) : "/*";
            if (addr.endsWith(".")) {
                deprecated = true;
            }
            if (path != null && (path.startsWith("|") || path.startsWith("/*."))) {
                path = path.substring(1);
            }
            if ((addrMap = (IPAddressMap)patternMap.get((Object)path)) == null) {
                void var2_2;
                addrMap = new IPAddressMap();
                var2_2.put(path, (Object)addrMap);
            }
            if (addr != null && !"".equals(addr)) {
                addrMap.put(addr, (Object)Boolean.TRUE);
            }
            if (var3_3 != false) {
                void var1_1;
                LOG.debug(this.toString() + " - deprecated specification syntax: " + (String)var1_1, new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void set(String[] entries, PathMap<IPAddressMap<Boolean>> patternMap) {
        patternMap.clear();
        if (entries != null && entries.length > 0) {
            void var1_1;
            for (void addrPath : var1_1) {
                this.add((String)addrPath, patternMap);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isAddrUriAllowed(String addr, String path) {
        if (this._white.size() > 0) {
            void var3_3;
            boolean match = false;
            boolean matchedByPath = false;
            for (Map.Entry entry : this._white.getMatches(path)) {
                matchedByPath = true;
                IPAddressMap addrMap = (IPAddressMap)entry.getValue();
                if (addrMap == null || addrMap.size() != 0 && addrMap.match(addr) == null) continue;
                match = true;
                break;
            }
            if (this._whiteListByPath ? matchedByPath && !match : var3_3 == false) {
                return false;
            }
        }
        if (this._black.size() > 0) {
            void var2_2;
            for (Map.Entry entry : this._black.getMatches((String)var2_2)) {
                IPAddressMap addrMap = (IPAddressMap)entry.getValue();
                if (addrMap == null || addrMap.size() != 0 && addrMap.match(addr) == null) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        this.dumpObjects((Appendable)var1_1, (String)var2_2, new Object[]{DumpableCollection.from((String)"white", (Object[])new Object[]{this._white}), DumpableCollection.from((String)"black", (Object[])new Object[]{this._black}), DumpableCollection.from((String)"whiteListByPath", (Object[])new Object[]{this._whiteListByPath})});
    }
}

