/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="Handler wrapping another Handler")
public class HandlerWrapper
extends AbstractHandlerContainer {
    protected Handler _handler;

    @ManagedAttribute(value="Wrapped Handler", readonly=true)
    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public Handler[] getHandlers() {
        if (this._handler == null) {
            return new Handler[0];
        }
        return new Handler[]{this._handler};
    }

    /*
     * WARNING - void declaration
     */
    public void setHandler(Handler handler) {
        void var2_2;
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        if (handler == this || handler instanceof HandlerContainer && Arrays.asList(((HandlerContainer)((Object)handler)).getChildHandlers()).contains(this)) {
            throw new IllegalStateException("setHandler loop");
        }
        if (handler != null) {
            handler.setServer(this.getServer());
        }
        Handler old = this._handler;
        this._handler = var1_1;
        this.updateBean(var2_2, this._handler, true);
    }

    /*
     * WARNING - void declaration
     */
    public void insertHandler(HandlerWrapper wrapper) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (wrapper == null) {
            throw new IllegalArgumentException();
        }
        HandlerWrapper tail = wrapper;
        while (tail.getHandler() instanceof HandlerWrapper) {
            tail = (HandlerWrapper)tail.getHandler();
        }
        if (tail.getHandler() != null) {
            throw new IllegalArgumentException("bad tail of inserted wrapper chain");
        }
        Handler next = this.getHandler();
        this.setHandler((Handler)var1_1);
        var2_2.setHandler((Handler)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Handler handler = this._handler;
        if (handler != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            handler.handle((String)var1_1, (Request)var2_2, (HttpServletRequest)var3_3, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void expandChildren(List<Handler> list, Class<?> byClass) {
        void var2_2;
        void var1_1;
        HandlerWrapper handlerWrapper = this;
        handlerWrapper.expandHandler(handlerWrapper._handler, (List<Handler>)var1_1, (Class<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler child = this.getHandler();
        if (child != null) {
            void var1_1;
            this.setHandler(null);
            var1_1.destroy();
        }
        super.destroy();
    }
}

