/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="Handler of multiple handlers")
public class HandlerCollection
extends AbstractHandlerContainer {
    private final boolean _mutableWhenRunning;
    protected final AtomicReference<Handlers> _handlers = new AtomicReference();

    public HandlerCollection() {
        this(false, new Handler[0]);
    }

    /*
     * WARNING - void declaration
     */
    public HandlerCollection(Handler ... handlers) {
        this(false, (Handler[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HandlerCollection(boolean mutableWhenRunning, Handler ... handlers) {
        void var1_1;
        this._mutableWhenRunning = var1_1;
        if (handlers.length > 0) {
            void var2_2;
            this.setHandlers((Handler[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManagedAttribute(value="Wrapped handlers", readonly=true)
    public Handler[] getHandlers() {
        void var1_1;
        Handlers handlers = this._handlers.get();
        if (handlers == null) {
            return null;
        }
        return ((Handlers)var1_1)._handlers;
    }

    public void setHandlers(Handler[] handlers) {
        HandlerCollection handlerCollection;
        if (!this._mutableWhenRunning && this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        do {
            handlerCollection = this;
        } while (!handlerCollection.updateHandlers(handlerCollection._handlers.get(), this.newHandlers(handlers)));
    }

    /*
     * WARNING - void declaration
     */
    protected Handlers newHandlers(Handler[] handlers) {
        void var1_1;
        if (handlers == null || handlers.length == 0) {
            return null;
        }
        return new Handlers((Handler[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean updateHandlers(Handlers old, Handlers handlers) {
        Object[] objectArray;
        if (handlers != null) {
            for (Handler handler : handlers._handlers) {
                if (handler != this && (!(handler instanceof HandlerContainer) || !Arrays.asList(((HandlerContainer)((Object)handler)).getChildHandlers()).contains(this))) continue;
                throw new IllegalStateException("setHandler loop");
            }
            objectArray = handlers._handlers;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                if (object.getServer() == this.getServer()) continue;
                object.setServer(this.getServer());
            }
        }
        if (this._handlers.compareAndSet(old, handlers)) {
            void var2_2;
            void var1_1;
            Handler[] oldBeans = old == null ? null : ((Handlers)var1_1)._handlers;
            Object[] newBeans = handlers == null ? null : ((Handlers)var2_2)._handlers;
            this.updateBeans(objectArray, newBeans);
            return true;
        }
        return false;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.isStarted()) {
            Handlers handlers = this._handlers.get();
            if (handlers == null) {
                return;
            }
            MultiException mex = null;
            for (Handler handler : handlers._handlers) {
                try {
                    handler.handle(target, baseRequest, request, response);
                }
                catch (IOException | RuntimeException exception) {
                    Exception exception2 = exception;
                    throw exception;
                }
                catch (Exception exception) {
                    if (mex == null) {
                        mex = new MultiException();
                    }
                    mex.add((Throwable)exception);
                }
            }
            if (mex != null) {
                if (mex.size() == 1) {
                    throw new ServletException(mex.getThrowable(0));
                }
                throw new ServletException(mex);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addHandler(Handler handler) {
        void var3_3;
        void var2_2;
        do {
            Handlers old;
            Handlers handlers = this.newHandlers((Handler[])ArrayUtil.addToArray((old = this._handlers.get()) == null ? null : (Handler[])ArrayUtil.removeFromArray((Object[])old._handlers, (Object)handler), (Object)handler, Handler.class));
        } while (!this.updateHandlers((Handlers)var2_2, (Handlers)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void prependHandler(Handler handler) {
        void var3_3;
        void var2_2;
        do {
            Handlers old;
            Handlers handlers = this.newHandlers((Handler[])ArrayUtil.prependToArray((Object)handler, (Object[])((old = this._handlers.get()) == null ? null : old._handlers), Handler.class));
        } while (!this.updateHandlers((Handlers)var2_2, (Handlers)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void removeHandler(Handler handler) {
        Handlers old;
        while ((old = this._handlers.get()) != null && old._handlers.length != 0) {
            void var3_3;
            void var2_2;
            Handlers handlers = this.newHandlers((Handler[])ArrayUtil.removeFromArray((Object[])old._handlers, (Object)handler));
            if (!this.updateHandlers((Handlers)var2_2, (Handlers)var3_3)) continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void expandChildren(List<Handler> list, Class<?> byClass) {
        Handler[] handlers = this.getHandlers();
        if (handlers != null) {
            void var3_3;
            for (void h : var3_3) {
                this.expandHandler((Handler)h, list, byClass);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void destroy() {
        void var1_1;
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler[] children = this.getChildHandlers();
        this.setHandlers(null);
        for (void var4_4 : var1_1) {
            var4_4.destroy();
        }
        super.destroy();
    }

    protected static class Handlers {
        private final Handler[] _handlers;

        /*
         * WARNING - void declaration
         */
        protected Handlers(Handler[] handlers) {
            void var1_1;
            this._handlers = var1_1;
        }

        public Handler[] getHandlers() {
            return this._handlers;
        }
    }
}

