/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.handler.BufferedResponseHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FileBufferedResponseHandler
extends BufferedResponseHandler {
    private static final Logger LOG = Log.getLogger(FileBufferedResponseHandler.class);
    private Path _tempDir = new File(System.getProperty("java.io.tmpdir")).toPath();

    public Path getTempDir() {
        return this._tempDir;
    }

    /*
     * WARNING - void declaration
     */
    public void setTempDir(Path tempDir) {
        void var1_1;
        this._tempDir = (Path)Objects.requireNonNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected BufferedResponseHandler.BufferedInterceptor newBufferedInterceptor(HttpChannel httpChannel, HttpOutput.Interceptor interceptor) {
        void var2_2;
        void var1_1;
        return new FileBufferedInterceptor(this, (HttpChannel)var1_1, (HttpOutput.Interceptor)var2_2);
    }

    class FileBufferedInterceptor
    implements BufferedResponseHandler.BufferedInterceptor {
        private static final int MAX_MAPPED_BUFFER_SIZE = 0x3FFFFFFF;
        private final HttpOutput.Interceptor _next;
        private final HttpChannel _channel;
        private Boolean _aggregating;
        private Path _filePath;
        private OutputStream _fileOutputStream;
        final /* synthetic */ FileBufferedResponseHandler this$0;

        /*
         * WARNING - void declaration
         */
        public FileBufferedInterceptor(FileBufferedResponseHandler this$0, HttpChannel httpChannel, HttpOutput.Interceptor interceptor) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.this$0 = var1_1;
            this._next = var3_3;
            this._channel = var2_2;
        }

        @Override
        public HttpOutput.Interceptor getNextInterceptor() {
            return this._next;
        }

        @Override
        public boolean isOptimizedForDirectBuffers() {
            return false;
        }

        @Override
        public void resetBuffer() {
            this.dispose();
            BufferedResponseHandler.BufferedInterceptor.super.resetBuffer();
        }

        /*
         * WARNING - void declaration
         */
        private void closeFileOutput() {
            if (this._fileOutputStream != null) {
                try {
                    this._fileOutputStream.flush();
                }
                catch (IOException e) {
                    void var1_1;
                    LOG.debug("flush failure", (Throwable)var1_1);
                }
                IO.close((OutputStream)this._fileOutputStream);
                this._fileOutputStream = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void dispose() {
            this.closeFileOutput();
            this._aggregating = null;
            if (this._filePath != null) {
                try {
                    Files.deleteIfExists(this._filePath);
                }
                catch (Throwable t) {
                    void var1_1;
                    LOG.debug("Could not immediately delete file (delaying to jvm exit) {}", new Object[]{this._filePath, var1_1});
                    this._filePath.toFile().deleteOnExit();
                }
                this._filePath = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(ByteBuffer content, boolean last, Callback callback) {
            void var3_4;
            void var2_3;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} write last={} {}", new Object[]{this, last, BufferUtil.toDetailString((ByteBuffer)content)});
            }
            if (this._aggregating == null) {
                this._aggregating = this.this$0.shouldBuffer(this._channel, last);
            }
            if (!this._aggregating.booleanValue()) {
                this.getNextInterceptor().write(content, last, callback);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} aggregating", new Object[]{this});
            }
            try {
                if (BufferUtil.hasContent((ByteBuffer)content)) {
                    this.aggregate(content);
                }
            }
            catch (Throwable t) {
                void var1_2;
                this.dispose();
                callback.failed((Throwable)var1_2);
                return;
            }
            if (var2_3 != false) {
                this.commit(callback);
                return;
            }
            var3_4.succeeded();
        }

        /*
         * WARNING - void declaration
         */
        private void aggregate(ByteBuffer content) throws IOException {
            void var1_1;
            if (this._fileOutputStream == null) {
                this._filePath = Files.createTempFile(this.this$0._tempDir, "BufferedResponse", "", new FileAttribute[0]);
                this._fileOutputStream = Files.newOutputStream(this._filePath, StandardOpenOption.WRITE);
            }
            BufferUtil.writeTo((ByteBuffer)var1_1, (OutputStream)this._fileOutputStream);
        }

        /*
         * WARNING - void declaration
         */
        private void commit(Callback callback) {
            void var1_1;
            if (this._fileOutputStream == null) {
                this.getNextInterceptor().write(BufferUtil.EMPTY_BUFFER, true, callback);
                return;
            }
            try {
                this.closeFileOutput();
            }
            catch (Throwable t) {
                void var2_2;
                this.dispose();
                callback.failed((Throwable)var2_2);
                return;
            }
            IteratingCallback iteratingCallback = new IteratingCallback(this, (Callback)var1_1){
                private final long fileLength;
                private long _pos;
                private boolean _last;
                final /* synthetic */ Callback val$callback;
                final /* synthetic */ FileBufferedInterceptor this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$callback = callback;
                    this.fileLength = this.this$1._filePath.toFile().length();
                    this._pos = 0L;
                    this._last = false;
                }

                /*
                 * WARNING - void declaration
                 */
                protected IteratingCallback.Action process() throws Exception {
                    void var1_1;
                    void var3_2;
                    if (this._last) {
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    long len = Math.min(0x3FFFFFFFL, this.fileLength - this._pos);
                    this._last = this._pos + len == this.fileLength;
                    ByteBuffer buffer = BufferUtil.toMappedBuffer((Path)this.this$1._filePath, (long)this._pos, (long)len);
                    this.this$1.getNextInterceptor().write((ByteBuffer)var3_2, this._last, (Callback)this);
                    this._pos += var1_1;
                    return IteratingCallback.Action.SCHEDULED;
                }

                protected void onCompleteSuccess() {
                    this.this$1.dispose();
                    this.val$callback.succeeded();
                }

                /*
                 * WARNING - void declaration
                 */
                protected void onCompleteFailure(Throwable cause) {
                    void var1_1;
                    this.this$1.dispose();
                    this.val$callback.failed((Throwable)var1_1);
                }
            };
            iteratingCallback.iterate();
        }
    }
}

