/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.eclipse.jetty.io.ByteBufferOutputStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ErrorHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(ErrorHandler.class);
    public static final String ERROR_PAGE = "org.eclipse.jetty.server.error_page";
    public static final String ERROR_CONTEXT = "org.eclipse.jetty.server.error_context";
    public static final String ERROR_CHARSET = "org.eclipse.jetty.server.error_charset";
    boolean _showServlet = true;
    boolean _showStacks = true;
    boolean _disableStacks = false;
    boolean _showMessageInTitle = true;
    String _cacheControl = "must-revalidate,no-cache,no-store";

    public boolean errorPageForMethod(String method) {
        switch (method) {
            case "GET": 
            case "POST": 
            case "HEAD": {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.doError((String)var1_1, (Request)var2_2, (HttpServletRequest)var3_3, response);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void doError(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void generateAcceptableResponse(Request baseRequest, HttpServletRequest request, HttpServletResponse response, int code, String message) throws IOException {
        List acceptable = baseRequest.getHttpFields().getQualityCSV(HttpHeader.ACCEPT, QuotedQualityCSV.MOST_SPECIFIC_MIME_ORDERING);
        if (acceptable.isEmpty() && !baseRequest.getHttpFields().contains(HttpHeader.ACCEPT)) {
            this.generateAcceptableResponse(baseRequest, request, response, code, message, MimeTypes.Type.TEXT_HTML.asString());
            return;
        }
        for (String mimeType : acceptable) {
            this.generateAcceptableResponse(baseRequest, request, response, code, message, mimeType);
            if (!response.isCommitted() && !baseRequest.getResponse().isWritingOrStreaming()) continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected Writer getAcceptableWriter(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Iterator iterator;
        List acceptable = baseRequest.getHttpFields().getQualityCSV(HttpHeader.ACCEPT_CHARSET);
        if (acceptable.isEmpty()) {
            response.setCharacterEncoding(StandardCharsets.ISO_8859_1.name());
            return response.getWriter();
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String charset = (String)iterator.next();
            try {
                if ("*".equals(charset)) {
                    response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                } else {
                    response.setCharacterEncoding(Charset.forName(charset).name());
                }
                return response.getWriter();
            }
            catch (Exception e) {
                void var2_3;
                LOG.ignore((Throwable)var2_3);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void generateAcceptableResponse(Request baseRequest, HttpServletRequest request, HttpServletResponse response, int code, String message, String contentType) throws IOException {
        void var1_1;
        MimeTypes.Type type;
        Charset charset = null;
        Object acceptable = baseRequest.getHttpFields().getQualityCSV(HttpHeader.ACCEPT_CHARSET);
        if (!acceptable.isEmpty()) {
            acceptable = acceptable.iterator();
            while (acceptable.hasNext()) {
                String name = (String)acceptable.next();
                if ("*".equals(name)) {
                    charset = StandardCharsets.UTF_8;
                    break;
                }
                try {
                    charset = Charset.forName(name);
                }
                catch (Exception e) {
                    LOG.ignore((Throwable)e);
                }
            }
            if (charset == null) {
                return;
            }
        }
        switch (contentType) {
            case "text/html": 
            case "text/*": 
            case "*/*": {
                type = MimeTypes.Type.TEXT_HTML;
                if (charset != null) break;
                charset = StandardCharsets.ISO_8859_1;
                break;
            }
            case "text/json": 
            case "application/json": {
                type = MimeTypes.Type.TEXT_JSON;
                if (charset != null) break;
                charset = StandardCharsets.UTF_8;
                break;
            }
            case "text/plain": {
                type = MimeTypes.Type.TEXT_PLAIN;
                if (charset != null) break;
                charset = StandardCharsets.ISO_8859_1;
                break;
            }
            default: {
                return;
            }
        }
        while (true) {
            try {
                ByteBuffer buffer = baseRequest.getResponse().getHttpOutput().getBuffer();
                ByteBufferOutputStream out = new ByteBufferOutputStream(buffer);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, charset));
                switch (type) {
                    case TEXT_HTML: {
                        response.setContentType(MimeTypes.Type.TEXT_HTML.asString());
                        response.setCharacterEncoding(charset.name());
                        request.setAttribute(ERROR_CHARSET, (Object)charset);
                        this.handleErrorPage(request, writer, code, message);
                        break;
                    }
                    case TEXT_JSON: {
                        response.setContentType(contentType);
                        this.writeErrorJson(request, writer, code, message);
                        break;
                    }
                    case TEXT_PLAIN: {
                        response.setContentType(MimeTypes.Type.TEXT_PLAIN.asString());
                        response.setCharacterEncoding(charset.name());
                        this.writeErrorPlain(request, writer, code, message);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                writer.flush();
            }
            catch (BufferOverflowException e) {
                LOG.warn("Error page too large: {} {} {}", new Object[]{code, message, request});
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Throwable)e);
                }
                baseRequest.getResponse().resetContent();
                if (this._disableStacks) break;
                LOG.info("Disabling showsStacks for " + this, new Object[0]);
                this._disableStacks = true;
                continue;
            }
            break;
        }
        var1_1.getHttpChannel().sendResponseAndComplete();
    }

    /*
     * WARNING - void declaration
     */
    protected void handleErrorPage(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeErrorPage((HttpServletRequest)var1_1, (Writer)var2_2, (int)var3_3, message, this._showStacks);
    }

    /*
     * WARNING - void declaration
     */
    protected void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        void var2_2;
        void var3_3;
        void var1_1;
        if (message == null) {
            message = HttpStatus.getMessage((int)code);
        }
        writer.write("<html>\n<head>\n");
        this.writeErrorPageHead(request, writer, code, message);
        writer.write("</head>\n<body>");
        this.writeErrorPageBody((HttpServletRequest)var1_1, writer, (int)var3_3, message, showStacks);
        var2_2.write("\n</body>\n</html>\n");
    }

    /*
     * WARNING - void declaration
     */
    protected void writeErrorPageHead(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        Charset charset = (Charset)request.getAttribute(ERROR_CHARSET);
        if (charset != null) {
            writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=");
            writer.write(charset.name());
            writer.write("\"/>\n");
        }
        writer.write("<title>Error ");
        String status = Integer.toString((int)var3_3);
        writer.write(status);
        if (message != null && !message.equals(var1_1)) {
            writer.write(32);
            writer.write(StringUtil.sanitizeXmlString((String)message));
        }
        var2_2.write("</title>\n");
    }

    /*
     * WARNING - void declaration
     */
    protected void writeErrorPageBody(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        String uri = request.getRequestURI();
        this.writeErrorPageMessage(request, writer, (int)var3_3, message, uri);
        if (showStacks && !this._disableStacks) {
            this.writeErrorPageStacks(request, writer);
        }
        Request.getBaseRequest((ServletRequest)var1_1).getHttpChannel().getHttpConfiguration().writePoweredBy((Appendable)var2_2, "<hr/>", "<hr/>\n");
    }

    /*
     * WARNING - void declaration
     */
    protected void writeErrorPageMessage(HttpServletRequest request, Writer writer, int code, String message, String uri) throws IOException {
        void var2_2;
        void var3_4;
        writer.write("<h2>HTTP ERROR ");
        String status = Integer.toString(code);
        writer.write(status);
        if (message != null && !message.equals(status)) {
            writer.write(32);
            writer.write(StringUtil.sanitizeXmlString((String)message));
        }
        writer.write("</h2>\n");
        writer.write("<table>\n");
        this.htmlRow(writer, "URI", uri);
        this.htmlRow(writer, "STATUS", var3_4);
        this.htmlRow(writer, "MESSAGE", message);
        if (this.isShowServlet()) {
            this.htmlRow(writer, "SERVLET", request.getAttribute("javax.servlet.error.servlet_name"));
        }
        for (Throwable cause = (Throwable)request.getAttribute("javax.servlet.error.exception"); cause != null; cause = cause.getCause()) {
            this.htmlRow(writer, "CAUSED BY", cause);
        }
        var2_2.write("</table>\n");
    }

    /*
     * WARNING - void declaration
     */
    private void htmlRow(Writer writer, String tag, Object value) throws IOException {
        void var1_1;
        void var2_2;
        writer.write("<tr><th>");
        writer.write((String)var2_2);
        writer.write(":</th><td>");
        if (value == null) {
            writer.write("-");
        } else {
            void var3_3;
            writer.write(StringUtil.sanitizeXmlString((String)var3_3.toString()));
        }
        var1_1.write("</td></tr>\n");
    }

    /*
     * WARNING - void declaration
     */
    private void writeErrorPlain(HttpServletRequest request, PrintWriter writer, int code, String message) {
        void var3_3;
        writer.write("HTTP ERROR ");
        writer.write(Integer.toString(code));
        writer.write(32);
        writer.write(StringUtil.sanitizeXmlString((String)message));
        writer.write("\n");
        writer.printf("URI: %s%n", request.getRequestURI());
        writer.printf("STATUS: %s%n", (int)var3_3);
        writer.printf("MESSAGE: %s%n", message);
        if (this.isShowServlet()) {
            writer.printf("SERVLET: %s%n", request.getAttribute("javax.servlet.error.servlet_name"));
        }
        for (Throwable cause = (Throwable)request.getAttribute("javax.servlet.error.exception"); cause != null; cause = cause.getCause()) {
            writer.printf("CAUSED BY %s%n", cause);
            if (!this.isShowStacks() || this._disableStacks) continue;
            cause.printStackTrace(writer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeErrorJson(HttpServletRequest request, PrintWriter writer, int code, String message) {
        void var2_3;
        void var3_4;
        Throwable cause = (Throwable)request.getAttribute("javax.servlet.error.exception");
        Object servlet = request.getAttribute("javax.servlet.error.servlet_name");
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("url", request.getRequestURI());
        json.put("status", Integer.toString((int)var3_4));
        json.put("message", message);
        if (this.isShowServlet() && servlet != null) {
            json.put("servlet", servlet.toString());
        }
        int c = 0;
        while (cause != null) {
            json.put("cause" + c++, cause.toString());
            cause = cause.getCause();
        }
        var2_3.append(json.entrySet().stream().map(e -> {
            Map.Entry entry;
            return QuotedStringTokenizer.quote((String)((String)e.getKey())) + ":" + QuotedStringTokenizer.quote((String)StringUtil.sanitizeXmlString((String)((String)entry.getValue())));
        }).collect(Collectors.joining(",\n", "{\n", "\n}")));
    }

    /*
     * WARNING - void declaration
     */
    protected void writeErrorPageStacks(HttpServletRequest request, Writer writer) throws IOException {
        Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (th != null) {
            void var2_4;
            writer.write("<h3>Caused by:</h3><pre>");
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                void var1_1;
                var1_1.printStackTrace(pw);
                pw.flush();
                this.write(writer, sw.getBuffer().toString());
            }
            catch (Throwable throwable) {
                try {
                    void var3_6;
                    var3_6.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            sw.close();
            var2_4.write("</pre>\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer badMessageError(int status, String reason, HttpFields fields) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (reason == null) {
            reason = HttpStatus.getMessage((int)status);
        }
        var3_3.put(HttpHeader.CONTENT_TYPE, MimeTypes.Type.TEXT_HTML_8859_1.asString());
        return BufferUtil.toBuffer((String)("<h1>Bad Message " + (int)var1_1 + "</h1><pre>reason: " + (String)var2_2 + "</pre>"));
    }

    public String getCacheControl() {
        return this._cacheControl;
    }

    /*
     * WARNING - void declaration
     */
    public void setCacheControl(String cacheControl) {
        void var1_1;
        this._cacheControl = var1_1;
    }

    public boolean isShowServlet() {
        return this._showServlet;
    }

    /*
     * WARNING - void declaration
     */
    public void setShowServlet(boolean showServlet) {
        void var1_1;
        this._showServlet = var1_1;
    }

    public boolean isShowStacks() {
        return this._showStacks;
    }

    /*
     * WARNING - void declaration
     */
    public void setShowStacks(boolean showStacks) {
        void var1_1;
        this._showStacks = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setShowMessageInTitle(boolean showMessageInTitle) {
        void var1_1;
        this._showMessageInTitle = var1_1;
    }

    public boolean getShowMessageInTitle() {
        return this._showMessageInTitle;
    }

    /*
     * WARNING - void declaration
     */
    protected void write(Writer writer, String string) throws IOException {
        void var2_2;
        void var1_1;
        if (string == null) {
            return;
        }
        var1_1.write(StringUtil.sanitizeXmlString((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static ErrorHandler getErrorHandler(Server server, ContextHandler context) {
        void var2_2;
        ErrorHandler errorHandler = null;
        if (context != null) {
            void var1_1;
            errorHandler = var1_1.getErrorHandler();
        }
        if (errorHandler == null && server != null) {
            Server server2;
            errorHandler = (ErrorHandler)server2.getBean(ErrorHandler.class);
        }
        return var2_2;
    }

    public static interface ErrorPageMapper {
        public String getErrorPage(HttpServletRequest var1);
    }
}

