/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class DefaultHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(DefaultHandler.class);
    final long _faviconModified = System.currentTimeMillis() / 1000L * 1000L;
    final byte[] _favicon;
    boolean _serveIcon = true;
    boolean _showContexts = true;

    /*
     * WARNING - void declaration
     */
    public DefaultHandler() {
        Object favbytes = null;
        try {
            void var1_1;
            URL fav = this.getClass().getClassLoader().getResource("org/eclipse/jetty/favicon.ico");
            if (fav != null) {
                favbytes = Resource.newResource((URL)fav);
                favbytes = IO.readBytes((InputStream)favbytes.getInputStream());
            }
            this._favicon = var1_1;
            return;
        }
        catch (Exception e) {
            void var2_4;
            LOG.warn((Throwable)var2_4);
            return;
        }
        finally {
            this._favicon = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted() || baseRequest.isHandled()) {
            return;
        }
        baseRequest.setHandled(true);
        String method = request.getMethod();
        if (this._serveIcon && this._favicon != null && HttpMethod.GET.is(method) && target.equals("/favicon.ico")) {
            if (request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.toString()) == this._faviconModified) {
                response.setStatus(304);
                return;
            }
            response.setStatus(200);
            response.setContentType("image/x-icon");
            response.setContentLength(this._favicon.length);
            response.setDateHeader(HttpHeader.LAST_MODIFIED.toString(), this._faviconModified);
            response.setHeader(HttpHeader.CACHE_CONTROL.toString(), "max-age=360000,public");
            response.getOutputStream().write(this._favicon);
            return;
        }
        if (!(this._showContexts && HttpMethod.GET.is(method) && request.getRequestURI().equals("/"))) {
            response.sendError(404);
            return;
        }
        response.setStatus(404);
        response.setContentType(MimeTypes.Type.TEXT_HTML_UTF_8.toString());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
            try {
                writer.append("<!DOCTYPE html>\n");
                writer.append("<html lang=\"en\">\n<head>\n");
                writer.append("<title>Error 404 - Not Found</title>\n");
                writer.append("<meta charset=\"utf-8\">\n");
                writer.append("<style>body { font-family: sans-serif; } table, td { border: 1px solid #333; } td, th { padding: 5px; } thead, tfoot { background-color: #333; color: #fff; } </style>\n");
                writer.append("</head>\n<body>\n");
                writer.append("<h2>Error 404 - Not Found.</h2>\n");
                writer.append("<p>No context on this server matched or handled this request.</p>\n");
                writer.append("<p>Contexts known to this server are:</p>\n");
                Server server = this.getServer();
                Handler[] handlers = server == null ? null : server.getChildHandlersByClass(ContextHandler.class);
                writer.append("<table class=\"contexts\"><thead><tr>");
                writer.append("<th>Context Path</th>");
                writer.append("<th>Display Name</th>");
                writer.append("<th>Status</th>");
                writer.append("<th>LifeCycle</th>");
                writer.append("</tr></thead><tbody>\n");
                for (int i = 0; handlers != null && i < handlers.length; ++i) {
                    writer.append("<tr><td>");
                    ContextHandler context = (ContextHandler)handlers[i];
                    String contextPath = context.getContextPath();
                    String href = URIUtil.encodePath((String)contextPath);
                    if (contextPath.length() > 1 && !contextPath.endsWith("/")) {
                        href = href + '/';
                    }
                    if (context.isRunning()) {
                        writer.append("<a href=\"").append(href).append("\">");
                    }
                    writer.append(StringUtil.replace((String)contextPath, (String)"%", (String)"&#37;"));
                    if (context.isRunning()) {
                        writer.append("</a>");
                    }
                    writer.append("</td><td>");
                    if (StringUtil.isNotBlank((String)context.getDisplayName())) {
                        writer.append(StringUtil.sanitizeXmlString((String)context.getDisplayName()));
                    }
                    writer.append("&nbsp;</td><td>");
                    if (context.isAvailable()) {
                        writer.append("Available");
                    } else {
                        writer.append("<em>Not</em> Available");
                    }
                    writer.append("</td><td>");
                    writer.append(context.getState());
                    writer.append("</td></tr>\n");
                }
                writer.append("</tbody></table><hr/>\n");
                writer.append("<a href=\"https://eclipse.org/jetty\"><img alt=\"icon\" src=\"/favicon.ico\"/></a>&nbsp;");
                writer.append("<a href=\"https://eclipse.org/jetty\">Powered by Eclipse Jetty:// Server</a><hr/>\n");
                writer.append("</body>\n</html>\n");
                writer.flush();
                byte[] content = outputStream.toByteArray();
                response.setContentLength(content.length);
                try (ServletOutputStream out = response.getOutputStream();){
                    void var3_6;
                    out.write((byte[])var3_6);
                }
            }
            catch (Throwable throwable) {
                try {
                    void var2_2;
                    var2_2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            writer.close();
        }
        catch (Throwable throwable) {
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Throwable throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        outputStream.close();
    }

    public boolean getServeIcon() {
        return this._serveIcon;
    }

    /*
     * WARNING - void declaration
     */
    public void setServeIcon(boolean serveIcon) {
        void var1_1;
        this._serveIcon = var1_1;
    }

    public boolean getShowContexts() {
        return this._showContexts;
    }

    /*
     * WARNING - void declaration
     */
    public void setShowContexts(boolean show) {
        void var1_1;
        this._showContexts = var1_1;
    }
}

