/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.RolloverFileOutputStream;

public class DebugHandler
extends HandlerWrapper
implements Connection.Listener {
    private DateCache _date = new DateCache("HH:mm:ss", Locale.US);
    private OutputStream _out;
    private PrintStream _print;

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Response base_response = baseRequest.getResponse();
        Thread thread = Thread.currentThread();
        String old_name = thread.getName();
        boolean retry = false;
        String name = (String)request.getAttribute("org.eclipse.jetty.thread.name");
        if (name == null) {
            name = old_name + ":" + baseRequest.getHttpURI();
        } else {
            retry = true;
        }
        String ex = null;
        try {
            if (retry) {
                this.print(name, "RESUME");
            } else {
                this.print(name, "REQUEST " + baseRequest.getRemoteAddr() + " " + request.getMethod() + " " + baseRequest.getHeader("Cookie") + "; " + baseRequest.getHeader("User-Agent"));
            }
            thread.setName(name);
            this.getHandler().handle(target, baseRequest, request, response);
        }
        catch (IOException iOException) {
            try {
                IOException ioe = iOException;
                ex = iOException.toString();
                throw ioe;
                catch (ServletException cause) {
                    ex = cause.toString() + ":" + cause.getCause();
                    throw cause;
                }
                catch (RuntimeException runtimeException) {
                    RuntimeException rte = runtimeException;
                    ex = runtimeException.toString();
                    throw rte;
                }
                catch (Error error) {
                    void var1_1;
                    Error e = error;
                    ex = error.toString();
                    throw var1_1;
                }
            }
            catch (Throwable throwable) {
                void var2_4;
                thread.setName(old_name);
                if (var2_4.getHttpChannelState().isAsyncStarted()) {
                    void var3_5;
                    var3_5.setAttribute("org.eclipse.jetty.thread.name", (Object)name);
                    this.print(name, "ASYNC");
                    throw throwable;
                }
                this.print(name, "RESPONSE " + base_response.getStatus() + (ex == null ? "" : "/" + ex) + " " + base_response.getContentType());
                throw throwable;
            }
        }
        thread.setName(old_name);
        if (baseRequest.getHttpChannelState().isAsyncStarted()) {
            request.setAttribute("org.eclipse.jetty.thread.name", (Object)name);
            this.print(name, "ASYNC");
            return;
        }
        this.print(name, "RESPONSE " + base_response.getStatus() + " " + base_response.getContentType());
    }

    /*
     * WARNING - void declaration
     */
    private void print(String name, String message) {
        void var2_2;
        void var1_1;
        void var3_4;
        long now = System.currentTimeMillis();
        String d = this._date.formatNow(now);
        int ms = (int)(now % 1000L);
        this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + (int)var3_4 + ":" + (String)var1_1 + " " + (String)var2_2);
    }

    @Override
    protected void doStart() throws Exception {
        if (this._out == null) {
            this._out = new RolloverFileOutputStream("./logs/yyyy_mm_dd.debug.log", true);
        }
        this._print = new PrintStream(this._out);
        for (Connector connector : this.getServer().getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            connector.addBean(this, false);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._print.close();
        for (Connector connector : this.getServer().getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            connector.removeBean(this);
        }
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    /*
     * WARNING - void declaration
     */
    public void setOutputStream(OutputStream out) {
        void var1_1;
        this._out = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void onOpened(Connection connection) {
        void var1_1;
        this.print(Thread.currentThread().getName(), "OPENED " + var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void onClosed(Connection connection) {
        void var1_1;
        this.print(Thread.currentThread().getName(), "CLOSED " + var1_1.toString());
    }
}

