/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.SerializedExecutor;

@ManagedObject(value="Context Handler Collection")
public class ContextHandlerCollection
extends HandlerCollection {
    private static final Logger LOG = Log.getLogger(ContextHandlerCollection.class);
    private final SerializedExecutor _serializedExecutor = new SerializedExecutor();
    @Deprecated
    private Class<? extends ContextHandler> _contextClass = ContextHandler.class;

    public ContextHandlerCollection() {
        super(true, new Handler[0]);
    }

    /*
     * WARNING - void declaration
     */
    public ContextHandlerCollection(ContextHandler ... contexts) {
        super(true, new Handler[0]);
        void var1_1;
        this.setHandlers((Handler[])var1_1);
    }

    @ManagedOperation(value="Update the mapping of context path to context")
    public void mapContexts() {
        this._serializedExecutor.execute(() -> {
            void var1_1;
            HandlerCollection.Handlers handlers;
            while ((handlers = this._handlers.get()) != null && !this.updateHandlers(handlers, this.newHandlers(var1_1.getHandlers()))) {
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected HandlerCollection.Handlers newHandlers(Handler[] handlers) {
        void var2_3;
        Mapping mapping;
        if (handlers == null || handlers.length == 0) {
            return null;
        }
        HashMap<String, Branch[]> path2Branches = new HashMap<String, Branch[]>();
        Handler[] handlerArray = handlers;
        int n = handlers.length;
        for (int i = 0; i < n; ++i) {
            Handler handler = handlerArray[i];
            Branch branch = new Branch(handler);
            for (String contextPath : branch.getContextPaths()) {
                Object[] branches = (Branch[])path2Branches.get(contextPath);
                path2Branches.put(contextPath, (Branch[])ArrayUtil.addToArray((Object[])branches, (Object)branch, Branch.class));
            }
        }
        for (Map.Entry entry : path2Branches.entrySet()) {
            Branch branch;
            int branches;
            Branch[] branches2 = (Branch[])entry.getValue();
            Branch[] sorted = new Branch[branches2.length];
            int i = 0;
            Branch[] branchArray = branches2;
            int n2 = branches2.length;
            for (branches = 0; branches < n2; ++branches) {
                branch = branchArray[branches];
                if (!branch.hasVirtualHost()) continue;
                sorted[i++] = branch;
            }
            branchArray = branches2;
            n2 = branches2.length;
            for (branches = 0; branches < n2; ++branches) {
                branch = branchArray[branches];
                if (branch.hasVirtualHost()) continue;
                sorted[i++] = branch;
            }
            entry.setValue(sorted);
        }
        int capacity = 512;
        block5: while (true) {
            mapping = new Mapping(handlers, capacity);
            for (Map.Entry entry : path2Branches.entrySet()) {
                if (mapping._pathBranches.put(((String)entry.getKey()).substring(1), entry)) continue;
                capacity += 512;
                continue block5;
            }
            break;
        }
        if (LOG.isDebugEnabled()) {
            for (String ctx : mapping._pathBranches.keySet()) {
                LOG.debug("{}->{}", new Object[]{ctx, Arrays.asList((Branch[])((Map.Entry)mapping._pathBranches.get(ctx)).getValue())});
            }
        }
        Iterator iterator = var2_3.values().iterator();
        while (iterator.hasNext()) {
            Branch[] branchArray;
            Branch[] branchArray2 = branchArray = (Branch[])iterator.next();
            int n3 = branchArray.length;
            for (int i = 0; i < n3; ++i) {
                Branch branch = branchArray2[i];
                for (ContextHandler context : branch.getContextHandlers()) {
                    void var3_7;
                    mapping._contextBranches.put(var3_7, branch.getHandler());
                }
            }
        }
        return mapping;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        void var6_9;
        Handler branch;
        ContextHandler context;
        Mapping mapping = (Mapping)this._handlers.get();
        if (mapping == null) {
            return;
        }
        Handler[] handlers = mapping.getHandlers();
        if (handlers == null || handlers.length == 0) {
            return;
        }
        if (handlers.length == 1) {
            handlers[0].handle(target, baseRequest, request, response);
            return;
        }
        HttpChannelState async = baseRequest.getHttpChannelState();
        if (async.isAsync() && (context = async.getContextHandler()) != null) {
            branch = (Handler)mapping._contextBranches.get(context);
            if (branch == null) {
                ((AbstractHandler)context).handle(target, baseRequest, request, response);
                return;
            }
            branch.handle(target, baseRequest, request, response);
            return;
        }
        if (target.startsWith("/")) {
            Map.Entry branches;
            Trie pathBranches = ((Mapping)((Object)branch))._pathBranches;
            if (pathBranches == null) {
                return;
            }
            int limit = target.length() - 1;
            while (limit >= 0 && (branches = (Map.Entry)pathBranches.getBest(target, 1, limit)) != null) {
                int l = ((String)branches.getKey()).length();
                if (l == 1 || target.length() == l || target.charAt(l) == '/') {
                    for (Branch branch2 : (Branch[])branches.getValue()) {
                        branch2.getHandler().handle(target, baseRequest, request, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                }
                limit = l - 2;
            }
            return;
        }
        for (void var8_14 : var6_9) {
            var8_14.handle(target, baseRequest, request, response);
            if (!baseRequest.isHandled()) continue;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ContextHandler addContext(String contextPath, String resourceBase) {
        try {
            void var2_2;
            void var1_1;
            ContextHandler context = this._contextClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            context.setContextPath((String)var1_1);
            context.setResourceBase((String)var2_2);
            this.addHandler(context);
            return context;
        }
        catch (Exception e) {
            void var3_4;
            LOG.debug((Throwable)e);
            throw new Error((Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deployHandler(Handler handler, Callback callback) {
        void var2_2;
        void var1_1;
        if (handler.getServer() != this.getServer()) {
            handler.setServer(this.getServer());
        }
        this._serializedExecutor.execute((Runnable)new SerializedExecutor.ErrorHandlingTask(this, (Handler)var1_1, (Callback)var2_2){
            final /* synthetic */ Handler val$handler;
            final /* synthetic */ Callback val$callback;
            final /* synthetic */ ContextHandlerCollection this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$handler = handler;
                this.val$callback = callback;
            }

            public void run() {
                this.this$0.addHandler(this.val$handler);
                this.val$callback.succeeded();
            }

            /*
             * WARNING - void declaration
             */
            public void accept(Throwable throwable) {
                void var1_1;
                this.val$callback.failed((Throwable)var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void undeployHandler(Handler handler, Callback callback) {
        void var2_2;
        void var1_1;
        this._serializedExecutor.execute((Runnable)new SerializedExecutor.ErrorHandlingTask(this, (Handler)var1_1, (Callback)var2_2){
            final /* synthetic */ Handler val$handler;
            final /* synthetic */ Callback val$callback;
            final /* synthetic */ ContextHandlerCollection this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$handler = handler;
                this.val$callback = callback;
            }

            public void run() {
                this.this$0.removeHandler(this.val$handler);
                this.val$callback.succeeded();
            }

            /*
             * WARNING - void declaration
             */
            public void accept(Throwable throwable) {
                void var1_1;
                this.val$callback.failed((Throwable)var1_1);
            }
        });
    }

    @Deprecated
    public Class<?> getContextClass() {
        return this._contextClass;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setContextClass(Class<? extends ContextHandler> contextClass) {
        void var1_1;
        if (contextClass == null || !ContextHandler.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException();
        }
        this._contextClass = var1_1;
    }

    private static class Mapping
    extends HandlerCollection.Handlers {
        private final Map<ContextHandler, Handler> _contextBranches = new HashMap<ContextHandler, Handler>();
        private final Trie<Map.Entry<String, Branch[]>> _pathBranches;

        /*
         * WARNING - void declaration
         */
        private Mapping(Handler[] handlers, int capacity) {
            super((Handler[])var1_1);
            void var2_2;
            void var1_1;
            this._pathBranches = new ArrayTernaryTrie(false, (int)var2_2);
        }
    }

    private static final class Branch {
        private final Handler _handler;
        private final ContextHandler[] _contexts;

        /*
         * WARNING - void declaration
         */
        Branch(Handler handler) {
            this._handler = handler;
            if (handler instanceof ContextHandler) {
                this._contexts = new ContextHandler[]{(ContextHandler)handler};
                return;
            }
            if (handler instanceof HandlerContainer) {
                void var1_1;
                Handler[] contexts = ((HandlerContainer)((Object)handler)).getChildHandlersByClass(ContextHandler.class);
                this._contexts = new ContextHandler[contexts.length];
                System.arraycopy(contexts, 0, this._contexts, 0, ((void)var1_1).length);
                return;
            }
            this._contexts = new ContextHandler[0];
        }

        /*
         * WARNING - void declaration
         */
        final Set<String> getContextPaths() {
            void var1_1;
            HashSet<String> set = new HashSet<String>();
            ContextHandler[] contextHandlerArray = this._contexts;
            int n = this._contexts.length;
            for (int i = 0; i < n; ++i) {
                ContextHandler context = contextHandlerArray[i];
                set.add(context.getContextPath());
            }
            return var1_1;
        }

        final boolean hasVirtualHost() {
            ContextHandler[] contextHandlerArray = this._contexts;
            int n = this._contexts.length;
            for (int i = 0; i < n; ++i) {
                ContextHandler context = contextHandlerArray[i];
                if (context.getVirtualHosts() == null || context.getVirtualHosts().length <= 0) continue;
                return true;
            }
            return false;
        }

        final ContextHandler[] getContextHandlers() {
            return this._contexts;
        }

        final Handler getHandler() {
            return this._handler;
        }

        public final String toString() {
            return String.format("{%s,%s}", this._handler, Arrays.asList(this._contexts));
        }
    }
}

