/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.ClassLoaderDump;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SymlinkAllowedResourceAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ManagedAttributeListener;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.Graceful;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

@ManagedObject(value="URI Context")
public class ContextHandler
extends ScopedHandler
implements Attributes,
Graceful {
    public static final int SERVLET_MAJOR_VERSION = 3;
    public static final int SERVLET_MINOR_VERSION = 1;
    public static final Class<?>[] SERVLET_LISTENER_TYPES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionIdListener.class, HttpSessionListener.class, HttpSessionAttributeListener.class};
    public static final int DEFAULT_LISTENER_TYPE_INDEX = 1;
    public static final int EXTENDED_LISTENER_TYPE_INDEX = 0;
    private static final String UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER = "Unimplemented {} - use org.eclipse.jetty.servlet.ServletContextHandler";
    private static final Logger LOG = Log.getLogger(ContextHandler.class);
    private static final ThreadLocal<Context> __context = new ThreadLocal();
    private static String __serverInfo = "jetty/" + Server.getVersion();
    public static final String MANAGED_ATTRIBUTES = "org.eclipse.jetty.server.context.ManagedAttributes";
    public static final String MAX_FORM_KEYS_KEY = "org.eclipse.jetty.server.Request.maxFormKeys";
    public static final String MAX_FORM_CONTENT_SIZE_KEY = "org.eclipse.jetty.server.Request.maxFormContentSize";
    public static final int DEFAULT_MAX_FORM_KEYS = 1000;
    public static final int DEFAULT_MAX_FORM_CONTENT_SIZE = 200000;
    protected ContextStatus _contextStatus = ContextStatus.NOTSET;
    protected Context _scontext;
    private final AttributesMap _attributes;
    private final Map<String, String> _initParams;
    private ClassLoader _classLoader;
    private String _contextPath = "/";
    private String _contextPathEncoded = "/";
    private String _displayName;
    private Resource _baseResource;
    private MimeTypes _mimeTypes;
    private Map<String, String> _localeEncodingMap;
    private String[] _welcomeFiles;
    private ErrorHandler _errorHandler;
    private String[] _vhosts;
    private boolean[] _vhostswildcard;
    private String[] _vconnectors;
    private Logger _logger;
    private boolean _allowNullPathInfo;
    private int _maxFormKeys = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormKeys", 1000);
    private int _maxFormContentSize = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormContentSize", 200000);
    private boolean _compactPath = false;
    private boolean _usingSecurityManager = System.getSecurityManager() != null;
    private final List<EventListener> _eventListeners = new CopyOnWriteArrayList<EventListener>();
    private final List<EventListener> _programmaticListeners = new CopyOnWriteArrayList<EventListener>();
    private final List<ServletContextListener> _servletContextListeners = new CopyOnWriteArrayList<ServletContextListener>();
    private final List<ServletContextListener> _destroyServletContextListeners = new ArrayList<ServletContextListener>();
    private final List<ServletContextAttributeListener> _servletContextAttributeListeners = new CopyOnWriteArrayList<ServletContextAttributeListener>();
    private final List<ServletRequestListener> _servletRequestListeners = new CopyOnWriteArrayList<ServletRequestListener>();
    private final List<ServletRequestAttributeListener> _servletRequestAttributeListeners = new CopyOnWriteArrayList<ServletRequestAttributeListener>();
    private final List<ContextScopeListener> _contextListeners = new CopyOnWriteArrayList<ContextScopeListener>();
    private final List<EventListener> _durableListeners = new CopyOnWriteArrayList<EventListener>();
    private String[] _protectedTargets;
    private final List<AliasCheck> _aliasChecks = new CopyOnWriteArrayList<AliasCheck>();
    private final AtomicReference<Availability> _availability = new AtomicReference<Availability>(Availability.STOPPED);

    public static Context getCurrentContext() {
        return __context.get();
    }

    public static ContextHandler getContextHandler(ServletContext context) {
        if (context instanceof Context) {
            return ((Context)context).getContextHandler();
        }
        ServletContext c = ContextHandler.getCurrentContext();
        if (c != null) {
            ServletContext servletContext;
            return servletContext.getContextHandler();
        }
        return null;
    }

    public static String getServerInfo() {
        return __serverInfo;
    }

    public static void setServerInfo(String serverInfo) {
        __serverInfo = serverInfo;
    }

    public ContextHandler() {
        this(null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    protected ContextHandler(Context context) {
        this((Context)var1_1, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ContextHandler(String contextPath) {
        this(null, null, (String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ContextHandler(HandlerContainer parent, String contextPath) {
        this(null, (HandlerContainer)var1_1, (String)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ContextHandler(Context context, HandlerContainer parent, String contextPath) {
        void var1_1;
        this._scontext = context == null ? new Context(this) : var1_1;
        this._attributes = new AttributesMap();
        this._initParams = new HashMap<String, String>();
        if (File.separatorChar == '/') {
            this.addAliasCheck(new SymlinkAllowedResourceAliasChecker(this));
        }
        if (contextPath != null) {
            void var3_3;
            this.setContextPath((String)var3_3);
        }
        if (parent instanceof HandlerWrapper) {
            ((HandlerWrapper)parent).setHandler(this);
            return;
        }
        if (parent instanceof HandlerCollection) {
            void var2_2;
            ((HandlerCollection)var2_2).addHandler(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        this.dumpObjects((Appendable)var1_1, (String)var2_2, new Object[]{new ClassLoaderDump(this.getClassLoader()), new DumpableCollection("eventListeners " + this, this._eventListeners), new DumpableCollection("handler attributes " + this, (Collection)((AttributesMap)this.getAttributes()).getAttributeEntrySet()), new DumpableCollection("context attributes " + this, (Collection)this.getServletContext().getAttributeEntrySet()), new DumpableCollection("initparams " + this, this.getInitParams().entrySet())});
    }

    public Context getServletContext() {
        return this._scontext;
    }

    @ManagedAttribute(value="Checks if the /context is not redirected to /context/")
    public boolean getAllowNullPathInfo() {
        return this._allowNullPathInfo;
    }

    /*
     * WARNING - void declaration
     */
    public void setAllowNullPathInfo(boolean allowNullPathInfo) {
        void var1_1;
        this._allowNullPathInfo = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setServer(Server server) {
        super.setServer(server);
        if (this._errorHandler != null) {
            void var1_1;
            this._errorHandler.setServer((Server)var1_1);
        }
    }

    public boolean isUsingSecurityManager() {
        return this._usingSecurityManager;
    }

    /*
     * WARNING - void declaration
     */
    public void setUsingSecurityManager(boolean usingSecurityManager) {
        void var1_1;
        if (usingSecurityManager && System.getSecurityManager() == null) {
            throw new IllegalStateException("No security manager");
        }
        this._usingSecurityManager = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setVirtualHosts(String[] vhosts) {
        void var3_3;
        void var2_2;
        if (vhosts == null) {
            this._vhosts = vhosts;
            return;
        }
        boolean hostMatch = false;
        boolean connectorHostMatch = false;
        this._vhosts = new String[vhosts.length];
        this._vconnectors = new String[vhosts.length];
        this._vhostswildcard = new boolean[vhosts.length];
        ArrayList<Integer> connectorOnlyIndexes = null;
        for (int i = 0; i < vhosts.length; ++i) {
            boolean connectorMatch = false;
            this._vhosts[i] = vhosts[i];
            if (vhosts[i] == null) continue;
            int connectorIndex = this._vhosts[i].indexOf(64);
            if (connectorIndex >= 0) {
                connectorMatch = true;
                this._vconnectors[i] = this._vhosts[i].substring(connectorIndex + 1);
                this._vhosts[i] = this._vhosts[i].substring(0, connectorIndex);
                if (connectorIndex == 0) {
                    if (connectorOnlyIndexes == null) {
                        connectorOnlyIndexes = new ArrayList<Integer>();
                    }
                    connectorOnlyIndexes.add(i);
                }
            }
            if (this._vhosts[i].startsWith("*.")) {
                this._vhosts[i] = this._vhosts[i].substring(1);
                this._vhostswildcard[i] = true;
            }
            if (this._vhosts[i].isEmpty()) {
                this._vhosts[i] = null;
            } else {
                hostMatch = true;
                connectorHostMatch = connectorHostMatch || connectorMatch;
            }
            ContextHandler contextHandler = this;
            this._vhosts[i] = contextHandler.normalizeHostname(contextHandler._vhosts[i]);
        }
        if (connectorOnlyIndexes != null && var2_2 != false && var3_3 == false) {
            LOG.warn("ContextHandler {} has a connector only entry e.g. \"@connector\" and one or more host only entries. \nThe host entries will be ignored to match legacy behavior.  To clear this warning remove the host entries or update to use at least one host@connector syntax entry that will match a host for an specific connector", new Object[]{Arrays.asList(vhosts)});
            String[] filteredHosts = new String[connectorOnlyIndexes.size()];
            for (int i = 0; i < connectorOnlyIndexes.size(); ++i) {
                filteredHosts[i] = vhosts[(Integer)connectorOnlyIndexes.get(i)];
            }
            this.setVirtualHosts(filteredHosts);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addVirtualHosts(String[] virtualHosts) {
        void var2_2;
        void var1_1;
        if (virtualHosts == null || virtualHosts.length == 0) {
            return;
        }
        if (this._vhosts == null) {
            this.setVirtualHosts(virtualHosts);
            return;
        }
        HashSet<String> currentVirtualHosts = new HashSet<String>(Arrays.asList(this.getVirtualHosts()));
        for (void vh : var1_1) {
            currentVirtualHosts.add(this.normalizeHostname((String)vh));
        }
        this.setVirtualHosts(var2_2.toArray(new String[0]));
    }

    /*
     * WARNING - void declaration
     */
    public void removeVirtualHosts(String[] virtualHosts) {
        void var2_2;
        void var1_1;
        if (virtualHosts == null || virtualHosts.length == 0 || this._vhosts == null || this._vhosts.length == 0) {
            return;
        }
        HashSet<String> existingVirtualHosts = new HashSet<String>(Arrays.asList(this.getVirtualHosts()));
        for (void vh : var1_1) {
            existingVirtualHosts.remove(this.normalizeHostname((String)vh));
        }
        if (existingVirtualHosts.isEmpty()) {
            this.setVirtualHosts(null);
            return;
        }
        this.setVirtualHosts(var2_2.toArray(new String[0]));
    }

    /*
     * WARNING - void declaration
     */
    @ManagedAttribute(value="Virtual hosts accepted by the context", readonly=true)
    public String[] getVirtualHosts() {
        void var1_1;
        if (this._vhosts == null) {
            return null;
        }
        String[] vhosts = new String[this._vhosts.length];
        for (int i = 0; i < this._vhosts.length; ++i) {
            void var3_3;
            StringBuilder sb = new StringBuilder();
            if (this._vhostswildcard[i]) {
                sb.append("*");
            }
            if (this._vhosts[i] != null) {
                sb.append(this._vhosts[i]);
            }
            if (this._vconnectors[i] != null) {
                sb.append("@").append(this._vconnectors[i]);
            }
            vhosts[i] = var3_3.toString();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String name) {
        void var1_1;
        return this._attributes.getAttribute((String)var1_1);
    }

    public Enumeration<String> getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy((Attributes)this._attributes);
    }

    public Set<String> getAttributeNameSet() {
        return this._attributes.getAttributeNameSet();
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    /*
     * WARNING - void declaration
     */
    @ManagedAttribute(value="The file classpath")
    public String getClassPath() {
        void var2_2;
        if (this._classLoader == null || !(this._classLoader instanceof URLClassLoader)) {
            return null;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)this._classLoader;
        URL[] urls = uRLClassLoader.getURLs();
        StringBuilder classpath = new StringBuilder();
        for (int i = 0; i < urls.length; ++i) {
            try {
                Resource resource = this.newResource(urls[i]);
                File file = resource.getFile();
                if (file == null || !file.exists()) continue;
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparatorChar);
                }
                classpath.append(file.getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        if (classpath.length() == 0) {
            return null;
        }
        return var2_2.toString();
    }

    @ManagedAttribute(value="True if URLs are compacted to replace the multiple '/'s with a single '/'")
    public String getContextPath() {
        return this._contextPath;
    }

    public String getContextPathEncoded() {
        return this._contextPathEncoded;
    }

    /*
     * WARNING - void declaration
     */
    public String getRequestContextPath() {
        void var1_1;
        String contextPathEncoded = this.getContextPathEncoded();
        if ("/".equals(contextPathEncoded)) {
            return "";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String getInitParameter(String name) {
        void var1_1;
        return this._initParams.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String setInitParameter(String name, String value) {
        void var2_2;
        void var1_1;
        return this._initParams.put((String)var1_1, (String)var2_2);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    @ManagedAttribute(value="Initial Parameter map for the context")
    public Map<String, String> getInitParams() {
        return this._initParams;
    }

    @ManagedAttribute(value="Display name of the Context", readonly=true)
    public String getDisplayName() {
        return this._displayName;
    }

    public EventListener[] getEventListeners() {
        return this._eventListeners.toArray(new EventListener[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void setEventListeners(EventListener[] eventListeners) {
        this._contextListeners.clear();
        this._servletContextListeners.clear();
        this._servletContextAttributeListeners.clear();
        this._servletRequestListeners.clear();
        this._servletRequestAttributeListeners.clear();
        this._eventListeners.clear();
        if (eventListeners != null) {
            void var1_1;
            for (void listener : var1_1) {
                this.addEventListener((EventListener)listener);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addEventListener(EventListener listener) {
        this._eventListeners.add(listener);
        if (!this.isStarted() && !this.isStarting()) {
            this._durableListeners.add(listener);
        }
        if (listener instanceof ContextScopeListener) {
            this._contextListeners.add((ContextScopeListener)listener);
            if (__context.get() != null) {
                ((ContextScopeListener)listener).enterScope(__context.get(), null, "Listener registered");
            }
        }
        if (listener instanceof ServletContextListener) {
            this._servletContextListeners.add((ServletContextListener)listener);
        }
        if (listener instanceof ServletContextAttributeListener) {
            this._servletContextAttributeListeners.add((ServletContextAttributeListener)listener);
        }
        if (listener instanceof ServletRequestListener) {
            this._servletRequestListeners.add((ServletRequestListener)listener);
        }
        if (listener instanceof ServletRequestAttributeListener) {
            void var1_1;
            this._servletRequestAttributeListeners.add((ServletRequestAttributeListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeEventListener(EventListener listener) {
        this._eventListeners.remove(listener);
        if (listener instanceof ContextScopeListener) {
            this._contextListeners.remove(listener);
        }
        if (listener instanceof ServletContextListener) {
            this._servletContextListeners.remove(listener);
            this._destroyServletContextListeners.remove(listener);
        }
        if (listener instanceof ServletContextAttributeListener) {
            this._servletContextAttributeListeners.remove(listener);
        }
        if (listener instanceof ServletRequestListener) {
            this._servletRequestListeners.remove(listener);
        }
        if (listener instanceof ServletRequestAttributeListener) {
            void var1_1;
            this._servletRequestAttributeListeners.remove(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addProgrammaticListener(EventListener listener) {
        void var1_1;
        this._programmaticListeners.add((EventListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isProgrammaticListener(EventListener listener) {
        void var1_1;
        return this._programmaticListeners.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDurableListener(EventListener listener) {
        void var1_1;
        return this._durableListeners.contains(var1_1);
    }

    @ManagedAttribute(value="true for graceful shutdown, which allows existing requests to complete")
    public boolean isShutdown() {
        return this._availability.get() == Availability.SHUTDOWN;
    }

    /*
     * WARNING - void declaration
     */
    public Future<Void> shutdown() {
        block4: while (true) {
            Availability availability = this._availability.get();
            switch (availability) {
                case STOPPED: {
                    return new FutureCallback((Throwable)new IllegalStateException(this.getState()));
                }
                case STARTING: 
                case AVAILABLE: 
                case UNAVAILABLE: {
                    void var1_1;
                    if (!this._availability.compareAndSet((Availability)var1_1, Availability.SHUTDOWN)) continue block4;
                }
            }
            break;
        }
        return new FutureCallback(true);
    }

    public boolean isAvailable() {
        return this._availability.get() == Availability.AVAILABLE;
    }

    /*
     * WARNING - void declaration
     */
    public void setAvailable(boolean available) {
        block11: {
            if (available) {
                block7: while (true) {
                    Availability availability = this._availability.get();
                    switch (availability) {
                        case AVAILABLE: {
                            return;
                        }
                        case UNAVAILABLE: {
                            if (!this._availability.compareAndSet(availability, Availability.AVAILABLE)) {
                                continue block7;
                            }
                            break block11;
                        }
                        default: {
                            throw new IllegalStateException(availability.toString());
                        }
                    }
                    break;
                }
            }
            block8: while (true) {
                Availability availability = this._availability.get();
                switch (availability) {
                    case STARTING: 
                    case AVAILABLE: {
                        void var1_3;
                        if (!this._availability.compareAndSet((Availability)var1_3, Availability.UNAVAILABLE)) continue block8;
                    }
                }
                break;
            }
        }
    }

    public Logger getLogger() {
        return this._logger;
    }

    /*
     * WARNING - void declaration
     */
    public void setLogger(Logger logger) {
        void var1_1;
        this._logger = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStart() throws Exception {
        this._availability.set(Availability.STARTING);
        if (this._contextPath == null) {
            throw new IllegalStateException("Null contextPath");
        }
        if (this._logger == null) {
            this._logger = Log.getLogger((String)(ContextHandler.class.getName() + this.getLogNameSuffix()));
        }
        ClassLoader oldClassloader = null;
        Thread currentThread = null;
        Context oldContext = null;
        this._attributes.setAttribute("org.eclipse.jetty.server.Executor", (Object)this.getServer().getThreadPool());
        if (this._mimeTypes == null) {
            this._mimeTypes = new MimeTypes();
        }
        try {
            if (this._classLoader != null) {
                currentThread = Thread.currentThread();
                oldClassloader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(this._classLoader);
            }
            oldContext = __context.get();
            __context.set(this._scontext);
            this.enterScope(null, this.getState());
            this.startContext();
            this.contextInitialized();
            this._availability.compareAndSet(Availability.STARTING, Availability.AVAILABLE);
            LOG.info("Started {}", new Object[]{this});
            this._availability.compareAndSet(Availability.STARTING, Availability.UNAVAILABLE);
        }
        catch (Throwable throwable) {
            void var3_3;
            this._availability.compareAndSet(Availability.STARTING, Availability.UNAVAILABLE);
            this.exitScope(null);
            __context.set((Context)var3_3);
            if (this._classLoader != null && currentThread != null) {
                void var1_1;
                void var2_2;
                var2_2.setContextClassLoader((ClassLoader)var1_1);
            }
            throw throwable;
        }
        this.exitScope(null);
        __context.set(oldContext);
        if (this._classLoader != null && currentThread != null) {
            currentThread.setContextClassLoader(oldClassloader);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getLogNameSuffix() {
        void var1_1;
        String logName = this.getDisplayName();
        if (StringUtil.isBlank((String)logName)) {
            logName = this.getContextPath();
            if (logName != null && logName.startsWith("/")) {
                logName = logName.substring(1);
            }
            if (StringUtil.isBlank((String)logName)) {
                logName = "ROOT";
            }
        }
        return "." + var1_1.replaceAll("\\W", "_");
    }

    /*
     * WARNING - void declaration
     */
    protected void startContext() throws Exception {
        String managedAttributes = this._initParams.get(MANAGED_ATTRIBUTES);
        if (managedAttributes != null) {
            void var1_1;
            this.addEventListener((EventListener)((Object)new ManagedAttributeListener(this, StringUtil.csvSplit((String)var1_1))));
        }
        super.doStart();
    }

    /*
     * WARNING - void declaration
     */
    public void contextInitialized() throws Exception {
        switch (this._contextStatus) {
            case NOTSET: {
                try {
                    this._destroyServletContextListeners.clear();
                    if (!this._servletContextListeners.isEmpty()) {
                        ServletContextEvent event = new ServletContextEvent((ServletContext)this._scontext);
                        for (ServletContextListener listener : this._servletContextListeners) {
                            void var3_4;
                            this.callContextInitialized(listener, event);
                            this._destroyServletContextListeners.add((ServletContextListener)var3_4);
                        }
                    }
                    return;
                }
                finally {
                    this._contextStatus = ContextStatus.INITIALIZED;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void contextDestroyed() throws Exception {
        switch (this._contextStatus) {
            case INITIALIZED: {
                try {
                    void var1_1;
                    MultiException ex = new MultiException();
                    ServletContextEvent event = new ServletContextEvent((ServletContext)this._scontext);
                    Collections.reverse(this._destroyServletContextListeners);
                    for (ServletContextListener listener : this._destroyServletContextListeners) {
                        try {
                            this.callContextDestroyed(listener, event);
                        }
                        catch (Exception x) {
                            ex.add((Throwable)x);
                        }
                    }
                    var1_1.ifExceptionThrow();
                    return;
                }
                finally {
                    this._contextStatus = ContextStatus.DESTROYED;
                }
            }
        }
    }

    protected void stopContext() throws Exception {
        super.doStop();
    }

    /*
     * WARNING - void declaration
     */
    protected void callContextInitialized(ServletContextListener l, ServletContextEvent e) {
        void var2_2;
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("contextInitialized: {}->{}", new Object[]{e, l});
        }
        var1_1.contextInitialized((ServletContextEvent)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void callContextDestroyed(ServletContextListener l, ServletContextEvent e) {
        void var2_2;
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("contextDestroyed: {}->{}", new Object[]{e, l});
        }
        var1_1.contextDestroyed((ServletContextEvent)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStop() throws Exception {
        MultiException multiException;
        MultiException mex2 = null;
        if (this.getStopTimeout() > 0L) {
            try {
                this.doShutdown(null);
            }
            catch (MultiException multiException2) {
                multiException = multiException2;
                mex2 = multiException2;
            }
        }
        this._availability.set(Availability.STOPPED);
        ClassLoader oldClassloader = null;
        ClassLoader oldWebapploader = null;
        Thread currentThread = null;
        Context oldContext = __context.get();
        this.enterScope(null, "doStop");
        __context.set(this._scontext);
        try {
            if (this._classLoader != null) {
                oldWebapploader = this._classLoader;
                currentThread = Thread.currentThread();
                oldClassloader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(this._classLoader);
            }
            this.stopContext();
            this.contextDestroyed();
            ContextHandler contextHandler = this;
            contextHandler.setEventListeners(contextHandler._durableListeners.toArray(new EventListener[0]));
            this._durableListeners.clear();
            if (this._errorHandler != null) {
                this._errorHandler.stop();
            }
            for (EventListener l : this._programmaticListeners) {
                this.removeEventListener(l);
                if (!(l instanceof ContextScopeListener)) continue;
                try {
                    ((ContextScopeListener)l).exitScope(this._scontext, null);
                }
                catch (Throwable e) {
                    LOG.warn(e);
                }
            }
            this._programmaticListeners.clear();
            this._contextStatus = ContextStatus.NOTSET;
            __context.set(oldContext);
            this.exitScope(null);
        }
        catch (Throwable x) {
            try {
                if (mex2 == null) {
                    mex2 = new MultiException();
                }
                mex2.add(x);
                this._contextStatus = ContextStatus.NOTSET;
                __context.set(oldContext);
                this.exitScope(null);
            }
            catch (Throwable mex2) {
                void var3_4;
                this._contextStatus = ContextStatus.NOTSET;
                __context.set(oldContext);
                this.exitScope(null);
                LOG.info("Stopped {}", new Object[]{this});
                if ((oldClassloader == null || oldClassloader != var3_4) && currentThread != null) {
                    currentThread.setContextClassLoader((ClassLoader)((Object)multiException));
                }
                this._scontext.clearAttributes();
                throw mex2;
            }
            LOG.info("Stopped {}", new Object[]{this});
            if ((oldClassloader == null || oldClassloader != oldWebapploader) && currentThread != null) {
                currentThread.setContextClassLoader(oldClassloader);
            }
            this._scontext.clearAttributes();
        }
        LOG.info("Stopped {}", new Object[]{this});
        if ((oldClassloader == null || oldClassloader != oldWebapploader) && currentThread != null) {
            currentThread.setContextClassLoader(oldClassloader);
        }
        this._scontext.clearAttributes();
        if (mex2 != null) {
            void var1_1;
            var1_1.ifExceptionThrow();
        }
    }

    public boolean checkVirtualHost(Request baseRequest) {
        if (this._vhosts == null || this._vhosts.length == 0) {
            return true;
        }
        String vhost = this.normalizeHostname(baseRequest.getServerName());
        String connectorName = baseRequest.getHttpChannel().getConnector().getName();
        for (int i = 0; i < this._vhosts.length; ++i) {
            int index;
            String contextVhost = this._vhosts[i];
            String contextVConnector = this._vconnectors[i];
            if (contextVConnector != null) {
                if (!contextVConnector.equalsIgnoreCase(connectorName)) continue;
                if (contextVhost == null) {
                    return true;
                }
            }
            if (contextVhost == null || !(this._vhostswildcard[i] ? (index = vhost.indexOf(".")) >= 0 && vhost.substring(index).equalsIgnoreCase(contextVhost) : vhost.equalsIgnoreCase(contextVhost))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkContextPath(String uri) {
        if (this._contextPath.length() > 1) {
            void var1_1;
            if (!uri.startsWith(this._contextPath)) {
                return false;
            }
            return uri.length() <= this._contextPath.length() || var1_1.charAt(this._contextPath.length()) == '/';
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkContext(String target, Request baseRequest, HttpServletResponse response) throws IOException {
        void var2_2;
        DispatcherType dispatch = baseRequest.getDispatcherType();
        if (!this.checkVirtualHost(baseRequest)) {
            return false;
        }
        if (!this.checkContextPath(target)) {
            return false;
        }
        if (!this._allowNullPathInfo && this._contextPath.length() == target.length() && this._contextPath.length() > 1) {
            void var1_1;
            baseRequest.setHandled(true);
            String queryString = baseRequest.getQueryString();
            baseRequest.getResponse().sendRedirect(302, baseRequest.getRequestURI() + (queryString == null ? "/" : "/?" + (String)var1_1), true);
            return false;
        }
        switch (this._availability.get()) {
            case STOPPED: {
                return false;
            }
            case UNAVAILABLE: 
            case SHUTDOWN: {
                void var3_3;
                baseRequest.setHandled(true);
                var3_3.sendError(503);
                return false;
            }
        }
        return !DispatcherType.REQUEST.equals((Object)dispatch) || !var2_2.isHandled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("scope {}|{}|{} @ {}", new Object[]{baseRequest.getContextPath(), baseRequest.getServletPath(), baseRequest.getPathInfo(), this});
        }
        String oldContextPath = null;
        String oldServletPath = null;
        String oldPathInfo = null;
        ClassLoader oldClassloader = null;
        Thread currentThread = null;
        String pathInfo = target;
        DispatcherType dispatch = baseRequest.getDispatcherType();
        Context oldContext = baseRequest.getContext();
        if (oldContext != this._scontext) {
            if (DispatcherType.REQUEST.equals((Object)dispatch) || DispatcherType.ASYNC.equals((Object)dispatch)) {
                if (this.isCompactPath()) {
                    target = URIUtil.compactPath((String)target);
                }
                if (!this.checkContext(target, baseRequest, response)) {
                    return;
                }
                if (target.length() > this._contextPath.length()) {
                    if (this._contextPath.length() > 1) {
                        target = target.substring(this._contextPath.length());
                    }
                    pathInfo = target;
                } else if (this._contextPath.length() == 1) {
                    target = "/";
                    pathInfo = "/";
                } else {
                    target = "/";
                    pathInfo = null;
                }
            }
            if (this._classLoader != null) {
                currentThread = Thread.currentThread();
                oldClassloader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(this._classLoader);
            }
        }
        try {
            void var3_4;
            void var1_1;
            oldContextPath = baseRequest.getContextPath();
            oldServletPath = baseRequest.getServletPath();
            oldPathInfo = baseRequest.getPathInfo();
            baseRequest.setContext(this._scontext);
            __context.set(this._scontext);
            if (!DispatcherType.INCLUDE.equals((Object)dispatch) && target.startsWith("/")) {
                baseRequest.setContextPath(this.getRequestContextPath());
                baseRequest.setServletPath(null);
                baseRequest.setPathInfo(pathInfo);
            }
            if (oldContext != this._scontext) {
                this.enterScope(baseRequest, dispatch);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("context={}|{}|{} @ {}", new Object[]{baseRequest.getContextPath(), baseRequest.getServletPath(), baseRequest.getPathInfo(), this});
            }
            this.nextScope((String)var1_1, baseRequest, (HttpServletRequest)var3_4, response);
            if (oldContext != this._scontext) {
                this.exitScope(baseRequest);
                if (this._classLoader != null && currentThread != null) {
                    currentThread.setContextClassLoader(oldClassloader);
                }
                baseRequest.setContext(oldContext);
                __context.set(oldContext);
                baseRequest.setContextPath(oldContextPath);
                baseRequest.setServletPath(oldServletPath);
                baseRequest.setPathInfo(oldPathInfo);
                return;
            }
        }
        catch (Throwable throwable) {
            if (oldContext != this._scontext) {
                void var2_3;
                this.exitScope(baseRequest);
                if (this._classLoader != null && currentThread != null) {
                    currentThread.setContextClassLoader(oldClassloader);
                }
                baseRequest.setContext(oldContext);
                __context.set(oldContext);
                baseRequest.setContextPath(oldContextPath);
                baseRequest.setServletPath(oldServletPath);
                var2_3.setPathInfo(oldPathInfo);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void requestInitialized(Request baseRequest, HttpServletRequest request) {
        if (!this._servletRequestAttributeListeners.isEmpty()) {
            for (ServletRequestAttributeListener l : this._servletRequestAttributeListeners) {
                baseRequest.addEventListener((EventListener)l);
            }
        }
        if (!this._servletRequestListeners.isEmpty()) {
            void var2_2;
            ServletRequestEvent sre = new ServletRequestEvent((ServletContext)this._scontext, (ServletRequest)var2_2);
            for (ServletRequestListener servletRequestListener : this._servletRequestListeners) {
                servletRequestListener.requestInitialized(sre);
            }
        }
    }

    protected void requestDestroyed(Request baseRequest, HttpServletRequest request) {
        if (!this._servletRequestListeners.isEmpty()) {
            ServletRequestEvent sre = new ServletRequestEvent((ServletContext)this._scontext, (ServletRequest)request);
            int i = this._servletRequestListeners.size();
            while (i-- > 0) {
                this._servletRequestListeners.get(i).requestDestroyed(sre);
            }
        }
        if (!this._servletRequestAttributeListeners.isEmpty()) {
            int i = this._servletRequestAttributeListeners.size();
            while (i-- > 0) {
                baseRequest.removeEventListener((EventListener)this._servletRequestAttributeListeners.get(i));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        void var1_1;
        boolean new_context;
        block7: {
            DispatcherType dispatch = baseRequest.getDispatcherType();
            new_context = baseRequest.takeNewContext();
            try {
                if (new_context) {
                    this.requestInitialized(baseRequest, request);
                }
                if (dispatch != DispatcherType.REQUEST || !this.isProtectedTarget(target)) break block7;
                baseRequest.setHandled(true);
                response.sendError(404);
                if (new_context) {
                    this.requestDestroyed(baseRequest, request);
                }
                return;
            }
            catch (Throwable throwable) {
                if (new_context) {
                    void var3_4;
                    void var2_3;
                    this.requestDestroyed((Request)var2_3, (HttpServletRequest)var3_4);
                }
                throw throwable;
            }
        }
        this.nextHandle((String)var1_1, baseRequest, request, response);
        if (new_context) {
            this.requestDestroyed(baseRequest, request);
            return;
        }
    }

    protected void enterScope(Request request, Object reason) {
        if (!this._contextListeners.isEmpty()) {
            for (ContextScopeListener listener : this._contextListeners) {
                try {
                    listener.enterScope(this._scontext, request, reason);
                }
                catch (Throwable e) {
                    LOG.warn(e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void exitScope(Request request) {
        if (!this._contextListeners.isEmpty()) {
            int i = this._contextListeners.size();
            while (i-- > 0) {
                try {
                    this._contextListeners.get(i).exitScope(this._scontext, request);
                }
                catch (Throwable e) {
                    void var3_3;
                    LOG.warn((Throwable)var3_3);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handle(Request request, Runnable runnable) {
        ClassLoader oldClassloader = null;
        Thread currentThread = null;
        Context oldContext = __context.get();
        if (oldContext == this._scontext) {
            runnable.run();
            return;
        }
        try {
            void var2_2;
            __context.set(this._scontext);
            if (this._classLoader != null) {
                currentThread = Thread.currentThread();
                oldClassloader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(this._classLoader);
            }
            this.enterScope(request, runnable);
            var2_2.run();
            this.exitScope(request);
            __context.set(oldContext);
            if (oldClassloader != null) {
                currentThread.setContextClassLoader(oldClassloader);
                return;
            }
        }
        catch (Throwable throwable) {
            void var1_1;
            this.exitScope((Request)var1_1);
            __context.set(oldContext);
            if (oldClassloader != null) {
                void var3_4;
                currentThread.setContextClassLoader((ClassLoader)var3_4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handle(Runnable runnable) {
        void var1_1;
        this.handle(null, (Runnable)var1_1);
    }

    public boolean isProtectedTarget(String target) {
        if (target == null || this._protectedTargets == null) {
            return false;
        }
        if (target.startsWith("//")) {
            target = URIUtil.compactPath((String)target);
        }
        String[] stringArray = this._protectedTargets;
        int n = this._protectedTargets.length;
        for (int i = 0; i < n; ++i) {
            String t = stringArray[i];
            if (!StringUtil.startsWithIgnoreCase((String)target, (String)t)) continue;
            if (target.length() == t.length()) {
                return true;
            }
            char c = target.charAt(t.length());
            if (c != '/' && c != '?' && c != '#' && c != ';') continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void setProtectedTargets(String[] targets) {
        void var1_1;
        if (targets == null) {
            this._protectedTargets = null;
            return;
        }
        void v0 = var1_1;
        this._protectedTargets = (String[])Arrays.copyOf(v0, ((void)v0).length);
    }

    public String[] getProtectedTargets() {
        if (this._protectedTargets == null) {
            return null;
        }
        return Arrays.copyOf(this._protectedTargets, this._protectedTargets.length);
    }

    /*
     * WARNING - void declaration
     */
    public void removeAttribute(String name) {
        void var1_1;
        this._attributes.removeAttribute((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String name, Object value) {
        void var2_2;
        void var1_1;
        this._attributes.setAttribute((String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setAttributes(Attributes attributes) {
        void var1_1;
        this._attributes.clearAttributes();
        this._attributes.addAll((Attributes)var1_1);
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    @Deprecated
    public void setManagedAttribute(String name, Object value) {
    }

    /*
     * WARNING - void declaration
     */
    public void setClassLoader(ClassLoader classLoader) {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._classLoader = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setContextPath(String contextPath) {
        if (contextPath == null) {
            throw new IllegalArgumentException("null contextPath");
        }
        if (contextPath.endsWith("/*")) {
            LOG.warn(this + " contextPath ends with /*", new Object[0]);
            contextPath = contextPath.substring(0, contextPath.length() - 2);
        } else if (contextPath.length() > 1 && contextPath.endsWith("/")) {
            LOG.warn(this + " contextPath ends with /", new Object[0]);
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        if (contextPath.length() == 0) {
            LOG.warn("Empty contextPath", new Object[0]);
            contextPath = "/";
        }
        this._contextPath = contextPath;
        this._contextPathEncoded = URIUtil.encodePath((String)contextPath);
        if (this.getServer() != null && (this.getServer().isStarting() || this.getServer().isStarted())) {
            Class<ContextHandlerCollection> handlerClass = ContextHandlerCollection.class;
            Handler[] contextCollections = this.getServer().getChildHandlersByClass(handlerClass);
            if (contextCollections != null) {
                void var2_2;
                for (void contextCollection : var2_2) {
                    ((ContextHandlerCollection)handlerClass.cast(contextCollection)).mapContexts();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDisplayName(String servletContextName) {
        void var1_1;
        this._displayName = var1_1;
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    @ManagedAttribute(value="document root for context")
    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void setBaseResource(Resource base) {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot call setBaseResource after starting");
        }
        this._baseResource = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setResourceBase(String resourceBase) {
        try {
            ContextHandler contextHandler = this;
            contextHandler.setBaseResource(contextHandler.newResource(resourceBase));
            return;
        }
        catch (Exception e) {
            void var1_1;
            void var2_2;
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug((Throwable)var2_2);
            throw new IllegalArgumentException((String)var1_1);
        }
    }

    public MimeTypes getMimeTypes() {
        if (this._mimeTypes == null) {
            this._mimeTypes = new MimeTypes();
        }
        return this._mimeTypes;
    }

    /*
     * WARNING - void declaration
     */
    public void setMimeTypes(MimeTypes mimeTypes) {
        void var1_1;
        this._mimeTypes = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWelcomeFiles(String[] files) {
        void var1_1;
        this._welcomeFiles = var1_1;
    }

    @ManagedAttribute(value="Partial URIs of directory welcome files", readonly=true)
    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    @ManagedAttribute(value="The error handler to use for the context")
    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    /*
     * WARNING - void declaration
     */
    public void setErrorHandler(ErrorHandler errorHandler) {
        void var1_1;
        if (errorHandler != null) {
            errorHandler.setServer(this.getServer());
        }
        ContextHandler contextHandler = this;
        contextHandler.updateBean(contextHandler._errorHandler, errorHandler, true);
        this._errorHandler = var1_1;
    }

    @ManagedAttribute(value="The maximum content size")
    public int getMaxFormContentSize() {
        return this._maxFormContentSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxFormContentSize(int maxSize) {
        void var1_1;
        this._maxFormContentSize = var1_1;
    }

    public int getMaxFormKeys() {
        return this._maxFormKeys;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxFormKeys(int max) {
        void var1_1;
        this._maxFormKeys = var1_1;
    }

    public boolean isCompactPath() {
        return this._compactPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setCompactPath(boolean compactPath) {
        void var1_1;
        this._compactPath = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var2_2;
        String p;
        String[] vhosts = this.getVirtualHosts();
        StringBuilder b = new StringBuilder();
        Package pkg = this.getClass().getPackage();
        if (pkg != null && (p = pkg.getName()) != null && p.length() > 0) {
            String[] stringArray;
            String[] stringArray2 = stringArray.split("\\.");
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String s = stringArray[i];
                b.append(s.charAt(0)).append('.');
            }
        }
        b.append(this.getClass().getSimpleName()).append('@').append(Integer.toString(this.hashCode(), 16));
        b.append('{');
        if (this.getDisplayName() != null) {
            b.append(this.getDisplayName()).append(',');
        }
        b.append(this.getContextPath()).append(',').append(this.getBaseResource()).append(',').append((Object)this._availability.get());
        if (vhosts != null && vhosts.length > 0) {
            void var1_1;
            b.append(',').append((String)var1_1[0]);
        }
        b.append('}');
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        void var1_1;
        if (className == null) {
            return null;
        }
        if (this._classLoader == null) {
            return Loader.loadClass((String)className);
        }
        return this._classLoader.loadClass((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addLocaleEncoding(String locale, String encoding) {
        void var2_2;
        void var1_1;
        if (this._localeEncodingMap == null) {
            this._localeEncodingMap = new HashMap<String, String>();
        }
        this._localeEncodingMap.put((String)var1_1, (String)var2_2);
    }

    public String getLocaleEncoding(String locale) {
        String string;
        if (this._localeEncodingMap == null) {
            return null;
        }
        string = this._localeEncodingMap.get(string);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String getLocaleEncoding(Locale locale) {
        void var2_2;
        if (this._localeEncodingMap == null) {
            return null;
        }
        String encoding = this._localeEncodingMap.get(locale.toString());
        if (encoding == null) {
            void var1_1;
            encoding = this._localeEncodingMap.get(var1_1.getLanguage());
        }
        return var2_2;
    }

    public Map<String, String> getLocaleEncodings() {
        if (this._localeEncodingMap == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._localeEncodingMap);
    }

    /*
     * WARNING - void declaration
     */
    public Resource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if (this._baseResource == null) {
            return null;
        }
        try {
            void var1_1;
            Resource resource = this._baseResource.addPath(path);
            if (this.checkAlias((String)var1_1, resource)) {
                return resource;
            }
            return null;
        }
        catch (Exception e) {
            void var2_3;
            LOG.ignore((Throwable)var2_3);
            return null;
        }
    }

    public boolean checkAlias(String path, Resource resource) {
        if (resource.isAlias()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aliased resource: " + resource + "~=" + resource.getAlias(), new Object[0]);
            }
            for (AliasCheck check : this.getAliasChecks()) {
                if (!check.check(path, resource)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Aliased resource: " + resource + " approved by " + check, new Object[0]);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public Resource newResource(URL url) throws IOException {
        return Resource.newResource((URL)url);
    }

    public Resource newResource(URI uri) throws IOException {
        return Resource.newResource((URI)uri);
    }

    public Resource newResource(String urlOrPath) throws IOException {
        return Resource.newResource((String)urlOrPath);
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getResourcePaths(String path) {
        try {
            Resource resource = this.getResource(path);
            if (resource != null && resource.exists()) {
                String[] l;
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if ((l = resource.list()) != null) {
                    void var3_4;
                    HashSet<String> set = new HashSet<String>();
                    for (int i = 0; i < l.length; ++i) {
                        set.add(path + l[i]);
                    }
                    return var3_4;
                }
            }
        }
        catch (Exception e) {
            void var2_3;
            LOG.ignore((Throwable)var2_3);
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    private String normalizeHostname(String host) {
        void var1_1;
        if (host == null) {
            return null;
        }
        int connectorIndex = host.indexOf(64);
        String connector = null;
        if (connectorIndex > 0) {
            void var2_2;
            host = host.substring(0, connectorIndex);
            connector = host.substring((int)var2_2);
        }
        if (host.endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        if (connector != null) {
            void var3_3;
            host = host + (String)var3_3;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addAliasCheck(AliasCheck check) {
        void var1_1;
        this._aliasChecks.add(check);
        if (check instanceof LifeCycle) {
            this.addManaged((LifeCycle)check);
            return;
        }
        this.addBean(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean removeAliasCheck(AliasCheck check) {
        void var2_2;
        boolean removed = this._aliasChecks.remove(check);
        if (removed) {
            void var1_1;
            this.removeBean(var1_1);
        }
        return (boolean)var2_2;
    }

    public List<AliasCheck> getAliasChecks() {
        return new AliasChecksList();
    }

    /*
     * WARNING - void declaration
     */
    public void setAliasChecks(List<AliasCheck> checks) {
        void var1_1;
        this.clearAliasChecks();
        var1_1.forEach(this::addAliasCheck);
    }

    public void clearAliasChecks() {
        this._aliasChecks.forEach(arg_0 -> ((ContextHandler)this).removeBean(arg_0));
        this._aliasChecks.clear();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$900(ContextHandler x0, AliasCheck x1) {
        void var1_1;
        return x0.removeAliasCheck((AliasCheck)var1_1);
    }

    private class AliasChecksList
    implements List<AliasCheck> {
        private AliasChecksList() {
        }

        @Override
        public int size() {
            return ContextHandler.this._aliasChecks.size();
        }

        @Override
        public boolean isEmpty() {
            return ContextHandler.this._aliasChecks.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return ContextHandler.this._aliasChecks.contains(var1_1);
        }

        @Override
        public Iterator<AliasCheck> iterator() {
            return new Iterator<AliasCheck>(this){
                private final Iterator<AliasCheck> _iterator;
                final /* synthetic */ AliasChecksList this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this._iterator = this.this$1.ContextHandler.this._aliasChecks.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this._iterator.hasNext();
                }

                @Override
                public AliasCheck next() {
                    return this._iterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void forEachRemaining(Consumer<? super AliasCheck> action) {
                    void var1_1;
                    this._iterator.forEachRemaining((Consumer<AliasCheck>)var1_1);
                }
            };
        }

        @Override
        public Object[] toArray() {
            return ContextHandler.this._aliasChecks.toArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] a) {
            void var1_1;
            return ContextHandler.this._aliasChecks.toArray((T[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean add(AliasCheck aliasCheck) {
            void var1_1;
            ContextHandler.this.addAliasCheck((AliasCheck)var1_1);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            void var1_1;
            return ContextHandler.access$900(ContextHandler.this, (AliasCheck)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            void var1_1;
            return ContextHandler.this._aliasChecks.containsAll((Collection<?>)var1_1);
        }

        @Override
        public boolean addAll(Collection<? extends AliasCheck> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends AliasCheck> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ContextHandler.this.clearAliasChecks();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AliasCheck get(int index) {
            void var1_1;
            return (AliasCheck)ContextHandler.this._aliasChecks.get((int)var1_1);
        }

        @Override
        public AliasCheck set(int index, AliasCheck element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, AliasCheck element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AliasCheck remove(int index) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object o) {
            void var1_1;
            return ContextHandler.this._aliasChecks.indexOf(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object o) {
            void var1_1;
            return ContextHandler.this._aliasChecks.lastIndexOf(var1_1);
        }

        @Override
        public ListIterator<AliasCheck> listIterator() {
            return this.listIterator(0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ListIterator<AliasCheck> listIterator(int index) {
            void var1_1;
            return new ListIterator<AliasCheck>(this, (int)var1_1){
                private final ListIterator<AliasCheck> _iterator;
                final /* synthetic */ int val$index;
                final /* synthetic */ AliasChecksList this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$index = n;
                    this._iterator = this.this$1.ContextHandler.this._aliasChecks.listIterator(this.val$index);
                }

                @Override
                public boolean hasNext() {
                    return this._iterator.hasNext();
                }

                @Override
                public AliasCheck next() {
                    return this._iterator.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this._iterator.hasPrevious();
                }

                @Override
                public AliasCheck previous() {
                    return this._iterator.previous();
                }

                @Override
                public int nextIndex() {
                    return this._iterator.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this._iterator.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(AliasCheck check) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(AliasCheck check) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public List<AliasCheck> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }

    private static class Caller
    extends SecurityManager {
        private Caller() {
        }

        /*
         * WARNING - void declaration
         */
        public ClassLoader getCallerClassLoader(int depth) {
            void var1_1;
            void var2_2;
            if (depth < 0) {
                return null;
            }
            Class<?>[] classContext = this.getClassContext();
            if (classContext.length <= depth) {
                return null;
            }
            return var2_2[var1_1].getClassLoader();
        }
    }

    public static interface ContextScopeListener
    extends EventListener {
        public void enterScope(Context var1, Request var2, Object var3);

        public void exitScope(Context var1, Request var2);
    }

    @Deprecated
    public static class ApproveNonExistentDirectoryAliases
    implements AliasCheck {
        /*
         * WARNING - void declaration
         */
        @Override
        public boolean check(String path, Resource resource) {
            void var2_2;
            void var1_1;
            if (resource.exists()) {
                return false;
            }
            String a = resource.getAlias().toString();
            String r = resource.getURI().toString();
            if (a.length() > r.length()) {
                return a.startsWith(r) && a.length() == r.length() + 1 && a.endsWith("/");
            }
            if (a.length() < r.length()) {
                return r.startsWith(a) && r.length() == a.length() + 1 && r.endsWith("/");
            }
            return var1_1.equals(var2_2);
        }
    }

    @Deprecated
    public static class ApproveAliases
    implements AliasCheck {
        @Override
        public boolean check(String path, Resource resource) {
            return true;
        }
    }

    public static interface AliasCheck {
        public boolean check(String var1, Resource var2);
    }

    public static class StaticContext
    extends AttributesMap
    implements ServletContext {
        private int _effectiveMajorVersion = 3;
        private int _effectiveMinorVersion = 1;

        public ServletContext getContext(String uripath) {
            return null;
        }

        public int getMajorVersion() {
            return 3;
        }

        public String getMimeType(String file) {
            return null;
        }

        public int getMinorVersion() {
            return 1;
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String uriInContext) {
            return null;
        }

        public String getRealPath(String path) {
            return null;
        }

        public URL getResource(String path) throws MalformedURLException {
            return null;
        }

        public InputStream getResourceAsStream(String path) {
            return null;
        }

        public Set<String> getResourcePaths(String path) {
            return null;
        }

        public String getServerInfo() {
            return ContextHandler.getServerInfo();
        }

        @Deprecated
        public Servlet getServlet(String name) throws ServletException {
            return null;
        }

        @Deprecated
        public Enumeration<String> getServletNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        @Deprecated
        public Enumeration<Servlet> getServlets() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        /*
         * WARNING - void declaration
         */
        public void log(Exception exception, String msg) {
            void var1_1;
            void var2_2;
            LOG.warn((String)var2_2, (Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void log(String msg) {
            void var1_1;
            LOG.info((String)var1_1, new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        public void log(String message, Throwable throwable) {
            void var2_2;
            void var1_1;
            LOG.warn((String)var1_1, (Throwable)var2_2);
        }

        public String getInitParameter(String name) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public String getServletContextName() {
            return "No Context";
        }

        public String getContextPath() {
            return null;
        }

        public boolean setInitParameter(String name, String value) {
            return false;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"addFilter(String, Class)"});
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"addFilter(String, Filter)"});
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"addFilter(String, String)"});
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"addServlet(String, Class)"});
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"addServlet(String, Servlet)"});
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"addServlet(String, String)"});
            return null;
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"getDefaultSessionTrackingModes()"});
            return null;
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"getEffectiveSessionTrackingModes()"});
            return null;
        }

        public FilterRegistration getFilterRegistration(String filterName) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"getFilterRegistration(String)"});
            return null;
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"getFilterRegistrations()"});
            return null;
        }

        public ServletRegistration getServletRegistration(String servletName) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"getServletRegistration(String)"});
            return null;
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"getServletRegistrations()"});
            return null;
        }

        public SessionCookieConfig getSessionCookieConfig() {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"getSessionCookieConfig()"});
            return null;
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"setSessionTrackingModes(Set<SessionTrackingMode>)"});
        }

        public void addListener(String className) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"addListener(String)"});
        }

        public <T extends EventListener> void addListener(T t) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"addListener(T)"});
        }

        public void addListener(Class<? extends EventListener> listenerClass) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"addListener(Class)"});
        }

        /*
         * WARNING - void declaration
         */
        protected <T> T createInstance(Class<T> clazz) throws ServletException {
            try {
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                void var1_2;
                throw new ServletException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
            void var1_1;
            return (T)((EventListener)this.createInstance((Class<T>)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
            void var1_1;
            return (T)((Servlet)this.createInstance((Class<T>)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
            void var1_1;
            return (T)((Filter)this.createInstance((Class<T>)var1_1));
        }

        public ClassLoader getClassLoader() {
            return ContextHandler.class.getClassLoader();
        }

        public int getEffectiveMajorVersion() {
            return this._effectiveMajorVersion;
        }

        public int getEffectiveMinorVersion() {
            return this._effectiveMinorVersion;
        }

        /*
         * WARNING - void declaration
         */
        public void setEffectiveMajorVersion(int v) {
            void var1_1;
            this._effectiveMajorVersion = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setEffectiveMinorVersion(int v) {
            void var1_1;
            this._effectiveMinorVersion = var1_1;
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"getJspConfigDescriptor()"});
            return null;
        }

        public void declareRoles(String ... roleNames) {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"declareRoles(String...)"});
        }

        public String getVirtualServerName() {
            return null;
        }
    }

    public class Context
    extends StaticContext {
        protected boolean _enabled = true;
        protected boolean _extendedListenerTypes = false;
        final /* synthetic */ ContextHandler this$0;

        /*
         * WARNING - void declaration
         */
        protected Context(ContextHandler this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public ContextHandler getContextHandler() {
            return this.this$0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ServletContext getContext(String uripath) {
            void var3_3;
            ContextHandler ch;
            String contextPath;
            ArrayList<ContextHandler> contexts = new ArrayList<ContextHandler>();
            Handler[] handlers = this.this$0.getServer().getChildHandlersByClass(ContextHandler.class);
            String matchedPath = null;
            Handler[] handlerArray = handlers;
            int n = handlers.length;
            for (int i = 0; i < n; ++i) {
                Handler handler = handlerArray[i];
                if (handler == null || !uripath.equals(contextPath = (ch = (ContextHandler)handler).getContextPath()) && (!uripath.startsWith(contextPath) || uripath.charAt(contextPath.length()) != '/') && !"/".equals(contextPath)) continue;
                if (this.this$0.getVirtualHosts() != null && this.this$0.getVirtualHosts().length > 0) {
                    if (ch.getVirtualHosts() == null || ch.getVirtualHosts().length <= 0) continue;
                    for (String h1 : this.this$0.getVirtualHosts()) {
                        for (String h2 : ch.getVirtualHosts()) {
                            if (!h1.equals(h2)) continue;
                            if (matchedPath == null || contextPath.length() > matchedPath.length()) {
                                contexts.clear();
                                matchedPath = contextPath;
                            }
                            if (!matchedPath.equals(contextPath)) continue;
                            contexts.add(ch);
                        }
                    }
                    continue;
                }
                if (matchedPath == null || contextPath.length() > matchedPath.length()) {
                    contexts.clear();
                    matchedPath = contextPath;
                }
                if (!matchedPath.equals(contextPath)) continue;
                contexts.add(ch);
            }
            if (contexts.size() > 0) {
                return ((ContextHandler)contexts.get((int)0))._scontext;
            }
            matchedPath = null;
            for (Handler handler : var3_3) {
                if (handler == null || !uripath.equals(contextPath = (ch = (ContextHandler)handler).getContextPath()) && (!uripath.startsWith(contextPath) || uripath.charAt(contextPath.length()) != '/') && !"/".equals(contextPath)) continue;
                if (matchedPath == null || contextPath.length() > matchedPath.length()) {
                    contexts.clear();
                    matchedPath = contextPath;
                }
                if (!matchedPath.equals(contextPath)) continue;
                contexts.add(ch);
            }
            if (contexts.size() > 0) {
                void var2_2;
                return ((ContextHandler)var2_2.get((int)0))._scontext;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getMimeType(String file) {
            void var1_1;
            if (this.this$0._mimeTypes == null) {
                return null;
            }
            return this.this$0._mimeTypes.getMimeByExtension((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RequestDispatcher getRequestDispatcher(String uriInContext) {
            if (uriInContext == null) {
                return null;
            }
            if (!uriInContext.startsWith("/")) {
                return null;
            }
            try {
                void var2_3;
                HttpURI uri = new HttpURI(null, null, 0, uriInContext);
                String pathInfo = uri.getDecodedPath();
                String contextPath = ((StaticContext)this).getContextPath();
                if (contextPath != null && contextPath.length() > 0) {
                    void var3_4;
                    uri.setPath(URIUtil.addPaths((String)var3_4, (String)uri.getPath()));
                }
                return new Dispatcher(this.this$0, uri, (String)var2_3);
            }
            catch (Exception e) {
                void var1_2;
                LOG.ignore((Throwable)var1_2);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getRealPath(String path) {
            if ((path = URIUtil.canonicalPath((String)path)) == null) {
                return null;
            }
            if (path.length() == 0) {
                path = "/";
            } else if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            try {
                File file;
                Resource resource = this.this$0.getResource(path);
                if (resource != null && (file = resource.getFile()) != null) {
                    return file.getCanonicalPath();
                }
            }
            catch (Exception e) {
                void var1_2;
                LOG.ignore((Throwable)var1_2);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public URL getResource(String path) throws MalformedURLException {
            if ((path = URIUtil.canonicalPath((String)path)) == null) {
                return null;
            }
            Resource resource = this.this$0.getResource(path);
            if (resource != null && resource.exists()) {
                void var1_1;
                return var1_1.getURI().toURL();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public InputStream getResourceAsStream(String path) {
            try {
                URL url = ((StaticContext)this).getResource(path);
                if (url == null) {
                    return null;
                }
                Resource r = Resource.newResource((URL)url);
                if (r.isDirectory()) {
                    return null;
                }
                return r.getInputStream();
            }
            catch (Exception e) {
                void var1_2;
                LOG.ignore((Throwable)var1_2);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<String> getResourcePaths(String path) {
            void var1_1;
            if ((path = URIUtil.canonicalPath((String)path)) == null) {
                return null;
            }
            return this.this$0.getResourcePaths((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void log(Exception exception, String msg) {
            void var1_1;
            void var2_2;
            this.this$0._logger.warn((String)var2_2, (Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void log(String msg) {
            void var1_1;
            this.this$0._logger.info((String)var1_1, new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void log(String message, Throwable throwable) {
            void var2_2;
            void var1_1;
            this.this$0._logger.warn((String)var1_1, (Throwable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getInitParameter(String name) {
            void var1_1;
            return this.this$0.getInitParameter((String)var1_1);
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return this.this$0.getInitParameterNames();
        }

        /*
         * WARNING - void declaration
         */
        public Object getAttribute(String name) {
            void var2_2;
            Object o = this.this$0.getAttribute(name);
            if (o == null) {
                void var1_1;
                o = super.getAttribute((String)var1_1);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Enumeration<String> getAttributeNames() {
            void var1_1;
            HashSet<String> set = new HashSet<String>();
            Enumeration e = super.getAttributeNames();
            while (e.hasMoreElements()) {
                set.add((String)e.nextElement());
            }
            e = this.this$0._attributes.getAttributeNames();
            while (e.hasMoreElements()) {
                set.add((String)e.nextElement());
            }
            return Collections.enumeration(var1_1);
        }

        public void setAttribute(String name, Object value) {
            Object oldValue = super.getAttribute(name);
            if (value == null) {
                super.removeAttribute(name);
            } else {
                super.setAttribute(name, value);
            }
            if (!this.this$0._servletContextAttributeListeners.isEmpty()) {
                ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this.this$0._scontext, name, oldValue == null ? value : oldValue);
                for (ServletContextAttributeListener l : this.this$0._servletContextAttributeListeners) {
                    if (oldValue == null) {
                        l.attributeAdded(event);
                        continue;
                    }
                    if (value == null) {
                        l.attributeRemoved(event);
                        continue;
                    }
                    l.attributeReplaced(event);
                }
            }
        }

        public void removeAttribute(String name) {
            Object oldValue = super.getAttribute(name);
            super.removeAttribute(name);
            if (oldValue != null && !this.this$0._servletContextAttributeListeners.isEmpty()) {
                Iterator iterator;
                ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this.this$0._scontext, name, (Object)iterator);
                for (ServletContextAttributeListener servletContextAttributeListener : this.this$0._servletContextAttributeListeners) {
                    servletContextAttributeListener.attributeRemoved(event);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getServletContextName() {
            void var1_1;
            String name = this.this$0.getDisplayName();
            if (name == null) {
                name = this.this$0.getContextPath();
            }
            return var1_1;
        }

        @Override
        public String getContextPath() {
            return this.this$0.getRequestContextPath();
        }

        public String toString() {
            return "ServletContext@" + this.this$0.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean setInitParameter(String name, String value) {
            void var2_2;
            void var1_1;
            if (this.this$0.getInitParameter(name) != null) {
                return false;
            }
            this.this$0.getInitParams().put((String)var1_1, (String)var2_2);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void addListener(String className) {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            try {
                Class<?> clazz = this.this$0._classLoader == null ? Loader.loadClass((String)className) : this.this$0._classLoader.loadClass(className);
                ((StaticContext)this).addListener(clazz);
                return;
            }
            catch (ClassNotFoundException e) {
                void var1_2;
                throw new IllegalArgumentException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T extends EventListener> void addListener(T t) {
            void var1_1;
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            this.checkListener(t.getClass());
            this.this$0.addEventListener(t);
            this.this$0.addProgrammaticListener((EventListener)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void addListener(Class<? extends EventListener> listenerClass) {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            try {
                EventListener e = this.createListener(listenerClass);
                ((StaticContext)this).addListener(e);
                return;
            }
            catch (ServletException e) {
                void var1_2;
                throw new IllegalArgumentException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void checkListener(Class<? extends EventListener> listener) throws IllegalStateException {
            void var2_2;
            boolean ok = false;
            int i = this.isExtendedListenerTypes() ? 0 : 1;
            for (i = i; i < SERVLET_LISTENER_TYPES.length; ++i) {
                if (!SERVLET_LISTENER_TYPES[i].isAssignableFrom(listener)) continue;
                ok = true;
                break;
            }
            if (var2_2 == false) {
                void var1_1;
                throw new IllegalArgumentException("Inappropriate listener class " + var1_1.getName());
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setExtendedListenerTypes(boolean extended) {
            void var1_1;
            this._extendedListenerTypes = var1_1;
        }

        public boolean isExtendedListenerTypes() {
            return this._extendedListenerTypes;
        }

        @Override
        public ClassLoader getClassLoader() {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            if (!this.this$0.isUsingSecurityManager()) {
                return this.this$0._classLoader;
            }
            Caller caller = AccessController.doPrivileged(() -> new Caller());
            for (ClassLoader callerLoader = caller.getCallerClassLoader(2); callerLoader != null; callerLoader = callerLoader.getParent()) {
                if (callerLoader != this.this$0._classLoader) continue;
                return this.this$0._classLoader;
            }
            System.getSecurityManager().checkPermission(new RuntimePermission("getClassLoader"));
            return this.this$0._classLoader;
        }

        @Override
        public JspConfigDescriptor getJspConfigDescriptor() {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, new Object[]{"getJspConfigDescriptor()"});
            return null;
        }

        public void setJspConfigDescriptor(JspConfigDescriptor d) {
        }

        @Override
        public void declareRoles(String ... roleNames) {
            if (!this.this$0.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setEnabled(boolean enabled) {
            void var1_1;
            this._enabled = var1_1;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getVirtualServerName() {
            String[] hosts = this.this$0.getVirtualHosts();
            if (hosts != null && hosts.length > 0) {
                void var1_1;
                return var1_1[0];
            }
            return null;
        }
    }

    public static enum Availability {
        STOPPED,
        STARTING,
        AVAILABLE,
        UNAVAILABLE,
        SHUTDOWN;

    }

    public static enum ContextStatus {
        NOTSET,
        INITIALIZED,
        DESTROYED;

    }
}

