/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class BufferedResponseHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(BufferedResponseHandler.class);
    private final IncludeExclude<String> _methods = new IncludeExclude();
    private final IncludeExclude<String> _paths = new IncludeExclude(PathSpecSet.class);
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude();

    /*
     * WARNING - void declaration
     */
    public BufferedResponseHandler() {
        this._methods.include((Object)HttpMethod.GET.asString());
        for (String type : MimeTypes.getKnownMimeTypes()) {
            void var2_2;
            if (!type.startsWith("image/") && !type.startsWith("audio/") && !type.startsWith("video/")) continue;
            this._mimeTypes.exclude((Object)var2_2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} mime types {}", new Object[]{this, this._mimeTypes});
        }
    }

    public IncludeExclude<String> getMethodIncludeExclude() {
        return this._methods;
    }

    public IncludeExclude<String> getPathIncludeExclude() {
        return this._paths;
    }

    public IncludeExclude<String> getMimeIncludeExclude() {
        return this._mimeTypes;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isMimeTypeBufferable(String mimetype) {
        void var1_1;
        return this._mimeTypes.test((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isPathBufferable(String requestURI) {
        void var1_1;
        if (requestURI == null) {
            return true;
        }
        return this._paths.test((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean shouldBuffer(HttpChannel channel, boolean last) {
        void var1_1;
        void var2_2;
        if (last) {
            return false;
        }
        Response response = channel.getResponse();
        int status = response.getStatus();
        if (HttpStatus.hasNoBody((int)status) || HttpStatus.isRedirection((int)var2_2)) {
            return false;
        }
        String ct = response.getContentType();
        if (ct == null) {
            return true;
        }
        ct = MimeTypes.getContentTypeWithoutCharset((String)ct);
        return this.isMimeTypeBufferable(StringUtil.asciiToLowerCase((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path;
        ServletContext context = baseRequest.getServletContext();
        String string = path = context == null ? baseRequest.getRequestURI() : URIUtil.addPaths((String)baseRequest.getServletPath(), (String)baseRequest.getPathInfo());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} handle {} in {}", new Object[]{this, baseRequest, context});
        }
        HttpOutput out = baseRequest.getResponse().getHttpOutput();
        for (HttpOutput.Interceptor interceptor = out.getInterceptor(); interceptor != null; interceptor = interceptor.getNextInterceptor()) {
            if (!(interceptor instanceof BufferedInterceptor)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} already intercepting {}", new Object[]{this, request});
            }
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        if (!this._methods.test((Object)baseRequest.getMethod())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} excluded by method {}", new Object[]{this, request});
            }
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        if (!this.isPathBufferable(path)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} excluded by path {}", new Object[]{this, request});
            }
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        String mimeType = context == null ? MimeTypes.getDefaultMimeByExtension((String)path) : context.getMimeType(path);
        if (mimeType != null && !this.isMimeTypeBufferable(mimeType = MimeTypes.getContentTypeWithoutCharset((String)mimeType))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} excluded by path suffix mime type {}", new Object[]{this, request});
            }
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        out.setInterceptor(this.newBufferedInterceptor(baseRequest.getHttpChannel(), out.getInterceptor()));
        if (this._handler != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this._handler.handle((String)var1_1, (Request)var2_2, (HttpServletRequest)var3_3, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected BufferedInterceptor newBufferedInterceptor(HttpChannel httpChannel, HttpOutput.Interceptor interceptor) {
        void var2_2;
        void var1_1;
        return new ArrayBufferedInterceptor(this, (HttpChannel)var1_1, (HttpOutput.Interceptor)var2_2);
    }

    class ArrayBufferedInterceptor
    implements BufferedInterceptor {
        private final HttpOutput.Interceptor _next;
        private final HttpChannel _channel;
        private final Queue<ByteBuffer> _buffers = new ArrayDeque<ByteBuffer>();
        private Boolean _aggregating;
        private ByteBuffer _aggregate;
        final /* synthetic */ BufferedResponseHandler this$0;

        /*
         * WARNING - void declaration
         */
        public ArrayBufferedInterceptor(BufferedResponseHandler this$0, HttpChannel httpChannel, HttpOutput.Interceptor interceptor) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.this$0 = var1_1;
            this._next = var3_3;
            this._channel = var2_2;
        }

        @Override
        public HttpOutput.Interceptor getNextInterceptor() {
            return this._next;
        }

        @Override
        public boolean isOptimizedForDirectBuffers() {
            return false;
        }

        @Override
        public void resetBuffer() {
            this._buffers.clear();
            this._aggregating = null;
            this._aggregate = null;
            BufferedInterceptor.super.resetBuffer();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(ByteBuffer content, boolean last, Callback callback) {
            void var3_3;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} write last={} {}", new Object[]{this, last, BufferUtil.toDetailString((ByteBuffer)content)});
            }
            if (this._aggregating == null) {
                this._aggregating = this.this$0.shouldBuffer(this._channel, last);
            }
            if (!this._aggregating.booleanValue()) {
                this.getNextInterceptor().write(content, last, callback);
                return;
            }
            if (last) {
                if (BufferUtil.length((ByteBuffer)content) > 0) {
                    this._buffers.offer(content);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} committing {}", new Object[]{this, this._buffers.size()});
                }
                this.commit(callback);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} aggregating", new Object[]{this});
            }
            while (BufferUtil.hasContent((ByteBuffer)content)) {
                if (BufferUtil.space((ByteBuffer)this._aggregate) == 0) {
                    void var2_2;
                    int size = Math.max(this._channel.getHttpConfiguration().getOutputBufferSize(), BufferUtil.length((ByteBuffer)content));
                    this._aggregate = BufferUtil.allocate((int)var2_2);
                    this._buffers.offer(this._aggregate);
                }
                BufferUtil.append((ByteBuffer)this._aggregate, (ByteBuffer)content);
            }
            var3_3.succeeded();
        }

        private void commit(Callback callback) {
            IteratingCallback iteratingCallback;
            if (this._buffers.size() == 0) {
                this.getNextInterceptor().write(BufferUtil.EMPTY_BUFFER, true, callback);
                return;
            }
            if (this._buffers.size() == 1) {
                this.getNextInterceptor().write(this._buffers.poll(), true, callback);
                return;
            }
            iteratingCallback = new IteratingCallback(this, (Callback)iteratingCallback){
                final /* synthetic */ Callback val$callback;
                final /* synthetic */ ArrayBufferedInterceptor this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$callback = callback;
                }

                /*
                 * WARNING - void declaration
                 */
                protected IteratingCallback.Action process() {
                    void var1_1;
                    ByteBuffer buffer = (ByteBuffer)this.this$1._buffers.poll();
                    if (buffer == null) {
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    this.this$1.getNextInterceptor().write((ByteBuffer)var1_1, this.this$1._buffers.isEmpty(), (Callback)this);
                    return IteratingCallback.Action.SCHEDULED;
                }

                protected void onCompleteSuccess() {
                    this.val$callback.succeeded();
                }

                /*
                 * WARNING - void declaration
                 */
                protected void onCompleteFailure(Throwable cause) {
                    void var1_1;
                    this.val$callback.failed((Throwable)var1_1);
                }
            };
            iteratingCallback.iterate();
        }
    }

    protected static interface BufferedInterceptor
    extends HttpOutput.Interceptor {
    }
}

