/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.component.Graceful;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractHandlerContainer
extends AbstractHandler
implements HandlerContainer {
    private static final Logger LOG = Log.getLogger(AbstractHandlerContainer.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public Handler[] getChildHandlers() {
        void var1_1;
        ArrayList<Handler> list = new ArrayList<Handler>();
        this.expandChildren(list, null);
        void v0 = var1_1;
        return v0.toArray(new Handler[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Handler[] getChildHandlersByClass(Class<?> byclass) {
        void var2_2;
        void var1_1;
        ArrayList<Handler> list = new ArrayList<Handler>();
        this.expandChildren((List<Handler>)list, (Class<?>)var1_1);
        void v0 = var2_2;
        return v0.toArray(new Handler[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Handler> T getChildHandlerByClass(Class<T> byclass) {
        void var2_2;
        void var1_1;
        ArrayList<Handler> list = new ArrayList<Handler>();
        this.expandChildren((List<Handler>)list, (Class<?>)var1_1);
        if (list.isEmpty()) {
            return null;
        }
        return (T)((Handler)var2_2.get(0));
    }

    protected void expandChildren(List<Handler> list, Class<?> byClass) {
    }

    /*
     * WARNING - void declaration
     */
    protected void expandHandler(Handler handler, List<Handler> list, Class<?> byClass) {
        if (handler == null) {
            return;
        }
        if (byClass == null || byClass.isAssignableFrom(handler.getClass())) {
            list.add(handler);
        }
        if (handler instanceof AbstractHandlerContainer) {
            ((AbstractHandlerContainer)handler).expandChildren(list, byClass);
            return;
        }
        if (handler instanceof HandlerContainer) {
            void var1_1;
            void var2_2;
            void var3_3;
            HandlerContainer container = (HandlerContainer)((Object)handler);
            Handler[] handlers = byClass == null ? container.getChildHandlers() : container.getChildHandlersByClass((Class<?>)var3_3);
            var2_2.addAll(Arrays.asList(var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends HandlerContainer> T findContainerOf(HandlerContainer root, Class<T> type, Handler handler) {
        void var1_1;
        if (root == null || handler == null) {
            return null;
        }
        Handler[] branches = root.getChildHandlersByClass((Class<?>)var1_1);
        if (branches != null) {
            Handler[] handlerArray;
            for (Handler handler2 : handlerArray) {
                HandlerContainer container = (HandlerContainer)((Object)handler2);
                Handler[] candidates = container.getChildHandlersByClass(handler.getClass());
                if (candidates == null) continue;
                Handler[] handlerArray2 = candidates;
                int n = candidates.length;
                for (int i = 0; i < n; ++i) {
                    Handler handler3 = handlerArray2[i];
                    if (handler3 != handler) continue;
                    return (T)container;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setServer(Server server) {
        if (server == this.getServer()) {
            return;
        }
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        super.setServer(server);
        Handler[] handlers = this.getHandlers();
        if (handlers != null) {
            void var2_2;
            for (void var5_5 : var2_2) {
                var5_5.setServer(server);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doShutdown(List<Future<Void>> futures) throws MultiException {
        void var1_1;
        Iterator<Future<Void>> iterator;
        MultiException mex = null;
        Handler[] gracefuls = this.getChildHandlersByClass(Graceful.class);
        if (futures == null) {
            futures = new ArrayList<Future<Void>>(gracefuls.length);
        }
        for (void graceful : iterator) {
            futures.add(((Graceful)graceful).shutdown());
        }
        long stopTimeout = this.getStopTimeout();
        if (stopTimeout > 0L) {
            long stopBy = System.currentTimeMillis() + stopTimeout;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Graceful shutdown {} by ", new Object[]{this, new Date(stopBy)});
            }
            for (Future<Void> future : futures) {
                try {
                    if (future.isDone()) continue;
                    future.get(Math.max(1L, stopBy - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    if (future instanceof Callback && !future.isDone()) {
                        ((Callback)future).failed((Throwable)e);
                    }
                    if (mex == null) {
                        mex = new MultiException();
                    }
                    mex.add((Throwable)e);
                }
            }
        }
        for (Future future : var1_1) {
            if (future.isDone()) continue;
            future.cancel(true);
        }
        if (mex != null) {
            void var2_2;
            var2_2.ifExceptionThrowMulti();
        }
    }
}

