/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jetty.server.AllowedResourceAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SymlinkAllowedResourceAliasChecker
extends AllowedResourceAliasChecker {
    private static final Logger LOG = Log.getLogger(SymlinkAllowedResourceAliasChecker.class);

    /*
     * WARNING - void declaration
     */
    public SymlinkAllowedResourceAliasChecker(ContextHandler contextHandler) {
        super((ContextHandler)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean check(String pathInContext, Path path) {
        void var2_3;
        void var3_4;
        if (this._base == null) {
            return false;
        }
        if (File.separatorChar != '/' && pathInContext.indexOf(File.separatorChar) >= 0) {
            return false;
        }
        String[] segments = pathInContext.substring(1).split("/");
        Path fromBase = this._base;
        StringBuilder realURI = new StringBuilder();
        try {
            for (String segment : segments) {
                fromBase = fromBase.resolve(segment);
                realURI.append("/").append(fromBase.toRealPath(NO_FOLLOW_LINKS).getFileName());
                if (Files.isSymbolicLink(fromBase)) {
                    return !this.getContextHandler().isProtectedTarget(realURI.toString());
                }
                if (this.isAllowed(fromBase)) continue;
                return false;
            }
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                void var1_2;
                LOG.debug("Failed to check alias", (Throwable)var1_2);
            }
            return false;
        }
        return this.isSameFile((Path)var3_4, (Path)var2_3);
    }
}

