/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslConnectionFactory
extends AbstractConnectionFactory
implements ConnectionFactory.Detecting {
    private static final int TLS_ALERT_FRAME_TYPE = 21;
    private static final int TLS_HANDSHAKE_FRAME_TYPE = 22;
    private static final int TLS_MAJOR_VERSION = 3;
    private final SslContextFactory _sslContextFactory;
    private final String _nextProtocol;
    private boolean _directBuffersForEncryption = false;
    private boolean _directBuffersForDecryption = false;

    public SslConnectionFactory() {
        this(HttpVersion.HTTP_1_1.asString());
    }

    /*
     * WARNING - void declaration
     */
    public SslConnectionFactory(@Name(value="next") String nextProtocol) {
        this((SslContextFactory)null, (String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SslConnectionFactory(@Name(value="sslContextFactory") SslContextFactory factory, @Name(value="next") String nextProtocol) {
        super("SSL");
        void var2_2;
        void var1_1;
        this._sslContextFactory = factory == null ? new SslContextFactory.Server() : var1_1;
        this._nextProtocol = var2_2;
        SslConnectionFactory sslConnectionFactory = this;
        sslConnectionFactory.addBean(sslConnectionFactory._sslContextFactory);
    }

    public SslContextFactory getSslContextFactory() {
        return this._sslContextFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void setDirectBuffersForEncryption(boolean useDirectBuffers) {
        void var1_1;
        this._directBuffersForEncryption = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setDirectBuffersForDecryption(boolean useDirectBuffers) {
        void var1_1;
        this._directBuffersForDecryption = var1_1;
    }

    public boolean isDirectBuffersForDecryption() {
        return this._directBuffersForDecryption;
    }

    public boolean isDirectBuffersForEncryption() {
        return this._directBuffersForEncryption;
    }

    public String getNextProtocol() {
        return this._nextProtocol;
    }

    /*
     * WARNING - void declaration
     */
    protected void doStart() throws Exception {
        super.doStart();
        SSLEngine engine = this._sslContextFactory.newSSLEngine();
        engine.setUseClientMode(false);
        SSLSession session = engine.getSession();
        if (session.getPacketBufferSize() > this.getInputBufferSize()) {
            void var1_1;
            this.setInputBufferSize(var1_1.getPacketBufferSize());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConnectionFactory.Detecting.Detection detect(ByteBuffer buffer) {
        int n;
        void var2_3;
        if (buffer.remaining() < 2) {
            return ConnectionFactory.Detecting.Detection.NEED_MORE_BYTES;
        }
        int tlsFrameType = buffer.get(0) & 0xFF;
        int tlsMajorVersion = buffer.get(1) & 0xFF;
        n = (tlsFrameType == 22 || var2_3 == 21) && n == 3 ? 1 : 0;
        if (n != 0) {
            return ConnectionFactory.Detecting.Detection.RECOGNIZED;
        }
        return ConnectionFactory.Detecting.Detection.NOT_RECOGNIZED;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        void var3_3;
        void var1_1;
        void var2_2;
        SSLEngine engine = this._sslContextFactory.newSSLEngine(endPoint.getRemoteAddress());
        engine.setUseClientMode(false);
        SslConnection sslConnection = this.newSslConnection(connector, endPoint, engine);
        sslConnection.setRenegotiationAllowed(this._sslContextFactory.isRenegotiationAllowed());
        sslConnection.setRenegotiationLimit(this._sslContextFactory.getRenegotiationLimit());
        this.configure((AbstractConnection)sslConnection, connector, endPoint);
        ConnectionFactory next = connector.getConnectionFactory(this._nextProtocol);
        SslConnection.DecryptedEndPoint decryptedEndPoint = sslConnection.getDecryptedEndPoint();
        Connection connection = var2_2.newConnection(connector, (EndPoint)decryptedEndPoint);
        decryptedEndPoint.setConnection((Connection)var1_1);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected SslConnection newSslConnection(Connector connector, EndPoint endPoint, SSLEngine engine) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new SslConnection(connector.getByteBufferPool(), var1_1.getExecutor(), (EndPoint)var2_2, (SSLEngine)var3_3, this.isDirectBuffersForEncryption(), this.isDirectBuffersForDecryption());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected AbstractConnection configure(AbstractConnection connection, Connector connector, EndPoint endPoint) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (connection instanceof SslConnection) {
            SslConnection sslConnection = (SslConnection)connection;
            if (connector instanceof ContainerLifeCycle) {
                ContainerLifeCycle containerLifeCycle = (ContainerLifeCycle)connector;
                containerLifeCycle.getBeans(SslHandshakeListener.class).forEach(arg_0 -> ((SslConnection)sslConnection).addHandshakeListener(arg_0));
            }
            this.getBeans(SslHandshakeListener.class).forEach(arg_0 -> ((SslConnection)sslConnection).addHandshakeListener(arg_0));
        }
        return super.configure((AbstractConnection)var1_1, (Connector)var2_2, (EndPoint)var3_3);
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s->%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocol(), this._nextProtocol);
    }
}

