/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ShutdownThread;

public class ShutdownMonitor {
    private final Set<LifeCycle> _lifeCycles = new LinkedHashSet<LifeCycle>();
    private boolean debug = System.getProperty("DEBUG") != null;
    private final String host = System.getProperty("STOP.HOST", "127.0.0.1");
    private int port = Integer.getInteger("STOP.PORT", -1);
    private String key = System.getProperty("STOP.KEY", null);
    private boolean exitVm = Boolean.valueOf(System.getProperty("STOP.EXIT", "true"));
    private boolean alive;

    public static ShutdownMonitor getInstance() {
        return Holder.instance;
    }

    protected static void reset() {
        Holder.instance = new ShutdownMonitor();
    }

    public static void register(LifeCycle ... lifeCycles) {
        LifeCycle[] lifeCycleArray;
        ShutdownMonitor.getInstance().addLifeCycles(lifeCycleArray);
    }

    public static void deregister(LifeCycle lifeCycle) {
        LifeCycle lifeCycle2;
        ShutdownMonitor.getInstance().removeLifeCycle(lifeCycle2);
    }

    public static boolean isRegistered(LifeCycle lifeCycle) {
        LifeCycle lifeCycle2;
        return ShutdownMonitor.getInstance().containsLifeCycle(lifeCycle2);
    }

    private ShutdownMonitor() {
    }

    /*
     * WARNING - void declaration
     */
    private void addLifeCycles(LifeCycle ... lifeCycles) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            void var1_1;
            this._lifeCycles.addAll(Arrays.asList(var1_1));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeLifeCycle(LifeCycle lifeCycle) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            void var1_1;
            this._lifeCycles.remove(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean containsLifeCycle(LifeCycle lifeCycle) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            void var1_1;
            return this._lifeCycles.contains(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void debug(String format, Object ... args) {
        if (this.debug) {
            void var2_2;
            void var1_1;
            System.err.printf("[ShutdownMonitor] " + (String)var1_1 + "%n", (Object[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void debug(Throwable t) {
        if (this.debug) {
            void var1_1;
            var1_1.printStackTrace(System.err);
        }
    }

    public String getKey() {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            return this.key;
        }
    }

    public int getPort() {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            return this.port;
        }
    }

    public boolean isExitVm() {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            return this.exitVm;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDebug(boolean flag) {
        void var1_1;
        this.debug = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setExitVm(boolean exitVm) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            void var1_1;
            if (this.alive) {
                throw new IllegalStateException("ShutdownMonitor already started");
            }
            this.exitVm = var1_1;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setKey(String key) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            void var1_1;
            if (this.alive) {
                throw new IllegalStateException("ShutdownMonitor already started");
            }
            this.key = var1_1;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPort(int port) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            void var1_1;
            if (this.alive) {
                throw new IllegalStateException("ShutdownMonitor already started");
            }
            this.port = var1_1;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void start() throws Exception {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.alive) {
                this.debug("Already started", new Object[0]);
                return;
            }
            ServerSocket serverSocket = this.listen();
            if (serverSocket != null) {
                void var2_2;
                this.alive = true;
                Thread thread = new Thread(new ShutdownMonitorRunnable(serverSocket));
                thread.setDaemon(true);
                thread.setName("ShutdownMonitor");
                var2_2.start();
            }
            return;
        }
    }

    private void stop() {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            this.alive = false;
            this.notifyAll();
            return;
        }
    }

    void await() throws InterruptedException {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            while (this.alive) {
                this.wait();
            }
            return;
        }
    }

    protected boolean isAlive() {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            return this.alive;
        }
    }

    /*
     * WARNING - void declaration
     */
    private ServerSocket listen() {
        ServerSocket serverSocket;
        int port = this.getPort();
        if (port < 0) {
            this.debug("Not enabled (port < 0): %d", port);
            return null;
        }
        String key = this.getKey();
        try {
            ServerSocket serverSocket2 = new ServerSocket();
            try {
                serverSocket2.setReuseAddress(true);
                serverSocket2.bind(new InetSocketAddress(InetAddress.getByName(this.host), port));
            }
            catch (Throwable e) {
                IO.close((Closeable)serverSocket2);
                throw e;
            }
            if (port == 0) {
                port = serverSocket2.getLocalPort();
                System.out.printf("STOP.PORT=%d%n", port);
                this.setPort(port);
            }
            if (key == null) {
                key = Long.toString((long)(9.223372036854776E18 * Math.random() + (double)this.hashCode() + (double)System.currentTimeMillis()), 36);
                System.out.printf("STOP.KEY=%s%n", key);
                this.setKey(key);
            }
            serverSocket = serverSocket2;
        }
        catch (Throwable x) {
            try {
                void var3_4;
                this.debug(x);
                System.err.println("Error binding ShutdownMonitor to port " + port + ": " + var3_4.toString());
            }
            catch (Throwable throwable) {
                void var2_2;
                void var1_1;
                this.debug("STOP.PORT=%d", (int)var1_1);
                this.debug("STOP.KEY=%s", var2_2);
                this.debug("STOP.EXIT=%b", this.exitVm);
                throw throwable;
            }
            this.debug("STOP.PORT=%d", port);
            this.debug("STOP.KEY=%s", key);
            this.debug("STOP.EXIT=%b", this.exitVm);
            return null;
        }
        this.debug("STOP.PORT=%d", port);
        this.debug("STOP.KEY=%s", key);
        this.debug("STOP.EXIT=%b", this.exitVm);
        return serverSocket;
    }

    public String toString() {
        return String.format("%s[port=%d,alive=%b]", this.getClass().getName(), this.getPort(), this.isAlive());
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(ShutdownMonitor x0, String x1, Object[] x2) {
        void var2_2;
        void var1_1;
        x0.debug((String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(ShutdownMonitor x0, Throwable x1) {
        void var1_1;
        x0.debug((Throwable)var1_1);
    }

    private class ShutdownMonitorRunnable
    implements Runnable {
        private final ServerSocket serverSocket;

        /*
         * WARNING - void declaration
         */
        private ShutdownMonitorRunnable(ServerSocket serverSocket) {
            void var2_2;
            this.serverSocket = var2_2;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            String key;
            ShutdownMonitor.access$200(ShutdownMonitor.this, "Started", new Object[0]);
            try {
                key = ShutdownMonitor.this.getKey();
                while (true) {
                    try {}
                    catch (Throwable x) {
                        void var2_5;
                        ShutdownMonitor.access$300(ShutdownMonitor.this, (Throwable)var2_5);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable x) {
                void var1_2;
                ShutdownMonitor.access$300(ShutdownMonitor.this, (Throwable)var1_2);
                return;
            }
            finally {
                IO.close((Closeable)this.serverSocket);
                ShutdownMonitor.this.stop();
                ShutdownMonitor.access$200(ShutdownMonitor.this, "Stopped", new Object[0]);
            }
            while (true) {
                Socket socket = this.serverSocket.accept();
                try {
                    void var3_6;
                    LineNumberReader reader = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                    String receivedKey = reader.readLine();
                    if (!key.equals(receivedKey)) {
                        ShutdownMonitor.access$200(ShutdownMonitor.this, "Ignoring command with incorrect key: %s", new Object[]{receivedKey});
                        continue;
                    }
                    String cmd = reader.readLine();
                    ShutdownMonitor.access$200(ShutdownMonitor.this, "command=%s", new Object[]{cmd});
                    OutputStream out = socket.getOutputStream();
                    boolean exitVm = ShutdownMonitor.this.isExitVm();
                    if ("stop".equalsIgnoreCase(cmd)) {
                        ShutdownMonitor.access$200(ShutdownMonitor.this, "Performing stop command", new Object[0]);
                        this.stopLifeCycles(ShutdownThread::isRegistered, exitVm);
                        ShutdownMonitor.access$200(ShutdownMonitor.this, "Informing client that we are stopped", new Object[0]);
                        this.informClient(out, "Stopped\r\n");
                        if (!exitVm) {
                            return;
                        }
                        ShutdownMonitor.access$200(ShutdownMonitor.this, "Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if ("forcestop".equalsIgnoreCase(cmd)) {
                        ShutdownMonitor.access$200(ShutdownMonitor.this, "Performing forced stop command", new Object[0]);
                        this.stopLifeCycles(l -> true, exitVm);
                        ShutdownMonitor.access$200(ShutdownMonitor.this, "Informing client that we are stopped", new Object[0]);
                        this.informClient(out, "Stopped\r\n");
                        if (!exitVm) {
                            return;
                        }
                        ShutdownMonitor.access$200(ShutdownMonitor.this, "Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if ("stopexit".equalsIgnoreCase(cmd)) {
                        ShutdownMonitor.access$200(ShutdownMonitor.this, "Performing stop and exit commands", new Object[0]);
                        this.stopLifeCycles(ShutdownThread::isRegistered, true);
                        ShutdownMonitor.access$200(ShutdownMonitor.this, "Informing client that we are stopped", new Object[0]);
                        this.informClient(out, "Stopped\r\n");
                        ShutdownMonitor.access$200(ShutdownMonitor.this, "Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if ("exit".equalsIgnoreCase(cmd)) {
                        ShutdownMonitor.access$200(ShutdownMonitor.this, "Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if (!"status".equalsIgnoreCase((String)var3_6)) continue;
                    this.informClient(out, "OK\r\n");
                    continue;
                }
                finally {
                    if (socket == null) continue;
                    socket.close();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void informClient(OutputStream out, String message) throws IOException {
            void var1_1;
            void var2_2;
            out.write(var2_2.getBytes(StandardCharsets.UTF_8));
            var1_1.flush();
        }

        /*
         * WARNING - void declaration
         */
        private void stopLifeCycles(Predicate<LifeCycle> predicate, boolean destroy) {
            ArrayList lifeCycles = new ArrayList();
            ShutdownMonitorRunnable shutdownMonitorRunnable = this;
            synchronized (shutdownMonitorRunnable) {
                lifeCycles.addAll(ShutdownMonitor.this._lifeCycles);
            }
            for (LifeCycle l : lifeCycles) {
                try {
                    if (l.isStarted() && predicate.test(l)) {
                        l.stop();
                    }
                    if (!(l instanceof Destroyable) || !destroy) continue;
                    ((Destroyable)l).destroy();
                }
                catch (Throwable x) {
                    void var3_5;
                    ShutdownMonitor.access$300(ShutdownMonitor.this, (Throwable)var3_5);
                }
            }
        }
    }

    private static class Holder {
        static ShutdownMonitor instance = new ShutdownMonitor();

        private Holder() {
        }
    }
}

