/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.EventListener;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject(value="HTTP connector using NIO ByteChannels and Selectors")
public class ServerConnector
extends AbstractNetworkConnector {
    private final SelectorManager _manager;
    private final AtomicReference<Closeable> _acceptor = new AtomicReference();
    private volatile ServerSocketChannel _acceptChannel;
    private volatile boolean _inheritChannel = false;
    private volatile int _localPort = -1;
    private volatile int _acceptQueueSize = 0;
    private volatile boolean _reuseAddress = true;
    private volatile boolean _acceptedTcpNoDelay = true;
    private volatile int _acceptedReceiveBufferSize = -1;
    private volatile int _acceptedSendBufferSize = -1;

    /*
     * WARNING - void declaration
     */
    public ServerConnector(@Name(value="server") Server server) {
        this((Server)var1_1, null, null, null, -1, -1, new HttpConnectionFactory());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServerConnector(@Name(value="server") Server server, @Name(value="acceptors") int acceptors, @Name(value="selectors") int selectors) {
        this((Server)var1_1, null, null, null, (int)var2_2, (int)var3_3, new HttpConnectionFactory());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServerConnector(@Name(value="server") Server server, @Name(value="acceptors") int acceptors, @Name(value="selectors") int selectors, ConnectionFactory ... factories) {
        this((Server)var1_1, null, null, null, (int)var2_2, (int)var3_3, factories);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServerConnector(@Name(value="server") Server server, ConnectionFactory ... factories) {
        this((Server)var1_1, null, null, null, -1, -1, (ConnectionFactory[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServerConnector(@Name(value="server") Server server, @Name(value="sslContextFactory") SslContextFactory sslContextFactory) {
        this((Server)var1_1, null, null, null, -1, -1, AbstractConnectionFactory.getFactories((SslContextFactory)var2_2, new HttpConnectionFactory()));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServerConnector(@Name(value="server") Server server, @Name(value="acceptors") int acceptors, @Name(value="selectors") int selectors, @Name(value="sslContextFactory") SslContextFactory sslContextFactory) {
        this((Server)var1_1, null, null, null, (int)var2_2, (int)var3_3, AbstractConnectionFactory.getFactories(sslContextFactory, new HttpConnectionFactory()));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServerConnector(@Name(value="server") Server server, @Name(value="sslContextFactory") SslContextFactory sslContextFactory, ConnectionFactory ... factories) {
        this((Server)var1_1, null, null, null, -1, -1, AbstractConnectionFactory.getFactories((SslContextFactory)var2_2, (ConnectionFactory[])var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServerConnector(@Name(value="server") Server server, @Name(value="executor") Executor executor, @Name(value="scheduler") Scheduler scheduler, @Name(value="bufferPool") ByteBufferPool bufferPool, @Name(value="acceptors") int acceptors, @Name(value="selectors") int selectors, ConnectionFactory ... factories) {
        super((Server)var1_1, (Executor)var2_2, (Scheduler)var3_3, bufferPool, acceptors, factories);
        void var3_3;
        void var2_2;
        void var1_1;
        this._manager = this.newSelectorManager(this.getExecutor(), this.getScheduler(), selectors);
        ServerConnector serverConnector = this;
        serverConnector.addBean(serverConnector._manager, true);
        this.setAcceptorPriorityDelta(-2);
    }

    /*
     * WARNING - void declaration
     */
    protected SelectorManager newSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new ServerConnectorManager(this, (Executor)var1_1, (Scheduler)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStart() throws Exception {
        for (EventListener l : this.getBeans(EventListener.class)) {
            void var2_2;
            this._manager.addEventListener((EventListener)var2_2);
        }
        super.doStart();
        if (this.getAcceptors() == 0) {
            this._acceptChannel.configureBlocking(false);
            this._acceptor.set(this._manager.acceptor((SelectableChannel)this._acceptChannel));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        for (EventListener l : this.getBeans(EventListener.class)) {
            void var2_2;
            this._manager.removeEventListener((EventListener)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isOpen() {
        void var1_1;
        ServerSocketChannel channel = this._acceptChannel;
        return channel != null && var1_1.isOpen();
    }

    public boolean isInheritChannel() {
        return this._inheritChannel;
    }

    /*
     * WARNING - void declaration
     */
    public void setInheritChannel(boolean inheritChannel) {
        void var1_1;
        this._inheritChannel = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void open(ServerSocketChannel acceptChannel) throws IOException {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        ServerConnector serverConnector = this;
        serverConnector.updateBean(serverConnector._acceptChannel, acceptChannel);
        this._acceptChannel = var1_1;
        this._localPort = this._acceptChannel.socket().getLocalPort();
        if (this._localPort <= 0) {
            throw new IOException("Server channel not bound");
        }
    }

    @Override
    public void open() throws IOException {
        if (this._acceptChannel == null) {
            this._acceptChannel = this.openAcceptChannel();
            this._acceptChannel.configureBlocking(true);
            this._localPort = this._acceptChannel.socket().getLocalPort();
            if (this._localPort <= 0) {
                throw new IOException("Server channel not bound");
            }
            ServerConnector serverConnector = this;
            serverConnector.addBean(serverConnector._acceptChannel);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ServerSocketChannel openAcceptChannel() throws IOException {
        void var1_1;
        ServerSocketChannel serverChannel = null;
        if (this.isInheritChannel()) {
            Channel channel = System.inheritedChannel();
            if (channel instanceof ServerSocketChannel) {
                serverChannel = (ServerSocketChannel)channel;
            } else {
                LOG.warn("Unable to use System.inheritedChannel() [{}]. Trying a new ServerSocketChannel at {}:{}", new Object[]{channel, this.getHost(), this.getPort()});
            }
        }
        if (serverChannel == null) {
            InetSocketAddress bindAddress = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
            serverChannel = ServerSocketChannel.open();
            try {
                serverChannel.socket().setReuseAddress(this.getReuseAddress());
                serverChannel.socket().bind(bindAddress, this.getAcceptQueueSize());
            }
            catch (Throwable e) {
                void var3_3;
                void var2_2;
                IO.close((Closeable)serverChannel);
                throw new IOException("Failed to bind to " + var2_2, (Throwable)var3_3);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        super.close();
        ServerSocketChannel serverChannel = this._acceptChannel;
        this._acceptChannel = null;
        if (serverChannel != null) {
            this.removeBean(serverChannel);
            if (serverChannel.isOpen()) {
                try {
                    serverChannel.close();
                }
                catch (IOException e) {
                    void var1_2;
                    LOG.warn((Throwable)var1_2);
                }
            }
        }
        this._localPort = -2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(int acceptorID) throws IOException {
        ServerSocketChannel serverChannel = this._acceptChannel;
        if (serverChannel != null && serverChannel.isOpen()) {
            void var1_2;
            SocketChannel channel = serverChannel.accept();
            this.accepted((SocketChannel)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void accepted(SocketChannel channel) throws IOException {
        void var1_1;
        void var2_2;
        channel.configureBlocking(false);
        Socket socket = channel.socket();
        this.configure((Socket)var2_2);
        this._manager.accept((SelectableChannel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void configure(Socket socket) {
        try {
            socket.setTcpNoDelay(this._acceptedTcpNoDelay);
            if (this._acceptedReceiveBufferSize >= 0) {
                socket.setReceiveBufferSize(this._acceptedReceiveBufferSize);
            }
            if (this._acceptedSendBufferSize >= 0) {
                socket.setSendBufferSize(this._acceptedSendBufferSize);
            }
            return;
        }
        catch (SocketException e) {
            void var1_2;
            LOG.ignore((Throwable)var1_2);
            return;
        }
    }

    @ManagedAttribute(value="The Selector Manager")
    public SelectorManager getSelectorManager() {
        return this._manager;
    }

    @Override
    public Object getTransport() {
        return this._acceptChannel;
    }

    @Override
    @ManagedAttribute(value="local port")
    public int getLocalPort() {
        return this._localPort;
    }

    /*
     * WARNING - void declaration
     */
    protected ChannelEndPoint newEndPoint(SocketChannel channel, ManagedSelector selectSet, SelectionKey key) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        SocketChannelEndPoint endpoint = new SocketChannelEndPoint(channel, (ManagedSelector)var2_2, (SelectionKey)var3_3, this.getScheduler());
        endpoint.setIdleTimeout(this.getIdleTimeout());
        return var1_1;
    }

    @ManagedAttribute(value="Socket close linger time. Deprecated, always returns -1", readonly=true)
    @Deprecated
    public int getSoLingerTime() {
        return -1;
    }

    @Deprecated
    public void setSoLingerTime(int lingerTime) {
        LOG.warn("Ignoring deprecated socket close linger time", new Object[0]);
    }

    @ManagedAttribute(value="Accept Queue size")
    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setAcceptQueueSize(int acceptQueueSize) {
        void var1_1;
        this._acceptQueueSize = var1_1;
    }

    @ManagedAttribute(value="Server Socket SO_REUSEADDR")
    public boolean getReuseAddress() {
        return this._reuseAddress;
    }

    /*
     * WARNING - void declaration
     */
    public void setReuseAddress(boolean reuseAddress) {
        void var1_1;
        this._reuseAddress = var1_1;
    }

    @ManagedAttribute(value="Accepted Socket TCP_NODELAY")
    public boolean getAcceptedTcpNoDelay() {
        return this._acceptedTcpNoDelay;
    }

    /*
     * WARNING - void declaration
     */
    public void setAcceptedTcpNoDelay(boolean tcpNoDelay) {
        void var1_1;
        this._acceptedTcpNoDelay = var1_1;
    }

    @ManagedAttribute(value="Accepted Socket SO_RCVBUF")
    public int getAcceptedReceiveBufferSize() {
        return this._acceptedReceiveBufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setAcceptedReceiveBufferSize(int receiveBufferSize) {
        void var1_1;
        this._acceptedReceiveBufferSize = var1_1;
    }

    @ManagedAttribute(value="Accepted Socket SO_SNDBUF")
    public int getAcceptedSendBufferSize() {
        return this._acceptedSendBufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setAcceptedSendBufferSize(int sendBufferSize) {
        void var1_1;
        this._acceptedSendBufferSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAccepting(boolean accepting) {
        block8: {
            super.setAccepting(accepting);
            if (this.getAcceptors() > 0) {
                return;
            }
            try {
                if (accepting) {
                    if (this._acceptor.get() == null) {
                        Closeable acceptor = this._manager.acceptor((SelectableChannel)this._acceptChannel);
                        if (!this._acceptor.compareAndSet(null, acceptor)) {
                            acceptor.close();
                        }
                        break block8;
                    }
                } else {
                    Closeable acceptor = this._acceptor.get();
                    if (acceptor != null && this._acceptor.compareAndSet(acceptor, null)) {
                        acceptor.close();
                    }
                }
                return;
            }
            catch (IOException e) {
                void var1_4;
                throw new RuntimeException((Throwable)var1_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(ServerConnector x0, SocketChannel x1) throws IOException {
        void var1_1;
        x0.accepted((SocketChannel)var1_1);
    }

    protected class ServerConnectorManager
    extends SelectorManager {
        final /* synthetic */ ServerConnector this$0;

        /*
         * WARNING - void declaration
         */
        public ServerConnectorManager(ServerConnector this$0, Executor executor, Scheduler scheduler, int selectors) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((Executor)var2_2, (Scheduler)var3_3, selectors);
        }

        /*
         * WARNING - void declaration
         */
        protected void accepted(SelectableChannel channel) throws IOException {
            void var1_1;
            ServerConnector.access$000(this.this$0, (SocketChannel)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected ChannelEndPoint newEndPoint(SelectableChannel channel, ManagedSelector selectSet, SelectionKey selectionKey) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.this$0.newEndPoint((SocketChannel)var1_1, (ManagedSelector)var2_2, (SelectionKey)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public Connection newConnection(SelectableChannel channel, EndPoint endpoint, Object attachment) throws IOException {
            void var2_2;
            return this.this$0.getDefaultConnectionFactory().newConnection(this.this$0, (EndPoint)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        protected void endPointOpened(EndPoint endpoint) {
            void var1_1;
            super.endPointOpened(endpoint);
            this.this$0.onEndPointOpened((EndPoint)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected void endPointClosed(EndPoint endpoint) {
            void var1_1;
            this.this$0.onEndPointClosed(endpoint);
            super.endPointClosed((EndPoint)var1_1);
        }

        public String toString() {
            return String.format("SelectorManager@%s", this.this$0);
        }
    }
}

