/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.ClassLoaderDump;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.Uptime;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AttributeContainerMap;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.util.thread.ThreadPool;

@ManagedObject(value="Jetty HTTP Servlet server")
public class Server
extends HandlerWrapper
implements Attributes {
    private static final Logger LOG = Log.getLogger(Server.class);
    private final AttributeContainerMap _attributes = new AttributeContainerMap();
    private final ThreadPool _threadPool;
    private final List<Connector> _connectors = new CopyOnWriteArrayList<Connector>();
    private SessionIdManager _sessionIdManager;
    private boolean _stopAtShutdown;
    private boolean _dumpAfterStart = false;
    private boolean _dumpBeforeStop = false;
    private ErrorHandler _errorHandler;
    private RequestLog _requestLog;
    private final Locker _dateLocker = new Locker();
    private volatile DateField _dateField;

    public Server() {
        this((ThreadPool)null);
    }

    /*
     * WARNING - void declaration
     */
    public Server(@Name(value="port") int port) {
        this((ThreadPool)null);
        void var2_2;
        void var1_1;
        ServerConnector connector = new ServerConnector(this);
        connector.setPort((int)var1_1);
        this.setConnectors(new Connector[]{var2_2});
        Server server = this;
        server.addBean(server._attributes);
    }

    /*
     * WARNING - void declaration
     */
    public Server(@Name(value="address") InetSocketAddress addr) {
        this((ThreadPool)null);
        void var2_2;
        void var1_1;
        ServerConnector connector = new ServerConnector(this);
        connector.setHost(addr.getHostName());
        connector.setPort(var1_1.getPort());
        this.setConnectors(new Connector[]{var2_2});
    }

    /*
     * WARNING - void declaration
     */
    public Server(@Name(value="threadpool") ThreadPool pool) {
        void var1_1;
        this._threadPool = pool != null ? var1_1 : new QueuedThreadPool();
        Server server = this;
        server.addBean(server._threadPool);
        Server server2 = this;
        ((AbstractHandler)server2).setServer(server2);
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestLog(RequestLog requestLog) {
        void var1_1;
        Server server = this;
        server.updateBean(server._requestLog, requestLog);
        this._requestLog = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler instanceof ErrorHandler.ErrorPageMapper) {
            throw new IllegalArgumentException("ErrorPageMapper is applicable only to ContextHandler");
        }
        Server server = this;
        server.updateBean(server._errorHandler, errorHandler);
        this._errorHandler = errorHandler;
        if (errorHandler != null) {
            void var1_1;
            var1_1.setServer(this);
        }
    }

    @ManagedAttribute(value="version of this server")
    public static String getVersion() {
        return Jetty.VERSION;
    }

    public boolean getStopAtShutdown() {
        return this._stopAtShutdown;
    }

    /*
     * WARNING - void declaration
     */
    public void setStopTimeout(long stopTimeout) {
        void var1_1;
        super.setStopTimeout((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setStopAtShutdown(boolean stop) {
        void var1_1;
        if (stop) {
            if (!this._stopAtShutdown && this.isStarted()) {
                ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
            }
        } else {
            ShutdownThread.deregister((LifeCycle)this);
        }
        this._stopAtShutdown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @ManagedAttribute(value="connectors for this server", readonly=true)
    public Connector[] getConnectors() {
        void var1_1;
        ArrayList<Connector> connectors = new ArrayList<Connector>(this._connectors);
        return connectors.toArray(new Connector[var1_1.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public void addConnector(Connector connector) {
        void var1_1;
        if (connector.getServer() != this) {
            throw new IllegalArgumentException("Connector " + connector + " cannot be shared among server " + connector.getServer() + " and server " + this);
        }
        this._connectors.add(connector);
        this.addBean(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeConnector(Connector connector) {
        if (this._connectors.remove(connector)) {
            void var1_1;
            this.removeBean(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectors(Connector[] connectors) {
        Connector[] connectorArray;
        if (connectors != null) {
            connectorArray = connectors;
            int n = connectors.length;
            for (int i = 0; i < n; ++i) {
                Connector connector = connectorArray[i];
                if (connector.getServer() == this) continue;
                throw new IllegalArgumentException("Connector " + connector + " cannot be shared among server " + connector.getServer() + " and server " + this);
            }
        }
        Object[] oldConnectors = this.getConnectors();
        this.updateBeans(oldConnectors, connectors);
        this._connectors.removeAll(Arrays.asList(connectorArray));
        if (connectors != null) {
            void var1_1;
            this._connectors.addAll(Arrays.asList(var1_1));
        }
    }

    public void addBeanToAllConnectors(Object bean) {
        for (Connector connector : this.getConnectors()) {
            connector.addBean(bean);
        }
    }

    @ManagedAttribute(value="the server thread pool")
    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    @ManagedAttribute(value="dump state to stderr after start")
    public boolean isDumpAfterStart() {
        return this._dumpAfterStart;
    }

    /*
     * WARNING - void declaration
     */
    public void setDumpAfterStart(boolean dumpAfterStart) {
        void var1_1;
        this._dumpAfterStart = var1_1;
    }

    @ManagedAttribute(value="dump state to stderr before stop")
    public boolean isDumpBeforeStop() {
        return this._dumpBeforeStop;
    }

    /*
     * WARNING - void declaration
     */
    public void setDumpBeforeStop(boolean dumpBeforeStop) {
        void var1_1;
        this._dumpBeforeStop = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpField getDateField() {
        long now = System.currentTimeMillis();
        long seconds = now / 1000L;
        DateField df = this._dateField;
        if (df == null || df._seconds != seconds) {
            try (Locker.Lock lock = this._dateLocker.lock();){
                df = this._dateField;
                if (df == null || df._seconds != seconds) {
                    void var1_2;
                    void var3_4;
                    PreEncodedHttpField field = new PreEncodedHttpField(HttpHeader.DATE, DateGenerator.formatDate((long)now));
                    this._dateField = new DateField((long)var3_4, (HttpField)field);
                    void var2_7 = var1_2;
                    return var2_7;
                }
            }
        }
        return df._dateField;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStart() throws Exception {
        void var1_1;
        if (this._errorHandler == null) {
            this._errorHandler = (ErrorHandler)this.getBean(ErrorHandler.class);
        }
        if (this._errorHandler == null) {
            this.setErrorHandler(new ErrorHandler());
        }
        if (this._errorHandler instanceof ErrorHandler.ErrorPageMapper) {
            LOG.warn("ErrorPageMapper not supported for Server level Error Handling", new Object[0]);
        }
        this._errorHandler.setServer(this);
        if (this.getStopAtShutdown()) {
            ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
        }
        ShutdownMonitor.register(this);
        ShutdownMonitor.getInstance().start();
        String gitHash = Jetty.GIT_HASH;
        String timestamp = Jetty.BUILD_TIMESTAMP;
        LOG.info("jetty-{}; built: {}; git: {}; jvm {}", new Object[]{Server.getVersion(), timestamp, gitHash, System.getProperty("java.runtime.version", System.getProperty("java.version"))});
        if (!Jetty.STABLE) {
            LOG.warn("THIS IS NOT A STABLE RELEASE! DO NOT USE IN PRODUCTION!", new Object[0]);
            LOG.warn("Download a stable release from https://download.eclipse.org/jetty/", new Object[0]);
        }
        HttpGenerator.setJettyVersion((String)HttpConfiguration.SERVER_VERSION);
        MultiException mex = new MultiException();
        try {
            super.doStart();
        }
        catch (Throwable e) {
            void var2_3;
            mex.add((Throwable)var2_3);
        }
        if (mex.size() == 0) {
            for (Connector connector : this._connectors) {
                try {
                    connector.start();
                }
                catch (Throwable e) {
                    void var3_5;
                    mex.add((Throwable)var3_5);
                }
            }
        }
        if (this.isDumpAfterStart()) {
            this.dumpStdErr();
        }
        var1_1.ifExceptionThrow();
        LOG.info(String.format("Started @%dms", Uptime.getUptime()), new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    protected void start(LifeCycle l) throws Exception {
        if (!(l instanceof Connector)) {
            void var1_1;
            super.start((LifeCycle)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStop() throws Exception {
        void var1_1;
        Iterator<Connector> iterator;
        if (this.isDumpBeforeStop()) {
            this.dumpStdErr();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("doStop {}", new Object[]{this});
        }
        MultiException mex = new MultiException();
        try {
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            iterator = this._connectors.iterator();
            while (iterator.hasNext()) {
                Connector connector = iterator.next();
                futures.add(connector.shutdown());
            }
            this.doShutdown(futures);
        }
        catch (Throwable e) {
            mex.add(e);
        }
        for (Connector connector : this._connectors) {
            try {
                iterator.stop();
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable e) {
            void var2_4;
            mex.add((Throwable)var2_4);
        }
        if (this.getStopAtShutdown()) {
            ShutdownThread.deregister((LifeCycle)this);
        }
        ShutdownMonitor.deregister(this);
        var1_1.ifExceptionThrow();
    }

    /*
     * WARNING - void declaration
     */
    public void handle(HttpChannel channel) throws IOException, ServletException {
        Response response;
        Request request;
        block7: {
            void var2_2;
            block5: {
                block6: {
                    String target = channel.getRequest().getPathInfo();
                    request = channel.getRequest();
                    response = channel.getResponse();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} {} {} on {}", new Object[]{request.getDispatcherType(), request.getMethod(), target, channel});
                    }
                    if (!HttpMethod.OPTIONS.is(request.getMethod()) && !"*".equals(target)) break block5;
                    if (HttpMethod.OPTIONS.is(request.getMethod())) break block6;
                    request.setHandled(true);
                    response.sendError(400);
                    break block7;
                }
                this.handleOptions(request, response);
                if (request.isHandled()) break block7;
            }
            Request request2 = request;
            ((AbstractHandler)this).handle((String)var2_2, request2, request2, response);
        }
        if (LOG.isDebugEnabled()) {
            void var1_1;
            void var3_3;
            LOG.debug("handled={} async={} committed={} on {}", new Object[]{request.isHandled(), var3_3.isAsyncStarted(), response.isCommitted(), var1_1});
        }
    }

    protected void handleOptions(Request request, Response response) throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    public void handleAsync(HttpChannel channel) throws IOException, ServletException {
        void var3_3;
        HttpChannelState httpChannelState = channel.getRequest().getHttpChannelState();
        AsyncContextEvent event = httpChannelState.getAsyncContextEvent();
        Request baseRequest = channel.getRequest();
        String path = event.getPath();
        if (path != null) {
            ServletContext context = event.getServletContext();
            String query = baseRequest.getQueryString();
            baseRequest.setURIPathQuery(URIUtil.addEncodedPaths((String)(context == null ? null : context.getContextPath()), (String)path));
            HttpURI uri = baseRequest.getHttpURI();
            baseRequest.setPathInfo(uri.getDecodedPath());
            if (uri.getQuery() != null) {
                baseRequest.mergeQueryParameters(query, uri.getQuery(), true);
            }
        }
        String target = baseRequest.getPathInfo();
        HttpServletRequest request = Request.unwrap(event.getSuppliedRequest());
        HttpServletResponse response = Response.unwrap(httpChannelState.getSuppliedResponse());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} {} on {}", new Object[]{request.getDispatcherType(), request.getMethod(), target, channel});
        }
        ((AbstractHandler)this).handle(target, (Request)var3_3, request, response);
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("handledAsync={} async={} committed={} on {}", new Object[]{channel.getRequest().isHandled(), request.isAsyncStarted(), response.isCommitted(), var1_1});
        }
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        void var1_1;
        Server server = this;
        server.updateBean(server._sessionIdManager, sessionIdManager);
        this._sessionIdManager = var1_1;
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String name) {
        void var1_1;
        return this._attributes.getAttribute((String)var1_1);
    }

    public Enumeration<String> getAttributeNames() {
        return this._attributes.getAttributeNames();
    }

    public Set<String> getAttributeNameSet() {
        return this._attributes.getAttributeNameSet();
    }

    /*
     * WARNING - void declaration
     */
    public void removeAttribute(String name) {
        void var1_1;
        this._attributes.removeAttribute((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String name, Object attribute) {
        void var2_2;
        void var1_1;
        this._attributes.setAttribute((String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public URI getURI() {
        NetworkConnector connector = null;
        Iterator<Connector> iterator = this._connectors.iterator();
        while (iterator.hasNext()) {
            Connector c = iterator.next();
            if (!(c instanceof NetworkConnector)) continue;
            connector = (NetworkConnector)c;
            break;
        }
        if (connector == null) {
            return null;
        }
        ContextHandler context = this.getChildHandlerByClass(ContextHandler.class);
        try {
            void var1_1;
            String path;
            String protocol = connector.getDefaultConnectionFactory().getProtocol();
            String scheme = "http";
            if (protocol.startsWith("SSL-") || protocol.equals("SSL")) {
                scheme = "https";
            }
            String host = connector.getHost();
            if (context != null && context.getVirtualHosts() != null && context.getVirtualHosts().length > 0) {
                host = context.getVirtualHosts()[0];
            }
            if (host == null) {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            if ((path = context == null ? null : context.getContextPath()) == null) {
                path = "/";
            }
            return new URI(scheme, null, host, var1_1.getLocalPort(), (String)((Object)iterator), null, null);
        }
        catch (Exception e) {
            void var3_4;
            LOG.warn((Throwable)var3_4);
            return null;
        }
    }

    public String toString() {
        return String.format("%s[%s]", super.toString(), Server.getVersion());
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        this.dumpObjects((Appendable)var1_1, (String)var2_2, new Object[]{new ClassLoaderDump(this.getClass().getClassLoader())});
    }

    public static void main(String ... args) throws Exception {
        System.err.println(Server.getVersion());
    }

    private static class DateField {
        final long _seconds;
        final HttpField _dateField;

        /*
         * WARNING - void declaration
         */
        public DateField(long seconds, HttpField dateField) {
            void var3_2;
            void var1_1;
            this._seconds = var1_1;
            this._dateField = var3_2;
        }
    }
}

