/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.ssl.X509;

public class SecureRequestCustomizer
implements HttpConfiguration.Customizer {
    private static final Logger LOG = Log.getLogger(SecureRequestCustomizer.class);
    public static final String JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE = "javax.servlet.request.X509Certificate";
    public static final String JAVAX_SERVLET_REQUEST_CIPHER_SUITE = "javax.servlet.request.cipher_suite";
    public static final String JAVAX_SERVLET_REQUEST_KEY_SIZE = "javax.servlet.request.key_size";
    public static final String JAVAX_SERVLET_REQUEST_SSL_SESSION_ID = "javax.servlet.request.ssl_session_id";
    private String sslSessionAttribute = "org.eclipse.jetty.servlet.request.ssl_session";
    private boolean _sniRequired;
    private boolean _sniHostCheck;
    private long _stsMaxAge = -1L;
    private boolean _stsIncludeSubDomains;
    private HttpField _stsField;

    public SecureRequestCustomizer() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    public SecureRequestCustomizer(@Name(value="sniHostCheck") boolean sniHostCheck) {
        this((boolean)var1_1, -1L, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SecureRequestCustomizer(@Name(value="sniHostCheck") boolean sniHostCheck, @Name(value="stsMaxAgeSeconds") long stsMaxAgeSeconds, @Name(value="stsIncludeSubdomains") boolean stsIncludeSubdomains) {
        this(false, (boolean)var1_1, (long)var2_2, stsIncludeSubdomains);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SecureRequestCustomizer(@Name(value="sniRequired") boolean sniRequired, @Name(value="sniHostCheck") boolean sniHostCheck, @Name(value="stsMaxAgeSeconds") long stsMaxAgeSeconds, @Name(value="stsIncludeSubdomains") boolean stsIncludeSubdomains) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._sniRequired = var1_1;
        this._sniHostCheck = var2_2;
        this._stsMaxAge = var3_3;
        this._stsIncludeSubDomains = stsIncludeSubdomains;
        this.formatSTS();
    }

    public boolean isSniHostCheck() {
        return this._sniHostCheck;
    }

    /*
     * WARNING - void declaration
     */
    public void setSniHostCheck(boolean sniHostCheck) {
        void var1_1;
        this._sniHostCheck = var1_1;
    }

    public boolean isSniRequired() {
        return this._sniRequired;
    }

    /*
     * WARNING - void declaration
     */
    public void setSniRequired(boolean sniRequired) {
        void var1_1;
        this._sniRequired = var1_1;
    }

    public long getStsMaxAge() {
        return this._stsMaxAge;
    }

    /*
     * WARNING - void declaration
     */
    public void setStsMaxAge(long stsMaxAgeSeconds) {
        void var1_1;
        this._stsMaxAge = var1_1;
        this.formatSTS();
    }

    /*
     * WARNING - void declaration
     */
    public void setStsMaxAge(long period, TimeUnit units) {
        void var1_1;
        void var3_2;
        this._stsMaxAge = var3_2.toSeconds((long)var1_1);
        this.formatSTS();
    }

    public boolean isStsIncludeSubDomains() {
        return this._stsIncludeSubDomains;
    }

    /*
     * WARNING - void declaration
     */
    public void setStsIncludeSubDomains(boolean stsIncludeSubDomains) {
        void var1_1;
        this._stsIncludeSubDomains = var1_1;
        this.formatSTS();
    }

    private void formatSTS() {
        if (this._stsMaxAge < 0L) {
            this._stsField = null;
            return;
        }
        this._stsField = new PreEncodedHttpField(HttpHeader.STRICT_TRANSPORT_SECURITY, String.format("max-age=%d%s", this._stsMaxAge, this._stsIncludeSubDomains ? "; includeSubDomains" : ""));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        SSLEngine sslEngine;
        EndPoint endp = request.getHttpChannel().getEndPoint();
        if (endp instanceof SslConnection.DecryptedEndPoint) {
            endp = (SslConnection.DecryptedEndPoint)endp;
            endp = endp.getSslConnection();
            sslEngine = endp.getSSLEngine();
            this.customize(sslEngine, request);
            if (request.getHttpURI().getScheme() == null) {
                request.setScheme(HttpScheme.HTTPS.asString());
            }
        } else if (sslEngine instanceof ProxyConnectionFactory.ProxyEndPoint) {
            void var1_1;
            ProxyConnectionFactory.ProxyEndPoint proxy = (ProxyConnectionFactory.ProxyEndPoint)((Object)sslEngine);
            if (request.getHttpURI().getScheme() == null && var1_1.getAttribute("TLS_VERSION") != null) {
                request.setScheme(HttpScheme.HTTPS.asString());
            }
        }
        if (HttpScheme.HTTPS.is(request.getScheme())) {
            void var3_3;
            this.customizeSecure((Request)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void customizeSecure(Request request) {
        request.setSecure(true);
        if (this._stsField != null) {
            void var1_1;
            var1_1.getResponse().getHttpFields().add(this._stsField);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void customize(SSLEngine sslEngine, Request request) {
        void var2_2;
        void var1_1;
        SSLSession sslSession = sslEngine.getSession();
        if (this._sniHostCheck || this._sniRequired) {
            void var3_3;
            X509 x509 = (X509)sslSession.getValue("org.eclipse.jetty.util.ssl.snix509");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Host {} with SNI {}", new Object[]{request.getServerName(), x509});
            }
            if (x509 == null) {
                if (this._sniRequired) {
                    throw new BadMessageException(400, "SNI required");
                }
            } else if (this._sniHostCheck && !var3_3.matches(request.getServerName())) {
                throw new BadMessageException(400, "Host does not match SNI");
            }
        }
        request.setAttributes((Attributes)new SslAttributes(request, (SSLSession)var1_1, var2_2.getAttributes()));
    }

    /*
     * WARNING - void declaration
     */
    private X509Certificate[] getCertChain(Connector connector, SSLSession sslSession) {
        void var2_2;
        SslContextFactory sslContextFactory;
        SslConnectionFactory sslConnectionFactory = connector.getConnectionFactory(SslConnectionFactory.class);
        if (sslConnectionFactory != null && (sslContextFactory = sslConnectionFactory.getSslContextFactory()) != null) {
            void var1_1;
            return var1_1.getX509CertChain(sslSession);
        }
        return SslContextFactory.getCertChain((SSLSession)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setSslSessionAttribute(String attribute) {
        void var1_1;
        this.sslSessionAttribute = var1_1;
    }

    public String getSslSessionAttribute() {
        return this.sslSessionAttribute;
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ X509Certificate[] access$400(SecureRequestCustomizer x0, Connector x1, SSLSession x2) {
        void var2_2;
        void var1_1;
        return x0.getCertChain((Connector)var1_1, (SSLSession)var2_2);
    }

    private static class SslSessionData {
        private final Integer _keySize;
        private final X509Certificate[] _certs;
        private final String _idStr;

        /*
         * WARNING - void declaration
         */
        private SslSessionData(Integer keySize, X509Certificate[] certs, String idStr) {
            void var3_3;
            void var2_2;
            void var1_1;
            this._keySize = var1_1;
            this._certs = var2_2;
            this._idStr = var3_3;
        }

        private Integer getKeySize() {
            return this._keySize;
        }

        private X509Certificate[] getCerts() {
            return this._certs;
        }

        private String getIdStr() {
            return this._idStr;
        }
    }

    private class SslAttributes
    extends Attributes.Wrapper {
        private final Request _request;
        private final SSLSession _session;
        private X509Certificate[] _certs;
        private String _cipherSuite;
        private Integer _keySize;
        private String _sessionId;
        private String _sessionAttribute;

        /*
         * WARNING - void declaration
         */
        public SslAttributes(Request request, SSLSession sslSession, Attributes attributes) {
            void var3_4;
            super(attributes);
            this._request = request;
            this._session = var3_4;
            try {
                SslSessionData sslSessionData = this.getSslSessionData();
                this._certs = sslSessionData.getCerts();
                this._cipherSuite = this._session.getCipherSuite();
                this._keySize = sslSessionData.getKeySize();
                this._sessionId = sslSessionData.getIdStr();
                this._sessionAttribute = SecureRequestCustomizer.this.getSslSessionAttribute();
                return;
            }
            catch (Exception e) {
                void var2_3;
                LOG.warn("Unable to get secure details ", (Throwable)var2_3);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public Object getAttribute(String name) {
            void var1_1;
            switch (name) {
                case "javax.servlet.request.X509Certificate": {
                    return this._certs;
                }
                case "javax.servlet.request.cipher_suite": {
                    return this._cipherSuite;
                }
                case "javax.servlet.request.key_size": {
                    return this._keySize;
                }
                case "javax.servlet.request.ssl_session_id": {
                    return this._sessionId;
                }
            }
            if (!StringUtil.isEmpty((String)this._sessionAttribute) && this._sessionAttribute.equals(name)) {
                return this._session;
            }
            return this._attributes.getAttribute((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private SslSessionData getSslSessionData() {
            SslSessionData sslSessionData;
            String key = SslSessionData.class.getName();
            Object sslSessionData2 = (SslSessionData)this._session.getValue(key);
            if (sslSessionData2 == null) {
                void var1_1;
                void var3_4;
                void var2_3;
                sslSessionData2 = this._session.getCipherSuite();
                int keySize = SslContextFactory.deduceKeyLength((String)sslSessionData2);
                X509Certificate[] certs = SecureRequestCustomizer.access$400(SecureRequestCustomizer.this, this._request.getHttpChannel().getConnector(), this._session);
                byte[] byArray = this._session.getId();
                String idStr = TypeUtil.toHexString((byte[])byArray);
                sslSessionData = new SslSessionData((int)var2_3, (X509Certificate[])var3_4, idStr);
                this._session.putValue((String)var1_1, sslSessionData);
            }
            return sslSessionData;
        }

        /*
         * WARNING - void declaration
         */
        public Set<String> getAttributeNameSet() {
            void var1_1;
            HashSet<String> names = new HashSet<String>(this._attributes.getAttributeNameSet());
            names.remove(SecureRequestCustomizer.JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE);
            names.remove(SecureRequestCustomizer.JAVAX_SERVLET_REQUEST_CIPHER_SUITE);
            names.remove(SecureRequestCustomizer.JAVAX_SERVLET_REQUEST_KEY_SIZE);
            names.remove(SecureRequestCustomizer.JAVAX_SERVLET_REQUEST_SSL_SESSION_ID);
            if (this._certs != null) {
                names.add(SecureRequestCustomizer.JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE);
            }
            if (this._cipherSuite != null) {
                names.add(SecureRequestCustomizer.JAVAX_SERVLET_REQUEST_CIPHER_SUITE);
            }
            if (this._keySize != null) {
                names.add(SecureRequestCustomizer.JAVAX_SERVLET_REQUEST_KEY_SIZE);
            }
            if (this._sessionId != null) {
                names.add(SecureRequestCustomizer.JAVAX_SERVLET_REQUEST_SSL_SESSION_ID);
            }
            if (!StringUtil.isEmpty((String)this._sessionAttribute)) {
                names.add(this._sessionAttribute);
            }
            return var1_1;
        }
    }
}

