/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Formatter;
import java.util.Locale;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpWriter;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ResponseWriter
extends PrintWriter {
    private static final Logger LOG = Log.getLogger(ResponseWriter.class);
    private final HttpWriter _httpWriter;
    private final Locale _locale;
    private final String _encoding;
    private IOException _ioException;
    private boolean _isClosed = false;
    private Formatter _formatter;

    /*
     * WARNING - void declaration
     */
    public ResponseWriter(HttpWriter httpWriter, Locale locale, String encoding) {
        super((Writer)httpWriter, false);
        void var3_3;
        void var2_2;
        void var1_1;
        this._httpWriter = var1_1;
        this._locale = var2_2;
        this._encoding = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFor(Locale locale, String encoding) {
        void var1_1;
        void var2_2;
        if (this._locale == null && locale != null) {
            return false;
        }
        if (this._encoding == null && encoding != null) {
            return false;
        }
        return this._encoding.equalsIgnoreCase((String)var2_2) && this._locale.equals(var1_1);
    }

    protected void reopen() {
        Object object = this.lock;
        synchronized (object) {
            this._isClosed = false;
            this.clearError();
            this.out = this._httpWriter;
            return;
        }
    }

    @Override
    protected void clearError() {
        Object object = this.lock;
        synchronized (object) {
            this._ioException = null;
            super.clearError();
            return;
        }
    }

    @Override
    public boolean checkError() {
        Object object = this.lock;
        synchronized (object) {
            return this._ioException != null || super.checkError();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setError(Throwable th) {
        super.setError();
        if (th instanceof IOException) {
            this._ioException = (IOException)th;
        } else {
            this._ioException = new IOException(String.valueOf(th));
            this._ioException.initCause(th);
        }
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug((Throwable)var1_1);
        }
    }

    @Override
    protected void setError() {
        this.setError(new IOException());
    }

    private void isOpen() throws IOException {
        if (this._ioException != null) {
            throw this._ioException;
        }
        if (this._isClosed) {
            this._ioException = new EofException("Stream closed");
            throw this._ioException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.flush();
            }
        }
        catch (Throwable ex) {
            void var1_2;
            this.setError((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.out.close();
                this._isClosed = true;
            }
        }
        catch (IOException ex) {
            void var1_2;
            this.setError((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void complete(Callback callback) {
        void var1_1;
        Object object = this.lock;
        synchronized (object) {
            this._isClosed = true;
        }
        this._httpWriter.complete((Callback)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int c) {
        try {
            Object object = this.lock;
            synchronized (object) {
                void var1_1;
                this.isOpen();
                this.out.write((int)var1_1);
            }
        }
        catch (InterruptedIOException ex) {
            LOG.debug((Throwable)ex);
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException ex) {
            void var2_5;
            this.setError((Throwable)var2_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(char[] buf, int off, int len) {
        try {
            Object object = this.lock;
            synchronized (object) {
                void var3_4;
                void var2_3;
                void var1_1;
                this.isOpen();
                this.out.write((char[])var1_1, (int)var2_3, (int)var3_4);
            }
        }
        catch (InterruptedIOException ex) {
            LOG.debug((Throwable)ex);
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException ex) {
            this.setError(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(char[] buf) {
        void var1_1;
        this.write(buf, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(String s, int off, int len) {
        try {
            Object object = this.lock;
            synchronized (object) {
                void var3_4;
                void var2_3;
                void var1_1;
                this.isOpen();
                this.out.write((String)var1_1, (int)var2_3, (int)var3_4);
            }
        }
        catch (InterruptedIOException ex) {
            LOG.debug((Throwable)ex);
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException ex) {
            this.setError(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(String s) {
        void var1_1;
        this.write(s, 0, var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void print(boolean b) {
        void var1_1;
        this.write(var1_1 != false ? "true" : "false");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void print(char c) {
        void var1_1;
        this.write((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void print(int i) {
        void var1_1;
        this.write(String.valueOf((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void print(long l) {
        void var1_1;
        this.write(String.valueOf((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void print(float f) {
        void var1_1;
        this.write(String.valueOf((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void print(double d) {
        void var1_1;
        this.write(String.valueOf((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void print(char[] s) {
        void var1_1;
        this.write((char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void print(String s) {
        void var1_1;
        if (s == null) {
            s = "null";
        }
        this.write((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void print(Object obj) {
        void var1_1;
        this.write(String.valueOf(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void println() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(System.lineSeparator());
            }
        }
        catch (InterruptedIOException ex) {
            LOG.debug((Throwable)ex);
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException ex) {
            void var1_3;
            this.setError((Throwable)var1_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void println(boolean b) {
        void var1_1;
        this.println(Boolean.toString((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void println(char c) {
        try {
            Object object = this.lock;
            synchronized (object) {
                void var1_1;
                this.isOpen();
                this.out.write((int)var1_1);
                this.out.write(System.lineSeparator());
            }
        }
        catch (InterruptedIOException ex) {
            LOG.debug((Throwable)ex);
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException ex) {
            void var2_5;
            this.setError((Throwable)var2_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void println(int x) {
        void var1_1;
        this.println(String.valueOf((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void println(long x) {
        void var1_1;
        this.println(String.valueOf((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void println(float x) {
        void var1_1;
        this.println(String.valueOf((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void println(double x) {
        void var1_1;
        this.println(String.valueOf((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void println(char[] s) {
        try {
            Object object = this.lock;
            synchronized (object) {
                void var1_1;
                this.isOpen();
                this.out.write(s, 0, ((void)var1_1).length);
                this.out.write(System.lineSeparator());
            }
        }
        catch (InterruptedIOException ex) {
            LOG.debug((Throwable)ex);
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException ex) {
            void var2_5;
            this.setError((Throwable)var2_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void println(String s) {
        if (s == null) {
            s = "null";
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                void var1_1;
                this.isOpen();
                this.out.write(s, 0, var1_1.length());
                this.out.write(System.lineSeparator());
            }
        }
        catch (InterruptedIOException ex) {
            LOG.debug((Throwable)ex);
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException ex) {
            void var2_5;
            this.setError((Throwable)var2_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void println(Object x) {
        void var1_1;
        this.println(String.valueOf(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PrintWriter printf(String format, Object ... args) {
        void var2_2;
        void var1_1;
        ResponseWriter responseWriter = this;
        return responseWriter.format(responseWriter._locale, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.format((Locale)var1_1, (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PrintWriter format(String format, Object ... args) {
        void var2_2;
        void var1_1;
        ResponseWriter responseWriter = this;
        return responseWriter.format(responseWriter._locale, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PrintWriter format(Locale locale, String format, Object ... args) {
        try {
            if (locale == null) {
                locale = this._locale;
            }
            Object object = this.lock;
            synchronized (object) {
                void var3_4;
                void var2_3;
                void var1_1;
                this.isOpen();
                if (this._formatter == null) {
                    this._formatter = new Formatter(this, locale);
                } else if (!this._formatter.locale().equals(locale)) {
                    this._formatter = new Formatter(this, locale);
                }
                this._formatter.format((Locale)var1_1, (String)var2_3, (Object[])var3_4);
            }
        }
        catch (InterruptedIOException ex) {
            LOG.debug((Throwable)ex);
            Thread.currentThread().interrupt();
        }
        catch (IOException ex) {
            this.setError(ex);
        }
        return this;
    }
}

