/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.IllegalSelectorException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.EncodingHttpWriter;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Iso88591HttpWriter;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ResponseWriter;
import org.eclipse.jetty.server.Utf8HttpWriter;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.AtomicBiInteger;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Response
implements HttpServletResponse {
    private static final Logger LOG = Log.getLogger(Response.class);
    private static final int __MIN_BUFFER_SIZE = 1;
    private static final HttpField __EXPIRES_01JAN1970 = new PreEncodedHttpField(HttpHeader.EXPIRES, DateGenerator.__01Jan1970);
    public static final int NO_CONTENT_LENGTH = -1;
    public static final int USE_KNOWN_CONTENT_LENGTH = -2;
    public static final String SET_INCLUDE_HEADER_PREFIX = "org.eclipse.jetty.server.include.";
    private final HttpChannel _channel;
    private final HttpFields _fields = new HttpFields();
    private final AtomicBiInteger _errorSentAndIncludes = new AtomicBiInteger();
    private final HttpOutput _out;
    private int _status = 200;
    private String _reason;
    private Locale _locale;
    private MimeTypes.Type _mimeType;
    private String _characterEncoding;
    private EncodingFrom _encodingFrom = EncodingFrom.NOT_SET;
    private String _contentType;
    private OutputType _outputType = OutputType.NONE;
    private ResponseWriter _writer;
    private long _contentLength = -1L;
    private Supplier<HttpFields> _trailers;
    private static final EnumSet<EncodingFrom> __localeOverride = EnumSet.of(EncodingFrom.NOT_SET, EncodingFrom.INFERRED);
    private static final EnumSet<EncodingFrom> __explicitCharset = EnumSet.of(EncodingFrom.SET_LOCALE, EncodingFrom.SET_CHARACTER_ENCODING);

    /*
     * WARNING - void declaration
     */
    public Response(HttpChannel channel, HttpOutput out) {
        void var2_2;
        void var1_1;
        this._channel = var1_1;
        this._out = var2_2;
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    protected void recycle() {
        this._fields.clear();
        this._errorSentAndIncludes.set(0L);
        this._out.recycle();
        this._status = 200;
        this._reason = null;
        this._locale = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._encodingFrom = EncodingFrom.NOT_SET;
        this._contentType = null;
        this._outputType = OutputType.NONE;
        this._contentLength = -1L;
        this._trailers = null;
    }

    public HttpOutput getHttpOutput() {
        return this._out;
    }

    public void reopen() {
        this.setErrorSent(false);
        this._out.reopen();
    }

    public void errorClose() {
        this.setErrorSent(true);
        this._out.softClose();
    }

    private boolean isMutable() {
        return this._errorSentAndIncludes.get() == 0L;
    }

    /*
     * WARNING - void declaration
     */
    private void setErrorSent(boolean errorSent) {
        void var1_1;
        this._errorSentAndIncludes.getAndSetHi(var1_1 != false ? 1 : 0);
    }

    public boolean isIncluding() {
        return this._errorSentAndIncludes.getLo() > 0;
    }

    public void include() {
        this._errorSentAndIncludes.add(0, 1);
    }

    public void included() {
        this._errorSentAndIncludes.add(0, -1);
        if (this._outputType == OutputType.WRITER) {
            this._writer.reopen();
        }
        this._out.reopen();
    }

    /*
     * WARNING - void declaration
     */
    public void addCookie(HttpCookie cookie) {
        void var1_1;
        if (StringUtil.isBlank((String)cookie.getName())) {
            throw new IllegalArgumentException("Cookie.name cannot be blank/null");
        }
        this._fields.add((HttpField)new HttpCookie.SetCookieHttpField(this.checkSameSite((HttpCookie)var1_1), this.getHttpChannel().getHttpConfiguration().getResponseCookieCompliance()));
        this._fields.put(__EXPIRES_01JAN1970);
    }

    /*
     * WARNING - void declaration
     */
    private HttpCookie checkSameSite(HttpCookie cookie) {
        void var2_2;
        void var1_1;
        if (cookie == null || cookie.getSameSite() != null) {
            return cookie;
        }
        HttpCookie.SameSite contextDefault = HttpCookie.getSameSiteDefault((ServletContext)this._channel.getRequest().getServletContext());
        if (contextDefault == null) {
            return cookie;
        }
        return new HttpCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getMaxAge(), cookie.isHttpOnly(), cookie.isSecure(), cookie.getComment(), var1_1.getVersion(), (HttpCookie.SameSite)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void replaceCookie(HttpCookie cookie) {
        void var1_1;
        ListIterator i = this._fields.listIterator();
        while (i.hasNext()) {
            void var3_3;
            HttpCookie oldCookie;
            HttpField field = (HttpField)i.next();
            if (field.getHeader() != HttpHeader.SET_COOKIE) continue;
            CookieCompliance compliance = this.getHttpChannel().getHttpConfiguration().getResponseCookieCompliance();
            oldCookie = field instanceof HttpCookie.SetCookieHttpField ? ((HttpCookie.SetCookieHttpField)field).getHttpCookie() : new HttpCookie(oldCookie.getValue());
            if (!cookie.getName().equals(oldCookie.getName()) || (cookie.getDomain() != null ? !cookie.getDomain().equalsIgnoreCase(oldCookie.getDomain()) : oldCookie.getDomain() != null) || (cookie.getPath() != null ? !cookie.getPath().equals(var3_3.getPath()) : oldCookie.getPath() != null)) continue;
            i.set(new HttpCookie.SetCookieHttpField(this.checkSameSite(cookie), compliance));
            return;
        }
        this.addCookie((HttpCookie)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addCookie(Cookie cookie) {
        if (this.isMutable()) {
            void var1_1;
            void var2_2;
            void var3_3;
            if (StringUtil.isBlank((String)cookie.getName())) {
                throw new IllegalArgumentException("Cookie.name cannot be blank/null");
            }
            String comment = cookie.getComment();
            boolean httpOnly = cookie.isHttpOnly() || HttpCookie.isHttpOnlyInComment((String)comment);
            HttpCookie.SameSite sameSite = HttpCookie.getSameSiteFromComment((String)comment);
            comment = HttpCookie.getCommentWithoutAttributes((String)comment);
            this.addCookie(new HttpCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), (long)cookie.getMaxAge(), (boolean)var3_3, cookie.getSecure(), (String)var2_2, var1_1.getVersion(), sameSite));
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsHeader(String name) {
        void var1_1;
        return this._fields.containsKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String encodeURL(String url) {
        void var3_5;
        void var1_1;
        void var2_2;
        int suffix;
        void suffix22;
        String sessionURLPrefix;
        if (url == null) {
            return null;
        }
        Request request = this._channel.getRequest();
        SessionHandler sessionManager = request.getSessionHandler();
        if (sessionManager == null) {
            return url;
        }
        HttpURI uri = null;
        boolean hasScheme = URIUtil.hasScheme((String)url);
        if (sessionManager.isCheckingRemoteSessionIdEncoding() && hasScheme) {
            uri = new HttpURI(url);
            String path = uri.getPath();
            path = path == null ? "" : path;
            int port = uri.getPort();
            if (port < 0) {
                int n = port = HttpScheme.HTTPS.asString().equalsIgnoreCase(uri.getScheme()) ? 443 : 80;
            }
            if (!request.getServerName().equalsIgnoreCase(uri.getHost())) {
                return url;
            }
            if (request.getServerPort() != port) {
                return url;
            }
            if (!path.startsWith(request.getContextPath())) {
                return url;
            }
        }
        if ((sessionURLPrefix = sessionManager.getSessionIdPathParameterNamePrefix()) == null) {
            return url;
        }
        if (sessionManager.isUsingCookies() && request.isRequestedSessionIdFromCookie() || !sessionManager.isUsingURLs()) {
            int prefix = url.indexOf(sessionURLPrefix);
            if (prefix != -1) {
                int suffix22 = url.indexOf("?", prefix);
                if (suffix22 < 0) {
                    suffix22 = url.indexOf("#", prefix);
                }
                if (suffix22 <= prefix) {
                    return url.substring(0, prefix);
                }
                return url.substring(0, prefix) + url.substring(suffix22);
            }
            return url;
        }
        HttpSession session = suffix22.getSession(false);
        if (session == null) {
            return url;
        }
        if (!sessionManager.isValid(session)) {
            return url;
        }
        String id = sessionManager.getExtendedId(session);
        int prefix = url.indexOf(sessionURLPrefix);
        if (prefix != -1) {
            int suffix3 = url.indexOf("?", prefix);
            if (suffix3 < 0) {
                suffix3 = url.indexOf("#", prefix);
            }
            if (suffix3 <= prefix) {
                return url.substring(0, prefix + sessionURLPrefix.length()) + id;
            }
            return url.substring(0, prefix + sessionURLPrefix.length()) + id + url.substring(suffix3);
        }
        String nonNullPath = "";
        if (hasScheme) {
            if (uri == null) {
                uri = new HttpURI(url);
            }
            if (uri.getPath() == null) {
                nonNullPath = "/";
            }
        }
        if ((suffix = url.indexOf(63)) < 0) {
            suffix = url.indexOf(35);
        }
        if (suffix < 0) {
            return url + nonNullPath + sessionURLPrefix + id;
        }
        return url.substring(0, suffix) + nonNullPath + sessionURLPrefix + (String)var2_2 + var1_1.substring((int)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public String encodeRedirectURL(String url) {
        void var1_1;
        return this.encodeURL((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String encodeUrl(String url) {
        void var1_1;
        return this.encodeURL((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String encodeRedirectUrl(String url) {
        void var1_1;
        return this.encodeRedirectURL((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void sendError(int sc) throws IOException {
        void var1_1;
        this.sendError((int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void sendError(int code, String message) throws IOException {
        void var2_2;
        void var1_1;
        if (this.isIncluding()) {
            return;
        }
        switch (code) {
            case -1: {
                this._channel.abort(new IOException(message));
                return;
            }
            case 102: {
                this.sendProcessing();
                return;
            }
        }
        this._channel.getState().sendError((int)var1_1, (String)var2_2);
    }

    public void sendProcessing() throws IOException {
        if (this._channel.isExpecting102Processing() && !this.isCommitted()) {
            this._channel.sendResponse(HttpGenerator.PROGRESS_102_INFO, null, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendRedirect(int code, String location) throws IOException {
        void var2_2;
        void var1_1;
        this.sendRedirect((int)var1_1, (String)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public void sendRedirect(String location, boolean consumeAll) throws IOException {
        void var2_2;
        void var1_1;
        Response response = this;
        response.sendRedirect(response.getHttpChannel().getRequest().getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303, (String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void sendRedirect(int code, String location, boolean consumeAll) throws IOException {
        void var1_1;
        void var2_2;
        if (consumeAll) {
            this.getHttpChannel().ensureConsumeAllOrNotPersistent();
        }
        if (!HttpStatus.isRedirection((int)code)) {
            throw new IllegalArgumentException("Not a 3xx redirect code");
        }
        if (!this.isMutable()) {
            return;
        }
        if (location == null) {
            throw new IllegalArgumentException();
        }
        if (!URIUtil.hasScheme((String)location)) {
            void var3_4;
            StringBuilder buf;
            StringBuilder stringBuilder = buf = this._channel.getHttpConfiguration().isRelativeRedirectAllowed() ? new StringBuilder() : this._channel.getRequest().getRootURL();
            if (location.startsWith("/")) {
                location = URIUtil.canonicalURI((String)location);
            } else {
                String path = this._channel.getRequest().getRequestURI();
                String string = path.endsWith("/") ? path : URIUtil.parentPath((String)path);
                location = URIUtil.canonicalURI((String)URIUtil.addEncodedPaths((String)string, (String)location));
                if (location != null && !location.startsWith("/")) {
                    buf.append('/');
                }
            }
            if (location == null) {
                throw new IllegalStateException("path cannot be above root");
            }
            buf.append(location);
            location = var3_4.toString();
        }
        this.resetBuffer();
        this.setHeader(HttpHeader.LOCATION, (String)var2_2);
        this.setStatus((int)var1_1);
        this.closeOutput();
    }

    /*
     * WARNING - void declaration
     */
    public void sendRedirect(String location) throws IOException {
        void var1_1;
        this.sendRedirect(302, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setDateHeader(String name, long date) {
        if (this.isMutable()) {
            void var2_2;
            void var1_1;
            this._fields.putDateField((String)var1_1, (long)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addDateHeader(String name, long date) {
        if (this.isMutable()) {
            void var2_2;
            void var1_1;
            this._fields.addDateField((String)var1_1, (long)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setHeader(HttpHeader name, String value) {
        if (this.isMutable()) {
            void var1_1;
            if (HttpHeader.CONTENT_TYPE == name) {
                this.setContentType(value);
                return;
            }
            this._fields.put(name, value);
            if (HttpHeader.CONTENT_LENGTH == var1_1) {
                void var2_2;
                if (value == null) {
                    this._contentLength = -1L;
                    return;
                }
                this._contentLength = Long.parseLong((String)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setHeader(String name, String value) {
        void var1_1;
        long biInt = this._errorSentAndIncludes.get();
        if (biInt != 0L) {
            void var3_4;
            boolean including;
            boolean errorSent = AtomicBiInteger.getHi((long)biInt) != 0;
            boolean bl = including = AtomicBiInteger.getLo((long)biInt) > 0;
            if (!errorSent && var3_4 != false && name.startsWith(SET_INCLUDE_HEADER_PREFIX)) {
                name = name.substring(33);
            } else {
                return;
            }
        }
        if (HttpHeader.CONTENT_TYPE.is(name)) {
            this.setContentType(value);
            return;
        }
        this._fields.put(name, value);
        if (HttpHeader.CONTENT_LENGTH.is((String)var1_1)) {
            void var2_2;
            if (value == null) {
                this._contentLength = -1L;
                return;
            }
            this._contentLength = Long.parseLong((String)var2_2);
        }
    }

    public Collection<String> getHeaderNames() {
        return this._fields.getFieldNamesCollection();
    }

    /*
     * WARNING - void declaration
     */
    public String getHeader(String name) {
        void var1_1;
        return this._fields.get((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<String> getHeaders(String name) {
        void var1_1;
        List i = this._fields.getValuesList(name);
        if (i == null) {
            return Collections.emptyList();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addHeader(String name, String value) {
        void var2_2;
        void var1_1;
        long biInt = this._errorSentAndIncludes.get();
        if (biInt != 0L) {
            void var3_4;
            boolean including;
            boolean errorSent = AtomicBiInteger.getHi((long)biInt) != 0;
            boolean bl = including = AtomicBiInteger.getLo((long)biInt) > 0;
            if (!errorSent && var3_4 != false && name.startsWith(SET_INCLUDE_HEADER_PREFIX)) {
                name = name.substring(33);
            } else {
                return;
            }
        }
        if (HttpHeader.CONTENT_TYPE.is(name)) {
            this.setContentType(value);
            return;
        }
        if (HttpHeader.CONTENT_LENGTH.is(name)) {
            this.setHeader(name, value);
            return;
        }
        this._fields.add((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setIntHeader(String name, int value) {
        if (this.isMutable()) {
            void var1_1;
            this._fields.putLongField(name, (long)value);
            if (HttpHeader.CONTENT_LENGTH.is((String)var1_1)) {
                void var2_2;
                this._contentLength = (long)var2_2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addIntHeader(String name, int value) {
        if (this.isMutable()) {
            void var1_1;
            this._fields.add(name, Integer.toString(value));
            if (HttpHeader.CONTENT_LENGTH.is((String)var1_1)) {
                void var2_2;
                this._contentLength = (long)var2_2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setStatus(int sc) {
        if (sc <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.isMutable()) {
            void var1_1;
            if (this._status != sc) {
                this._reason = null;
            }
            this._status = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setStatus(int sc, String sm) {
        void var2_2;
        void var1_1;
        this.setStatusWithReason((int)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setStatusWithReason(int sc, String sm) {
        if (sc <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.isMutable()) {
            void var2_2;
            void var1_1;
            this._status = var1_1;
            this._reason = var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getCharacterEncoding() {
        if (this._characterEncoding == null) {
            String encoding = MimeTypes.getCharsetAssumedFromContentType((String)this._contentType);
            if (encoding != null) {
                return encoding;
            }
            encoding = MimeTypes.getCharsetInferredFromContentType((String)this._contentType);
            if (encoding != null) {
                void var1_1;
                return var1_1;
            }
            return "iso-8859-1";
        }
        return this._characterEncoding;
    }

    public String getContentType() {
        return this._contentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._outputType == OutputType.WRITER) {
            throw new IllegalStateException("WRITER");
        }
        this._outputType = OutputType.STREAM;
        return this._out;
    }

    public boolean isWriting() {
        return this._outputType == OutputType.WRITER;
    }

    public boolean isStreaming() {
        return this._outputType == OutputType.STREAM;
    }

    public boolean isWritingOrStreaming() {
        return this.isWriting() || this.isStreaming();
    }

    /*
     * WARNING - void declaration
     */
    public PrintWriter getWriter() throws IOException {
        if (this._outputType == OutputType.STREAM) {
            throw new IllegalStateException("STREAM");
        }
        if (this._outputType == OutputType.NONE) {
            String encoding = this._characterEncoding;
            if (encoding == null) {
                if (this._mimeType != null && this._mimeType.isCharsetAssumed()) {
                    encoding = this._mimeType.getCharsetString();
                } else {
                    encoding = MimeTypes.getCharsetAssumedFromContentType((String)this._contentType);
                    if (encoding == null) {
                        encoding = MimeTypes.getCharsetInferredFromContentType((String)this._contentType);
                        if (encoding == null) {
                            encoding = "iso-8859-1";
                        }
                        this.setCharacterEncoding(encoding, EncodingFrom.INFERRED);
                    }
                }
            }
            Locale locale = this.getLocale();
            if (this._writer != null && this._writer.isFor(locale, encoding)) {
                this._writer.reopen();
            } else {
                void var1_1;
                void var2_2;
                this._writer = "iso-8859-1".equalsIgnoreCase(encoding) ? new ResponseWriter(new Iso88591HttpWriter(this._out), locale, encoding) : ("utf-8".equalsIgnoreCase(encoding) ? new ResponseWriter(new Utf8HttpWriter(this._out), locale, encoding) : new ResponseWriter(new EncodingHttpWriter(this._out, encoding), (Locale)var2_2, (String)var1_1));
            }
            this._outputType = OutputType.WRITER;
        }
        return this._writer;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContentLength(int len) {
        if (this.isCommitted() || !this.isMutable()) {
            return;
        }
        if (len > 0) {
            long written = this._out.getWritten();
            if (written > (long)len) {
                throw new IllegalArgumentException("setContentLength(" + len + ") when already written " + written);
            }
            this._contentLength = len;
            this._fields.putLongField(HttpHeader.CONTENT_LENGTH, (long)len);
            if (!this.isAllContentWritten(written)) return;
            try {
                this.closeOutput();
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeIOException((Throwable)var1_2);
            }
        } else {
            void var1_1;
            if (var1_1 == false) {
                long written = this._out.getWritten();
                if (written > 0L) {
                    void var2_4;
                    throw new IllegalArgumentException("setContentLength(0) when already written " + (long)var2_4);
                }
                this._contentLength = (long)var1_1;
                this._fields.put(HttpHeader.CONTENT_LENGTH, "0");
                return;
            }
            this._contentLength = (long)var1_1;
            this._fields.remove(HttpHeader.CONTENT_LENGTH);
        }
    }

    public long getContentLength() {
        return this._contentLength;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAllContentWritten(long written) {
        void var1_1;
        return this._contentLength >= 0L && var1_1 >= this._contentLength;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isContentComplete(long written) {
        void var1_1;
        return this._contentLength < 0L || var1_1 >= this._contentLength;
    }

    public void closeOutput() throws IOException {
        if (this._outputType == OutputType.WRITER) {
            this._writer.close();
            return;
        }
        this._out.close();
    }

    @Deprecated
    public void completeOutput() throws IOException {
        this.closeOutput();
    }

    /*
     * WARNING - void declaration
     */
    public void completeOutput(Callback callback) {
        void var1_1;
        if (this._outputType == OutputType.WRITER) {
            this._writer.complete(callback);
            return;
        }
        this._out.complete((Callback)var1_1);
    }

    public long getLongContentLength() {
        return this._contentLength;
    }

    /*
     * WARNING - void declaration
     */
    public void setLongContentLength(long len) {
        void var1_1;
        if (this.isCommitted() || !this.isMutable()) {
            return;
        }
        this._contentLength = len;
        this._fields.putLongField(HttpHeader.CONTENT_LENGTH.toString(), (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setContentLengthLong(long length) {
        void var1_1;
        this.setLongContentLength((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setCharacterEncoding(String encoding) {
        void var1_1;
        this.setCharacterEncoding((String)var1_1, EncodingFrom.SET_CHARACTER_ENCODING);
    }

    /*
     * WARNING - void declaration
     */
    private void setCharacterEncoding(String encoding, EncodingFrom from) {
        if (!this.isMutable() || this.isWriting()) {
            return;
        }
        if (this._outputType != OutputType.WRITER && !this.isCommitted()) {
            if (encoding == null) {
                this._encodingFrom = EncodingFrom.NOT_SET;
                if (this._characterEncoding != null) {
                    this._characterEncoding = null;
                    if (this._mimeType != null) {
                        this._mimeType = this._mimeType.getBaseType();
                        this._contentType = this._mimeType.asString();
                        this._fields.put(this._mimeType.getContentTypeField());
                        return;
                    }
                    if (this._contentType != null) {
                        this._contentType = MimeTypes.getContentTypeWithoutCharset((String)this._contentType);
                        this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
                        return;
                    }
                }
            } else {
                void var1_1;
                void var2_2;
                this._encodingFrom = var2_2;
                String string = this._characterEncoding = HttpGenerator.__STRICT ? encoding : StringUtil.normalizeCharset((String)var1_1);
                if (this._mimeType != null) {
                    this._contentType = this._mimeType.getBaseType().asString() + ";charset=" + this._characterEncoding;
                    this._mimeType = (MimeTypes.Type)MimeTypes.CACHE.get(this._contentType);
                    if (this._mimeType == null || HttpGenerator.__STRICT) {
                        this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
                        return;
                    }
                    this._fields.put(this._mimeType.getContentTypeField());
                    return;
                }
                if (this._contentType != null) {
                    this._contentType = MimeTypes.getContentTypeWithoutCharset((String)this._contentType) + ";charset=" + this._characterEncoding;
                    this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setContentType(String contentType) {
        if (this.isCommitted() || !this.isMutable()) {
            return;
        }
        if (contentType == null) {
            if (this.isWriting() && this._characterEncoding != null) {
                throw new IllegalSelectorException();
            }
            if (this._locale == null) {
                this._characterEncoding = null;
            }
            this._mimeType = null;
            this._contentType = null;
            this._fields.remove(HttpHeader.CONTENT_TYPE);
            return;
        }
        this._contentType = contentType;
        this._mimeType = (MimeTypes.Type)MimeTypes.CACHE.get(contentType);
        String charset = this._mimeType != null && this._mimeType.getCharset() != null && !this._mimeType.isCharsetAssumed() ? this._mimeType.getCharsetString() : MimeTypes.getCharsetFromContentType((String)contentType);
        if (charset == null) {
            switch (this._encodingFrom) {
                case NOT_SET: {
                    break;
                }
                case INFERRED: 
                case SET_CONTENT_TYPE: {
                    if (this.isWriting()) {
                        this._mimeType = null;
                        this._contentType = this._contentType + ";charset=" + this._characterEncoding;
                        break;
                    }
                    this._encodingFrom = EncodingFrom.NOT_SET;
                    this._characterEncoding = null;
                    break;
                }
                case SET_LOCALE: 
                case SET_CHARACTER_ENCODING: {
                    void var1_1;
                    this._contentType = (String)var1_1 + ";charset=" + this._characterEncoding;
                    this._mimeType = null;
                }
            }
        } else if (this.isWriting() && !charset.equalsIgnoreCase(this._characterEncoding)) {
            this._mimeType = null;
            this._contentType = MimeTypes.getContentTypeWithoutCharset((String)this._contentType);
            if (this._characterEncoding != null) {
                this._contentType = this._contentType + ";charset=" + this._characterEncoding;
            }
        } else {
            void var2_2;
            this._characterEncoding = var2_2;
            this._encodingFrom = EncodingFrom.SET_CONTENT_TYPE;
        }
        if (HttpGenerator.__STRICT || this._mimeType == null) {
            this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
            return;
        }
        this._contentType = this._mimeType.asString();
        this._fields.put(this._mimeType.getContentTypeField());
    }

    /*
     * WARNING - void declaration
     */
    public void setBufferSize(int size) {
        void var1_1;
        if (this.isCommitted()) {
            throw new IllegalStateException("cannot set buffer size after response is in committed state");
        }
        if (this.getContentCount() > 0L) {
            throw new IllegalStateException("cannot set buffer size after response has " + this.getContentCount() + " bytes already written");
        }
        if (size <= 0) {
            size = 1;
        }
        this._out.setBufferSize((int)var1_1);
    }

    public int getBufferSize() {
        return this._out.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        if (!this._out.isClosed()) {
            this._out.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reset() {
        void var2_2;
        void var3_3;
        HttpCookie c;
        SessionHandler sh;
        this._status = 200;
        this._reason = null;
        this._out.resetBuffer();
        this._outputType = OutputType.NONE;
        this._contentLength = -1L;
        this._contentType = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._encodingFrom = EncodingFrom.NOT_SET;
        this._trailers = null;
        this._fields.clear();
        Iterator iterator = this._channel.getRequest().getHttpFields().getCSV(HttpHeader.CONNECTION, false).iterator();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            HttpHeaderValue cb = (HttpHeaderValue)HttpHeaderValue.CACHE.get(value);
            if (cb != null) {
                switch (cb) {
                    case CLOSE: {
                        this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.toString());
                        break;
                    }
                    case KEEP_ALIVE: {
                        if (!HttpVersion.HTTP_1_0.is(this._channel.getRequest().getProtocol())) break;
                        this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.toString());
                        break;
                    }
                    case TE: {
                        this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.TE.toString());
                    }
                }
            }
        }
        Request request = this.getHttpChannel().getRequest();
        HttpSession session = request.getSession(false);
        if (session != null && session.isNew() && (sh = request.getSessionHandler()) != null && (c = var3_3.getSessionCookie((HttpSession)var2_2, request.getContextPath(), request.isSecure())) != null) {
            this.addCookie((HttpCookie)iterator);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resetContent() {
        this._out.resetBuffer();
        this._outputType = OutputType.NONE;
        this._contentLength = -1L;
        this._contentType = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._encodingFrom = EncodingFrom.NOT_SET;
        Iterator i = this.getHttpFields().iterator();
        block3: while (i.hasNext()) {
            void var2_2;
            HttpField field = (HttpField)i.next();
            if (field.getHeader() == null) continue;
            switch (var2_2.getHeader()) {
                case CONTENT_TYPE: 
                case CONTENT_LENGTH: 
                case CONTENT_ENCODING: 
                case CONTENT_LANGUAGE: 
                case CONTENT_RANGE: 
                case CONTENT_MD5: 
                case CONTENT_LOCATION: 
                case TRANSFER_ENCODING: 
                case CACHE_CONTROL: 
                case LAST_MODIFIED: 
                case EXPIRES: 
                case ETAG: 
                case DATE: 
                case VARY: {
                    i.remove();
                    continue block3;
                }
            }
        }
    }

    public void resetForForward() {
        this.resetBuffer();
        this._outputType = OutputType.NONE;
    }

    public void resetBuffer() {
        this._out.resetBuffer();
        this._out.reopen();
    }

    /*
     * WARNING - void declaration
     */
    public void setTrailers(Supplier<HttpFields> trailers) {
        void var1_1;
        this._trailers = var1_1;
    }

    public Supplier<HttpFields> getTrailers() {
        return this._trailers;
    }

    /*
     * WARNING - void declaration
     */
    protected MetaData.Response newResponseMetaData() {
        void var1_1;
        MetaData.Response info = new MetaData.Response(this._channel.getRequest().getHttpVersion(), this.getStatus(), this.getReason(), this._fields, this.getLongContentLength());
        info.setTrailerSupplier(this.getTrailers());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MetaData.Response getCommittedMetaData() {
        void var1_1;
        MetaData.Response meta = this._channel.getCommittedMetaData();
        if (meta == null) {
            return this.newResponseMetaData();
        }
        return var1_1;
    }

    public boolean isCommitted() {
        if (this._channel.isSendError()) {
            return true;
        }
        return this._channel.isCommitted();
    }

    /*
     * WARNING - void declaration
     */
    public void setLocale(Locale locale) {
        if (locale == null || this.isCommitted() || !this.isMutable()) {
            return;
        }
        this._locale = locale;
        this._fields.put(HttpHeader.CONTENT_LANGUAGE, StringUtil.replace((String)locale.toString(), (char)'_', (char)'-'));
        if (this._outputType != OutputType.NONE) {
            return;
        }
        if (this._channel.getRequest().getContext() == null) {
            return;
        }
        String charset = this._channel.getRequest().getContext().getContextHandler().getLocaleEncoding(locale);
        if (charset != null && charset.length() > 0 && __localeOverride.contains((Object)this._encodingFrom)) {
            void var1_1;
            this.setCharacterEncoding((String)var1_1, EncodingFrom.SET_LOCALE);
        }
    }

    public Locale getLocale() {
        if (this._locale == null) {
            return Locale.getDefault();
        }
        return this._locale;
    }

    public int getStatus() {
        return this._status;
    }

    public String getReason() {
        return this._reason;
    }

    public HttpFields getHttpFields() {
        return this._fields;
    }

    public long getContentCount() {
        return this._out.getWritten();
    }

    public String toString() {
        return String.format("%s %d %s%n%s", this._channel.getRequest().getHttpVersion(), this._status, this._reason == null ? "" : this._reason, this._fields);
    }

    /*
     * WARNING - void declaration
     */
    public void putHeaders(HttpContent content, long contentLength, boolean etag) {
        HttpField et;
        HttpField ce;
        HttpField lm = content.getLastModified();
        if (lm != null) {
            this._fields.put(lm);
        }
        if (contentLength == -2L) {
            this._fields.put(content.getContentLength());
            this._contentLength = content.getContentLengthValue();
        } else if (contentLength > -1L) {
            this._fields.putLongField(HttpHeader.CONTENT_LENGTH, contentLength);
            this._contentLength = contentLength;
        }
        HttpField ct = content.getContentType();
        if (ct != null) {
            if (this._characterEncoding != null && content.getCharacterEncoding() == null && content.getContentTypeValue() != null && __explicitCharset.contains((Object)this._encodingFrom)) {
                this.setContentType(MimeTypes.getContentTypeWithoutCharset((String)content.getContentTypeValue()));
            } else {
                this._fields.put(ct);
                this._contentType = ct.getValue();
                this._characterEncoding = content.getCharacterEncoding();
                this._mimeType = content.getMimeType();
            }
        }
        if ((ce = content.getContentEncoding()) != null) {
            void var2_3;
            this._fields.put((HttpField)var2_3);
        }
        if (etag && (et = content.getETag()) != null) {
            void var1_1;
            this._fields.put((HttpField)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void putHeaders(HttpServletResponse response, HttpContent content, long contentLength, boolean etag) {
        String et;
        String ce;
        String ct;
        long lml = content.getResource().lastModified();
        if (lml >= 0L) {
            response.setDateHeader(HttpHeader.LAST_MODIFIED.asString(), lml);
        }
        if (contentLength == -2L) {
            contentLength = content.getContentLengthValue();
        }
        if (contentLength > -1L) {
            if (contentLength < Integer.MAX_VALUE) {
                response.setContentLength((int)contentLength);
            } else {
                response.setHeader(HttpHeader.CONTENT_LENGTH.asString(), Long.toString(contentLength));
            }
        }
        if ((ct = content.getContentTypeValue()) != null && response.getContentType() == null) {
            response.setContentType(ct);
        }
        if ((ce = content.getContentEncodingValue()) != null) {
            void var2_3;
            response.setHeader(HttpHeader.CONTENT_ENCODING.asString(), (String)var2_3);
        }
        if (etag && (et = content.getETagValue()) != null) {
            void var1_1;
            HttpServletResponse httpServletResponse;
            httpServletResponse.setHeader(HttpHeader.ETAG.asString(), (String)var1_1);
        }
    }

    public static HttpServletResponse unwrap(ServletResponse servletResponse) {
        ServletResponse servletResponse2;
        while (true) {
            if (servletResponse instanceof HttpServletResponseWrapper) {
                return (HttpServletResponseWrapper)servletResponse;
            }
            if (!(servletResponse instanceof ServletResponseWrapper)) break;
            servletResponse = ((ServletResponseWrapper)servletResponse).getResponse();
        }
        return (HttpServletResponse)servletResponse2;
    }

    private static enum EncodingFrom {
        NOT_SET,
        INFERRED,
        SET_LOCALE,
        SET_CONTENT_TYPE,
        SET_CHARACTER_ENCODING;

    }

    public static enum OutputType {
        NONE,
        STREAM,
        WRITER;

    }
}

