/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.servlet.AsyncContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.DateParser;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.InclusiveByteRange;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.resource.HttpContentRangeWriter;
import org.eclipse.jetty.server.resource.RangeWriter;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.MultiPartOutputStream;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.Invocable;

public class ResourceService {
    private static final Logger LOG = Log.getLogger(ResourceService.class);
    private static final PreEncodedHttpField ACCEPT_RANGES = new PreEncodedHttpField(HttpHeader.ACCEPT_RANGES, "bytes");
    private HttpContent.ContentFactory _contentFactory;
    private WelcomeFactory _welcomeFactory;
    private boolean _acceptRanges = true;
    private boolean _dirAllowed = true;
    private boolean _redirectWelcome = false;
    private CompressedContentFormat[] _precompressedFormats = new CompressedContentFormat[0];
    private String[] _preferredEncodingOrder = new String[0];
    private final Map<String, List<String>> _preferredEncodingOrderCache = new ConcurrentHashMap<String, List<String>>();
    private int _encodingCacheSize = 100;
    private boolean _pathInfoOnly = false;
    private boolean _etags = false;
    private HttpField _cacheControl;
    private List<String> _gzipEquivalentFileExtensions;

    public HttpContent.ContentFactory getContentFactory() {
        return this._contentFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void setContentFactory(HttpContent.ContentFactory contentFactory) {
        void var1_1;
        this._contentFactory = var1_1;
    }

    public WelcomeFactory getWelcomeFactory() {
        return this._welcomeFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void setWelcomeFactory(WelcomeFactory welcomeFactory) {
        void var1_1;
        this._welcomeFactory = var1_1;
    }

    public boolean isAcceptRanges() {
        return this._acceptRanges;
    }

    /*
     * WARNING - void declaration
     */
    public void setAcceptRanges(boolean acceptRanges) {
        void var1_1;
        this._acceptRanges = var1_1;
    }

    public boolean isDirAllowed() {
        return this._dirAllowed;
    }

    /*
     * WARNING - void declaration
     */
    public void setDirAllowed(boolean dirAllowed) {
        void var1_1;
        this._dirAllowed = var1_1;
    }

    public boolean isRedirectWelcome() {
        return this._redirectWelcome;
    }

    /*
     * WARNING - void declaration
     */
    public void setRedirectWelcome(boolean redirectWelcome) {
        void var1_1;
        this._redirectWelcome = var1_1;
    }

    public CompressedContentFormat[] getPrecompressedFormats() {
        return this._precompressedFormats;
    }

    /*
     * WARNING - void declaration
     */
    public void setPrecompressedFormats(CompressedContentFormat[] precompressedFormats) {
        void var1_1;
        this._precompressedFormats = var1_1;
        this._preferredEncodingOrder = (String[])Arrays.stream(this._precompressedFormats).map(f -> f.getEncoding()).toArray(String[]::new);
    }

    /*
     * WARNING - void declaration
     */
    public void setEncodingCacheSize(int encodingCacheSize) {
        void var1_1;
        this._encodingCacheSize = var1_1;
    }

    public int getEncodingCacheSize() {
        return this._encodingCacheSize;
    }

    public boolean isPathInfoOnly() {
        return this._pathInfoOnly;
    }

    /*
     * WARNING - void declaration
     */
    public void setPathInfoOnly(boolean pathInfoOnly) {
        void var1_1;
        this._pathInfoOnly = var1_1;
    }

    public boolean isEtags() {
        return this._etags;
    }

    /*
     * WARNING - void declaration
     */
    public void setEtags(boolean etags) {
        void var1_1;
        this._etags = var1_1;
    }

    public HttpField getCacheControl() {
        return this._cacheControl;
    }

    /*
     * WARNING - void declaration
     */
    public void setCacheControl(HttpField cacheControl) {
        void var1_1;
        if (cacheControl == null) {
            this._cacheControl = null;
        }
        if (cacheControl.getHeader() != HttpHeader.CACHE_CONTROL) {
            throw new IllegalArgumentException("!Cache-Control");
        }
        this._cacheControl = cacheControl instanceof PreEncodedHttpField ? cacheControl : new PreEncodedHttpField(cacheControl.getHeader(), var1_1.getValue());
    }

    public List<String> getGzipEquivalentFileExtensions() {
        return this._gzipEquivalentFileExtensions;
    }

    /*
     * WARNING - void declaration
     */
    public void setGzipEquivalentFileExtensions(List<String> gzipEquivalentFileExtensions) {
        void var1_1;
        this._gzipEquivalentFileExtensions = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo;
        String servletPath;
        Enumeration reqRanges = null;
        boolean included = request.getAttribute("javax.servlet.include.request_uri") != null;
        if (included) {
            servletPath = this._pathInfoOnly ? "/" : (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            servletPath = this._pathInfoOnly ? "/" : request.getServletPath();
            pathInfo = request.getPathInfo();
            reqRanges = request.getHeaders(HttpHeader.RANGE.asString());
            if (!this.hasDefinedRange(reqRanges)) {
                reqRanges = null;
            }
        }
        String pathInContext = URIUtil.addPaths((String)servletPath, (String)pathInfo);
        boolean endsWithSlash = (pathInfo == null ? (this._pathInfoOnly ? "" : servletPath) : pathInfo).endsWith("/");
        boolean checkPrecompressedVariants = this._precompressedFormats.length > 0 && !endsWithSlash && !included && reqRanges == null;
        HttpContent content = null;
        try {
            void var1_2;
            content = this._contentFactory.getContent(pathInContext, response.getBufferSize());
            if (LOG.isDebugEnabled()) {
                LOG.debug("content={}", new Object[]{content});
            }
            if (content == null || !content.getResource().exists()) {
                if (included) {
                    throw new FileNotFoundException("!" + pathInContext);
                }
                this.notFound(request, response);
                endsWithSlash = response.isCommitted();
                return endsWithSlash;
            }
            if (content.getResource().isDirectory()) {
                this.sendWelcome(content, pathInContext, endsWithSlash, included, request, response);
                return true;
            }
            if (!included && endsWithSlash && pathInContext.length() > 1) {
                String q = request.getQueryString();
                pathInContext = pathInContext.substring(0, pathInContext.length() - 1);
                if (q != null && q.length() != 0) {
                    pathInContext = pathInContext + "?" + q;
                }
                HttpServletResponse httpServletResponse = response;
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(URIUtil.addPaths((String)request.getContextPath(), (String)pathInContext)));
                return true;
            }
            if (!included && !this.passConditionalHeaders(request, response, content)) {
                return true;
            }
            Map precompressedContents = checkPrecompressedVariants ? content.getPrecompressedContents() : null;
            if (precompressedContents != null && precompressedContents.size() > 0) {
                response.addHeader(HttpHeader.VARY.asString(), HttpHeader.ACCEPT_ENCODING.asString());
                List<String> preferredEncodings = this.getPreferredEncodingOrder(request);
                CompressedContentFormat precompressedContentEncoding = this.getBestPrecompressedContent(preferredEncodings, precompressedContents.keySet());
                if (precompressedContentEncoding != null) {
                    HttpContent precompressedContent = (HttpContent)precompressedContents.get(precompressedContentEncoding);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("precompressed={}", new Object[]{precompressedContent});
                    }
                    content = precompressedContent;
                    response.setHeader(HttpHeader.CONTENT_ENCODING.asString(), precompressedContentEncoding.getEncoding());
                }
            }
            if (this.isGzippedContent(pathInContext)) {
                response.setHeader(HttpHeader.CONTENT_ENCODING.asString(), "gzip");
            }
            boolean releaseContent = this.sendData(request, response, included, content, reqRanges);
            if (var1_2 == false || content == null) return true;
        }
        catch (IllegalArgumentException e) {
            void var3_11;
            void var2_4;
            LOG.warn("EXCEPTION ", (Throwable)e);
            if (response.isCommitted()) return true;
            var2_4.sendError(500, var3_11.getMessage());
            return true;
        }
        finally {
            if (content != null) {
                content.release();
            }
        }
        content.release();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getPreferredEncodingOrder(HttpServletRequest request) {
        void var3_3;
        List values;
        Enumeration headers = request.getHeaders(HttpHeader.ACCEPT_ENCODING.asString());
        if (!headers.hasMoreElements()) {
            return Collections.emptyList();
        }
        String key = (String)headers.nextElement();
        if (headers.hasMoreElements()) {
            StringBuilder sb = new StringBuilder(key.length() << 1);
            sb.append(key);
            do {
                sb.append(',').append((String)headers.nextElement());
            } while (headers.hasMoreElements());
            key = sb.toString();
        }
        if ((values = this._preferredEncodingOrderCache.get(key)) == null) {
            void var2_2;
            void var1_1;
            QuotedQualityCSV encodingQualityCSV = new QuotedQualityCSV(this._preferredEncodingOrder);
            encodingQualityCSV.addValue(key);
            values = var1_1.getValues();
            if (this._preferredEncodingOrderCache.size() > this._encodingCacheSize) {
                this._preferredEncodingOrderCache.clear();
            }
            this._preferredEncodingOrderCache.put((String)var2_2, values);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private CompressedContentFormat getBestPrecompressedContent(List<String> preferredEncodings, Collection<CompressedContentFormat> availableFormats) {
        Iterator iterator;
        if (availableFormats.isEmpty()) {
            return null;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String encoding = (String)iterator.next();
            for (CompressedContentFormat format : availableFormats) {
                if (!format.getEncoding().equals(encoding)) continue;
                return format;
            }
            if ("*".equals(encoding)) {
                return availableFormats.iterator().next();
            }
            if (!HttpHeaderValue.IDENTITY.asString().equals(var3_3)) continue;
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void sendWelcome(HttpContent content, String pathInContext, boolean endsWithSlash, boolean included, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        void var1_1;
        void var2_4;
        if (!endsWithSlash) {
            StringBuilder buf = new StringBuilder(request.getRequestURI());
            int param = buf.lastIndexOf(";");
            if (param < 0 || buf.lastIndexOf("/", param) > 0) {
                buf.append('/');
            } else {
                buf.insert(param, '/');
            }
            String q = request.getQueryString();
            if (q != null && q.length() != 0) {
                buf.append('?');
                buf.append(q);
            }
            response.setContentLength(0);
            HttpServletResponse httpServletResponse = response;
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(buf.toString()));
            return;
        }
        String welcome = this._welcomeFactory == null ? null : this._welcomeFactory.getWelcomeFile(pathInContext);
        if (welcome != null) {
            String uri;
            String servletPath;
            String string = servletPath = included ? (String)request.getAttribute("javax.servlet.include.servlet_path") : request.getServletPath();
            if (this._pathInfoOnly) {
                welcome = URIUtil.addPaths((String)servletPath, (String)welcome);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("welcome={}", new Object[]{welcome});
            }
            ServletContext context = request.getServletContext();
            if (this._redirectWelcome || context == null) {
                response.setContentLength(0);
                uri = URIUtil.encodePath((String)URIUtil.addPaths((String)request.getContextPath(), (String)welcome));
                String q = request.getQueryString();
                if (q != null && !q.isEmpty()) {
                    uri = uri + "?" + (String)var2_4;
                }
                HttpServletResponse httpServletResponse = response;
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(uri));
                return;
            }
            RequestDispatcher dispatcher = uri.getRequestDispatcher(URIUtil.encodePath((String)welcome));
            if (dispatcher != null) {
                void var3_7;
                if (included) {
                    dispatcher.include((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                request.setAttribute("org.eclipse.jetty.server.welcome", (Object)var3_7);
                var1_1.forward((ServletRequest)request, (ServletResponse)response);
            }
            return;
        }
        if (included || this.passConditionalHeaders(request, response, (HttpContent)var1_1)) {
            this.sendDirectory(request, response, var1_1.getResource(), (String)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isGzippedContent(String path) {
        if (path == null || this._gzipEquivalentFileExtensions == null) {
            return false;
        }
        for (String suffix : this._gzipEquivalentFileExtensions) {
            void var3_3;
            if (!path.endsWith((String)var3_3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasDefinedRange(Enumeration<String> reqRanges) {
        void var1_1;
        return reqRanges != null && var1_1.hasMoreElements();
    }

    protected void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(404);
    }

    /*
     * WARNING - void declaration
     */
    protected void sendStatus(HttpServletResponse response, int status, Supplier<String> etag) throws IOException {
        void var1_1;
        void var2_2;
        response.setStatus((int)var2_2);
        if (this._etags && etag != null) {
            void var3_3;
            response.setHeader(HttpHeader.ETAG.asString(), (String)var3_3.get());
        }
        var1_1.flushBuffer();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, HttpContent content) throws IOException {
        void var3_3;
        long ifums;
        String ifms;
        block24: {
            try {
                HttpField field;
                Object ifm = null;
                String ifnm = null;
                ifms = null;
                ifums = -1L;
                if (request instanceof Request) {
                    HttpFields fields = ((Request)request).getHttpFields();
                    int i = fields.size();
                    while (i-- > 0) {
                        field = fields.getField(i);
                        if (field.getHeader() != null) {
                            switch (field.getHeader()) {
                                case IF_MATCH: {
                                    ifm = field.getValue();
                                    break;
                                }
                                case IF_NONE_MATCH: {
                                    ifnm = field.getValue();
                                    break;
                                }
                                case IF_MODIFIED_SINCE: {
                                    ifms = field.getValue();
                                    break;
                                }
                                case IF_UNMODIFIED_SINCE: {
                                    ifums = DateParser.parseDate((String)field.getValue());
                                }
                            }
                        }
                    }
                } else {
                    ifm = request.getHeader(HttpHeader.IF_MATCH.asString());
                    ifnm = request.getHeader(HttpHeader.IF_NONE_MATCH.asString());
                    ifms = request.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
                    ifums = request.getDateHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString());
                }
                if (!this._etags) break block24;
                String etag = content.getETagValue();
                if (ifm != null) {
                    boolean match = false;
                    if (etag != null) {
                        field = new QuotedCSV(true, new String[]{ifm});
                        for (String etagWithSuffix : field) {
                            if (!CompressedContentFormat.tagEquals((String)etag, (String)etagWithSuffix)) continue;
                            match = true;
                            break;
                        }
                    }
                    if (!match) {
                        this.sendStatus(response, 412, null);
                        return false;
                    }
                }
                if (ifnm == null || etag == null) break block24;
                if (CompressedContentFormat.tagEquals((String)etag, (String)ifnm) && ifnm.indexOf(44) < 0) {
                    this.sendStatus(response, 304, ifnm::toString);
                    return false;
                }
                QuotedCSV match = new QuotedCSV(true, new String[]{ifnm});
                for (String tag : match) {
                    if (!CompressedContentFormat.tagEquals((String)etag, (String)tag)) continue;
                    this.sendStatus(response, 304, tag::toString);
                    return false;
                }
                return true;
            }
            catch (IllegalArgumentException iae) {
                if (!response.isCommitted()) {
                    void var2_2;
                    var2_2.sendError(400, iae.getMessage());
                }
                throw iae;
            }
        }
        if (ifms != null) {
            void var1_1;
            String mdlm = content.getLastModifiedValue();
            if (ifms.equals(mdlm)) {
                this.sendStatus(response, 304, () -> ((HttpContent)content).getETagValue());
                return false;
            }
            long ifmsl = var1_1.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
            if (ifmsl != -1L && content.getResource().lastModified() / 1000L <= ifmsl / 1000L) {
                this.sendStatus(response, 304, () -> ((HttpContent)content).getETagValue());
                return false;
            }
        }
        if (ifums != -1L && var3_3.getResource().lastModified() / 1000L > ifums / 1000L) {
            response.sendError(412);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, String pathInContext) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        String base = URIUtil.addEncodedPaths((String)request.getRequestURI(), (String)"/");
        String dir = var3_3.getListHTML(base, pathInContext.length() > 1, request.getQueryString());
        if (dir == null) {
            response.sendError(403, "No directory");
            return;
        }
        byte[] data = dir.getBytes(StandardCharsets.UTF_8);
        response.setContentType("text/html;charset=utf-8");
        response.setContentLength(data.length);
        var2_2.getOutputStream().write((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean sendData(HttpServletRequest request, HttpServletResponse response, boolean include, HttpContent content, Enumeration<String> reqRanges) throws IOException {
        boolean written;
        ServletOutputStream out;
        long content_length = content.getContentLengthValue();
        try {
            out = response.getOutputStream();
            written = !(out instanceof HttpOutput) || ((HttpOutput)out).isWritten();
        }
        catch (IllegalStateException illegalStateException) {
            out = new WriterOutputStream((Writer)response.getWriter());
            written = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("sendData content=%s out=%s async=%b", content, out, request.isAsyncSupported()), new Object[0]);
        }
        if (reqRanges == null || !reqRanges.hasMoreElements() || content_length < 0L) {
            if (include) {
                content.getResource().writeTo((OutputStream)out, 0L, content_length);
            } else if (written) {
                this.putHeaders(response, content, -1L);
                ByteBuffer buffer = content.getIndirectBuffer();
                if (buffer != null) {
                    BufferUtil.writeTo((ByteBuffer)buffer, (OutputStream)out);
                } else {
                    content.getResource().writeTo((OutputStream)out, 0L, content_length);
                }
            } else {
                this.putHeaders(response, content, -2L);
                if (request.isAsyncSupported()) {
                    AsyncContext context = request.startAsync();
                    context.setTimeout(0L);
                    ((HttpOutput)out).sendContent(content, new Callback(this, context, content){
                        final /* synthetic */ AsyncContext val$context;
                        final /* synthetic */ HttpContent val$content;
                        final /* synthetic */ ResourceService this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$context = asyncContext;
                            this.val$content = httpContent;
                        }

                        public void succeeded() {
                            this.val$context.complete();
                            this.val$content.release();
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void failed(Throwable x) {
                            if (x instanceof IOException) {
                                LOG.debug(x);
                            } else {
                                void var1_1;
                                LOG.warn((Throwable)var1_1);
                            }
                            this.val$context.complete();
                            this.val$content.release();
                        }

                        public Invocable.InvocationType getInvocationType() {
                            return Invocable.InvocationType.NON_BLOCKING;
                        }

                        public String toString() {
                            return String.format("ResourceService@%x$CB", this.this$0.hashCode());
                        }
                    });
                    return false;
                }
                ((HttpOutput)out).sendContent(content);
            }
        } else {
            void var2_5;
            List<InclusiveByteRange> ranges = InclusiveByteRange.satisfiableRanges(reqRanges, content_length);
            if (ranges == null || ranges.size() == 0) {
                this.putHeaders(response, content, -2L);
                response.setHeader(HttpHeader.CONTENT_RANGE.asString(), InclusiveByteRange.to416HeaderRangeString(content_length));
                this.sendStatus(response, 416, null);
                return true;
            }
            if (ranges.size() == 1) {
                InclusiveByteRange singleSatisfiableRange = ranges.iterator().next();
                long singleLength = singleSatisfiableRange.getSize();
                this.putHeaders(response, content, singleLength);
                response.setStatus(206);
                if (!response.containsHeader(HttpHeader.DATE.asString())) {
                    response.addDateHeader(HttpHeader.DATE.asString(), System.currentTimeMillis());
                }
                response.setHeader(HttpHeader.CONTENT_RANGE.asString(), singleSatisfiableRange.toHeaderRangeString(content_length));
                content.getResource().writeTo((OutputStream)out, singleSatisfiableRange.getFirst(), singleLength);
                return true;
            }
            this.putHeaders(response, content, -1L);
            String mimetype = content.getContentTypeValue();
            if (mimetype == null) {
                LOG.warn("Unknown mimetype for " + request.getRequestURI(), new Object[0]);
            }
            MultiPartOutputStream multi = new MultiPartOutputStream((OutputStream)out);
            response.setStatus(206);
            if (!response.containsHeader(HttpHeader.DATE.asString())) {
                response.addDateHeader(HttpHeader.DATE.asString(), System.currentTimeMillis());
            }
            String ctp = request.getHeader(HttpHeader.REQUEST_RANGE.asString()) != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            response.setContentType(ctp + multi.getBoundary());
            int length = 0;
            String[] header = new String[ranges.size()];
            int i = 0;
            int CRLF = 2;
            int DASHDASH = 2;
            int BOUNDARY = multi.getBoundary().length();
            int FIELD_SEP = 2;
            for (InclusiveByteRange ibr : ranges) {
                header[i] = ibr.toHeaderRangeString(content_length);
                if (i > 0) {
                    length += CRLF;
                }
                length += DASHDASH + BOUNDARY + CRLF;
                if (mimetype != null) {
                    length += HttpHeader.CONTENT_TYPE.asString().length() + FIELD_SEP + mimetype.length() + CRLF;
                }
                length += HttpHeader.CONTENT_RANGE.asString().length() + FIELD_SEP + header[i].length() + CRLF;
                length += CRLF;
                length = (int)((long)length + ibr.getSize());
                ++i;
            }
            var2_5.setContentLength(length += CRLF + DASHDASH + BOUNDARY + DASHDASH + CRLF);
            try (RangeWriter rangeWriter = HttpContentRangeWriter.newRangeWriter(content);){
                void var3_9;
                i = 0;
                for (InclusiveByteRange ibr : var3_9) {
                    void var1_3;
                    multi.startPart(mimetype, new String[]{HttpHeader.CONTENT_RANGE + ": " + header[i]});
                    rangeWriter.writeTo((OutputStream)multi, ibr.getFirst(), var1_3.getSize());
                    ++i;
                }
            }
            multi.close();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void putHeaders(HttpServletResponse response, HttpContent content, long contentLength) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (response instanceof Response) {
            Response r = (Response)response;
            r.putHeaders(content, contentLength, this._etags);
            HttpFields fields = r.getHttpFields();
            if (this._acceptRanges && !fields.contains(HttpHeader.ACCEPT_RANGES)) {
                fields.add((HttpField)ACCEPT_RANGES);
            }
            if (this._cacheControl != null && !fields.contains(HttpHeader.CACHE_CONTROL)) {
                var1_1.add(this._cacheControl);
            }
            return;
        }
        Response.putHeaders((HttpServletResponse)var1_1, (HttpContent)var2_2, (long)var3_3, this._etags);
        if (this._acceptRanges && !var1_1.containsHeader(HttpHeader.ACCEPT_RANGES.asString())) {
            var1_1.setHeader(ACCEPT_RANGES.getName(), ACCEPT_RANGES.getValue());
        }
        if (this._cacheControl != null && !var1_1.containsHeader(HttpHeader.CACHE_CONTROL.asString())) {
            var1_1.setHeader(this._cacheControl.getName(), this._cacheControl.getValue());
        }
    }

    public static interface WelcomeFactory {
        public String getWelcomeFile(String var1);
    }
}

