/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.ResourceHttpContent;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceContentFactory
implements HttpContent.ContentFactory {
    private final ResourceFactory _factory;
    private final MimeTypes _mimeTypes;
    private final CompressedContentFormat[] _precompressedFormats;

    /*
     * WARNING - void declaration
     */
    public ResourceContentFactory(ResourceFactory factory, MimeTypes mimeTypes, CompressedContentFormat[] precompressedFormats) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._factory = var1_1;
        this._mimeTypes = var2_2;
        this._precompressedFormats = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public HttpContent getContent(String pathInContext, int maxBufferSize) throws IOException {
        try {
            void var2_2;
            Resource resource = this._factory.getResource(pathInContext);
            HttpContent httpContent = this.load(pathInContext, resource, (int)var2_2);
            return httpContent;
        }
        catch (Throwable t) {
            void var3_5;
            void var1_1;
            throw (InvalidPathException)new InvalidPathException((String)var1_1, "Invalid PathInContext").initCause((Throwable)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    private HttpContent load(String pathInContext, Resource resource, int maxBufferSize) throws IOException {
        void var3_3;
        void var2_2;
        if (resource == null || !resource.exists()) {
            return null;
        }
        if (resource.isDirectory()) {
            return new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()), maxBufferSize);
        }
        String mt = this._mimeTypes.getMimeByExtension(pathInContext);
        if (this._precompressedFormats.length > 0) {
            HashMap<CompressedContentFormat, ResourceHttpContent> compressedContents = new HashMap<CompressedContentFormat, ResourceHttpContent>(this._precompressedFormats.length);
            CompressedContentFormat[] compressedContentFormatArray = this._precompressedFormats;
            int n = this._precompressedFormats.length;
            for (int i = 0; i < n; ++i) {
                CompressedContentFormat format = compressedContentFormatArray[i];
                String compressedPathInContext = pathInContext + format.getExtension();
                Resource compressedResource = this._factory.getResource(compressedPathInContext);
                if (compressedResource == null || !compressedResource.exists() || compressedResource.lastModified() < resource.lastModified() || compressedResource.length() >= resource.length()) continue;
                compressedContents.put(format, new ResourceHttpContent(compressedResource, this._mimeTypes.getMimeByExtension(compressedPathInContext), maxBufferSize));
            }
            if (!compressedContents.isEmpty()) {
                return new ResourceHttpContent(resource, mt, maxBufferSize, compressedContents);
            }
        }
        return new ResourceHttpContent((Resource)var2_2, mt, (int)var3_3);
    }

    public String toString() {
        return "ResourceContentFactory[" + this._factory + "]@" + this.hashCode();
    }
}

