/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.AsyncAttributes;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.CookieCutter;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.MultiPartFormDataCompliance;
import org.eclipse.jetty.server.MultiParts;
import org.eclipse.jetty.server.PushBuilder;
import org.eclipse.jetty.server.PushBuilderImpl;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServletAttributes;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Request
implements HttpServletRequest {
    public static final String MULTIPART_CONFIG_ELEMENT = "org.eclipse.jetty.multipartConfig";
    public static final String MULTIPARTS = "org.eclipse.jetty.multiParts";
    private static final Logger LOG = Log.getLogger(Request.class);
    private static final Collection<Locale> __defaultLocale = Collections.singleton(Locale.getDefault());
    private static final int INPUT_NONE = 0;
    private static final int INPUT_STREAM = 1;
    private static final int INPUT_READER = 2;
    private static final MultiMap<String> NO_PARAMS = new MultiMap();
    private final HttpChannel _channel;
    private final List<ServletRequestAttributeListener> _requestAttributeListeners = new ArrayList<ServletRequestAttributeListener>();
    private final HttpInput _input;
    private MetaData.Request _metaData;
    private String _originalURI;
    private String _contextPath;
    private String _servletPath;
    private String _pathInfo;
    private Object _asyncNotSupportedSource = null;
    private boolean _secure;
    private boolean _newContext;
    private boolean _cookiesExtracted = false;
    private boolean _handled = false;
    private boolean _contentParamsExtracted;
    private boolean _requestedSessionIdFromCookie = false;
    private Attributes _attributes;
    private Authentication _authentication;
    private String _contentType;
    private String _characterEncoding;
    private ContextHandler.Context _context;
    private ContextHandler.Context _errorContext;
    private CookieCutter _cookies;
    private DispatcherType _dispatcherType;
    private int _inputState = 0;
    private BufferedReader _reader;
    private String _readerEncoding;
    private MultiMap<String> _queryParameters;
    private MultiMap<String> _contentParameters;
    private MultiMap<String> _parameters;
    private String _queryEncoding;
    private InetSocketAddress _remote;
    private String _requestedSessionId;
    private UserIdentity.Scope _scope;
    private HttpSession _session;
    private SessionHandler _sessionHandler;
    private long _timeStamp;
    private MultiParts _multiParts;
    private AsyncContextState _async;
    private List<Session> _sessions;

    private static boolean isNoParams(MultiMap<String> inputParameters) {
        boolean bl = inputParameters == NO_PARAMS;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static Request getBaseRequest(ServletRequest request) {
        if (request instanceof Request) {
            return (Request)request;
        }
        Object channel = request.getAttribute(HttpChannel.class.getName());
        if (channel instanceof HttpChannel) {
            void var1_1;
            return ((HttpChannel)var1_1).getRequest();
        }
        while (request instanceof ServletRequestWrapper) {
            request = ((ServletRequestWrapper)request).getRequest();
        }
        if (request instanceof Request) {
            ServletRequest servletRequest;
            return (Request)servletRequest;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Request(HttpChannel channel, HttpInput input) {
        void var2_2;
        void var1_1;
        this._channel = var1_1;
        this._input = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public HttpFields getHttpFields() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return null;
        }
        return var1_1.getFields();
    }

    /*
     * WARNING - void declaration
     */
    public HttpFields getTrailers() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        Supplier trailers = metadata == null ? null : metadata.getTrailerSupplier();
        if (trailers == null) {
            return null;
        }
        return (HttpFields)var1_1.get();
    }

    public HttpInput getHttpInput() {
        return this._input;
    }

    public boolean isPush() {
        return Boolean.TRUE.equals(this.getAttribute("org.eclipse.jetty.pushed"));
    }

    public boolean isPushSupported() {
        return !this.isPush() && this.getHttpChannel().getHttpTransport().isPushSupported();
    }

    /*
     * WARNING - void declaration
     */
    public PushBuilder getPushBuilder() {
        void var2_2;
        void var1_1;
        String id;
        if (!this.isPushSupported()) {
            return null;
        }
        HttpFields fields = new HttpFields(this.getHttpFields().size() + 5);
        boolean conditional = false;
        Iterator iterator = this.getHttpFields().iterator();
        block7: while (iterator.hasNext()) {
            HttpField field = (HttpField)iterator.next();
            HttpHeader header = field.getHeader();
            if (header != null) {
                switch (header) {
                    case IF_MATCH: 
                    case IF_RANGE: 
                    case IF_UNMODIFIED_SINCE: 
                    case RANGE: 
                    case EXPECT: 
                    case REFERER: 
                    case COOKIE: {
                        continue block7;
                    }
                    case AUTHORIZATION: {
                        continue block7;
                    }
                    case IF_NONE_MATCH: 
                    case IF_MODIFIED_SINCE: {
                        conditional = true;
                        continue block7;
                    }
                }
            }
            fields.add(field);
        }
        try {
            HttpSession session = this.getSession();
            if (session != null) {
                session.getLastAccessedTime();
                id = session.getId();
            } else {
                id = this.getRequestedSessionId();
            }
        }
        catch (IllegalStateException illegalStateException) {
            id = this.getRequestedSessionId();
        }
        PushBuilderImpl builder = new PushBuilderImpl(this, (HttpFields)var1_1, this.getMethod(), this.getQueryString(), (String)((Object)iterator), (boolean)var2_2);
        builder.addHeader("referer", this.getRequestURL().toString());
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public void addEventListener(EventListener listener) {
        if (listener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners.add((ServletRequestAttributeListener)listener);
        }
        if (listener instanceof AsyncListener) {
            void var1_1;
            throw new IllegalArgumentException(var1_1.getClass().toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void enterSession(HttpSession s) {
        void var1_1;
        if (!(s instanceof Session)) {
            return;
        }
        if (this._sessions == null) {
            this._sessions = new ArrayList<Session>();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request {} entering session={}", new Object[]{this, s});
        }
        this._sessions.add((Session)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void leaveSession(Session session) {
        void var1_1;
        ServletContext servletContext;
        ContextHandler handler;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request {} leaving session {}", new Object[]{this, session});
        }
        if ((handler = ContextHandler.getContextHandler(servletContext = session.getServletContext())) == null) {
            session.getSessionHandler().complete(session);
            return;
        }
        servletContext.handle(this, () -> Request.lambda$leaveSession$0((Session)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void commitSession(Session session) {
        void var1_1;
        ServletContext servletContext;
        ContextHandler handler;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response {} committing for session {}", new Object[]{this, session});
        }
        if ((handler = ContextHandler.getContextHandler(servletContext = session.getServletContext())) == null) {
            session.getSessionHandler().commit(session);
            return;
        }
        servletContext.handle(this, () -> Request.lambda$commitSession$1((Session)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private MultiMap<String> getParameters() {
        void var1_3;
        if (!this._contentParamsExtracted) {
            this._contentParamsExtracted = true;
            if (this._contentParameters == null) {
                try {
                    this.extractContentParameters();
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    LOG.warn(e.toString(), new Object[0]);
                    throw new BadMessageException("Unable to parse form content", (Throwable)e);
                }
            }
        }
        if (this._queryParameters == null) {
            try {
                this.extractQueryParameters();
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new BadMessageException("Unable to parse URI query", (Throwable)e);
            }
        }
        if (Request.isNoParams(this._queryParameters) || this._queryParameters.size() == 0) {
            this._parameters = this._contentParameters;
        } else if (Request.isNoParams(this._contentParameters) || this._contentParameters.size() == 0) {
            this._parameters = this._queryParameters;
        } else if (this._parameters == null) {
            this._parameters = new MultiMap();
            this._parameters.addAllValues(this._queryParameters);
            this._parameters.addAllValues(this._contentParameters);
        }
        MultiMap<String> parameters = this._parameters;
        if (parameters == null) {
            return NO_PARAMS;
        }
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    private void extractQueryParameters() {
        MetaData.Request metadata = this._metaData;
        if (metadata == null || metadata.getURI() == null || !metadata.getURI().hasQuery()) {
            this._queryParameters = NO_PARAMS;
            return;
        }
        this._queryParameters = new MultiMap();
        if (this._queryEncoding == null) {
            metadata.getURI().decodeQueryTo(this._queryParameters);
            return;
        }
        try {
            metadata.getURI().decodeQueryTo(this._queryParameters, this._queryEncoding);
            return;
        }
        catch (UnsupportedEncodingException e) {
            void var1_2;
            if (LOG.isDebugEnabled()) {
                LOG.warn((Throwable)e);
                return;
            }
            LOG.warn(var1_2.toString(), new Object[0]);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isContentEncodingSupported() {
        void var1_1;
        String contentEncoding = this.getHttpFields().get(HttpHeader.CONTENT_ENCODING);
        if (contentEncoding == null) {
            return true;
        }
        return HttpHeaderValue.IDENTITY.is((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void extractContentParameters() {
        String contentType = this.getContentType();
        if (contentType == null || contentType.isEmpty()) {
            this._contentParameters = NO_PARAMS;
            return;
        }
        this._contentParameters = new MultiMap();
        int n = this.getContentLength();
        if (n != 0 && this._inputState == 0) {
            String baseType = HttpFields.valueParameters((String)contentType, null);
            if (MimeTypes.Type.FORM_ENCODED.is(baseType) && this._channel.getHttpConfiguration().isFormEncodedMethod(this.getMethod())) {
                if (this._metaData != null && !this.isContentEncodingSupported()) {
                    throw new BadMessageException(415, "Unsupported Content-Encoding");
                }
                Request request = this;
                request.extractFormParameters(request._contentParameters);
                return;
            }
            if (MimeTypes.Type.MULTIPART_FORM_DATA.is(baseType) && this.getAttribute(MULTIPART_CONFIG_ELEMENT) != null && this._multiParts == null) {
                try {
                    if (this._metaData != null && !this.isContentEncodingSupported()) {
                        throw new BadMessageException(415, "Unsupported Content-Encoding");
                    }
                    Request request = this;
                    request.getParts(request._contentParameters);
                    return;
                }
                catch (IOException e) {
                    void var1_2;
                    LOG.debug((Throwable)e);
                    throw new RuntimeIOException((Throwable)var1_2);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void extractFormParameters(MultiMap<String> params) {
        try {
            void var3_7;
            void var1_1;
            int maxFormKeys;
            int maxFormContentSize;
            if (this._context != null) {
                ContextHandler contextHandler = this._context.getContextHandler();
                maxFormContentSize = contextHandler.getMaxFormContentSize();
                maxFormKeys = contextHandler.getMaxFormKeys();
            } else {
                maxFormContentSize = this.lookupServerAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", 200000);
                maxFormKeys = this.lookupServerAttribute("org.eclipse.jetty.server.Request.maxFormKeys", 1000);
            }
            int contentLength = this.getContentLength();
            if (maxFormContentSize >= 0 && contentLength > maxFormContentSize) {
                throw new IllegalStateException("Form is larger than max length " + maxFormContentSize);
            }
            ServletInputStream in = this.getInputStream();
            if (this._input.isAsync()) {
                throw new IllegalStateException("Cannot extract parameters with async IO");
            }
            UrlEncoded.decodeTo((InputStream)in, (MultiMap)var1_1, (String)this.getCharacterEncoding(), (int)maxFormContentSize, (int)var3_7);
            return;
        }
        catch (IOException e) {
            void var2_6;
            LOG.debug((Throwable)e);
            throw new RuntimeIOException((Throwable)var2_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int lookupServerAttribute(String key, int dftValue) {
        void var2_2;
        Object attribute = this._channel.getServer().getAttribute(key);
        if (attribute instanceof Number) {
            return ((Number)attribute).intValue();
        }
        if (attribute instanceof String) {
            void var1_1;
            return Integer.parseInt((String)var1_1);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public AsyncContext getAsyncContext() {
        HttpChannelState state = this.getHttpChannelState();
        if (this._async == null || !state.isAsyncStarted()) {
            void var1_1;
            throw new IllegalStateException(var1_1.getStatusString());
        }
        return this._async;
    }

    public HttpChannelState getHttpChannelState() {
        return this._channel.getState();
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String name) {
        void var1_1;
        if (name.startsWith("org.eclipse.jetty")) {
            if (Server.class.getName().equals(name)) {
                return this._channel.getServer();
            }
            if (HttpChannel.class.getName().equals(name)) {
                return this._channel;
            }
            if (HttpConnection.class.getName().equals(name) && this._channel.getHttpTransport() instanceof HttpConnection) {
                return this._channel.getHttpTransport();
            }
        }
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.getAttribute((String)var1_1);
    }

    public Enumeration<String> getAttributeNames() {
        if (this._attributes == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return AttributesMap.getAttributeNamesCopy((Attributes)this._attributes);
    }

    public Attributes getAttributes() {
        if (this._attributes == null) {
            this._attributes = new ServletAttributes();
        }
        return this._attributes;
    }

    public Authentication getAuthentication() {
        return this._authentication;
    }

    public String getAuthType() {
        if (this._authentication instanceof Authentication.Deferred) {
            Request request = this;
            request.setAuthentication(((Authentication.Deferred)request._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getAuthMethod();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getCharacterEncoding() {
        void var2_2;
        MimeTypes.Type mime;
        String charset;
        String contentType;
        if (this._characterEncoding == null && (contentType = this.getContentType()) != null && (charset = (mime = (MimeTypes.Type)MimeTypes.CACHE.get(contentType)) == null || mime.getCharset() == null ? MimeTypes.getCharsetFromContentType((String)contentType) : var2_2.getCharset().toString()) != null) {
            void var1_1;
            this._characterEncoding = var1_1;
        }
        return this._characterEncoding;
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    /*
     * WARNING - void declaration
     */
    public int getContentLength() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return -1;
        }
        long contentLength = metadata.getContentLength();
        if (contentLength != Long.MIN_VALUE) {
            void var2_2;
            if (contentLength > Integer.MAX_VALUE) {
                return -1;
            }
            return (int)var2_2;
        }
        return (int)var1_1.getFields().getLongField(HttpHeader.CONTENT_LENGTH.asString());
    }

    /*
     * WARNING - void declaration
     */
    public long getContentLengthLong() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return -1L;
        }
        if (metadata.getContentLength() != Long.MIN_VALUE) {
            return metadata.getContentLength();
        }
        return var1_1.getFields().getLongField(HttpHeader.CONTENT_LENGTH.asString());
    }

    public long getContentRead() {
        return this._input.getContentConsumed();
    }

    /*
     * WARNING - void declaration
     */
    public String getContentType() {
        if (this._contentType == null) {
            void var1_1;
            MetaData.Request metadata = this._metaData;
            this._contentType = metadata == null ? null : var1_1.getFields().get(HttpHeader.CONTENT_TYPE);
        }
        return this._contentType;
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    /*
     * WARNING - void declaration
     */
    public ContextHandler.Context getErrorContext() {
        ContextHandler handler;
        if (this.isAsyncStarted() && (handler = this._channel.getState().getContextHandler()) != null) {
            void var1_1;
            return var1_1.getServletContext();
        }
        return this._errorContext;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    /*
     * WARNING - void declaration
     */
    public Cookie[] getCookies() {
        Iterator iterator;
        MetaData.Request metadata = this._metaData;
        if (metadata == null || this._cookiesExtracted) {
            if (this._cookies == null || this._cookies.getCookies().length == 0) {
                return null;
            }
            return this._cookies.getCookies();
        }
        this._cookiesExtracted = true;
        for (HttpField field : iterator.getFields()) {
            void var2_2;
            if (field.getHeader() != HttpHeader.COOKIE) continue;
            if (this._cookies == null) {
                this._cookies = new CookieCutter(this.getHttpChannel().getHttpConfiguration().getRequestCookieCompliance());
            }
            this._cookies.addCookieField(var2_2.getValue());
        }
        if (this._cookies == null || this._cookies.getCookies().length == 0) {
            return null;
        }
        return this._cookies.getCookies();
    }

    /*
     * WARNING - void declaration
     */
    public long getDateHeader(String name) {
        void var1_1;
        void var2_2;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return -1L;
        }
        return var2_2.getFields().getDateField((String)var1_1);
    }

    public DispatcherType getDispatcherType() {
        return this._dispatcherType;
    }

    /*
     * WARNING - void declaration
     */
    public String getHeader(String name) {
        void var1_1;
        void var2_2;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return null;
        }
        return var2_2.getFields().get((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Enumeration<String> getHeaderNames() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return Collections.emptyEnumeration();
        }
        return var1_1.getFields().getFieldNames();
    }

    /*
     * WARNING - void declaration
     */
    public Enumeration<String> getHeaders(String name) {
        void var1_1;
        void var2_2;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return Collections.emptyEnumeration();
        }
        Enumeration e = var2_2.getFields().getValues(name);
        if (e == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return var1_1;
    }

    public int getInputState() {
        return this._inputState;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException("READER");
        }
        this._inputState = 1;
        if (this._channel.isExpecting100Continue()) {
            this._channel.continue100(this._input.available());
        }
        return this._input;
    }

    /*
     * WARNING - void declaration
     */
    public int getIntHeader(String name) {
        void var1_1;
        void var2_2;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return -1;
        }
        return (int)var2_2.getFields().getLongField((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Locale getLocale() {
        void var2_2;
        void var1_1;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return Locale.getDefault();
        }
        Object acceptable = metadata.getFields().getQualityCSV(HttpHeader.ACCEPT_LANGUAGE);
        if (acceptable.isEmpty()) {
            return Locale.getDefault();
        }
        acceptable = (String)acceptable.get(0);
        String language = HttpFields.stripParameters((String)acceptable);
        String country = "";
        int dash = language.indexOf(45);
        if (dash >= 0) {
            void var3_3;
            country = language.substring(dash + 1).trim();
            language = language.substring(0, (int)var3_3).trim();
        }
        return new Locale((String)var1_1, (String)var2_2);
    }

    public Enumeration<Locale> getLocales() {
        List list;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return Collections.enumeration(__defaultLocale);
        }
        List acceptable = metadata.getFields().getQualityCSV(HttpHeader.ACCEPT_LANGUAGE);
        if (acceptable.isEmpty()) {
            return Collections.enumeration(__defaultLocale);
        }
        list = list.stream().map(language -> {
            void var1_1;
            String string;
            language = HttpFields.stripParameters((String)language);
            String country = "";
            int dash = language.indexOf(45);
            if (dash >= 0) {
                void var2_2;
                country = language.substring(dash + 1).trim();
                language = language.substring(0, (int)var2_2).trim();
            }
            return new Locale(string, (String)var1_1);
        }).collect(Collectors.toList());
        return Collections.enumeration(list);
    }

    /*
     * WARNING - void declaration
     */
    public String getLocalAddr() {
        if (this._channel != null) {
            void var1_1;
            void var2_2;
            InetSocketAddress local = this._channel.getLocalAddress();
            if (local == null) {
                return "";
            }
            InetAddress address = local.getAddress();
            String result = address == null ? local.getHostString() : var2_2.getHostAddress();
            return this.formatAddrOrHost((String)var1_1);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public String getLocalName() {
        if (this._channel != null) {
            void var1_1;
            String localName = this._channel.getLocalName();
            return this.formatAddrOrHost((String)var1_1);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public int getLocalPort() {
        int localPort;
        if (this._channel != null && (localPort = this._channel.getLocalPort()) > 0) {
            void var1_1;
            return (int)var1_1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public String getMethod() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return null;
        }
        return var1_1.getMethod();
    }

    /*
     * WARNING - void declaration
     */
    public String getParameter(String name) {
        void var1_1;
        return (String)this.getParameters().getValue((String)var1_1, 0);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.getParameters().toStringArrayMap());
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameters().keySet());
    }

    /*
     * WARNING - void declaration
     */
    public String[] getParameterValues(String name) {
        void var1_1;
        List vals = this.getParameters().getValues(name);
        if (vals == null) {
            return null;
        }
        void v0 = var1_1;
        return v0.toArray(new String[v0.size()]);
    }

    public MultiMap<String> getQueryParameters() {
        return this._queryParameters;
    }

    /*
     * WARNING - void declaration
     */
    public void setQueryParameters(MultiMap<String> queryParameters) {
        void var1_1;
        this._queryParameters = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setContentParameters(MultiMap<String> contentParameters) {
        void var1_1;
        this._contentParameters = var1_1;
    }

    public void resetParameters() {
        this._parameters = null;
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getPathTranslated() {
        if (this._pathInfo == null || this._context == null) {
            return null;
        }
        return ((ContextHandler.StaticContext)this._context).getRealPath(this._pathInfo);
    }

    /*
     * WARNING - void declaration
     */
    public String getProtocol() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return null;
        }
        HttpVersion version = metadata.getHttpVersion();
        if (version == null) {
            return null;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public HttpVersion getHttpVersion() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return null;
        }
        return var1_1.getHttpVersion();
    }

    public String getQueryEncoding() {
        return this._queryEncoding;
    }

    /*
     * WARNING - void declaration
     */
    public String getQueryString() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return null;
        }
        return var1_1.getURI().getQuery();
    }

    /*
     * WARNING - void declaration
     */
    public BufferedReader getReader() throws IOException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this._inputState == 2) {
            return this._reader;
        }
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "iso-8859-1";
        }
        if (this._reader == null || !encoding.equalsIgnoreCase(this._readerEncoding)) {
            void var2_2;
            void var1_1;
            ServletInputStream in = this.getInputStream();
            this._readerEncoding = encoding;
            this._reader = new BufferedReader(this, new InputStreamReader((InputStream)in, (String)var1_1), (ServletInputStream)var2_2){
                final /* synthetic */ ServletInputStream val$in;
                final /* synthetic */ Request this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$in = servletInputStream;
                    super((Reader)var2_2);
                }

                @Override
                public void close() throws IOException {
                    this.val$in.close();
                }
            };
        }
        this._inputState = 2;
        return this._reader;
    }

    /*
     * WARNING - void declaration
     */
    public String getRealPath(String path) {
        void var1_1;
        if (this._context == null) {
            return null;
        }
        return ((ContextHandler.StaticContext)this._context).getRealPath((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public InetSocketAddress getRemoteInetSocketAddress() {
        void var1_1;
        InetSocketAddress remote = this._remote;
        if (remote == null) {
            remote = this._channel.getRemoteAddress();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String getRemoteAddr() {
        void var1_1;
        void var2_2;
        InetSocketAddress remote = this._remote;
        if (remote == null) {
            remote = this._channel.getRemoteAddress();
        }
        if (remote == null) {
            return "";
        }
        InetAddress address = remote.getAddress();
        String result = address == null ? remote.getHostString() : var2_2.getHostAddress();
        return this.formatAddrOrHost((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getRemoteHost() {
        void var1_1;
        InetSocketAddress remote = this._remote;
        if (remote == null) {
            remote = this._channel.getRemoteAddress();
        }
        if (remote == null) {
            return "";
        }
        return this.formatAddrOrHost(var1_1.getHostString());
    }

    /*
     * WARNING - void declaration
     */
    public int getRemotePort() {
        void var1_1;
        InetSocketAddress remote = this._remote;
        if (remote == null) {
            remote = this._channel.getRemoteAddress();
        }
        if (remote == null) {
            return 0;
        }
        return var1_1.getPort();
    }

    /*
     * WARNING - void declaration
     */
    public String getRemoteUser() {
        void var1_1;
        Principal p = this.getUserPrincipal();
        if (p == null) {
            return null;
        }
        return var1_1.getName();
    }

    /*
     * WARNING - void declaration
     */
    public RequestDispatcher getRequestDispatcher(String path) {
        void var1_1;
        if ((path = URIUtil.compactPath((String)path)) == null || this._context == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            void var2_2;
            void var3_3;
            String relTo = URIUtil.addPaths((String)this._servletPath, (String)this._pathInfo);
            int slash = relTo.lastIndexOf("/");
            relTo = slash > 1 ? relTo.substring(0, (int)(var3_3 + true)) : "/";
            path = URIUtil.addPaths((String)var2_2, (String)path);
        }
        return ((ContextHandler.StaticContext)this._context).getRequestDispatcher((String)var1_1);
    }

    public String getRequestedSessionId() {
        return this._requestedSessionId;
    }

    /*
     * WARNING - void declaration
     */
    public String getRequestURI() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return null;
        }
        return var1_1.getURI().getPath();
    }

    /*
     * WARNING - void declaration
     */
    public StringBuffer getRequestURL() {
        void var1_1;
        StringBuffer url = new StringBuffer(128);
        URIUtil.appendSchemeHostPort((StringBuffer)url, (String)this.getScheme(), (String)this.getServerName(), (int)this.getServerPort());
        String path = this.getRequestURI();
        if (path != null) {
            void var2_2;
            url.append((String)var2_2);
        }
        return var1_1;
    }

    public Response getResponse() {
        return this._channel.getResponse();
    }

    /*
     * WARNING - void declaration
     */
    public StringBuilder getRootURL() {
        void var1_1;
        StringBuilder url = new StringBuilder(128);
        URIUtil.appendSchemeHostPort((StringBuilder)url, (String)this.getScheme(), (String)this.getServerName(), (int)this.getServerPort());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String getScheme() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        String scheme = metadata == null ? null : metadata.getURI().getScheme();
        if (scheme == null) {
            return HttpScheme.HTTP.asString();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String getServerName() {
        MetaData.Request metadata = this._metaData;
        String name = metadata == null ? null : this.formatAddrOrHost(metadata.getURI().getHost());
        if (name != null) {
            void var1_1;
            return var1_1;
        }
        return this.findServerName();
    }

    /*
     * WARNING - void declaration
     */
    private String findServerName() {
        HostPort serverAuthority;
        MetaData.Request metadata = this._metaData;
        HttpField host = metadata == null ? null : metadata.getFields().getField(HttpHeader.HOST);
        if (host != null) {
            if (!(host instanceof HostPortHttpField) && host.getValue() != null && !host.getValue().isEmpty()) {
                host = new HostPortHttpField(host.getValue());
            }
            if (host instanceof HostPortHttpField) {
                void var1_1;
                HostPortHttpField authority = (HostPortHttpField)host;
                var1_1.getURI().setAuthority(authority.getHost(), authority.getPort());
                return this.formatAddrOrHost(authority.getHost());
            }
        }
        if (this._channel != null && (serverAuthority = this._channel.getServerAuthority()) != null) {
            return this.formatAddrOrHost(serverAuthority.getHost());
        }
        String name = this.getLocalName();
        if (name != null) {
            void var2_2;
            return this.formatAddrOrHost((String)var2_2);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public int getServerPort() {
        void var1_2;
        MetaData.Request metadata = this._metaData;
        HttpURI uri = metadata == null ? null : metadata.getURI();
        int port = uri == null || uri.getHost() == null ? this.findServerPort() : uri.getPort();
        if (port <= 0) {
            if (HttpScheme.HTTPS.is(this.getScheme())) {
                return 443;
            }
            return 80;
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private int findServerPort() {
        HostPort serverAuthority;
        HostPortHttpField authority;
        MetaData.Request metadata = this._metaData;
        HttpField host = metadata == null ? null : metadata.getFields().getField(HttpHeader.HOST);
        if (host != null && (authority = host instanceof HostPortHttpField ? (HostPortHttpField)host : new HostPortHttpField(host.getValue())).getHostPort().hasHost() && authority.getHostPort().hasPort()) {
            void var1_1;
            var1_1.getURI().setAuthority(authority.getHost(), authority.getPort());
            return authority.getPort();
        }
        if (this._channel != null && (serverAuthority = this._channel.getServerAuthority()) != null) {
            void var2_2;
            return var2_2.getPort();
        }
        return this.getLocalPort();
    }

    public ServletContext getServletContext() {
        return this._context;
    }

    public String getServletName() {
        if (this._scope != null) {
            return this._scope.getName();
        }
        return null;
    }

    public String getServletPath() {
        if (this._servletPath == null) {
            this._servletPath = "";
        }
        return this._servletPath;
    }

    public ServletResponse getServletResponse() {
        return this._channel.getResponse();
    }

    /*
     * WARNING - void declaration
     */
    public String changeSessionId() {
        void var1_1;
        HttpSession session = this.getSession(false);
        if (session == null) {
            throw new IllegalStateException("No session");
        }
        if (session instanceof Session) {
            Session s = (Session)session;
            s.renewId(this);
            if (this.getRemoteUser() != null) {
                s.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", Boolean.TRUE);
            }
            if (s.isIdChanged() && this._sessionHandler.isUsingCookies()) {
                void var2_2;
                this._channel.getResponse().replaceCookie(this._sessionHandler.getSessionCookie((HttpSession)var2_2, this.getContextPath(), this.isSecure()));
            }
        }
        return var1_1.getId();
    }

    /*
     * WARNING - void declaration
     */
    public void onCompleted() {
        if (this._sessions != null) {
            for (Session s : this._sessions) {
                void var2_2;
                this.leaveSession((Session)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onResponseCommit() {
        if (this._sessions != null) {
            for (Session s : this._sessions) {
                void var2_2;
                this.commitSession((Session)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public HttpSession getSession(SessionHandler sessionHandler) {
        void var2_2;
        if (this._sessions == null || this._sessions.size() == 0 || sessionHandler == null) {
            return null;
        }
        HttpSession session = null;
        for (HttpSession httpSession : this._sessions) {
            Session ss = (Session)Session.class.cast(httpSession);
            if (sessionHandler != ss.getSessionHandler()) continue;
            session = httpSession;
            if (!ss.isValid()) continue;
            return session;
        }
        return var2_2;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    /*
     * WARNING - void declaration
     */
    public HttpSession getSession(boolean create) {
        if (this._session != null) {
            if (this._sessionHandler != null && !this._sessionHandler.isValid(this._session)) {
                this._session = null;
            } else {
                return this._session;
            }
        }
        if (!create) {
            return null;
        }
        if (this.getResponse().isCommitted()) {
            throw new IllegalStateException("Response is committed");
        }
        if (this._sessionHandler == null) {
            throw new IllegalStateException("No SessionManager");
        }
        this._session = this._sessionHandler.newHttpSession(this);
        if (this._session == null) {
            throw new IllegalStateException("Create session failed");
        }
        HttpCookie cookie = this._sessionHandler.getSessionCookie(this._session, this.getContextPath(), this.isSecure());
        if (cookie != null) {
            void var1_2;
            this._channel.getResponse().replaceCookie((HttpCookie)var1_2);
        }
        return this._session;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    /*
     * WARNING - void declaration
     */
    public HttpURI getHttpURI() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return null;
        }
        return var1_1.getURI();
    }

    public String getOriginalURI() {
        return this._originalURI;
    }

    /*
     * WARNING - void declaration
     */
    public void setHttpURI(HttpURI uri) {
        void var1_1;
        MetaData.Request request = this._metaData;
        request.setURI((HttpURI)var1_1);
    }

    public UserIdentity getUserIdentity() {
        if (this._authentication instanceof Authentication.Deferred) {
            Request request = this;
            request.setAuthentication(((Authentication.Deferred)request._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentity getResolvedUserIdentity() {
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentity.Scope getUserIdentityScope() {
        return this._scope;
    }

    public Principal getUserPrincipal() {
        if (this._authentication instanceof Authentication.Deferred) {
            Request request = this;
            request.setAuthentication(((Authentication.Deferred)request._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            UserIdentity userIdentity = ((Authentication.User)this._authentication).getUserIdentity();
            return userIdentity.getUserPrincipal();
        }
        return null;
    }

    public boolean isHandled() {
        return this._handled;
    }

    public boolean isAsyncStarted() {
        return this.getHttpChannelState().isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this._asyncNotSupportedSource == null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._requestedSessionId != null && this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isRequestedSessionIdValid() {
        void var1_1;
        if (this._requestedSessionId == null) {
            return false;
        }
        HttpSession session = this.getSession(false);
        return session != null && this._sessionHandler.getSessionIdManager().getId(this._requestedSessionId).equals(this._sessionHandler.getId((HttpSession)var1_1));
    }

    public boolean isSecure() {
        return this._secure;
    }

    /*
     * WARNING - void declaration
     */
    public void setSecure(boolean secure) {
        void var1_1;
        this._secure = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isUserInRole(String role) {
        if (this._authentication instanceof Authentication.Deferred) {
            Request request = this;
            request.setAuthentication(((Authentication.Deferred)request._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            void var1_1;
            return ((Authentication.User)this._authentication).isUserInRole(this._scope, (String)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void setMetaData(MetaData.Request request) {
        String path;
        String encoded;
        Connection connection;
        HttpCompliance httpCompliance;
        String badMessage;
        if (this._metaData == null && this._input != null && this._channel != null) {
            this._input.recycle();
            this._channel.getResponse().getHttpOutput().reopen();
        }
        this._metaData = request;
        this.setMethod(request.getMethod());
        HttpURI uri = request.getURI();
        if (uri.hasViolations() && (badMessage = HttpCompliance.checkUriCompliance((HttpCompliance)(httpCompliance = (connection = this._channel == null ? null : this._channel.getConnection()) instanceof HttpConnection ? ((HttpConnection)connection).getHttpCompliance() : (this._channel != null ? (HttpCompliance)this._channel.getConnector().getBean(HttpCompliance.class) : null)), (HttpURI)uri)) != null) {
            throw new BadMessageException(badMessage);
        }
        if (HttpMethod.CONNECT.is(request.getMethod())) {
            this._originalURI = uri.getAuthority();
            encoded = "/";
        } else {
            void var1_1;
            this._originalURI = uri.isAbsolute() && var1_1.getHttpVersion() != HttpVersion.HTTP_2 ? uri.toString() : uri.getPathQuery();
            encoded = uri.getPath();
        }
        if (encoded == null) {
            path = uri.isAbsolute() ? "/" : null;
            uri.setPath(path);
        } else {
            void var2_2;
            path = encoded.startsWith("/") ? (encoded.length() == 1 ? "/" : var2_2.getDecodedPath()) : ("*".equals(encoded) || HttpMethod.CONNECT.is(this.getMethod()) ? encoded : null);
        }
        if (path == null || path.isEmpty()) {
            void var3_3;
            this.setPathInfo((String)(encoded == null ? "" : var3_3));
            throw new BadMessageException(400, "Bad URI");
        }
        this.setPathInfo(path);
    }

    public MetaData.Request getMetaData() {
        return this._metaData;
    }

    public boolean hasMetaData() {
        return this._metaData != null;
    }

    /*
     * WARNING - void declaration
     */
    protected void recycle() {
        if (this._context != null) {
            throw new IllegalStateException("Request in context!");
        }
        if (this._reader != null && this._inputState == 2) {
            try {
                int r = this._reader.read();
                while (r != -1) {
                    r = this._reader.read();
                }
            }
            catch (Exception e) {
                void var1_2;
                LOG.ignore((Throwable)var1_2);
                this._reader = null;
                this._readerEncoding = null;
            }
        }
        this.getHttpChannelState().recycle();
        this._requestAttributeListeners.clear();
        this._metaData = null;
        this._originalURI = null;
        this._contextPath = null;
        this._servletPath = null;
        this._pathInfo = null;
        this._asyncNotSupportedSource = null;
        this._secure = false;
        this._newContext = false;
        this._cookiesExtracted = false;
        this._handled = false;
        this._contentParamsExtracted = false;
        this._requestedSessionIdFromCookie = false;
        this._attributes = Attributes.unwrap((Attributes)this._attributes);
        if (this._attributes != null) {
            if (ServletAttributes.class.equals(this._attributes.getClass())) {
                this._attributes.clearAttributes();
            } else {
                this._attributes = null;
            }
        }
        this.setAuthentication(Authentication.NOT_CHECKED);
        this._contentType = null;
        this._characterEncoding = null;
        this._context = null;
        this._errorContext = null;
        if (this._cookies != null) {
            this._cookies.reset();
        }
        this._dispatcherType = null;
        this._inputState = 0;
        this._queryParameters = null;
        this._contentParameters = null;
        this._parameters = null;
        this._queryEncoding = null;
        this._remote = null;
        this._requestedSessionId = null;
        this._scope = null;
        this._session = null;
        this._sessionHandler = null;
        this._timeStamp = 0L;
        this._multiParts = null;
        if (this._async != null) {
            this._async.reset();
        }
        this._async = null;
        this._sessions = null;
    }

    public void removeAttribute(String name) {
        Object oldValue;
        Object object = oldValue = this._attributes == null ? null : this._attributes.getAttribute(name);
        if (this._attributes != null) {
            this._attributes.removeAttribute(name);
        }
        if (oldValue != null && !this._requestAttributeListeners.isEmpty()) {
            Iterator<ServletRequestAttributeListener> iterator;
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, name, (Object)iterator);
            for (ServletRequestAttributeListener servletRequestAttributeListener : this._requestAttributeListeners) {
                servletRequestAttributeListener.attributeRemoved(event);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeEventListener(EventListener listener) {
        void var1_1;
        this._requestAttributeListeners.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAsyncSupported(boolean supported, Object source) {
        void var2_2;
        void var1_1;
        this._asyncNotSupportedSource = var1_1 != false ? null : (source == null ? "unknown" : var2_2);
    }

    public void setAttribute(String name, Object value) {
        Object oldValue;
        Object object = oldValue = this._attributes == null ? null : this._attributes.getAttribute(name);
        if ("org.eclipse.jetty.server.Request.queryEncoding".equals(name)) {
            this.setQueryEncoding(value == null ? null : value.toString());
        } else if ("org.eclipse.jetty.server.sendContent".equals(name)) {
            LOG.warn("Deprecated: org.eclipse.jetty.server.sendContent", new Object[0]);
        }
        if (this._attributes == null) {
            this._attributes = new ServletAttributes();
        }
        this._attributes.setAttribute(name, value);
        if (!this._requestAttributeListeners.isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, name, oldValue == null ? value : oldValue);
            for (ServletRequestAttributeListener l : this._requestAttributeListeners) {
                if (oldValue == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttributes(Attributes attributes) {
        void var1_1;
        this._attributes = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAsyncAttributes() {
        void var3_3;
        void var2_2;
        void var1_1;
        Attributes baseAttributes;
        String queryString;
        String pathInfo;
        String servletPath;
        String contextPath;
        if (this.getAttribute("javax.servlet.async.request_uri") != null) {
            return;
        }
        String requestURI = (String)this.getAttribute("javax.servlet.forward.request_uri");
        if (requestURI != null) {
            contextPath = (String)this.getAttribute("javax.servlet.forward.context_path");
            servletPath = (String)this.getAttribute("javax.servlet.forward.servlet_path");
            pathInfo = (String)this.getAttribute("javax.servlet.forward.path_info");
            queryString = (String)this.getAttribute("javax.servlet.forward.query_string");
        } else {
            requestURI = this.getRequestURI();
            contextPath = this.getContextPath();
            servletPath = this.getServletPath();
            pathInfo = this.getPathInfo();
            queryString = this.getQueryString();
        }
        if (this._attributes == null) {
            this._attributes = baseAttributes = new ServletAttributes();
        } else {
            baseAttributes = Attributes.unwrap((Attributes)this._attributes);
        }
        if (baseAttributes instanceof ServletAttributes) {
            ServletAttributes servletAttributes = (ServletAttributes)baseAttributes;
            servletAttributes.setAsyncAttributes(requestURI, contextPath, servletPath, pathInfo, queryString);
            return;
        }
        AsyncAttributes.applyAsyncAttributes(this._attributes, (String)var1_1, (String)var2_2, (String)var3_3, pathInfo, queryString);
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthentication(Authentication authentication) {
        void var1_1;
        this._authentication = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            return;
        }
        this._characterEncoding = encoding;
        if (!StringUtil.isUTF8((String)encoding)) {
            try {
                Charset.forName(encoding);
                return;
            }
            catch (UnsupportedCharsetException e) {
                void var1_2;
                throw new UnsupportedEncodingException(var1_2.getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setCharacterEncodingUnchecked(String encoding) {
        void var1_1;
        this._characterEncoding = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setContentType(String contentType) {
        void var1_1;
        this._contentType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setContext(ContextHandler.Context context) {
        void var1_1;
        boolean bl = this._newContext = this._context != context;
        if (context == null) {
            this._context = null;
            return;
        }
        this._context = context;
        this._errorContext = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean takeNewContext() {
        void var1_1;
        boolean nc = this._newContext;
        this._newContext = false;
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setContextPath(String contextPath) {
        void var1_1;
        this._contextPath = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setCookies(Cookie[] cookies) {
        void var1_1;
        if (this._cookies == null) {
            this._cookies = new CookieCutter(this.getHttpChannel().getHttpConfiguration().getRequestCookieCompliance());
        }
        this._cookies.setCookies((Cookie[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setDispatcherType(DispatcherType type) {
        void var1_1;
        this._dispatcherType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setHandled(boolean h) {
        void var1_1;
        this._handled = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMethod(String method) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            void var1_1;
            void var2_2;
            var2_2.setMethod((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setHttpVersion(HttpVersion version) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            void var1_1;
            void var2_2;
            var2_2.setHttpVersion((HttpVersion)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isHead() {
        void var1_1;
        MetaData.Request metadata = this._metaData;
        return metadata != null && HttpMethod.HEAD.is(var1_1.getMethod());
    }

    /*
     * WARNING - void declaration
     */
    public void setPathInfo(String pathInfo) {
        void var1_1;
        this._pathInfo = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setQueryEncoding(String queryEncoding) {
        void var1_1;
        this._queryEncoding = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setQueryString(String queryString) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            void var1_1;
            void var2_2;
            var2_2.getURI().setQuery((String)var1_1);
        }
        this._queryEncoding = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setRemoteAddr(InetSocketAddress addr) {
        void var1_1;
        this._remote = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestedSessionId(String requestedSessionId) {
        void var1_1;
        this._requestedSessionId = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdCookie) {
        void var1_1;
        this._requestedSessionIdFromCookie = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setURIPathQuery(String requestURI) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            void var1_1;
            void var2_2;
            var2_2.getURI().setPathQuery((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setScheme(String scheme) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            void var1_1;
            void var2_2;
            var2_2.getURI().setScheme((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthority(String host, int port) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.getURI().setAuthority((String)var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setServletPath(String servletPath) {
        void var1_1;
        this._servletPath = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSession(HttpSession session) {
        void var1_1;
        this._session = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionHandler(SessionHandler sessionHandler) {
        void var1_1;
        this._sessionHandler = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeStamp(long ts) {
        void var1_1;
        this._timeStamp = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserIdentityScope(UserIdentity.Scope scope) {
        void var1_1;
        this._scope = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsyncContext startAsync() throws IllegalStateException {
        void var2_2;
        void var1_1;
        if (this._asyncNotSupportedSource != null) {
            throw new IllegalStateException("!asyncSupported: " + this._asyncNotSupportedSource);
        }
        HttpChannelState state = this.getHttpChannelState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        Request request = this;
        AsyncContextEvent event = new AsyncContextEvent(this._context, this._async, state, request, (ServletRequest)request, (ServletResponse)this.getResponse());
        var1_1.startAsync((AsyncContextEvent)var2_2);
        return this._async;
    }

    /*
     * WARNING - void declaration
     */
    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        void var2_2;
        void var3_3;
        void var1_1;
        if (this._asyncNotSupportedSource != null) {
            throw new IllegalStateException("!asyncSupported: " + this._asyncNotSupportedSource);
        }
        HttpChannelState state = this.getHttpChannelState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        AsyncContextEvent event = new AsyncContextEvent(this._context, this._async, state, this, servletRequest, servletResponse);
        event.setDispatchContext(this.getServletContext());
        String uri = Request.unwrap(servletRequest).getRequestURI();
        uri = this._contextPath != null && uri.startsWith(this._contextPath) ? uri.substring(this._contextPath.length()) : URIUtil.encodePath((String)URIUtil.addPaths((String)this.getServletPath(), (String)this.getPathInfo()));
        event.setDispatchPath((String)var1_1);
        var3_3.startAsync((AsyncContextEvent)var2_2);
        return this._async;
    }

    public static HttpServletRequest unwrap(ServletRequest servletRequest) {
        ServletRequest servletRequest2;
        while (true) {
            if (servletRequest instanceof HttpServletRequestWrapper) {
                return (HttpServletRequestWrapper)servletRequest;
            }
            if (!(servletRequest instanceof ServletRequestWrapper)) break;
            servletRequest = ((ServletRequestWrapper)servletRequest).getRequest();
        }
        return (HttpServletRequest)servletRequest2;
    }

    public String toString() {
        return String.format("%s%s%s %s%s@%x", this.getClass().getSimpleName(), this._handled ? "[" : "(", this.getMethod(), this.getHttpURI(), this._handled ? "]" : ")", this.hashCode());
    }

    /*
     * WARNING - void declaration
     */
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        void var1_1;
        if (this._authentication instanceof Authentication.Deferred) {
            Request request = this;
            request.setAuthentication(((Authentication.Deferred)request._authentication).authenticate((ServletRequest)this, (ServletResponse)response));
            return !(this._authentication instanceof Authentication.ResponseSent);
        }
        var1_1.sendError(401);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Part getPart(String name) throws IOException, ServletException {
        void var1_1;
        this.getParts();
        return this._multiParts.getPart((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<Part> getParts() throws IOException, ServletException {
        String contentType = this.getContentType();
        if (contentType == null || !MimeTypes.Type.MULTIPART_FORM_DATA.is(HttpFields.valueParameters((String)contentType, null))) {
            void var1_1;
            throw new ServletException("Unsupported Content-Type [" + (String)var1_1 + "], expected [multipart/form-data]");
        }
        return this.getParts(null);
    }

    private Collection<Part> getParts(MultiMap<String> params) throws IOException {
        if (this._multiParts == null) {
            this._multiParts = (MultiParts)this.getAttribute(MULTIPARTS);
        }
        if (this._multiParts == null) {
            int maxFormKeys;
            int maxFormContentSize;
            MultipartConfigElement config = (MultipartConfigElement)this.getAttribute(MULTIPART_CONFIG_ELEMENT);
            if (config == null) {
                throw new IllegalStateException("No multipart config for servlet");
            }
            if (this._context != null) {
                ContextHandler contextHandler = this._context.getContextHandler();
                maxFormContentSize = contextHandler.getMaxFormContentSize();
                maxFormKeys = contextHandler.getMaxFormKeys();
            } else {
                maxFormContentSize = this.lookupServerAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", 200000);
                maxFormKeys = this.lookupServerAttribute("org.eclipse.jetty.server.Request.maxFormKeys", 1000);
            }
            this._multiParts = this.newMultiParts(config, maxFormKeys);
            this.setAttribute(MULTIPARTS, this._multiParts);
            Collection<Part> parts = this._multiParts.getParts();
            String formCharset = null;
            Part charsetPart = this._multiParts.getPart("_charset_");
            if (charsetPart != null) {
                try (InputStream is = charsetPart.getInputStream();){
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    IO.copy((InputStream)is, (OutputStream)os);
                    formCharset = new String(os.toByteArray(), StandardCharsets.UTF_8);
                }
            }
            Charset defaultCharset = formCharset != null ? Charset.forName(formCharset) : (this.getCharacterEncoding() != null ? Charset.forName(this.getCharacterEncoding()) : StandardCharsets.UTF_8);
            long formContentSize = 0L;
            ByteArrayOutputStream os = null;
            for (Part p : parts) {
                if (p.getSubmittedFileName() != null) continue;
                formContentSize = Math.addExact(formContentSize, p.getSize());
                if (maxFormContentSize >= 0 && formContentSize > (long)maxFormContentSize) {
                    throw new IllegalStateException("Form is larger than max length " + maxFormContentSize);
                }
                String charset = null;
                if (p.getContentType() != null) {
                    charset = MimeTypes.getCharsetFromContentType((String)p.getContentType());
                }
                try (InputStream is = p.getInputStream();){
                    if (os == null) {
                        os = new ByteArrayOutputStream();
                    }
                    IO.copy((InputStream)is, os);
                    String content = new String(os.toByteArray(), charset == null ? defaultCharset : Charset.forName(charset));
                    if (this._contentParameters == null) {
                        this._contentParameters = params == null ? new MultiMap() : params;
                    }
                    this._contentParameters.add(p.getName(), (Object)content);
                }
                os.reset();
            }
        }
        return this._multiParts.getParts();
    }

    /*
     * WARNING - void declaration
     */
    private MultiParts newMultiParts(MultipartConfigElement config, int maxParts) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        MultiPartFormDataCompliance compliance = this.getHttpChannel().getHttpConfiguration().getMultipartFormDataCompliance();
        if (LOG.isDebugEnabled()) {
            LOG.debug("newMultiParts {} {}", new Object[]{compliance, this});
        }
        switch (2.$SwitchMap$org$eclipse$jetty$server$MultiPartFormDataCompliance[var3_3.ordinal()]) {
            case 1: {
                return new MultiParts.MultiPartsHttpParser((InputStream)this.getInputStream(), this.getContentType(), config, this._context != null ? (File)this._context.getAttribute("javax.servlet.context.tempdir") : null, this, maxParts);
            }
        }
        return new MultiParts.MultiPartsUtilParser((InputStream)this.getInputStream(), this.getContentType(), (MultipartConfigElement)var1_1, this._context != null ? (File)this._context.getAttribute("javax.servlet.context.tempdir") : null, this, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void login(String username, String password) throws ServletException {
        void var1_1;
        if (this._authentication instanceof Authentication.LoginAuthentication) {
            void var2_2;
            Authentication auth = ((Authentication.LoginAuthentication)this._authentication).login(username, password, (ServletRequest)this);
            if (auth == null) {
                throw new Authentication.Failed("Authentication failed for username '" + username + "'");
            }
            this._authentication = var2_2;
            return;
        }
        throw new Authentication.Failed("Authenticated failed for username '" + (String)var1_1 + "'. Already authenticated as " + this._authentication);
    }

    public void logout() throws ServletException {
        if (this._authentication instanceof Authentication.LogoutAuthentication) {
            this._authentication = ((Authentication.LogoutAuthentication)this._authentication).logout((ServletRequest)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void mergeQueryParameters(String oldQuery, String newQuery, boolean updateQueryString) {
        MultiMap mergedQueryParams;
        MultiMap oldQueryParams;
        MultiMap newQueryParams = null;
        if (newQuery != null) {
            newQueryParams = new MultiMap();
            try {
                UrlEncoded.decodeTo((String)newQuery, (MultiMap)newQueryParams, (Charset)UrlEncoded.ENCODING);
            }
            catch (Exception e) {
                throw new BadMessageException(500, "Bad query encoding", (Throwable)e);
            }
        }
        if ((oldQueryParams = this._queryParameters) == null && oldQuery != null) {
            oldQueryParams = new MultiMap();
            try {
                UrlEncoded.decodeTo((String)oldQuery, (MultiMap)oldQueryParams, (String)this.getQueryEncoding());
            }
            catch (Throwable ex) {
                throw new BadMessageException(400, "Bad query encoding", ex);
            }
        }
        if (newQueryParams == null || newQueryParams.size() == 0) {
            mergedQueryParams = oldQueryParams == null ? NO_PARAMS : oldQueryParams;
        } else if (oldQueryParams == null || oldQueryParams.size() == 0) {
            mergedQueryParams = newQueryParams;
        } else {
            mergedQueryParams = new MultiMap(newQueryParams);
            mergedQueryParams.addAllValues(oldQueryParams);
        }
        this.setQueryParameters((MultiMap<String>)mergedQueryParams);
        this.resetParameters();
        if (updateQueryString) {
            void var1_1;
            if (newQuery == null) {
                this.setQueryString(oldQuery);
                return;
            }
            if (oldQuery == null) {
                this.setQueryString(newQuery);
                return;
            }
            StringBuilder mergedQuery = new StringBuilder();
            if (newQuery != null) {
                Iterator iterator;
                mergedQuery.append((String)((Object)iterator));
            }
            for (Map.Entry entry : mergedQueryParams.entrySet()) {
                if (newQueryParams != null && newQueryParams.containsKey(entry.getKey())) continue;
                for (String value : (List)entry.getValue()) {
                    if (mergedQuery.length() > 0) {
                        mergedQuery.append("&");
                    }
                    URIUtil.encodePath((StringBuilder)mergedQuery, (String)((String)entry.getKey()));
                    mergedQuery.append('=');
                    URIUtil.encodePath((StringBuilder)mergedQuery, (String)value);
                }
            }
            this.setQueryString(var1_1.toString());
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new ServletException("HttpServletRequest.upgrade() not supported in Jetty");
    }

    /*
     * WARNING - void declaration
     */
    private String formatAddrOrHost(String name) {
        void var1_1;
        if (this._channel == null) {
            return HostPort.normalizeHost((String)name);
        }
        return this._channel.formatAddrOrHost((String)var1_1);
    }

    private static /* synthetic */ void lambda$commitSession$1(Session session) {
        Session session2;
        session.getSessionHandler().commit(session2);
    }

    private static /* synthetic */ void lambda$leaveSession$0(Session session) {
        Session session2;
        session.getSessionHandler().complete(session2);
    }
}

