/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Set;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.server.PushBuilder;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class PushBuilderImpl
implements PushBuilder {
    private static final Logger LOG = Log.getLogger(PushBuilderImpl.class);
    private static final HttpField JettyPush = new HttpField("x-http2-push", "PushBuilder");
    private final Request _request;
    private final HttpFields _fields;
    private String _method;
    private String _queryString;
    private String _sessionId;
    private boolean _conditional;
    private String _path;
    private String _etag;
    private String _lastModified;

    /*
     * WARNING - void declaration
     */
    public PushBuilderImpl(Request request, HttpFields fields, String method, String queryString, String sessionId, boolean conditional) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._request = var1_1;
        this._fields = var2_2;
        this._method = var3_3;
        this._queryString = queryString;
        this._sessionId = sessionId;
        this._conditional = conditional;
        this._fields.add(JettyPush);
        if (LOG.isDebugEnabled()) {
            LOG.debug("PushBuilder({} {}?{} s={} c={})", new Object[]{this._method, this._request.getRequestURI(), this._queryString, this._sessionId, this._conditional});
        }
    }

    @Override
    public String getMethod() {
        return this._method;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PushBuilder method(String method) {
        void var1_1;
        this._method = var1_1;
        return this;
    }

    @Override
    public String getQueryString() {
        return this._queryString;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PushBuilder queryString(String queryString) {
        void var1_1;
        this._queryString = var1_1;
        return this;
    }

    @Override
    public String getSessionId() {
        return this._sessionId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PushBuilder sessionId(String sessionId) {
        void var1_1;
        this._sessionId = var1_1;
        return this;
    }

    @Override
    public boolean isConditional() {
        return this._conditional;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PushBuilder conditional(boolean conditional) {
        void var1_1;
        this._conditional = var1_1;
        return this;
    }

    @Override
    public Set<String> getHeaderNames() {
        return this._fields.getFieldNamesCollection();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getHeader(String name) {
        void var1_1;
        return this._fields.get((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PushBuilder setHeader(String name, String value) {
        void var2_2;
        void var1_1;
        this._fields.put((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PushBuilder addHeader(String name, String value) {
        void var2_2;
        void var1_1;
        this._fields.add((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PushBuilder removeHeader(String name) {
        void var1_1;
        this._fields.remove((String)var1_1);
        return this;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PushBuilder path(String path) {
        void var1_1;
        this._path = var1_1;
        return this;
    }

    @Override
    public String getEtag() {
        return this._etag;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PushBuilder etag(String etag) {
        void var1_1;
        this._etag = var1_1;
        return this;
    }

    @Override
    public String getLastModified() {
        return this._lastModified;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PushBuilder lastModified(String lastModified) {
        void var1_1;
        this._lastModified = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void push() {
        void var2_2;
        void var3_4;
        if (HttpMethod.POST.is(this._method) || HttpMethod.PUT.is(this._method)) {
            throw new IllegalStateException("Bad Method " + this._method);
        }
        if (this._path == null || this._path.length() == 0) {
            throw new IllegalStateException("Bad Path " + this._path);
        }
        String path = this._path;
        String query = this._queryString;
        int q = path.indexOf(63);
        if (q >= 0) {
            query = query != null && query.length() > 0 ? path.substring(q + 1) + '&' + query : path.substring(q + 1);
            path = path.substring(0, q);
        }
        if (!path.startsWith("/")) {
            path = URIUtil.addPaths((String)this._request.getContextPath(), (String)path);
        }
        String param = null;
        if (this._sessionId != null && this._request.isRequestedSessionIdFromURL()) {
            param = "jsessionid=" + this._sessionId;
        }
        if (this._conditional) {
            if (this._etag != null) {
                this._fields.add(HttpHeader.IF_NONE_MATCH, this._etag);
            } else if (this._lastModified != null) {
                this._fields.add(HttpHeader.IF_MODIFIED_SINCE, this._lastModified);
            }
        }
        HttpURI uri = HttpURI.createHttpURI((String)this._request.getScheme(), (String)this._request.getServerName(), (int)this._request.getServerPort(), (String)path, (String)var3_4, (String)query, null);
        MetaData.Request push = new MetaData.Request(this._method, uri, this._request.getHttpVersion(), this._fields);
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("Push {} {} inm={} ims={}", new Object[]{this._method, var1_1, this._fields.get(HttpHeader.IF_NONE_MATCH), this._fields.get(HttpHeader.IF_MODIFIED_SINCE)});
        }
        this._request.getHttpChannel().getHttpTransport().push((MetaData.Request)var2_2);
        this._path = null;
        this._etag = null;
        this._lastModified = null;
    }
}

