/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DetectorConnectionFactory;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ProxyConnectionFactory
extends DetectorConnectionFactory {
    public static final String TLS_VERSION = "TLS_VERSION";
    private static final Logger LOG = Log.getLogger(ProxyConnectionFactory.class);

    public ProxyConnectionFactory() {
        this((String)null);
    }

    /*
     * WARNING - void declaration
     */
    public ProxyConnectionFactory(String nextProtocol) {
        super(new ProxyV1ConnectionFactory(nextProtocol), new ProxyV2ConnectionFactory((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static ConnectionFactory findNextConnectionFactory(String nextProtocol, Connector connector, String currentProtocol, EndPoint endp) {
        void var2_2;
        currentProtocol = "[" + currentProtocol + "]";
        if (LOG.isDebugEnabled()) {
            LOG.debug("finding connection factory following {} for protocol {}", new Object[]{currentProtocol, nextProtocol});
        }
        String nextProtocolToFind = nextProtocol;
        if (nextProtocol == null) {
            nextProtocolToFind = AbstractConnectionFactory.findNextProtocol(connector, currentProtocol);
        }
        if (nextProtocolToFind == null) {
            throw new IllegalStateException("Cannot find protocol following '" + currentProtocol + "' in connector's protocol list " + connector.getProtocols() + " for " + endp);
        }
        ConnectionFactory connectionFactory = connector.getConnectionFactory(nextProtocolToFind);
        if (connectionFactory == null) {
            void var3_3;
            void var1_1;
            throw new IllegalStateException("Cannot find protocol '" + nextProtocol + "' in connector's protocol list " + var1_1.getProtocols() + " for " + var3_3);
        }
        if (LOG.isDebugEnabled()) {
            String string;
            LOG.debug("found next connection factory {} for protocol {}", new Object[]{connectionFactory, string});
        }
        return var2_2;
    }

    public int getMaxProxyHeader() {
        ProxyV2ConnectionFactory proxyV2ConnectionFactory = (ProxyV2ConnectionFactory)this.getBean(ProxyV2ConnectionFactory.class);
        return proxyV2ConnectionFactory.getMaxProxyHeader();
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxProxyHeader(int maxProxyHeader) {
        void var1_1;
        ProxyV2ConnectionFactory proxyV2ConnectionFactory = (ProxyV2ConnectionFactory)this.getBean(ProxyV2ConnectionFactory.class);
        proxyV2ConnectionFactory.setMaxProxyHeader((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ConnectionFactory access$300(String x0, Connector x1, String x2, EndPoint x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ProxyConnectionFactory.findNextConnectionFactory(x0, (Connector)var1_1, (String)var2_2, (EndPoint)var3_3);
    }

    public static class ProxyEndPoint
    extends AttributesMap
    implements EndPoint {
        private final EndPoint _endp;
        private final InetSocketAddress _remote;
        private final InetSocketAddress _local;

        /*
         * WARNING - void declaration
         */
        public ProxyEndPoint(EndPoint endp, InetSocketAddress remote, InetSocketAddress local) {
            void var3_3;
            void var2_2;
            void var1_1;
            this._endp = var1_1;
            this._remote = var2_2;
            this._local = var3_3;
        }

        public EndPoint unwrap() {
            return this._endp;
        }

        public void close() {
            this._endp.close();
        }

        /*
         * WARNING - void declaration
         */
        public int fill(ByteBuffer buffer) throws IOException {
            void var1_1;
            return this._endp.fill((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void fillInterested(Callback callback) throws ReadPendingException {
            void var1_1;
            this._endp.fillInterested((Callback)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public boolean flush(ByteBuffer ... buffer) throws IOException {
            void var1_1;
            return this._endp.flush((ByteBuffer[])var1_1);
        }

        public Connection getConnection() {
            return this._endp.getConnection();
        }

        /*
         * WARNING - void declaration
         */
        public void setConnection(Connection connection) {
            void var1_1;
            this._endp.setConnection((Connection)var1_1);
        }

        public long getCreatedTimeStamp() {
            return this._endp.getCreatedTimeStamp();
        }

        public long getIdleTimeout() {
            return this._endp.getIdleTimeout();
        }

        /*
         * WARNING - void declaration
         */
        public void setIdleTimeout(long idleTimeout) {
            void var1_1;
            this._endp.setIdleTimeout((long)var1_1);
        }

        public InetSocketAddress getLocalAddress() {
            return this._local;
        }

        public InetSocketAddress getRemoteAddress() {
            return this._remote;
        }

        public Object getTransport() {
            return this._endp.getTransport();
        }

        public boolean isFillInterested() {
            return this._endp.isFillInterested();
        }

        public boolean isInputShutdown() {
            return this._endp.isInputShutdown();
        }

        public boolean isOpen() {
            return this._endp.isOpen();
        }

        public boolean isOptimizedForDirectBuffers() {
            return this._endp.isOptimizedForDirectBuffers();
        }

        public boolean isOutputShutdown() {
            return this._endp.isOutputShutdown();
        }

        public void onClose() {
            this._endp.onClose();
        }

        public void onOpen() {
            this._endp.onOpen();
        }

        public void shutdownOutput() {
            this._endp.shutdownOutput();
        }

        public String toString() {
            return String.format("%s@%x[remote=%s,local=%s,endpoint=%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this._remote, this._local, this._endp);
        }

        /*
         * WARNING - void declaration
         */
        public boolean tryFillInterested(Callback callback) {
            void var1_1;
            return this._endp.tryFillInterested((Callback)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void upgrade(Connection newConnection) {
            void var1_1;
            this._endp.upgrade((Connection)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
            void var2_2;
            void var1_1;
            this._endp.write((Callback)var1_1, (ByteBuffer[])var2_2);
        }
    }

    private static class ProxyV2ConnectionFactory
    extends AbstractConnectionFactory
    implements ConnectionFactory.Detecting {
        private static final byte[] SIGNATURE = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
        private final String _nextProtocol;
        private int _maxProxyHeader = 1024;

        /*
         * WARNING - void declaration
         */
        private ProxyV2ConnectionFactory(String nextProtocol) {
            super("proxy");
            void var1_1;
            this._nextProtocol = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ConnectionFactory.Detecting.Detection detect(ByteBuffer buffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proxy v2 attempting detection with {} bytes", (long)buffer.remaining());
            }
            if (buffer.remaining() < SIGNATURE.length) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 detection requires more bytes", new Object[0]);
                }
                return ConnectionFactory.Detecting.Detection.NEED_MORE_BYTES;
            }
            for (int i = 0; i < SIGNATURE.length; ++i) {
                void var3_3;
                byte signatureByte = SIGNATURE[i];
                byte by = buffer.get(i);
                if (by == var3_3) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 detection unsuccessful", new Object[0]);
                }
                return ConnectionFactory.Detecting.Detection.NOT_RECOGNIZED;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proxy v2 detection succeeded", new Object[0]);
            }
            return ConnectionFactory.Detecting.Detection.RECOGNIZED;
        }

        public int getMaxProxyHeader() {
            return this._maxProxyHeader;
        }

        /*
         * WARNING - void declaration
         */
        public void setMaxProxyHeader(int maxProxyHeader) {
            void var1_1;
            this._maxProxyHeader = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Connection newConnection(Connector connector, EndPoint endp) {
            void var2_2;
            void var1_1;
            void var3_3;
            ConnectionFactory nextConnectionFactory = ProxyConnectionFactory.access$300(this._nextProtocol, connector, this.getProtocol(), endp);
            return this.configure(new ProxyProtocolV2Connection(endp, connector, (ConnectionFactory)var3_3), (Connector)var1_1, (EndPoint)var2_2);
        }

        private class ProxyProtocolV2Connection
        extends AbstractConnection
        implements Connection.UpgradeFrom,
        Connection.UpgradeTo {
            private static final int HEADER_LENGTH = 16;
            private final Connector _connector;
            private final ConnectionFactory _next;
            private final ByteBuffer _buffer;
            private boolean _local;
            private Family _family;
            private int _length;
            private boolean _headerParsed;

            /*
             * WARNING - void declaration
             */
            protected ProxyProtocolV2Connection(EndPoint endp, Connector connector, ConnectionFactory next) {
                void var3_3;
                void var2_2;
                super((EndPoint)var2_2, connector.getExecutor());
                this._connector = var3_3;
                this._next = next;
                this._buffer = this._connector.getByteBufferPool().acquire(this.getInputBufferSize(), true);
            }

            /*
             * WARNING - void declaration
             */
            public void onUpgradeTo(ByteBuffer buffer) {
                void var1_1;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 copying unconsumed buffer {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)buffer)});
                }
                BufferUtil.append((ByteBuffer)this._buffer, (ByteBuffer)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void onOpen() {
                super.onOpen();
                try {
                    this.parseHeader();
                    if (this._headerParsed && this._buffer.remaining() >= this._length) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v2 onOpen parsing fixed length packet part done, now upgrading", new Object[0]);
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v2 onOpen parsing fixed length packet ran out of bytes, marking as fillInterested", new Object[0]);
                        }
                        this.fillInterested();
                        return;
                    }
                    this.parseBodyAndUpgrade();
                }
                catch (Exception x) {
                    void var1_1;
                    LOG.warn("Proxy v2 error for {}", new Object[]{this.getEndPoint(), var1_1});
                    this.releaseAndClose();
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onFillable() {
                try {
                    int fill;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Proxy v2 onFillable header parsed? ", new Object[]{this._headerParsed});
                    }
                    while (!this._headerParsed) {
                        fill = this.getEndPoint().fill(this._buffer);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v2 filled buffer with {} bytes", (long)fill);
                        }
                        if (fill < 0) {
                            this._connector.getByteBufferPool().release(this._buffer);
                            this.getEndPoint().shutdownOutput();
                            return;
                        }
                        if (fill == 0) {
                            this.fillInterested();
                            return;
                        }
                        this.parseHeader();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Proxy v2 onFillable header parsed, length = {}, buffer = {}", new Object[]{this._length, BufferUtil.toDetailString((ByteBuffer)this._buffer)});
                    }
                    while (this._buffer.remaining() < this._length) {
                        fill = this.getEndPoint().fill(this._buffer);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v2 filled buffer with {} bytes", (long)fill);
                        }
                        if (fill < 0) {
                            this._connector.getByteBufferPool().release(this._buffer);
                            this.getEndPoint().shutdownOutput();
                            return;
                        }
                        if (fill != 0) continue;
                        this.fillInterested();
                        return;
                    }
                    this.parseBodyAndUpgrade();
                    return;
                }
                catch (Throwable x) {
                    void var1_2;
                    LOG.warn("Proxy v2 error for " + this.getEndPoint(), (Throwable)var1_2);
                    this.releaseAndClose();
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            public ByteBuffer onUpgradeFrom() {
                if (this._buffer.hasRemaining()) {
                    void var1_1;
                    ByteBuffer unconsumed = ByteBuffer.allocateDirect(this._buffer.remaining());
                    unconsumed.put(this._buffer);
                    unconsumed.flip();
                    this._connector.getByteBufferPool().release(this._buffer);
                    return var1_1;
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            private void parseBodyAndUpgrade() throws IOException {
                void var2_2;
                int nonProxyRemaining = this._buffer.remaining() - this._length;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 parsing body, length = {}, buffer = {}", new Object[]{this._length, BufferUtil.toHexSummary((ByteBuffer)this._buffer)});
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 body {} from {} for {}", new Object[]{this._next, BufferUtil.toHexSummary((ByteBuffer)this._buffer), this});
                }
                EndPoint endPoint = this.getEndPoint();
                if (!this._local) {
                    char dp;
                    char sp;
                    InetAddress dst;
                    InetAddress src;
                    switch (this._family) {
                        case INET: {
                            byte[] addr = new byte[4];
                            this._buffer.get(addr);
                            src = Inet4Address.getByAddress(addr);
                            this._buffer.get(addr);
                            dst = Inet4Address.getByAddress(addr);
                            sp = this._buffer.getChar();
                            dp = this._buffer.getChar();
                            break;
                        }
                        case INET6: {
                            byte[] addr = new byte[16];
                            this._buffer.get(addr);
                            src = Inet6Address.getByAddress(addr);
                            this._buffer.get(addr);
                            dst = Inet6Address.getByAddress(addr);
                            sp = this._buffer.getChar();
                            dp = this._buffer.getChar();
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    InetSocketAddress remote = new InetSocketAddress(src, (int)sp);
                    InetSocketAddress local = new InetSocketAddress(dst, (int)dp);
                    ProxyEndPoint proxyEndPoint = new ProxyEndPoint(endPoint, remote, local);
                    endPoint = proxyEndPoint;
                    while (this._buffer.remaining() > nonProxyRemaining) {
                        int type = 0xFF & this._buffer.get();
                        int length = this._buffer.getChar();
                        byte[] value = new byte[length];
                        this._buffer.get(value);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("Proxy v2 T=%x L=%d V=%s for %s", new Object[]{type, length, TypeUtil.toHexString((byte[])value), this}), new Object[0]);
                        }
                        switch (type) {
                            case 32: {
                                type = value[0] & 0xFF;
                                switch (type) {
                                    case 1: {
                                        int i = 5;
                                        while (i < length) {
                                            int subType = value[i++] & 0xFF;
                                            int subLength = ((value[i++] & 0xFF) << 8) + (value[i++] & 0xFF);
                                            byte[] subValue = new byte[subLength];
                                            System.arraycopy(value, i, subValue, 0, subLength);
                                            i += subLength;
                                            switch (subType) {
                                                case 33: {
                                                    String tlsVersion = new String(subValue, StandardCharsets.US_ASCII);
                                                    proxyEndPoint.setAttribute(ProxyConnectionFactory.TLS_VERSION, tlsVersion);
                                                }
                                            }
                                        }
                                        break block4;
                                    }
                                }
                            }
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        void var3_8;
                        LOG.debug("Proxy v2 {} {}", new Object[]{this.getEndPoint(), var3_8.toString()});
                    }
                } else {
                    this._buffer.position(this._buffer.position() + this._length);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 parsing dynamic packet part is now done, upgrading to {}", new Object[]{ProxyV2ConnectionFactory.this._nextProtocol});
                }
                DetectorConnectionFactory.upgradeToConnectionFactory(this._next, this._connector, (EndPoint)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            private void parseHeader() throws IOException {
                void var3_5;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 parsing fixed length packet part, buffer = {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)this._buffer)});
                }
                if (this._buffer.remaining() < 16) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 header {} for {}", new Object[]{BufferUtil.toHexSummary((ByteBuffer)this._buffer), this});
                }
                byte[] byArray = SIGNATURE;
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    byte signatureByte = byArray[i];
                    if (this._buffer.get() == signatureByte) continue;
                    throw new IOException("Proxy v2 bad PROXY signature");
                }
                int versionAndCommand = 0xFF & this._buffer.get();
                if ((versionAndCommand & 0xF0) != 32) {
                    throw new IOException("Proxy v2 bad PROXY version");
                }
                this._local = (versionAndCommand & 0xF) == 0;
                int transportAndFamily = 0xFF & this._buffer.get();
                switch (transportAndFamily >> 4) {
                    case 0: {
                        this._family = Family.UNSPEC;
                        break;
                    }
                    case 1: {
                        this._family = Family.INET;
                        break;
                    }
                    case 2: {
                        this._family = Family.INET6;
                        break;
                    }
                    case 3: {
                        this._family = Family.UNIX;
                        break;
                    }
                    default: {
                        throw new IOException("Proxy v2 bad PROXY family");
                    }
                }
                switch (0xF & transportAndFamily) {
                    case 0: {
                        Transport transport = Transport.UNSPEC;
                        break;
                    }
                    case 1: {
                        Transport transport = Transport.STREAM;
                        break;
                    }
                    case 2: {
                        Transport transport = Transport.DGRAM;
                        break;
                    }
                    default: {
                        throw new IOException("Proxy v2 bad PROXY family");
                    }
                }
                this._length = this._buffer.getChar();
                if (!(this._local || this._family != Family.UNSPEC && this._family != Family.UNIX && var3_5 == Transport.STREAM)) {
                    throw new IOException(String.format("Proxy v2 unsupported PROXY mode 0x%x,0x%x", versionAndCommand, transportAndFamily));
                }
                if (this._length > ProxyV2ConnectionFactory.this.getMaxProxyHeader()) {
                    void var1_2;
                    throw new IOException(String.format("Proxy v2 Unsupported PROXY mode 0x%x,0x%x,0x%x", (int)var1_2, n, this._length));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 fixed length packet part is now parsed", new Object[0]);
                }
                this._headerParsed = true;
            }

            private void releaseAndClose() {
                this._connector.getByteBufferPool().release(this._buffer);
                this.close();
            }
        }

        private static enum Transport {
            UNSPEC,
            STREAM,
            DGRAM;

        }

        private static enum Family {
            UNSPEC,
            INET,
            INET6,
            UNIX;

        }
    }

    private static class ProxyV1ConnectionFactory
    extends AbstractConnectionFactory
    implements ConnectionFactory.Detecting {
        private static final byte[] SIGNATURE = "PROXY".getBytes(StandardCharsets.US_ASCII);
        private final String _nextProtocol;

        /*
         * WARNING - void declaration
         */
        private ProxyV1ConnectionFactory(String nextProtocol) {
            super("proxy");
            void var1_1;
            this._nextProtocol = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ConnectionFactory.Detecting.Detection detect(ByteBuffer buffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proxy v1 attempting detection with {} bytes", (long)buffer.remaining());
            }
            if (buffer.remaining() < SIGNATURE.length) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 detection requires more bytes", new Object[0]);
                }
                return ConnectionFactory.Detecting.Detection.NEED_MORE_BYTES;
            }
            for (int i = 0; i < SIGNATURE.length; ++i) {
                void var3_3;
                byte signatureByte = SIGNATURE[i];
                byte by = buffer.get(i);
                if (by == var3_3) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 detection unsuccessful", new Object[0]);
                }
                return ConnectionFactory.Detecting.Detection.NOT_RECOGNIZED;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proxy v1 detection succeeded", new Object[0]);
            }
            return ConnectionFactory.Detecting.Detection.RECOGNIZED;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Connection newConnection(Connector connector, EndPoint endp) {
            void var2_2;
            void var1_1;
            void var3_3;
            ConnectionFactory nextConnectionFactory = ProxyConnectionFactory.access$300(this._nextProtocol, connector, this.getProtocol(), endp);
            return this.configure(new ProxyProtocolV1Connection(endp, connector, (ConnectionFactory)var3_3), (Connector)var1_1, (EndPoint)var2_2);
        }

        private static class ProxyProtocolV1Connection
        extends AbstractConnection
        implements Connection.UpgradeFrom,
        Connection.UpgradeTo {
            private static final int CR_INDEX = 6;
            private static final int LF_INDEX = 7;
            private final Connector _connector;
            private final ConnectionFactory _next;
            private final ByteBuffer _buffer;
            private final StringBuilder _builder = new StringBuilder();
            private final String[] _fields = new String[6];
            private int _index;
            private int _length;

            /*
             * WARNING - void declaration
             */
            private ProxyProtocolV1Connection(EndPoint endp, Connector connector, ConnectionFactory next) {
                super((EndPoint)var1_1, connector.getExecutor());
                void var3_3;
                void var2_2;
                void var1_1;
                this._connector = var2_2;
                this._next = var3_3;
                this._buffer = this._connector.getByteBufferPool().acquire(this.getInputBufferSize(), true);
            }

            /*
             * WARNING - void declaration
             */
            public void onFillable() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 onFillable current index = ", (long)this._index);
                }
                try {
                    while (this._index < 7) {
                        int fill = this.getEndPoint().fill(this._buffer);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v1 filled buffer with {} bytes", (long)fill);
                        }
                        if (fill < 0) {
                            this._connector.getByteBufferPool().release(this._buffer);
                            this.getEndPoint().shutdownOutput();
                            return;
                        }
                        if (fill == 0) {
                            this.fillInterested();
                            return;
                        }
                        if (!this.parse()) continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Proxy v1 onFillable parsing done, now upgrading", new Object[0]);
                    }
                    this.upgrade();
                    return;
                }
                catch (Throwable x) {
                    void var1_2;
                    LOG.warn("Proxy v1 error for {}", new Object[]{this.getEndPoint(), var1_2});
                    this.releaseAndClose();
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onOpen() {
                super.onOpen();
                try {
                    while (this._index < 7) {
                        if (this.parse()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v1 onOpen parsing ran out of bytes, marking as fillInterested", new Object[0]);
                        }
                        this.fillInterested();
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Proxy v1 onOpen parsing done, now upgrading", new Object[0]);
                    }
                    this.upgrade();
                    return;
                }
                catch (Throwable x) {
                    void var1_1;
                    LOG.warn("Proxy v1 error for {}", new Object[]{this.getEndPoint(), var1_1});
                    this.releaseAndClose();
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            public ByteBuffer onUpgradeFrom() {
                if (this._buffer.hasRemaining()) {
                    void var1_1;
                    ByteBuffer unconsumed = ByteBuffer.allocateDirect(this._buffer.remaining());
                    unconsumed.put(this._buffer);
                    unconsumed.flip();
                    this._connector.getByteBufferPool().release(this._buffer);
                    return var1_1;
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public void onUpgradeTo(ByteBuffer buffer) {
                void var1_1;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 copying unconsumed buffer {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)buffer)});
                }
                BufferUtil.append((ByteBuffer)this._buffer, (ByteBuffer)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            private boolean parse() throws IOException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 parsing {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)this._buffer)});
                }
                this._length += this._buffer.remaining();
                while (this._buffer.hasRemaining()) {
                    void var1_1;
                    byte b = this._buffer.get();
                    if (this._index < 6) {
                        if (b == 32 || b == 13) {
                            this._fields[this._index++] = this._builder.toString();
                            this._builder.setLength(0);
                            if (b != 13) continue;
                            this._index = 6;
                            continue;
                        }
                        if (b < 32) {
                            throw new IOException("Proxy v1 bad character " + (b & 0xFF));
                        }
                        this._builder.append((char)b);
                        continue;
                    }
                    if (b == 10) {
                        this._index = 7;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v1 parsing is done", new Object[0]);
                        }
                        return true;
                    }
                    throw new IOException("Proxy v1 bad CRLF " + (var1_1 & 0xFF));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 parsing requires more bytes", new Object[0]);
                }
                return false;
            }

            private void releaseAndClose() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 releasing buffer and closing", new Object[0]);
                }
                this._connector.getByteBufferPool().release(this._buffer);
                this.close();
            }

            /*
             * WARNING - void declaration
             */
            private void upgrade() {
                void var1_2;
                void var2_3;
                void var3_4;
                int proxyLineLength = this._length - this._buffer.remaining();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 pre-upgrade packet length (including CRLF) is {}", (long)proxyLineLength);
                }
                if (proxyLineLength >= 110) {
                    LOG.warn("Proxy v1 PROXY line too long {} for {}", new Object[]{proxyLineLength, this.getEndPoint()});
                    this.releaseAndClose();
                    return;
                }
                if (!"PROXY".equals(this._fields[0])) {
                    LOG.warn("Proxy v1 not PROXY protocol for {}", new Object[]{this.getEndPoint()});
                    this.releaseAndClose();
                    return;
                }
                String srcIP = this._fields[2];
                String srcPort = this._fields[4];
                String dstIP = this._fields[3];
                String dstPort = this._fields[5];
                boolean bl = "UNKNOWN".equalsIgnoreCase(this._fields[1]);
                if (bl) {
                    srcIP = this.getEndPoint().getRemoteAddress().getAddress().getHostAddress();
                    srcPort = String.valueOf(this.getEndPoint().getRemoteAddress().getPort());
                    dstIP = this.getEndPoint().getLocalAddress().getAddress().getHostAddress();
                    dstPort = String.valueOf(this.getEndPoint().getLocalAddress().getPort());
                }
                InetSocketAddress remote = new InetSocketAddress(srcIP, Integer.parseInt(srcPort));
                InetSocketAddress local = new InetSocketAddress((String)var3_4, Integer.parseInt(dstPort));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 next protocol '{}' for {} r={} l={}", new Object[]{this._next, this.getEndPoint(), remote, local});
                }
                ProxyEndPoint endPoint = new ProxyEndPoint(this.getEndPoint(), remote, (InetSocketAddress)var2_3);
                DetectorConnectionFactory.upgradeToConnectionFactory(this._next, this._connector, (EndPoint)var1_2);
            }
        }
    }
}

