/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.SslConnectionFactory;

public abstract class NegotiatingServerConnectionFactory
extends AbstractConnectionFactory {
    private final List<String> negotiatedProtocols = new ArrayList<String>();
    private String defaultProtocol;

    /*
     * WARNING - void declaration
     */
    public NegotiatingServerConnectionFactory(String protocol, String ... negotiatedProtocols) {
        super((String)var1_1);
        void var1_1;
        if (negotiatedProtocols != null) {
            void var2_2;
            for (void var4_5 : var2_2) {
                String p = var4_5.trim();
                if (p.isEmpty()) continue;
                this.negotiatedProtocols.add(p);
            }
        }
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultProtocol(String defaultProtocol) {
        void var1_1;
        String dft = defaultProtocol == null ? "" : defaultProtocol.trim();
        this.defaultProtocol = dft.isEmpty() ? null : var1_1;
    }

    public List<String> getNegotiatedProtocols() {
        return this.negotiatedProtocols;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        void var2_2;
        void var1_1;
        void var3_3;
        String dft;
        List<String> negotiated = this.negotiatedProtocols;
        if (negotiated.isEmpty()) {
            negotiated = connector.getProtocols().stream().filter(p -> {
                ConnectionFactory connectionFactory;
                void var1_1;
                ConnectionFactory f = connector.getConnectionFactory((String)var1_1);
                return !(f instanceof SslConnectionFactory) && !(connectionFactory instanceof NegotiatingServerConnectionFactory);
            }).collect(Collectors.toList());
        }
        if ((dft = this.defaultProtocol) == null && !negotiated.isEmpty()) {
            dft = negotiated.stream().filter(arg_0 -> ((HttpVersion)HttpVersion.HTTP_1_1).is(arg_0)).findFirst().orElse(negotiated.get(0));
        }
        SSLEngine engine = null;
        EndPoint ep = endPoint;
        while (engine == null && ep != null) {
            if (ep instanceof SslConnection.DecryptedEndPoint) {
                engine = ((SslConnection.DecryptedEndPoint)ep).getSslConnection().getSSLEngine();
                continue;
            }
            ep = null;
        }
        NegotiatingServerConnectionFactory negotiatingServerConnectionFactory = this;
        return negotiatingServerConnectionFactory.configure(negotiatingServerConnectionFactory.newServerConnection(connector, endPoint, engine, (List<String>)var3_3, dft), (Connector)var1_1, (EndPoint)var2_2);
    }

    protected abstract AbstractConnection newServerConnection(Connector var1, EndPoint var2, SSLEngine var3, List<String> var4, String var5);

    @Override
    public String toString() {
        return String.format("%s@%x{%s,%s,%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocols(), this.getDefaultProtocol(), this.getNegotiatedProtocols());
    }
}

