/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class NegotiatingServerConnection
extends AbstractConnection {
    private static final Logger LOG = Log.getLogger(NegotiatingServerConnection.class);
    private final Connector connector;
    private final SSLEngine engine;
    private final List<String> protocols;
    private final String defaultProtocol;
    private String protocol;

    /*
     * WARNING - void declaration
     */
    protected NegotiatingServerConnection(Connector connector, EndPoint endPoint, SSLEngine engine, List<String> protocols, String defaultProtocol) {
        super((EndPoint)var2_2, connector.getExecutor());
        void var3_3;
        void var1_1;
        void var2_2;
        this.connector = var1_1;
        this.protocols = protocols;
        this.defaultProtocol = defaultProtocol;
        this.engine = var3_3;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public SSLEngine getSSLEngine() {
        return this.engine;
    }

    public String getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - void declaration
     */
    protected void setProtocol(String protocol) {
        void var1_1;
        this.protocol = var1_1;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    /*
     * WARNING - void declaration
     */
    public void onFillable() {
        int filled = this.fill();
        if (filled == 0) {
            if (this.protocol == null) {
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} could not negotiate protocol, SSLEngine: {}", new Object[]{this, this.engine});
                    }
                    this.close();
                    return;
                }
                this.fillInterested();
                return;
            }
            ConnectionFactory connectionFactory = this.connector.getConnectionFactory(this.protocol);
            if (connectionFactory != null) {
                void var1_2;
                void var2_3;
                EndPoint endPoint = this.getEndPoint();
                Connection newConnection = connectionFactory.newConnection(this.connector, endPoint);
                var2_3.upgrade((Connection)var1_2);
                return;
            }
        } else {
            void var1_1;
            if (var1_1 < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} detected close on client side", new Object[]{this});
                }
                this.close();
                return;
            }
            throw new IllegalStateException();
        }
        LOG.info("{} application selected protocol '{}', but no correspondent {} has been configured", new Object[]{this, this.protocol, ConnectionFactory.class.getName()});
        this.close();
    }

    /*
     * WARNING - void declaration
     */
    private int fill() {
        try {
            return this.getEndPoint().fill(BufferUtil.EMPTY_BUFFER);
        }
        catch (IOException x) {
            void var1_1;
            LOG.debug((Throwable)var1_1);
            this.close();
            return -1;
        }
    }

    public void close() {
        this.getEndPoint().shutdownOutput();
        super.close();
    }

    public static interface CipherDiscriminator {
        public boolean isAcceptable(String var1, String var2, String var3);
    }
}

