/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.MultiPartFormInputStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.MultiPartInputStreamParser;

public interface MultiParts
extends Closeable {
    public Collection<Part> getParts() throws IOException;

    public Part getPart(String var1) throws IOException;

    public boolean isEmpty();

    public ContextHandler.Context getContext();

    public static class MultiPartsUtilParser
    implements MultiParts {
        private final MultiPartInputStreamParser _utilParser;
        private final ContextHandler.Context _context;
        private final Request _request;

        /*
         * WARNING - void declaration
         */
        public MultiPartsUtilParser(InputStream in, String contentType, MultipartConfigElement config, File contextTmpDir, Request request) throws IOException {
            this((InputStream)var1_1, (String)var2_2, (MultipartConfigElement)var3_3, contextTmpDir, request, 1000);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public MultiPartsUtilParser(InputStream in, String contentType, MultipartConfigElement config, File contextTmpDir, Request request, int maxParts) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            this._utilParser = new MultiPartInputStreamParser((InputStream)var1_1, (String)var2_2, (MultipartConfigElement)var3_3, contextTmpDir, maxParts);
            this._context = request.getContext();
            this._request = request;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<Part> getParts() throws IOException {
            void var1_1;
            Collection parts = this._utilParser.getParts();
            this.setNonComplianceViolationsOnRequest();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Part getPart(String name) throws IOException {
            void var1_1;
            Part part = this._utilParser.getPart(name);
            this.setNonComplianceViolationsOnRequest();
            return var1_1;
        }

        @Override
        public void close() {
            this._utilParser.deleteParts();
        }

        @Override
        public boolean isEmpty() {
            return this._utilParser.getParsedParts().isEmpty();
        }

        @Override
        public ContextHandler.Context getContext() {
            return this._context;
        }

        /*
         * WARNING - void declaration
         */
        private void setNonComplianceViolationsOnRequest() {
            Iterator iterator;
            List list = (List)this._request.getAttribute("org.eclipse.jetty.http.compliance.violations");
            if (list != null) {
                return;
            }
            EnumSet nonComplianceWarnings = this._utilParser.getNonComplianceWarnings();
            ArrayList<String> violations = new ArrayList<String>();
            iterator = ((AbstractCollection)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                void var3_3;
                MultiPartInputStreamParser.NonCompliance nc = (MultiPartInputStreamParser.NonCompliance)iterator.next();
                violations.add(nc.name() + ": " + var3_3.getURL());
            }
            this._request.setAttribute("org.eclipse.jetty.http.compliance.violations", list);
        }
    }

    public static class MultiPartsHttpParser
    implements MultiParts {
        private final MultiPartFormInputStream _httpParser;
        private final ContextHandler.Context _context;
        private final Request _request;

        /*
         * WARNING - void declaration
         */
        public MultiPartsHttpParser(InputStream in, String contentType, MultipartConfigElement config, File contextTmpDir, Request request) throws IOException {
            this((InputStream)var1_1, (String)var2_2, (MultipartConfigElement)var3_3, contextTmpDir, request, 1000);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public MultiPartsHttpParser(InputStream in, String contentType, MultipartConfigElement config, File contextTmpDir, Request request, int maxParts) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            this._httpParser = new MultiPartFormInputStream((InputStream)var1_1, (String)var2_2, (MultipartConfigElement)var3_3, contextTmpDir, maxParts);
            this._context = request.getContext();
            this._request = request;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<Part> getParts() throws IOException {
            void var1_1;
            Collection parts = this._httpParser.getParts();
            this.setNonComplianceViolationsOnRequest();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Part getPart(String name) throws IOException {
            void var1_1;
            Part part = this._httpParser.getPart(name);
            this.setNonComplianceViolationsOnRequest();
            return var1_1;
        }

        @Override
        public void close() {
            this._httpParser.deleteParts();
        }

        @Override
        public boolean isEmpty() {
            return this._httpParser.isEmpty();
        }

        @Override
        public ContextHandler.Context getContext() {
            return this._context;
        }

        /*
         * WARNING - void declaration
         */
        private void setNonComplianceViolationsOnRequest() {
            Iterator iterator;
            List list = (List)this._request.getAttribute("org.eclipse.jetty.http.compliance.violations");
            if (list != null) {
                return;
            }
            EnumSet nonComplianceWarnings = this._httpParser.getNonComplianceWarnings();
            ArrayList<String> violations = new ArrayList<String>();
            iterator = ((AbstractCollection)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                void var3_3;
                MultiPartFormInputStream.NonCompliance nc = (MultiPartFormInputStream.NonCompliance)iterator.next();
                violations.add(nc.name() + ": " + var3_3.getURL());
            }
            this._request.setAttribute("org.eclipse.jetty.http.compliance.violations", list);
        }
    }
}

