/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

@ManagedObject(value="Monitor for low resource conditions and activate a low resource mode if detected")
public class LowResourceMonitor
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(LowResourceMonitor.class);
    protected final Server _server;
    private Scheduler _scheduler;
    private Connector[] _monitoredConnectors;
    private Set<AbstractConnector> _acceptingConnectors = new HashSet<AbstractConnector>();
    private int _period = 1000;
    private int _lowResourcesIdleTimeout = 1000;
    private int _maxLowResourcesTime = 0;
    private final AtomicBoolean _low = new AtomicBoolean();
    private String _reasons;
    private long _lowStarted;
    private boolean _acceptingInLowResources = true;
    private Set<LowResourceCheck> _lowResourceChecks = new HashSet<LowResourceCheck>();
    private final Runnable _monitor = new Runnable(this){
        final /* synthetic */ LowResourceMonitor this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            if (this.this$0.isRunning()) {
                this.this$0.monitor();
                this.this$0._scheduler.schedule(this.this$0._monitor, (long)this.this$0._period, TimeUnit.MILLISECONDS);
            }
        }
    };

    /*
     * WARNING - void declaration
     */
    public LowResourceMonitor(@Name(value="server") Server server) {
        void var1_1;
        this._server = var1_1;
    }

    @ManagedAttribute(value="True if low available threads status is monitored")
    public boolean getMonitorThreads() {
        return !this.getBeans(ConnectorsThreadPoolLowResourceCheck.class).isEmpty();
    }

    public void setMonitorThreads(boolean monitorThreads) {
        if (monitorThreads) {
            if (!this.getMonitorThreads()) {
                this.addLowResourceCheck(new ConnectorsThreadPoolLowResourceCheck(this));
                return;
            }
            this.getBeans(ConnectorsThreadPoolLowResourceCheck.class).forEach(arg_0 -> ((LowResourceMonitor)this).removeBean(arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManagedAttribute(value="The maximum connections allowed for the monitored connectors before low resource handling is activated")
    @Deprecated
    public int getMaxConnections() {
        for (MaxConnectionsLowResourceCheck lowResourceCheck : this.getBeans(MaxConnectionsLowResourceCheck.class)) {
            void var2_2;
            if (lowResourceCheck.getMaxConnections() <= 0) continue;
            return var2_2.getMaxConnections();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setMaxConnections(int maxConnections) {
        if (maxConnections > 0) {
            void var1_1;
            if (this.getBeans(MaxConnectionsLowResourceCheck.class).isEmpty()) {
                this.addLowResourceCheck(new MaxConnectionsLowResourceCheck(this, maxConnections));
                return;
            }
            this.getBeans(MaxConnectionsLowResourceCheck.class).forEach(arg_0 -> LowResourceMonitor.lambda$setMaxConnections$0((int)var1_1, arg_0));
            return;
        }
        this.getBeans(ConnectorsThreadPoolLowResourceCheck.class).forEach(arg_0 -> ((LowResourceMonitor)this).removeBean(arg_0));
    }

    @ManagedAttribute(value="The reasons the monitored connectors are low on resources")
    public String getReasons() {
        return this._reasons;
    }

    /*
     * WARNING - void declaration
     */
    protected void setReasons(String reasons) {
        void var1_1;
        this._reasons = var1_1;
    }

    @ManagedAttribute(value="Are the monitored connectors low on resources?")
    public boolean isLowOnResources() {
        return this._low.get();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean enableLowOnResources(boolean expectedValue, boolean newValue) {
        void var2_2;
        void var1_1;
        return this._low.compareAndSet((boolean)var1_1, (boolean)var2_2);
    }

    @ManagedAttribute(value="The reason(s) the monitored connectors are low on resources")
    public String getLowResourcesReasons() {
        return this._reasons;
    }

    /*
     * WARNING - void declaration
     */
    protected void setLowResourcesReasons(String reasons) {
        void var1_1;
        this._reasons = var1_1;
    }

    @ManagedAttribute(value="Get the timestamp in ms since epoch that low resources state started")
    public long getLowResourcesStarted() {
        return this._lowStarted;
    }

    /*
     * WARNING - void declaration
     */
    public void setLowResourcesStarted(long lowStarted) {
        void var1_1;
        this._lowStarted = var1_1;
    }

    @ManagedAttribute(value="The monitored connectors. If null then all server connectors are monitored")
    public Collection<Connector> getMonitoredConnectors() {
        if (this._monitoredConnectors == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this._monitoredConnectors);
    }

    /*
     * WARNING - void declaration
     */
    public void setMonitoredConnectors(Collection<Connector> monitoredConnectors) {
        void var1_1;
        if (monitoredConnectors == null || monitoredConnectors.size() == 0) {
            this._monitoredConnectors = null;
            return;
        }
        void v0 = var1_1;
        this._monitoredConnectors = v0.toArray(new Connector[v0.size()]);
    }

    protected Connector[] getMonitoredOrServerConnectors() {
        if (this._monitoredConnectors != null && this._monitoredConnectors.length > 0) {
            return this._monitoredConnectors;
        }
        return this._server.getConnectors();
    }

    @ManagedAttribute(value="If false, new connections are not accepted while in low resources")
    public boolean isAcceptingInLowResources() {
        return this._acceptingInLowResources;
    }

    /*
     * WARNING - void declaration
     */
    public void setAcceptingInLowResources(boolean acceptingInLowResources) {
        void var1_1;
        this._acceptingInLowResources = var1_1;
    }

    @ManagedAttribute(value="The monitor period in ms")
    public int getPeriod() {
        return this._period;
    }

    /*
     * WARNING - void declaration
     */
    public void setPeriod(int periodMS) {
        void var1_1;
        this._period = var1_1;
    }

    @ManagedAttribute(value="The idletimeout in ms to apply to all existing connections when low resources is detected")
    public int getLowResourcesIdleTimeout() {
        return this._lowResourcesIdleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setLowResourcesIdleTimeout(int lowResourcesIdleTimeoutMS) {
        void var1_1;
        this._lowResourcesIdleTimeout = var1_1;
    }

    @ManagedAttribute(value="The maximum time in ms that low resources condition can persist before lowResourcesIdleTimeout is applied to new connections as well as existing connections")
    public int getMaxLowResourcesTime() {
        return this._maxLowResourcesTime;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxLowResourcesTime(int maxLowResourcesTimeMS) {
        void var1_1;
        this._maxLowResourcesTime = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @ManagedAttribute(value="The maximum memory (in bytes) that can be used before low resources is triggered.  Memory used is calculated as (totalMemory-freeMemory).")
    public long getMaxMemory() {
        void var1_1;
        Collection beans = this.getBeans(MemoryLowResourceCheck.class);
        if (beans.isEmpty()) {
            return 0L;
        }
        return ((MemoryLowResourceCheck)var1_1.stream().findFirst().get()).getMaxMemory();
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxMemory(long maxMemoryBytes) {
        void var1_1;
        void var3_2;
        if (maxMemoryBytes <= 0L) {
            return;
        }
        Collection beans = this.getBeans(MemoryLowResourceCheck.class);
        if (beans.isEmpty()) {
            this.addLowResourceCheck(new MemoryLowResourceCheck(this, maxMemoryBytes));
            return;
        }
        var3_2.forEach(arg_0 -> LowResourceMonitor.lambda$setMaxMemory$1((long)var1_1, arg_0));
    }

    public Set<LowResourceCheck> getLowResourceChecks() {
        return this._lowResourceChecks;
    }

    /*
     * WARNING - void declaration
     */
    public void setLowResourceChecks(Set<LowResourceCheck> lowResourceChecks) {
        void var1_1;
        LowResourceMonitor lowResourceMonitor = this;
        lowResourceMonitor.updateBeans(lowResourceMonitor._lowResourceChecks.toArray(), lowResourceChecks.toArray());
        this._lowResourceChecks = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addLowResourceCheck(LowResourceCheck lowResourceCheck) {
        void var1_1;
        this.addBean(lowResourceCheck);
        this._lowResourceChecks.add((LowResourceCheck)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void monitor() {
        String reasons = null;
        for (LowResourceCheck lowResourceCheck : this._lowResourceChecks) {
            void var3_3;
            if (!lowResourceCheck.isLowOnResources()) continue;
            reasons = var3_3.toString();
            break;
        }
        if (reasons != null) {
            if (!reasons.equals(this.getReasons())) {
                LOG.warn("Low Resources: {}", new Object[]{reasons});
                this.setReasons(reasons);
            }
            if (this.enableLowOnResources(false, true)) {
                void var1_1;
                this.setLowResourcesReasons((String)var1_1);
                this.setLowResourcesStarted(System.currentTimeMillis());
                this.setLowResources();
            }
            if (this.getMaxLowResourcesTime() > 0 && System.currentTimeMillis() - this.getLowResourcesStarted() > (long)this.getMaxLowResourcesTime()) {
                this.setLowResources();
                return;
            }
        } else if (this.enableLowOnResources(true, false)) {
            LOG.info("Low Resources cleared", new Object[0]);
            this.setLowResourcesReasons(null);
            this.setLowResourcesStarted(0L);
            this.setReasons(null);
            this.clearLowResources();
        }
    }

    protected void doStart() throws Exception {
        this._scheduler = (Scheduler)this._server.getBean(Scheduler.class);
        if (this._scheduler == null) {
            this._scheduler = new LRMScheduler();
            this._scheduler.start();
        }
        super.doStart();
        this._scheduler.schedule(this._monitor, (long)this._period, TimeUnit.MILLISECONDS);
    }

    protected void doStop() throws Exception {
        if (this._scheduler instanceof LRMScheduler) {
            this._scheduler.stop();
        }
        super.doStop();
    }

    protected void setLowResources() {
        for (Connector connector : this.getMonitoredOrServerConnectors()) {
            if (connector instanceof AbstractConnector) {
                AbstractConnector c = (AbstractConnector)connector;
                if (!this.isAcceptingInLowResources() && c.isAccepting()) {
                    this._acceptingConnectors.add(c);
                    c.setAccepting(false);
                }
            }
            for (EndPoint endPoint : connector.getConnectedEndPoints()) {
                endPoint.setIdleTimeout((long)this._lowResourcesIdleTimeout);
            }
        }
    }

    protected void clearLowResources() {
        for (Connector connector : this.getMonitoredOrServerConnectors()) {
            for (EndPoint endPoint : connector.getConnectedEndPoints()) {
                endPoint.setIdleTimeout(connector.getIdleTimeout());
            }
        }
        for (AbstractConnector abstractConnector : this._acceptingConnectors) {
            abstractConnector.setAccepting(true);
        }
        this._acceptingConnectors.clear();
    }

    /*
     * WARNING - void declaration
     */
    protected String low(String reasons, String newReason) {
        void var2_2;
        void var1_1;
        if (reasons == null) {
            return newReason;
        }
        return (String)var1_1 + ", " + (String)var2_2;
    }

    private static /* synthetic */ void lambda$setMaxMemory$1(long maxMemoryBytes, MemoryLowResourceCheck lowResourceCheck) {
        long l;
        lowResourceCheck.setMaxMemory(l);
    }

    private static /* synthetic */ void lambda$setMaxConnections$0(int maxConnections, MaxConnectionsLowResourceCheck c) {
        int n;
        c.setMaxConnections(n);
    }

    public class MemoryLowResourceCheck
    implements LowResourceCheck {
        private String reason;
        private long maxMemory;
        final /* synthetic */ LowResourceMonitor this$0;

        /*
         * WARNING - void declaration
         */
        public MemoryLowResourceCheck(LowResourceMonitor this$0, long maxMemory) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.maxMemory = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isLowOnResources() {
            long memory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            if (this.maxMemory > 0L && memory > this.maxMemory) {
                void var1_1;
                this.reason = "Max memory exceeded: " + (long)var1_1 + ">" + this.maxMemory;
                return true;
            }
            return false;
        }

        public long getMaxMemory() {
            return this.maxMemory;
        }

        /*
         * WARNING - void declaration
         */
        public void setMaxMemory(long maxMemoryBytes) {
            void var1_1;
            this.maxMemory = var1_1;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return "Check if used memory is higher than the allowed max memory";
        }
    }

    @ManagedObject(value="Check max allowed connections on connectors")
    public class MaxConnectionsLowResourceCheck
    implements LowResourceCheck {
        private String reason;
        private int maxConnections;
        final /* synthetic */ LowResourceMonitor this$0;

        /*
         * WARNING - void declaration
         */
        public MaxConnectionsLowResourceCheck(LowResourceMonitor this$0, int maxConnections) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.maxConnections = var2_2;
        }

        @ManagedAttribute(value="The maximum connections allowed for the monitored connectors before low resource handling is activated")
        @Deprecated
        public int getMaxConnections() {
            return this.maxConnections;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public void setMaxConnections(int maxConnections) {
            void var1_1;
            if (maxConnections > 0) {
                LOG.warn("LowResourceMonitor.setMaxConnections is deprecated. Use ConnectionLimit.", new Object[0]);
            }
            this.maxConnections = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isLowOnResources() {
            int connections = 0;
            for (Connector connector : this.this$0.getMonitoredConnectors()) {
                void var3_3;
                connections += var3_3.getConnectedEndPoints().size();
            }
            if (this.maxConnections > 0 && connections > this.maxConnections) {
                void var1_1;
                this.reason = "Max Connections exceeded: " + (int)var1_1 + ">" + this.maxConnections;
                return true;
            }
            return false;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return "All connections number is higher than the allowed maxConnection";
        }
    }

    public class ConnectorsThreadPoolLowResourceCheck
    implements LowResourceCheck {
        private String reason;
        final /* synthetic */ LowResourceMonitor this$0;

        /*
         * WARNING - void declaration
         */
        public ConnectorsThreadPoolLowResourceCheck(LowResourceMonitor this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public boolean isLowOnResources() {
            ThreadPool serverThreads = this.this$0._server.getThreadPool();
            if (serverThreads.isLowOnThreads()) {
                this.reason = "Server low on threads: " + serverThreads.getThreads() + ", idleThreads:" + serverThreads.getIdleThreads();
                return true;
            }
            for (Connector connector : this.this$0.getMonitoredConnectors()) {
                ThreadPool connectorThreads;
                Executor executor = connector.getExecutor();
                if (!(executor instanceof ThreadPool) || executor == serverThreads || !(connectorThreads = (ThreadPool)executor).isLowOnThreads()) continue;
                this.reason = "Connector low on threads: " + connector;
                return true;
            }
            return false;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return "Check if the ThreadPool from monitored connectors are lowOnThreads and if all connections number is higher than the allowed maxConnection";
        }
    }

    public class MainThreadPoolLowResourceCheck
    implements LowResourceCheck {
        private String reason;
        final /* synthetic */ LowResourceMonitor this$0;

        /*
         * WARNING - void declaration
         */
        public MainThreadPoolLowResourceCheck(LowResourceMonitor this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isLowOnResources() {
            ThreadPool serverThreads = this.this$0._server.getThreadPool();
            if (serverThreads.isLowOnThreads()) {
                void var1_1;
                this.reason = "Server low on threads: " + var1_1;
                return true;
            }
            return false;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return "Check if the server ThreadPool is lowOnThreads";
        }
    }

    public static interface LowResourceCheck {
        public boolean isLowOnResources();

        public String getReason();
    }

    private static class LRMScheduler
    extends ScheduledExecutorScheduler {
        private LRMScheduler() {
        }
    }
}

