/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

public class LocalConnector
extends AbstractConnector {
    private final BlockingQueue<LocalEndPoint> _connects = new LinkedBlockingQueue<LocalEndPoint>();

    /*
     * WARNING - void declaration
     */
    public LocalConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, ConnectionFactory ... factories) {
        super((Server)var1_1, (Executor)var2_2, (Scheduler)var3_3, pool, acceptors, factories);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setIdleTimeout(30000L);
    }

    /*
     * WARNING - void declaration
     */
    public LocalConnector(Server server) {
        this((Server)var1_1, null, null, null, -1, new HttpConnectionFactory());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalConnector(Server server, SslContextFactory sslContextFactory) {
        this((Server)var1_1, null, null, null, -1, AbstractConnectionFactory.getFactories((SslContextFactory)var2_2, new HttpConnectionFactory()));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalConnector(Server server, ConnectionFactory connectionFactory) {
        this((Server)var1_1, null, null, null, -1, new ConnectionFactory[]{var2_2});
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalConnector(Server server, ConnectionFactory connectionFactory, SslContextFactory sslContextFactory) {
        this((Server)var1_1, null, null, null, -1, AbstractConnectionFactory.getFactories((SslContextFactory)var3_3, new ConnectionFactory[]{var2_2}));
        void var2_2;
        void var3_3;
        void var1_1;
    }

    @Override
    public Object getTransport() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String getResponses(String requests) throws Exception {
        void var1_1;
        return this.getResponses((String)var1_1, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String getResponses(String requests, long idleFor, TimeUnit units) throws Exception {
        void var1_1;
        void var2_2;
        ByteBuffer result = this.getResponses(BufferUtil.toBuffer((String)requests, (Charset)StandardCharsets.UTF_8), (long)var2_2, units);
        if (result == null) {
            return null;
        }
        return BufferUtil.toString((ByteBuffer)var1_1, (Charset)StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ByteBuffer getResponses(ByteBuffer requestsBuffer) throws Exception {
        void var1_1;
        return this.getResponses((ByteBuffer)var1_1, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ByteBuffer getResponses(ByteBuffer requestsBuffer, long idleFor, TimeUnit units) throws Exception {
        void var2_3;
        if (LOG.isDebugEnabled()) {
            LOG.debug("requests {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)requestsBuffer)});
        }
        LocalEndPoint endp = this.executeRequest(requestsBuffer);
        endp.waitUntilClosedOrIdleFor(idleFor, units);
        ByteBuffer responses = endp.takeOutput();
        if (endp.isOutputShutdown()) {
            void var1_1;
            var1_1.close();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("responses {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)responses)});
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public LocalEndPoint executeRequest(String rawRequest) {
        void var1_1;
        return this.executeRequest(BufferUtil.toBuffer((String)var1_1, (Charset)StandardCharsets.UTF_8));
    }

    /*
     * WARNING - void declaration
     */
    private LocalEndPoint executeRequest(ByteBuffer rawRequest) {
        void var2_2;
        void var1_1;
        if (!this.isStarted()) {
            throw new IllegalStateException("!STARTED");
        }
        LocalEndPoint endp = new LocalEndPoint();
        endp.addInput((ByteBuffer)var1_1);
        this._connects.add(endp);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public LocalEndPoint connect() {
        void var1_1;
        LocalEndPoint endp = new LocalEndPoint();
        this._connects.add(endp);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void accept(int acceptorID) throws IOException, InterruptedException {
        void var2_3;
        void var1_2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("accepting {}", (long)acceptorID);
        }
        LocalEndPoint endPoint = this._connects.take();
        Connection connection = this.getDefaultConnectionFactory().newConnection(this, (EndPoint)endPoint);
        endPoint.setConnection(connection);
        endPoint.onOpen();
        this.onEndPointOpened((EndPoint)var1_2);
        var2_3.onOpen();
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer getResponse(ByteBuffer requestsBuffer) throws Exception {
        void var1_1;
        return this.getResponse((ByteBuffer)var1_1, false, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer getResponse(ByteBuffer requestBuffer, long time, TimeUnit unit) throws Exception {
        void var2_2;
        LocalEndPoint localEndPoint;
        boolean head = BufferUtil.toString((ByteBuffer)requestBuffer).toLowerCase().startsWith("head ");
        if (LOG.isDebugEnabled()) {
            LOG.debug("requests {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)requestBuffer)});
        }
        localEndPoint = this.executeRequest((ByteBuffer)((Object)localEndPoint));
        return localEndPoint.waitForResponse(head, (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer getResponse(ByteBuffer requestBuffer, boolean head, long time, TimeUnit unit) throws Exception {
        void var3_3;
        void var2_2;
        LocalEndPoint localEndPoint;
        if (LOG.isDebugEnabled()) {
            LOG.debug("requests {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)requestBuffer)});
        }
        localEndPoint = this.executeRequest((ByteBuffer)((Object)localEndPoint));
        return localEndPoint.waitForResponse((boolean)var2_2, (long)var3_3, unit);
    }

    /*
     * WARNING - void declaration
     */
    public String getResponse(String rawRequest) throws Exception {
        void var1_1;
        return this.getResponse((String)var1_1, false, 30L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public String getResponse(String rawRequest, long time, TimeUnit unit) throws Exception {
        void var2_2;
        LocalEndPoint localEndPoint;
        boolean head = rawRequest.toLowerCase().startsWith("head ");
        ByteBuffer requestsBuffer = BufferUtil.toBuffer((String)rawRequest, (Charset)StandardCharsets.ISO_8859_1);
        if (LOG.isDebugEnabled()) {
            LOG.debug("request {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)requestsBuffer)});
        }
        localEndPoint = this.executeRequest((ByteBuffer)((Object)localEndPoint));
        return BufferUtil.toString((ByteBuffer)localEndPoint.waitForResponse(head, (long)var2_2, unit), (Charset)StandardCharsets.ISO_8859_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getResponse(String rawRequest, boolean head, long time, TimeUnit unit) throws Exception {
        void var3_3;
        void var2_2;
        LocalEndPoint localEndPoint;
        ByteBuffer requestsBuffer = BufferUtil.toBuffer((String)rawRequest, (Charset)StandardCharsets.ISO_8859_1);
        if (LOG.isDebugEnabled()) {
            LOG.debug("request {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)requestsBuffer)});
        }
        localEndPoint = this.executeRequest((ByteBuffer)((Object)localEndPoint));
        return BufferUtil.toString((ByteBuffer)localEndPoint.waitForResponse((boolean)var2_2, (long)var3_3, unit), (Charset)StandardCharsets.ISO_8859_1);
    }

    public class LocalEndPoint
    extends ByteArrayEndPoint {
        private final CountDownLatch _closed;
        private ByteBuffer _responseData;

        /*
         * WARNING - void declaration
         */
        public LocalEndPoint() {
            void var1_1;
            super(LocalConnector.this.getScheduler(), var1_1.getIdleTimeout());
            this._closed = new CountDownLatch(1);
            this.setGrowOutput(true);
        }

        /*
         * WARNING - void declaration
         */
        protected void execute(Runnable task) {
            void var1_1;
            LocalConnector.this.getExecutor().execute((Runnable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void onClose() {
            Connection connection = this.getConnection();
            if (connection != null) {
                void var1_1;
                var1_1.onClose();
            }
            LocalConnector.this.onEndPointClosed((EndPoint)this);
            super.onClose();
            this._closed.countDown();
        }

        public void doShutdownOutput() {
            super.shutdownOutput();
            this.close();
        }

        /*
         * WARNING - void declaration
         */
        public void waitUntilClosed() {
            while (this.isOpen()) {
                try {
                    if (this._closed.await(10L, TimeUnit.SECONDS)) continue;
                    return;
                }
                catch (Exception e) {
                    void var1_1;
                    AbstractConnector.LOG.warn((Throwable)var1_1);
                }
            }
        }

        public void waitUntilClosedOrIdleFor(long idleFor, TimeUnit units) {
            Thread.yield();
            int size = this.getOutput().remaining();
            while (this.isOpen()) {
                try {
                    if (this._closed.await(idleFor, units)) continue;
                    if (size == this.getOutput().remaining()) {
                        if (AbstractConnector.LOG.isDebugEnabled()) {
                            AbstractConnector.LOG.debug("idle for {} {}", new Object[]{idleFor, units});
                        }
                        return;
                    }
                    size = this.getOutput().remaining();
                }
                catch (Exception e) {
                    AbstractConnector.LOG.warn((Throwable)e);
                }
            }
        }

        public ByteBuffer getResponseData() {
            return this._responseData;
        }

        public String getResponse() throws Exception {
            return this.getResponse(false, 30L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - void declaration
         */
        public String getResponse(boolean head, long time, TimeUnit unit) throws Exception {
            void var2_3;
            ByteBuffer response = this.waitForResponse(head, (long)var2_3, unit);
            if (response != null) {
                void var1_2;
                return BufferUtil.toString((ByteBuffer)var1_2);
            }
            return null;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ByteBuffer waitForResponse(boolean head, long time, TimeUnit unit) throws Exception {
            block14: {
                block15: {
                    handler = new HttpParser.ResponseHandler(this){
                        final /* synthetic */ LocalEndPoint this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                        }

                        public void parsedHeader(HttpField field) {
                        }

                        public boolean contentComplete() {
                            return false;
                        }

                        public boolean messageComplete() {
                            return true;
                        }

                        public boolean headerComplete() {
                            return false;
                        }

                        public int getHeaderCacheSize() {
                            return 0;
                        }

                        public void earlyEOF() {
                        }

                        public boolean content(ByteBuffer item) {
                            return false;
                        }

                        public boolean startResponse(HttpVersion version, int status, String reason) {
                            return false;
                        }
                    };
                    parser = new HttpParser(handler);
                    parser.setHeadResponse(head);
                    bout = new ByteArrayOutputStream2();
                    try {
                        block13: {
                            block6: while (true) {
                                if (BufferUtil.hasContent((ByteBuffer)this._responseData)) {
                                    chunk = this._responseData;
                                } else {
                                    chunk = this.waitForOutput(time, unit);
                                    if (BufferUtil.isEmpty((ByteBuffer)chunk) && (!this.isOpen() || this.isOutputShutdown())) {
                                        parser.atEOF();
                                        parser.parseNext(BufferUtil.EMPTY_BUFFER);
                                        break block13;
                                    }
                                }
                                do {
                                    if (!BufferUtil.hasContent((ByteBuffer)chunk)) continue block6;
                                    pos = chunk.position();
                                    complete = parser.parseNext(chunk);
                                    if (chunk.position() == pos) {
                                        if (!BufferUtil.isEmpty((ByteBuffer)chunk)) ** break;
                                        continue block6;
                                        break block14;
                                    }
                                    bout.write(chunk.array(), chunk.arrayOffset() + pos, chunk.position() - pos);
                                } while (!complete);
                                break;
                            }
                            if (BufferUtil.hasContent((ByteBuffer)chunk)) {
                                this._responseData = chunk;
                            }
                        }
                        if (bout.getCount() != 0 || !this.isOutputShutdown()) break block15;
                    }
                    catch (Throwable var6_7) {
                        try {
                            var1_2.close();
                            throw var6_7;
                        }
                        catch (Throwable var7_9) {
                            var6_7.addSuppressed(var7_9);
                        }
                        throw var6_7;
                    }
                    bout.close();
                    return null;
                }
                var6_6 = ByteBuffer.wrap(bout.getBuf(), 0, bout.getCount());
                bout.close();
                return var6_6;
            }
            bout.close();
            return null;
        }
    }
}

