/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritePendingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class HttpOutput
extends ServletOutputStream
implements Runnable {
    private static final String LSTRING_FILE = "javax.servlet.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.LocalStrings");
    private static Logger LOG = Log.getLogger(HttpOutput.class);
    private static final ThreadLocal<CharsetEncoder> _encoder = new ThreadLocal();
    private final HttpChannel _channel;
    private final HttpChannelState _channelState;
    private final SharedBlockingCallback _writeBlocker;
    private ApiState _apiState = ApiState.BLOCKING;
    private State _state = State.OPEN;
    private boolean _softClose = false;
    private Interceptor _interceptor;
    private long _written;
    private long _flushed;
    private long _firstByteTimeStamp = -1L;
    private ByteBuffer _aggregate;
    private int _bufferSize;
    private int _commitSize;
    private WriteListener _writeListener;
    private volatile Throwable _onError;
    private Callback _closedCallback;

    /*
     * WARNING - void declaration
     */
    public HttpOutput(HttpChannel channel) {
        void var1_1;
        this._channel = channel;
        this._channelState = channel.getState();
        this._interceptor = channel;
        this._writeBlocker = new WriteBlocker(channel);
        HttpConfiguration config = channel.getHttpConfiguration();
        this._bufferSize = config.getOutputBufferSize();
        this._commitSize = var1_1.getOutputAggregationSize();
        if (this._commitSize > this._bufferSize) {
            LOG.warn("OutputAggregationSize {} exceeds bufferSize {}", new Object[]{this._commitSize, this._bufferSize});
            this._commitSize = this._bufferSize;
        }
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    public Interceptor getInterceptor() {
        return this._interceptor;
    }

    /*
     * WARNING - void declaration
     */
    public void setInterceptor(Interceptor interceptor) {
        void var1_1;
        this._interceptor = var1_1;
    }

    public boolean isWritten() {
        return this._written > 0L;
    }

    public long getWritten() {
        return this._written;
    }

    public void reopen() {
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            this._softClose = false;
            return;
        }
    }

    protected SharedBlockingCallback.Blocker acquireWriteBlockingCallback() throws IOException {
        return this._writeBlocker.acquire();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void channelWrite(ByteBuffer content, boolean complete) throws IOException {
        SharedBlockingCallback.Blocker blocker = this._writeBlocker.acquire();
        try {
            void var2_3;
            void var1_1;
            this.channelWrite((ByteBuffer)var1_1, (boolean)var2_3, (Callback)blocker);
            blocker.block();
            if (blocker == null) return;
        }
        catch (Throwable throwable) {
            if (blocker == null) throw throwable;
            try {
                void var3_5;
                var3_5.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        blocker.close();
    }

    /*
     * WARNING - void declaration
     */
    private void channelWrite(ByteBuffer content, boolean last, Callback callback) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this._firstByteTimeStamp == -1L) {
            long l = this.getHttpChannel().getHttpConfiguration().getMinResponseDataRate();
            this._firstByteTimeStamp = l > 0L ? System.nanoTime() : Long.MAX_VALUE;
        }
        this._interceptor.write((ByteBuffer)var1_1, (boolean)var2_2, (Callback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void onWriteComplete(boolean last, Throwable failure) {
        String state = null;
        boolean wake = false;
        Callback closedCallback = null;
        ByteBuffer closeContent = null;
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                state = this.stateString();
            }
            if (last || failure != null) {
                this._state = State.CLOSED;
                closedCallback = this._closedCallback;
                this._closedCallback = null;
                this.releaseBuffer(failure);
                wake = this.updateApiState(failure);
            } else if (this._state == State.CLOSE) {
                this._state = State.CLOSING;
                closeContent = BufferUtil.hasContent((ByteBuffer)this._aggregate) ? this._aggregate : BufferUtil.EMPTY_BUFFER;
            } else {
                wake = this.updateApiState(null);
            }
        }
        if (LOG.isDebugEnabled()) {
            void var3_5;
            void var1_1;
            LOG.debug("onWriteComplete({},{}) {}->{} c={} cb={} w={}", new Object[]{(boolean)var1_1, failure, var3_5, this.stateString(), BufferUtil.toDetailString((ByteBuffer)closeContent), closedCallback, wake});
        }
        try {
            if (failure != null) {
                this._channel.abort(failure);
            }
            if (closedCallback != null) {
                if (failure == null) {
                    closedCallback.succeeded();
                } else {
                    void var2_4;
                    closedCallback.failed((Throwable)var2_4);
                }
            } else if (closeContent != null) {
                this.channelWrite(closeContent, true, new WriteCompleteCB());
            }
            if (wake) {
                this._channel.execute(this._channel);
                return;
            }
        }
        catch (Throwable throwable) {
            if (wake) {
                this._channel.execute(this._channel);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateApiState(Throwable failure) {
        void var2_2;
        boolean wake = false;
        switch (this._apiState) {
            case BLOCKED: {
                this._apiState = ApiState.BLOCKING;
                break;
            }
            case PENDING: {
                this._apiState = ApiState.ASYNC;
                if (failure == null) break;
                this._onError = failure;
                wake = this._channelState.onWritePossible();
                break;
            }
            case UNREADY: {
                this._apiState = ApiState.READY;
                if (failure != null) {
                    void var1_1;
                    this._onError = var1_1;
                }
                wake = this._channelState.onWritePossible();
                break;
            }
            default: {
                if (this._state == State.CLOSED) break;
                throw new IllegalStateException(this.stateString());
            }
        }
        return (boolean)var2_2;
    }

    private int maximizeAggregateSpace() {
        if (this._aggregate == null) {
            return this.getBufferSize();
        }
        BufferUtil.compact((ByteBuffer)this._aggregate);
        return BufferUtil.space((ByteBuffer)this._aggregate);
    }

    public void softClose() {
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            this._softClose = true;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void complete(Callback callback) {
        void var2_3;
        boolean succeeded = false;
        Throwable error = null;
        ByteBuffer content = null;
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            switch (this._apiState) {
                case UNREADY: {
                    error = new CancellationException("Completed whilst write unready");
                    break;
                }
                case PENDING: {
                    if (this._channel.getResponse().isContentComplete(this._written)) break;
                    error = new CancellationException("Completed whilst write pending");
                    break;
                }
                case BLOCKED: {
                    error = new CancellationException("Completed whilst write blocked");
                }
            }
            if (error != null) {
                this._channel.abort(error);
                this._writeBlocker.fail(error);
                this._state = State.CLOSED;
            } else {
                block7 : switch (this._state) {
                    case CLOSED: {
                        succeeded = true;
                        break;
                    }
                    case CLOSE: 
                    case CLOSING: {
                        this._closedCallback = Callback.combine((Callback)this._closedCallback, (Callback)callback);
                        break;
                    }
                    case OPEN: {
                        if (this._onError != null) {
                            error = this._onError;
                            break;
                        }
                        this._closedCallback = Callback.combine((Callback)this._closedCallback, (Callback)callback);
                        switch (this._apiState) {
                            case BLOCKING: {
                                this._apiState = ApiState.BLOCKED;
                                this._state = State.CLOSING;
                                content = BufferUtil.hasContent((ByteBuffer)this._aggregate) ? this._aggregate : BufferUtil.EMPTY_BUFFER;
                                break block7;
                            }
                            case ASYNC: 
                            case READY: {
                                this._apiState = ApiState.PENDING;
                                this._state = State.CLOSING;
                                content = BufferUtil.hasContent((ByteBuffer)this._aggregate) ? this._aggregate : BufferUtil.EMPTY_BUFFER;
                                break block7;
                            }
                            case PENDING: 
                            case UNREADY: {
                                this._softClose = true;
                                this._state = State.CLOSE;
                                break block7;
                            }
                        }
                        throw new IllegalStateException();
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("complete({}) {} s={} e={}, c={}", new Object[]{callback, this.stateString(), succeeded, error, BufferUtil.toDetailString((ByteBuffer)content)});
        }
        if (var2_3 != false) {
            callback.succeeded();
            return;
        }
        if (error != null) {
            void var3_4;
            void var1_1;
            var1_1.failed((Throwable)var3_4);
            return;
        }
        if (content != null) {
            this.channelWrite(content, true, new WriteCompleteCB());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void completed(Throwable failure) {
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            void var1_1;
            this._state = State.CLOSED;
            this.releaseBuffer((Throwable)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void close() throws IOException {
        block39: {
            SharedBlockingCallback.Blocker b;
            SharedBlockingCallback.Blocker blocker2;
            ByteBuffer content22;
            block38: {
                block36: {
                    content22 = null;
                    blocker2 = null;
                    HttpChannelState httpChannelState = this._channelState;
                    synchronized (httpChannelState) {
                        if (this._onError != null) {
                            if (this._onError instanceof IOException) {
                                throw (IOException)this._onError;
                            }
                            if (this._onError instanceof RuntimeException) {
                                throw (RuntimeException)this._onError;
                            }
                            if (this._onError instanceof Error) {
                                throw (Error)this._onError;
                            }
                            throw new IOException(this._onError);
                        }
                        block7 : switch (this._state) {
                            case CLOSED: {
                                break;
                            }
                            case CLOSE: 
                            case CLOSING: {
                                switch (this._apiState) {
                                    case BLOCKED: 
                                    case BLOCKING: {
                                        blocker2 = this._writeBlocker.acquire();
                                        this._closedCallback = Callback.combine((Callback)this._closedCallback, (Callback)blocker2);
                                        break block7;
                                    }
                                }
                                break;
                            }
                            case OPEN: {
                                switch (this._apiState) {
                                    case BLOCKING: {
                                        this._apiState = ApiState.BLOCKED;
                                        this._state = State.CLOSING;
                                        blocker2 = this._writeBlocker.acquire();
                                        content22 = BufferUtil.hasContent((ByteBuffer)this._aggregate) ? this._aggregate : BufferUtil.EMPTY_BUFFER;
                                        break block7;
                                    }
                                    case BLOCKED: {
                                        this._softClose = true;
                                        this._state = State.CLOSE;
                                        blocker2 = this._writeBlocker.acquire();
                                        this._closedCallback = Callback.combine((Callback)this._closedCallback, (Callback)blocker2);
                                        break block7;
                                    }
                                    case ASYNC: 
                                    case READY: {
                                        this._apiState = ApiState.PENDING;
                                        this._state = State.CLOSING;
                                        content22 = BufferUtil.hasContent((ByteBuffer)this._aggregate) ? this._aggregate : BufferUtil.EMPTY_BUFFER;
                                        break block7;
                                    }
                                    case PENDING: 
                                    case UNREADY: {
                                        this._softClose = true;
                                        this._state = State.CLOSE;
                                    }
                                }
                            }
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("close() {} c={} b={}", new Object[]{this.stateString(), BufferUtil.toDetailString((ByteBuffer)content22), blocker2});
                    }
                    if (content22 != null) break block38;
                    if (blocker2 == null) {
                        return;
                    }
                    b = blocker2;
                    try {
                        b.block();
                        if (b == null) break block36;
                    }
                    catch (Throwable content22) {
                        if (b != null) {
                            try {
                                b.close();
                            }
                            catch (Throwable blocker2) {
                                content22.addSuppressed(blocker2);
                            }
                        }
                        throw content22;
                    }
                    b.close();
                    break block39;
                }
                return;
            }
            if (blocker2 == null) {
                this.channelWrite(content22, true, new WriteCompleteCB());
                return;
            }
            try {
                block40: {
                    block37: {
                        b = blocker2;
                        try {
                            void var2_5;
                            void var1_1;
                            this.channelWrite((ByteBuffer)var1_1, true, (Callback)var2_5);
                            b.block();
                            this.onWriteComplete(true, null);
                            if (b == null) break block37;
                        }
                        catch (Throwable throwable) {
                            if (b != null) {
                                try {
                                    b.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        break block40;
                    }
                    return;
                }
                b.close();
            }
            catch (Throwable t) {
                void var3_9;
                this.onWriteComplete(true, t);
                throw var3_9;
            }
        }
    }

    public ByteBuffer getBuffer() {
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            return this.acquireBuffer();
        }
    }

    private ByteBuffer acquireBuffer() {
        if (this._aggregate == null) {
            this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), this._interceptor.isOptimizedForDirectBuffers());
        }
        return this._aggregate;
    }

    /*
     * WARNING - void declaration
     */
    private void releaseBuffer(Throwable failure) {
        if (this._aggregate != null) {
            void var1_1;
            ByteBufferPool bufferPool = this._channel.getConnector().getByteBufferPool();
            if (var1_1 == null) {
                bufferPool.release(this._aggregate);
            } else {
                void var2_2;
                var2_2.remove(this._aggregate);
            }
            this._aggregate = null;
        }
    }

    public boolean isClosed() {
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            return this._softClose || this._state != State.OPEN;
        }
    }

    public boolean isAsync() {
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            switch (this._apiState) {
                case PENDING: 
                case UNREADY: 
                case ASYNC: 
                case READY: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void flush() throws IOException {
        ByteBuffer content = null;
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            switch (this._state) {
                case CLOSED: 
                case CLOSING: {
                    return;
                }
            }
            switch (this._apiState) {
                case BLOCKING: {
                    this._apiState = ApiState.BLOCKED;
                    content = BufferUtil.hasContent((ByteBuffer)this._aggregate) ? this._aggregate : BufferUtil.EMPTY_BUFFER;
                    break;
                }
                case PENDING: 
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called: " + this.stateString());
                }
                case READY: {
                    this._apiState = ApiState.PENDING;
                    break;
                }
                case UNREADY: {
                    throw new WritePendingException();
                }
                default: {
                    throw new IllegalStateException(this.stateString());
                }
            }
        }
        if (content == null) {
            new AsyncFlush(false).iterate();
            return;
        }
        try {
            void var1_1;
            this.channelWrite((ByteBuffer)var1_1, false);
            this.onWriteComplete(false, null);
            return;
        }
        catch (Throwable t) {
            void var2_4;
            this.onWriteComplete(false, t);
            throw var2_4;
        }
    }

    private void checkWritable() throws EofException {
        if (this._softClose) {
            throw new EofException("Closed");
        }
        switch (this._state) {
            case CLOSED: 
            case CLOSING: {
                throw new EofException("Closed");
            }
        }
        if (this._onError != null) {
            throw new EofException(this._onError);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(byte[] b, int off, int len) throws IOException {
        boolean async;
        boolean aggregate;
        boolean last;
        if (LOG.isDebugEnabled()) {
            LOG.debug("write(array {})", new Object[]{BufferUtil.toDetailString((ByteBuffer)ByteBuffer.wrap(b, off, len))});
        }
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            block23: {
                boolean flush;
                this.checkWritable();
                long written = this._written + (long)len;
                int space = this.maximizeAggregateSpace();
                last = this._channel.getResponse().isAllContentWritten(written);
                aggregate = len <= this._commitSize && (!last || BufferUtil.hasContent((ByteBuffer)this._aggregate) && len <= space);
                boolean bl = flush = last || !aggregate || len >= space;
                if (last && this._state == State.OPEN) {
                    this._state = State.CLOSING;
                }
                switch (this._apiState) {
                    case BLOCKING: {
                        this._apiState = flush ? ApiState.BLOCKED : ApiState.BLOCKING;
                        async = false;
                        break;
                    }
                    case ASYNC: {
                        throw new IllegalStateException("isReady() not called: " + this.stateString());
                    }
                    case READY: {
                        async = true;
                        this._apiState = flush ? ApiState.PENDING : ApiState.ASYNC;
                        break;
                    }
                    case PENDING: 
                    case UNREADY: {
                        throw new WritePendingException();
                    }
                    default: {
                        throw new IllegalStateException(this.stateString());
                    }
                }
                this._written = written;
                if (!aggregate) break block23;
                this.acquireBuffer();
                int filled = BufferUtil.fill((ByteBuffer)this._aggregate, (byte[])b, (int)off, (int)len);
                if (!flush) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("write(array) {} aggregated !flush {}", new Object[]{this.stateString(), BufferUtil.toDetailString((ByteBuffer)this._aggregate)});
                    }
                    return;
                }
                off += filled;
                len -= filled;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("write(array) {} last={} agg={} flush=true async={}, len={} {}", new Object[]{this.stateString(), last, aggregate, async, len, BufferUtil.toDetailString((ByteBuffer)this._aggregate)});
        }
        if (async) {
            new AsyncWrite(b, off, len, last).iterate();
            return;
        }
        try {
            boolean complete = false;
            if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
                complete = last && len == 0;
                HttpOutput httpOutput = this;
                httpOutput.channelWrite(httpOutput._aggregate, complete);
                if (len > 0 && !last && len <= this._commitSize && len <= this.maximizeAggregateSpace()) {
                    BufferUtil.append((ByteBuffer)this._aggregate, (byte[])b, (int)off, (int)len);
                    this.onWriteComplete(false, null);
                    return;
                }
            }
            if (len > 0) {
                void var2_3;
                void var1_1;
                ByteBuffer view = ByteBuffer.wrap((byte[])var1_1, (int)var2_3, len);
                while (len > this.getBufferSize()) {
                    int p = view.position();
                    int l = p + this.getBufferSize();
                    view.limit(l);
                    this.channelWrite(view, false);
                    view.limit(p + len);
                    view.position(l);
                    len -= this.getBufferSize();
                }
                this.channelWrite(view, last);
            } else if (last && !complete) {
                this.channelWrite(BufferUtil.EMPTY_BUFFER, true);
            }
            this.onWriteComplete(last, null);
            return;
        }
        catch (Throwable t) {
            this.onWriteComplete(last, t);
            throw t;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(ByteBuffer buffer) throws IOException {
        void var3_9;
        boolean async;
        boolean last;
        int len = BufferUtil.length((ByteBuffer)buffer);
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            boolean flush;
            this.checkWritable();
            long written = this._written + (long)len;
            last = this._channel.getResponse().isAllContentWritten(written);
            boolean bl = flush = last || len > 0 || BufferUtil.hasContent((ByteBuffer)this._aggregate);
            if (last && this._state == State.OPEN) {
                this._state = State.CLOSING;
            }
            switch (this._apiState) {
                case BLOCKING: {
                    async = false;
                    this._apiState = flush ? ApiState.BLOCKED : ApiState.BLOCKING;
                    break;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called: " + this.stateString());
                }
                case READY: {
                    async = true;
                    this._apiState = flush ? ApiState.PENDING : ApiState.ASYNC;
                    break;
                }
                case PENDING: 
                case UNREADY: {
                    throw new WritePendingException();
                }
                default: {
                    throw new IllegalStateException(this.stateString());
                }
            }
            this._written = written;
        }
        if (var3_9 == false) {
            return;
        }
        if (async) {
            new AsyncWrite(buffer, last).iterate();
            return;
        }
        try {
            void var2_3;
            boolean complete = false;
            if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
                complete = last && len == 0;
                HttpOutput httpOutput = this;
                httpOutput.channelWrite(httpOutput._aggregate, complete);
            }
            if (var2_3 > 0) {
                void var1_1;
                this.channelWrite((ByteBuffer)var1_1, last);
            } else if (last && !complete) {
                this.channelWrite(BufferUtil.EMPTY_BUFFER, true);
            }
            this.onWriteComplete(last, null);
            return;
        }
        catch (Throwable t) {
            this.onWriteComplete(last, t);
            throw t;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(int b) throws IOException {
        void var2_7;
        boolean last;
        boolean async = false;
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            void var1_1;
            boolean flush;
            this.checkWritable();
            long written = this._written + 1L;
            int space = this.maximizeAggregateSpace();
            last = this._channel.getResponse().isAllContentWritten(written);
            boolean bl = flush = last || space == 1;
            if (last && this._state == State.OPEN) {
                this._state = State.CLOSING;
            }
            switch (this._apiState) {
                case BLOCKING: {
                    this._apiState = flush ? ApiState.BLOCKED : ApiState.BLOCKING;
                    break;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called: " + this.stateString());
                }
                case READY: {
                    async = true;
                    this._apiState = flush ? ApiState.PENDING : ApiState.ASYNC;
                    break;
                }
                case PENDING: 
                case UNREADY: {
                    throw new WritePendingException();
                }
                default: {
                    throw new IllegalStateException(this.stateString());
                }
            }
            this._written = written;
            this.acquireBuffer();
            BufferUtil.append((ByteBuffer)this._aggregate, (byte)((byte)var1_1));
        }
        if (var2_7 == false) {
            return;
        }
        if (async) {
            new AsyncFlush(last).iterate();
            return;
        }
        try {
            HttpOutput httpOutput = this;
            httpOutput.channelWrite(httpOutput._aggregate, last);
            this.onWriteComplete(last, null);
            return;
        }
        catch (Throwable t) {
            void var3_8;
            this.onWriteComplete((boolean)var3_8, t);
            throw t;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void print(String s) throws IOException {
        void var1_1;
        this.print((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public void println(String s) throws IOException {
        void var1_1;
        this.print((String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private void print(String s, boolean eoln) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
        String charset = this._channel.getResponse().getCharacterEncoding();
        CharsetEncoder encoder = _encoder.get();
        if (encoder == null || !encoder.charset().name().equalsIgnoreCase(charset)) {
            encoder = Charset.forName(charset).newEncoder();
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            _encoder.set(encoder);
        } else {
            encoder.reset();
        }
        CharBuffer in = CharBuffer.wrap(s);
        CharBuffer crlf = eoln ? CharBuffer.wrap("\r\n") : null;
        ByteBuffer out = this.getHttpChannel().getByteBufferPool().acquire((int)(1.0f + (float)(s.length() + 2) * encoder.averageBytesPerChar()), false);
        BufferUtil.flipToFill((ByteBuffer)out);
        while (true) {
            void var6_7;
            CoderResult result;
            if (in.hasRemaining()) {
                result = encoder.encode(in, out, crlf == null);
                if (result.isUnderflow()) {
                    if (crlf != null) continue;
                    break;
                }
            } else {
                if (crlf == null || !crlf.hasRemaining()) break;
                result = encoder.encode(crlf, out, true);
                if (result.isUnderflow()) {
                    if (encoder.flush(out).isUnderflow()) break;
                    result.throwException();
                    break;
                }
            }
            if (result.isOverflow()) {
                BufferUtil.flipToFlush((ByteBuffer)out, (int)0);
                ByteBuffer byteBuffer = out;
                ByteBuffer bigger = BufferUtil.ensureCapacity((ByteBuffer)byteBuffer, (int)(byteBuffer.capacity() + s.length() + 2));
                this.getHttpChannel().getByteBufferPool().release(out);
                BufferUtil.flipToFill((ByteBuffer)bigger);
                out = bigger;
                continue;
            }
            var6_7.throwException();
        }
        BufferUtil.flipToFlush((ByteBuffer)out, (int)0);
        this.write(out.array(), out.arrayOffset(), out.remaining());
        this.getHttpChannel().getByteBufferPool().release(out);
    }

    /*
     * WARNING - void declaration
     */
    public void println(boolean b) throws IOException {
        void var1_1;
        this.println(lStrings.getString(var1_1 != false ? "value.true" : "value.false"));
    }

    /*
     * WARNING - void declaration
     */
    public void println(char c) throws IOException {
        void var1_1;
        this.println(String.valueOf((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void println(int i) throws IOException {
        void var1_1;
        this.println(String.valueOf((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void println(long l) throws IOException {
        void var1_1;
        this.println(String.valueOf((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void println(float f) throws IOException {
        void var1_1;
        this.println(String.valueOf((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void println(double d) throws IOException {
        void var1_1;
        this.println(String.valueOf((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void sendContent(ByteBuffer content) throws IOException {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent({})", new Object[]{BufferUtil.toDetailString((ByteBuffer)content)});
        }
        this._written += (long)content.remaining();
        this.channelWrite((ByteBuffer)var1_1, true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendContent(InputStream in) throws IOException {
        SharedBlockingCallback.Blocker blocker = this._writeBlocker.acquire();
        try {
            void var1_1;
            new InputStreamWritingCB((InputStream)var1_1, (Callback)blocker).iterate();
            blocker.block();
            if (blocker == null) return;
        }
        catch (Throwable throwable) {
            if (blocker == null) throw throwable;
            try {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        blocker.close();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendContent(ReadableByteChannel in) throws IOException {
        SharedBlockingCallback.Blocker blocker = this._writeBlocker.acquire();
        try {
            void var1_1;
            new ReadableByteChannelWritingCB((ReadableByteChannel)var1_1, (Callback)blocker).iterate();
            blocker.block();
            if (blocker == null) return;
        }
        catch (Throwable throwable) {
            if (blocker == null) throw throwable;
            try {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        blocker.close();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendContent(HttpContent content) throws IOException {
        SharedBlockingCallback.Blocker blocker = this._writeBlocker.acquire();
        try {
            void var1_1;
            this.sendContent((HttpContent)var1_1, (Callback)blocker);
            blocker.block();
            if (blocker == null) return;
        }
        catch (Throwable throwable) {
            if (blocker == null) throw throwable;
            try {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        blocker.close();
    }

    /*
     * WARNING - void declaration
     */
    public void sendContent(ByteBuffer content, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent(buffer={},{})", new Object[]{BufferUtil.toDetailString((ByteBuffer)content), callback});
        }
        if (this.prepareSendContent(content.remaining(), callback)) {
            void var2_2;
            void var1_1;
            this.channelWrite((ByteBuffer)var1_1, true, (Callback)new Callback.Nested(this, (Callback)var2_2){
                final /* synthetic */ HttpOutput this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super((Callback)var2_2);
                }

                public void succeeded() {
                    HttpOutput.access$700(this.this$0, true, null);
                    super.succeeded();
                }

                /*
                 * WARNING - void declaration
                 */
                public void failed(Throwable x) {
                    void var1_1;
                    HttpOutput.access$700(this.this$0, true, x);
                    super.failed((Throwable)var1_1);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendContent(InputStream in, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent(stream={},{})", new Object[]{in, callback});
        }
        if (this.prepareSendContent(0, callback)) {
            void var2_2;
            void var1_1;
            new InputStreamWritingCB((InputStream)var1_1, (Callback)var2_2).iterate();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendContent(ReadableByteChannel in, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent(channel={},{})", new Object[]{in, callback});
        }
        if (this.prepareSendContent(0, callback)) {
            void var2_2;
            void var1_1;
            new ReadableByteChannelWritingCB((ReadableByteChannel)var1_1, (Callback)var2_2).iterate();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean prepareSendContent(int len, Callback callback) {
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
                callback.failed((Throwable)new IOException("cannot sendContent() after write()"));
                return false;
            }
            if (this._channel.isCommitted()) {
                callback.failed((Throwable)new IOException("cannot sendContent(), output already committed"));
                return false;
            }
            switch (this._state) {
                case CLOSED: 
                case CLOSING: {
                    callback.failed((Throwable)new EofException("Closed"));
                    return false;
                }
            }
            this._state = State.CLOSING;
            if (this._onError != null) {
                void var2_3;
                var2_3.failed(this._onError);
                return false;
            }
            if (this._apiState != ApiState.BLOCKING) {
                throw new IllegalStateException(this.stateString());
            }
            this._apiState = ApiState.PENDING;
            if (len > 0) {
                void var1_1;
                this._written += (long)var1_1;
            }
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendContent(HttpContent httpContent, Callback callback) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteBuffer buffer;
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent(http={},{})", new Object[]{httpContent, callback});
        }
        if ((buffer = this._channel.useDirectBuffers() ? httpContent.getDirectBuffer() : null) == null) {
            buffer = httpContent.getIndirectBuffer();
        }
        if (buffer != null) {
            this.sendContent(buffer, callback);
            return;
        }
        ReadableByteChannel rbc = null;
        try {
            rbc = httpContent.getReadableByteChannel();
        }
        catch (Throwable x) {
            LOG.debug(x);
        }
        if (rbc != null) {
            this.sendContent(rbc, callback);
            return;
        }
        InputStream in = null;
        try {
            in = httpContent.getInputStream();
        }
        catch (Throwable x) {
            LOG.debug(x);
        }
        if (in != null) {
            this.sendContent(in, callback);
            return;
        }
        IllegalArgumentException cause = new IllegalArgumentException("unknown content for " + var1_1);
        this._channel.abort(cause);
        var2_2.failed((Throwable)var3_3);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setBufferSize(int size) {
        void var1_1;
        this._bufferSize = size;
        this._commitSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void onFlushed(long bytes) throws IOException {
        if (this._firstByteTimeStamp == -1L || this._firstByteTimeStamp == Long.MAX_VALUE) {
            return;
        }
        long minDataRate = this.getHttpChannel().getHttpConfiguration().getMinResponseDataRate();
        this._flushed += bytes;
        long elapsed = System.nanoTime() - this._firstByteTimeStamp;
        long minFlushed = minDataRate * TimeUnit.NANOSECONDS.toMillis(elapsed) / TimeUnit.SECONDS.toMillis(1L);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushed bytes min/actual {}/{}", new Object[]{minFlushed, this._flushed});
        }
        if (this._flushed < minFlushed) {
            void var1_2;
            void var3_3;
            IOException ioe = new IOException(String.format("Response content data rate < %d B/s", (long)var3_3));
            this._channel.abort(ioe);
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void recycle() {
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            void var2_2;
            this._state = State.OPEN;
            this._apiState = ApiState.BLOCKING;
            this._softClose = true;
            this._interceptor = this._channel;
            HttpConfiguration config = this._channel.getHttpConfiguration();
            this._bufferSize = config.getOutputBufferSize();
            this._commitSize = var2_2.getOutputAggregationSize();
            if (this._commitSize > this._bufferSize) {
                this._commitSize = this._bufferSize;
            }
            this.releaseBuffer(null);
            this._written = 0L;
            this._writeListener = null;
            this._onError = null;
            this._firstByteTimeStamp = -1L;
            this._flushed = 0L;
            this._closedCallback = null;
            return;
        }
    }

    public void resetBuffer() {
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            this._interceptor.resetBuffer();
            if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
                BufferUtil.clear((ByteBuffer)this._aggregate);
            }
            this._written = 0L;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setWriteListener(WriteListener writeListener) {
        void var1_2;
        if (!this._channel.getState().isAsync()) {
            throw new IllegalStateException("!ASYNC: " + this.stateString());
        }
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            if (this._apiState != ApiState.BLOCKING) {
                throw new IllegalStateException("!OPEN" + this.stateString());
            }
            this._apiState = ApiState.READY;
            this._writeListener = writeListener;
            boolean wake = this._channel.getState().onWritePossible();
        }
        if (var1_2 != false) {
            this._channel.execute(this._channel);
        }
    }

    public boolean isReady() {
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            switch (this._apiState) {
                case BLOCKING: 
                case READY: {
                    return true;
                }
                case ASYNC: {
                    this._apiState = ApiState.READY;
                    return true;
                }
                case PENDING: {
                    this._apiState = ApiState.UNREADY;
                    return false;
                }
                case BLOCKED: 
                case UNREADY: {
                    return false;
                }
            }
            throw new IllegalStateException(this.stateString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        Throwable error = null;
        Object object = this._channelState;
        synchronized (object) {
            if (this._onError != null) {
                error = this._onError;
                this._onError = null;
            }
        }
        try {
            if (error == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onWritePossible", new Object[0]);
                }
                this._writeListener.onWritePossible();
                return;
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            error = throwable;
        }
        try {
            void var1_1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onError", error);
            }
            this._writeListener.onError((Throwable)var1_1);
            return;
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                void var2_5;
                LOG.debug((Throwable)var2_5);
            }
            return;
        }
        finally {
            IO.close((OutputStream)((Object)this));
        }
    }

    private String stateString() {
        return String.format("s=%s,api=%s,sc=%b,e=%s", new Object[]{this._state, this._apiState, this._softClose, this._onError});
    }

    public String toString() {
        HttpChannelState httpChannelState = this._channelState;
        synchronized (httpChannelState) {
            return String.format("%s@%x{%s}", this.getClass().getSimpleName(), this.hashCode(), this.stateString());
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(HttpOutput x0, boolean x1, Throwable x2) {
        void var2_2;
        void var1_1;
        x0.onWriteComplete((boolean)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1000(HttpOutput x0, ByteBuffer x1, boolean x2, Callback x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.channelWrite((ByteBuffer)var1_1, (boolean)var2_2, (Callback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$1614(HttpOutput x0, long x1) {
        void var1_1;
        return x0._written += var1_1;
    }

    private class WriteCompleteCB
    implements Callback {
        private WriteCompleteCB() {
        }

        public void succeeded() {
            HttpOutput.access$700(HttpOutput.this, true, null);
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            HttpOutput.access$700(HttpOutput.this, true, (Throwable)var1_1);
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }

    private static class WriteBlocker
    extends SharedBlockingCallback {
        private final HttpChannel _channel;

        /*
         * WARNING - void declaration
         */
        private WriteBlocker(HttpChannel channel) {
            void var1_1;
            this._channel = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected long getIdleTimeout() {
            void var1_1;
            long blockingTimeout = this._channel.getHttpConfiguration().getBlockingTimeout();
            if (blockingTimeout == 0L) {
                return this._channel.getIdleTimeout();
            }
            return (long)var1_1;
        }
    }

    private class ReadableByteChannelWritingCB
    extends NestedChannelWriteCB {
        private final ReadableByteChannel _in;
        private final ByteBuffer _buffer;
        private boolean _eof;
        private boolean _closed;

        /*
         * WARNING - void declaration
         */
        private ReadableByteChannelWritingCB(ReadableByteChannel in, Callback callback) {
            void var2_2;
            void var3_3;
            super((Callback)var3_3, true);
            this._in = var2_2;
            this._buffer = HttpOutput.this._channel.getByteBufferPool().acquire(HttpOutput.this.getBufferSize(), HttpOutput.this._channel.useDirectBuffers());
        }

        protected IteratingCallback.Action process() throws Exception {
            if (this._eof) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("EOF of {}", new Object[]{this});
                }
                if (!this._closed) {
                    this._closed = true;
                    HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
                    IO.close((Closeable)this._in);
                }
                return IteratingCallback.Action.SUCCEEDED;
            }
            BufferUtil.clearToFill((ByteBuffer)this._buffer);
            while (this._buffer.hasRemaining() && !this._eof) {
                this._eof = this._in.read(this._buffer) < 0;
            }
            BufferUtil.flipToFlush((ByteBuffer)this._buffer, (int)0);
            HttpOutput.access$1614(HttpOutput.this, this._buffer.remaining());
            HttpOutput.access$1000(HttpOutput.this, this._buffer, this._eof, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onCompleteFailure(Throwable x) {
            void var1_1;
            HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
            IO.close((Closeable)this._in);
            super.onCompleteFailure((Throwable)var1_1);
        }
    }

    private class InputStreamWritingCB
    extends NestedChannelWriteCB {
        private final InputStream _in;
        private final ByteBuffer _buffer;
        private boolean _eof;
        private boolean _closed;

        /*
         * WARNING - void declaration
         */
        private InputStreamWritingCB(InputStream in, Callback callback) {
            void var2_2;
            void var3_3;
            super((Callback)var3_3, true);
            this._in = var2_2;
            this._buffer = HttpOutput.this._channel.getByteBufferPool().acquire(HttpOutput.this.getBufferSize(), false);
        }

        /*
         * WARNING - void declaration
         */
        protected IteratingCallback.Action process() throws Exception {
            void var1_1;
            if (this._eof) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("EOF of {}", new Object[]{this});
                }
                if (!this._closed) {
                    this._closed = true;
                    HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
                    IO.close((InputStream)this._in);
                }
                return IteratingCallback.Action.SUCCEEDED;
            }
            int len = 0;
            while (len < this._buffer.capacity() && !this._eof) {
                void var2_2;
                int r = this._in.read(this._buffer.array(), this._buffer.arrayOffset() + len, this._buffer.capacity() - len);
                if (r < 0) {
                    this._eof = true;
                    continue;
                }
                len += var2_2;
            }
            this._buffer.position(0);
            this._buffer.limit(len);
            HttpOutput.access$1614(HttpOutput.this, (long)var1_1);
            HttpOutput.access$1000(HttpOutput.this, this._buffer, this._eof, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onCompleteFailure(Throwable x) {
            try {
                HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
                super.onCompleteFailure(x);
                return;
            }
            catch (Throwable throwable) {
                void var1_1;
                super.onCompleteFailure((Throwable)var1_1);
                throw throwable;
            }
        }
    }

    private class AsyncWrite
    extends ChannelWriteCB {
        private final ByteBuffer _buffer;
        private final ByteBuffer _slice;
        private final int _len;
        private boolean _completed;

        /*
         * WARNING - void declaration
         */
        private AsyncWrite(byte[] b, int off, int len, boolean last) {
            void var3_3;
            void var2_2;
            super(last);
            this._buffer = ByteBuffer.wrap((byte[])var2_2, (int)var3_3, len);
            this._len = len;
            this._slice = this._len < HttpOutput.this.getBufferSize() ? null : this._buffer.duplicate();
        }

        /*
         * WARNING - void declaration
         */
        private AsyncWrite(ByteBuffer buffer, boolean last) {
            void var2_2;
            void var3_3;
            super((boolean)var3_3);
            this._buffer = buffer;
            this._len = var2_2.remaining();
            if (this._buffer.isDirect() || this._len < HttpOutput.this.getBufferSize()) {
                this._slice = null;
                return;
            }
            this._slice = this._buffer.duplicate();
        }

        /*
         * WARNING - void declaration
         */
        protected IteratingCallback.Action process() throws Exception {
            if (BufferUtil.hasContent((ByteBuffer)HttpOutput.this._aggregate)) {
                this._completed = this._len == 0;
                HttpOutput.access$1000(HttpOutput.this, HttpOutput.this._aggregate, this._last && this._completed, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (!this._last && HttpOutput.this._aggregate != null && this._len < HttpOutput.this.maximizeAggregateSpace() && this._len < HttpOutput.this._commitSize) {
                int position = BufferUtil.flipToFill((ByteBuffer)HttpOutput.this._aggregate);
                BufferUtil.put((ByteBuffer)this._buffer, (ByteBuffer)HttpOutput.this._aggregate);
                BufferUtil.flipToFlush((ByteBuffer)HttpOutput.this._aggregate, (int)position);
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (this._buffer.hasRemaining()) {
                void var1_2;
                void var2_3;
                if (this._slice == null) {
                    this._completed = true;
                    HttpOutput.access$1000(HttpOutput.this, this._buffer, this._last, (Callback)this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                int p = this._buffer.position();
                int l = Math.min(HttpOutput.this.getBufferSize(), this._buffer.remaining());
                int pl = p + l;
                this._slice.limit(pl);
                this._buffer.position((int)var2_3);
                this._slice.position((int)var1_2);
                this._completed = !this._buffer.hasRemaining();
                HttpOutput.access$1000(HttpOutput.this, this._slice, this._last && this._completed, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (this._last && !this._completed) {
                this._completed = true;
                HttpOutput.access$1000(HttpOutput.this, BufferUtil.EMPTY_BUFFER, true, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (LOG.isDebugEnabled() && this._completed) {
                LOG.debug("EOF of {}", new Object[]{this});
            }
            return IteratingCallback.Action.SUCCEEDED;
        }
    }

    private class AsyncFlush
    extends ChannelWriteCB {
        private volatile boolean _flushed;

        /*
         * WARNING - void declaration
         */
        private AsyncFlush(boolean last) {
            void var2_2;
            super((boolean)var2_2);
        }

        protected IteratingCallback.Action process() throws Exception {
            if (BufferUtil.hasContent((ByteBuffer)HttpOutput.this._aggregate)) {
                this._flushed = true;
                HttpOutput.access$1000(HttpOutput.this, HttpOutput.this._aggregate, false, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (!this._flushed) {
                this._flushed = true;
                HttpOutput.access$1000(HttpOutput.this, BufferUtil.EMPTY_BUFFER, false, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            return IteratingCallback.Action.SUCCEEDED;
        }
    }

    private abstract class NestedChannelWriteCB
    extends ChannelWriteCB {
        private final Callback _callback;

        /*
         * WARNING - void declaration
         */
        private NestedChannelWriteCB(Callback callback, boolean last) {
            void var2_2;
            void var3_3;
            super((boolean)var3_3);
            this._callback = var2_2;
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this._callback.getInvocationType();
        }

        @Override
        protected void onCompleteSuccess() {
            try {
                super.onCompleteSuccess();
                return;
            }
            finally {
                this._callback.succeeded();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onCompleteFailure(Throwable e) {
            try {
                super.onCompleteFailure(e);
            }
            catch (Throwable throwable) {
                block4: {
                    try {
                        void var2_2;
                        Throwable t = throwable;
                        if (throwable == e) break block4;
                        e.addSuppressed((Throwable)var2_2);
                    }
                    catch (Throwable throwable2) {
                        void var1_1;
                        this._callback.failed((Throwable)var1_1);
                        throw throwable2;
                    }
                }
                this._callback.failed(e);
                return;
            }
            this._callback.failed(e);
            return;
        }
    }

    private abstract class ChannelWriteCB
    extends IteratingCallback {
        final boolean _last;

        /*
         * WARNING - void declaration
         */
        private ChannelWriteCB(boolean last) {
            void var2_2;
            this._last = var2_2;
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        protected void onCompleteSuccess() {
            HttpOutput.access$700(HttpOutput.this, this._last, null);
        }

        /*
         * WARNING - void declaration
         */
        public void onCompleteFailure(Throwable e) {
            void var1_1;
            HttpOutput.access$700(HttpOutput.this, this._last, (Throwable)var1_1);
        }
    }

    public static interface Interceptor {
        public void write(ByteBuffer var1, boolean var2, Callback var3);

        public Interceptor getNextInterceptor();

        public boolean isOptimizedForDirectBuffers();

        /*
         * WARNING - void declaration
         */
        default public void resetBuffer() throws IllegalStateException {
            Interceptor next = this.getNextInterceptor();
            if (next != null) {
                void var1_1;
                var1_1.resetBuffer();
            }
        }
    }

    static enum ApiState {
        BLOCKING,
        BLOCKED,
        ASYNC,
        READY,
        PENDING,
        UNREADY;

    }

    static enum State {
        OPEN,
        CLOSE,
        CLOSING,
        CLOSED;

    }
}

