/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.util.annotation.Name;

public class HttpConnectionFactory
extends AbstractConnectionFactory
implements HttpConfiguration.ConnectionFactory {
    private final HttpConfiguration _config;
    private HttpCompliance _httpCompliance;
    private boolean _recordHttpComplianceViolations = false;

    public HttpConnectionFactory() {
        this(new HttpConfiguration());
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnectionFactory(@Name(value="config") HttpConfiguration config) {
        this((HttpConfiguration)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnectionFactory(@Name(value="config") HttpConfiguration config, @Name(value="compliance") HttpCompliance compliance) {
        super(HttpVersion.HTTP_1_1.asString());
        void var1_1;
        void var2_2;
        this._config = config;
        Object object = this._httpCompliance = compliance == null ? HttpCompliance.RFC7230 : var2_2;
        if (var1_1 == null) {
            throw new IllegalArgumentException("Null HttpConfiguration");
        }
        HttpConnectionFactory httpConnectionFactory = this;
        httpConnectionFactory.addBean(httpConnectionFactory._config);
    }

    @Override
    public HttpConfiguration getHttpConfiguration() {
        return this._config;
    }

    public HttpCompliance getHttpCompliance() {
        return this._httpCompliance;
    }

    public boolean isRecordHttpComplianceViolations() {
        return this._recordHttpComplianceViolations;
    }

    /*
     * WARNING - void declaration
     */
    public void setHttpCompliance(HttpCompliance httpCompliance) {
        void var1_1;
        this._httpCompliance = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        void var2_2;
        void var1_1;
        void var3_3;
        HttpConnection conn = new HttpConnection(this._config, connector, endPoint, this._httpCompliance, this.isRecordHttpComplianceViolations());
        return this.configure((AbstractConnection)var3_3, (Connector)var1_1, (EndPoint)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setRecordHttpComplianceViolations(boolean recordHttpComplianceViolations) {
        void var1_1;
        this._recordHttpComplianceViolations = var1_1;
    }
}

