/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelOverHttp;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class HttpConnection
extends AbstractConnection
implements Runnable,
Connection.UpgradeFrom,
Connection.UpgradeTo,
WriteFlusher.Listener,
HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    public static final HttpField CONNECTION_CLOSE = new PreEncodedHttpField(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
    public static final String UPGRADE_CONNECTION_ATTRIBUTE = "org.eclipse.jetty.server.HttpConnection.UPGRADE";
    private static final boolean REQUEST_BUFFER_DIRECT = false;
    private static final boolean HEADER_BUFFER_DIRECT = false;
    private static final boolean CHUNK_BUFFER_DIRECT = false;
    private static final ThreadLocal<HttpConnection> __currentConnection = new ThreadLocal();
    private final HttpConfiguration _config;
    private final Connector _connector;
    private final ByteBufferPool _bufferPool;
    private final HttpInput _input;
    private final HttpGenerator _generator;
    private final HttpChannelOverHttp _channel;
    private final HttpParser _parser;
    private final AtomicInteger _contentBufferReferences = new AtomicInteger();
    private volatile ByteBuffer _requestBuffer = null;
    private final BlockingReadCallback _blockingReadCallback = new BlockingReadCallback();
    private final AsyncReadCallback _asyncReadCallback = new AsyncReadCallback();
    private final SendCallback _sendCallback = new SendCallback();
    private final boolean _recordHttpComplianceViolations;
    private final LongAdder bytesIn = new LongAdder();
    private final LongAdder bytesOut = new LongAdder();

    public static HttpConnection getCurrentConnection() {
        return __currentConnection.get();
    }

    /*
     * WARNING - void declaration
     */
    protected static HttpConnection setCurrentConnection(HttpConnection connection) {
        void var1_1;
        HttpConnection httpConnection;
        HttpConnection last = __currentConnection.get();
        __currentConnection.set(httpConnection);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection(HttpConfiguration config, Connector connector, EndPoint endPoint, HttpCompliance compliance, boolean recordComplianceViolations) {
        super((EndPoint)var3_3, connector.getExecutor());
        void var2_2;
        void var1_1;
        void var3_3;
        this._config = var1_1;
        this._connector = var2_2;
        this._bufferPool = this._connector.getByteBufferPool();
        this._generator = this.newHttpGenerator();
        this._channel = this.newHttpChannel();
        this._input = this._channel.getRequest().getHttpInput();
        this._parser = this.newHttpParser(compliance);
        this._recordHttpComplianceViolations = recordComplianceViolations;
        if (LOG.isDebugEnabled()) {
            LOG.debug("New HTTP Connection {}", new Object[]{this});
        }
    }

    @Deprecated
    public HttpCompliance getHttpCompliance() {
        return this._parser.getHttpCompliance();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._config;
    }

    public boolean isRecordHttpComplianceViolations() {
        return this._recordHttpComplianceViolations;
    }

    protected HttpGenerator newHttpGenerator() {
        return new HttpGenerator(this._config.getSendServerVersion(), this._config.getSendXPoweredBy());
    }

    protected HttpChannelOverHttp newHttpChannel() {
        HttpConnection httpConnection = this;
        return new HttpChannelOverHttp(httpConnection, httpConnection._connector, this._config, this.getEndPoint(), this);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpParser newHttpParser(HttpCompliance compliance) {
        void var1_1;
        return new HttpParser(this.newRequestHandler(), this.getHttpConfiguration().getRequestHeaderSize(), (HttpCompliance)var1_1);
    }

    protected HttpParser.RequestHandler newRequestHandler() {
        return this._channel;
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    public HttpParser getParser() {
        return this._parser;
    }

    public HttpGenerator getGenerator() {
        return this._generator;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return this.getEndPoint().isOptimizedForDirectBuffers();
    }

    public long getMessagesIn() {
        return this.getHttpChannel().getRequests();
    }

    public long getMessagesOut() {
        return this.getHttpChannel().getRequests();
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer onUpgradeFrom() {
        if (BufferUtil.hasContent((ByteBuffer)this._requestBuffer)) {
            void var1_1;
            ByteBuffer unconsumed = ByteBuffer.allocateDirect(this._requestBuffer.remaining());
            unconsumed.put(this._requestBuffer);
            unconsumed.flip();
            this.releaseRequestBuffer();
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void onUpgradeTo(ByteBuffer buffer) {
        void var1_1;
        BufferUtil.append((ByteBuffer)this.getRequestBuffer(), (ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void onFlushed(long bytes) throws IOException {
        void var1_1;
        this._channel.getResponse().getHttpOutput().onFlushed((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void releaseRequestBuffer() {
        if (this._requestBuffer != null && !this._requestBuffer.hasRemaining()) {
            void var1_1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("releaseRequestBuffer {}", new Object[]{this});
            }
            ByteBuffer buffer = this._requestBuffer;
            this._requestBuffer = null;
            this._bufferPool.release((ByteBuffer)var1_1);
        }
    }

    public ByteBuffer getRequestBuffer() {
        if (this._requestBuffer == null) {
            this._requestBuffer = this._bufferPool.acquire(this.getInputBufferSize(), false);
        }
        return this._requestBuffer;
    }

    public boolean isRequestBufferEmpty() {
        return BufferUtil.isEmpty((ByteBuffer)this._requestBuffer);
    }

    /*
     * WARNING - void declaration
     */
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillable enter {} {}", new Object[]{this, this._channel.getState(), BufferUtil.toDetailString((ByteBuffer)this._requestBuffer)});
        }
        HttpConnection last = HttpConnection.setCurrentConnection(this);
        try {
            while (this.getEndPoint().isOpen()) {
                void var3_5;
                int filled = this.fillRequestBuffer();
                if (filled < 0 && this.getEndPoint().isOutputShutdown()) {
                    this.close();
                }
                boolean handle = this.parseRequestBuffer();
                if (this.getEndPoint().getConnection() != this) break;
                if (var3_5 != false) {
                    filled = !this._channel.handle() ? 1 : 0;
                    if (filled != 0 || this.getEndPoint().getConnection() != this) break;
                    continue;
                }
                if (filled == 0) {
                    this.fillInterested();
                    break;
                }
                if (filled >= 0) continue;
                if (!this._channel.getState().isIdle()) break;
                this.getEndPoint().shutdownOutput();
                break;
            }
        }
        catch (Throwable x) {
            try {
                if (LOG.isDebugEnabled()) {
                    void var2_3;
                    LOG.debug("{} caught exception {}", new Object[]{this, this._channel.getState(), var2_3});
                }
                BufferUtil.clear((ByteBuffer)this._requestBuffer);
                this.releaseRequestBuffer();
                this.close();
            }
            catch (Throwable throwable) {
                void var1_1;
                HttpConnection.setCurrentConnection((HttpConnection)var1_1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} onFillable exit {} {}", new Object[]{this, this._channel.getState(), BufferUtil.toDetailString((ByteBuffer)this._requestBuffer)});
                }
                throw throwable;
            }
            HttpConnection.setCurrentConnection(last);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} onFillable exit {} {}", new Object[]{this, this._channel.getState(), BufferUtil.toDetailString((ByteBuffer)this._requestBuffer)});
                return;
            }
        }
        HttpConnection.setCurrentConnection(last);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillable exit {} {}", new Object[]{this, this._channel.getState(), BufferUtil.toDetailString((ByteBuffer)this._requestBuffer)});
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean fillAndParseForContent() {
        void var1_1;
        if (this._parser.isTerminated()) {
            throw new IllegalStateException("Parser is terminated: " + this._parser);
        }
        boolean handled = false;
        while (this._parser.inContentState()) {
            void var2_2;
            int filled = this.fillRequestBuffer();
            handled = this.parseRequestBuffer();
            if (!handled && var2_2 > 0 && !this._input.hasContent()) continue;
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int fillRequestBuffer() {
        if (this._contentBufferReferences.get() > 0) {
            throw new IllegalStateException("fill with unconsumed content on " + this);
        }
        if (BufferUtil.isEmpty((ByteBuffer)this._requestBuffer)) {
            this._requestBuffer = this.getRequestBuffer();
            try {
                int filled = this.getEndPoint().fill(this._requestBuffer);
                if (filled == 0) {
                    filled = this.getEndPoint().fill(this._requestBuffer);
                }
                if (filled > 0) {
                    this.bytesIn.add(filled);
                } else if (filled < 0) {
                    this._parser.atEOF();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} filled {} {}", new Object[]{this, filled, BufferUtil.toDetailString((ByteBuffer)this._requestBuffer)});
                }
                return filled;
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    void var1_2;
                    LOG.debug((Throwable)var1_2);
                }
                this._parser.atEOF();
                return -1;
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseRequestBuffer() {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} parse {} {}", new Object[]{this, BufferUtil.toDetailString((ByteBuffer)this._requestBuffer)});
        }
        boolean handle = this._parser.parseNext(this._requestBuffer == null ? BufferUtil.EMPTY_BUFFER : this._requestBuffer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} parsed {} {}", new Object[]{this, handle, this._parser});
        }
        if (this._contentBufferReferences.get() == 0) {
            this.releaseRequestBuffer();
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onCompleted() {
        Connection connection;
        if (this.isFillInterested()) {
            LOG.warn("Pending read in onCompleted {} {}", new Object[]{this, this.getEndPoint()});
            ((HttpChannel)this._channel).abort(new IOException("Pending read in onCompleted"));
        } else if (this._channel.getResponse().getStatus() == 101 && (connection = (Connection)this._channel.getRequest().getAttribute(UPGRADE_CONNECTION_ATTRIBUTE)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Upgrade from {} to {}", new Object[]{this, connection});
            }
            this._channel.getState().upgrade();
            this.getEndPoint().upgrade(connection);
            ((HttpChannel)this._channel).recycle();
            this._parser.reset();
            this._generator.reset();
            if (this._contentBufferReferences.get() == 0) {
                this.releaseRequestBuffer();
                return;
            }
            LOG.warn("{} lingering content references?!?!", new Object[]{this});
            this._requestBuffer = null;
            this._contentBufferReferences.set(0);
            return;
        }
        boolean complete = this._input.consumeAll();
        if (((HttpChannel)this._channel).isExpecting100Continue()) {
            this._parser.close();
        } else if (this._generator.isPersistent() && !complete) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unconsumed input {} {}", new Object[]{this, this._parser});
            }
            ((HttpChannel)this._channel).abort(new IOException("unconsumed input"));
        }
        ((HttpChannel)this._channel).recycle();
        if (!this._parser.isClosed()) {
            if (this._generator.isPersistent()) {
                this._parser.reset();
            } else {
                this._parser.close();
            }
        }
        this._generator.reset();
        if (HttpConnection.getCurrentConnection() != this) {
            if (this._parser.isStart()) {
                if (BufferUtil.isEmpty((ByteBuffer)this._requestBuffer)) {
                    this.fillInterested();
                    return;
                }
                if (this.getConnector().isRunning()) {
                    try {
                        this.getExecutor().execute(this);
                        return;
                    }
                    catch (RejectedExecutionException e) {
                        if (this.getConnector().isRunning()) {
                            LOG.warn((Throwable)e);
                        } else {
                            void var1_3;
                            LOG.ignore((Throwable)var1_3);
                        }
                        this.getEndPoint().close();
                        return;
                    }
                }
                this.getEndPoint().close();
                return;
            }
            if (this.getEndPoint().isOpen()) {
                this.fillInterested();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean onReadTimeout(Throwable timeout) {
        void var1_1;
        return this._channel.onIdleTimeout((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void onFillInterestedFailed(Throwable cause) {
        void var1_1;
        this._parser.close();
        super.onFillInterestedFailed((Throwable)var1_1);
    }

    public void onOpen() {
        super.onOpen();
        if (this.isRequestBufferEmpty()) {
            this.fillInterested();
            return;
        }
        this.getExecutor().execute(this);
    }

    public void onClose() {
        this._sendCallback.close();
        super.onClose();
    }

    @Override
    public void run() {
        this.onFillable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(MetaData.Response info, boolean head, ByteBuffer content, boolean lastContent, Callback callback) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (info == null) {
            if (!lastContent && BufferUtil.isEmpty((ByteBuffer)content)) {
                callback.succeeded();
                return;
            }
        } else if (((HttpChannel)this._channel).isExpecting100Continue()) {
            this._generator.setPersistent(false);
        }
        if (SendCallback.access$300(this._sendCallback, (MetaData.Response)var1_1, (boolean)var2_2, (ByteBuffer)var3_3, lastContent, callback)) {
            this._sendCallback.iterate();
        }
    }

    /*
     * WARNING - void declaration
     */
    HttpInput.Content newContent(ByteBuffer c) {
        void var1_1;
        return new Content((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void abort(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("abort {} {}", new Object[]{this, var1_1});
        }
        this.getEndPoint().close();
    }

    @Override
    public boolean isPushSupported() {
        return false;
    }

    @Override
    public void push(MetaData.Request request) {
        LOG.debug("ignore push in {}", new Object[]{this});
    }

    public void asyncReadFillInterested() {
        this.getEndPoint().fillInterested((Callback)this._asyncReadCallback);
    }

    public void blockingReadFillInterested() {
        this.getEndPoint().tryFillInterested((Callback)this._blockingReadCallback);
    }

    /*
     * WARNING - void declaration
     */
    public void blockingReadFailure(Throwable e) {
        void var1_1;
        this._blockingReadCallback.failed((Throwable)var1_1);
    }

    public long getBytesIn() {
        return this.bytesIn.longValue();
    }

    public long getBytesOut() {
        return this.bytesOut.longValue();
    }

    public String toConnectionString() {
        return String.format("%s@%x[p=%s,g=%s]=>%s", this.getClass().getSimpleName(), this.hashCode(), this._parser, this._generator, this._channel);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1200(HttpConnection x0, Callback x1, Throwable x2) {
        void var2_2;
        void var1_1;
        x0.failedCallback((Callback)var1_1, (Throwable)var2_2);
    }

    private class SendCallback
    extends IteratingCallback {
        private MetaData.Response _info;
        private boolean _head;
        private ByteBuffer _content;
        private boolean _lastContent;
        private Callback _callback;
        private ByteBuffer _header;
        private ByteBuffer _chunk;
        private boolean _shutdownOut;

        private SendCallback() {
            super(true);
        }

        public Invocable.InvocationType getInvocationType() {
            return this._callback.getInvocationType();
        }

        /*
         * WARNING - void declaration
         */
        private boolean reset(MetaData.Response info, boolean head, ByteBuffer content, boolean last, Callback callback) {
            if (this.reset()) {
                void var3_3;
                void var2_2;
                void var1_1;
                this._info = var1_1;
                this._head = var2_2;
                this._content = var3_3;
                this._lastContent = last;
                this._callback = callback;
                this._header = null;
                this._shutdownOut = false;
                if (HttpConnection.this.getConnector().isShutdown()) {
                    HttpConnection.this._generator.setPersistent(false);
                }
                return true;
            }
            if (this.isClosed()) {
                callback.failed((Throwable)new EofException());
            } else {
                callback.failed((Throwable)new WritePendingException());
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public IteratingCallback.Action process() throws Exception {
            void var1_1;
            if (this._callback == null) {
                throw new IllegalStateException();
            }
            block20: while (true) {
                HttpGenerator.Result result = HttpConnection.this._generator.generateResponse(this._info, this._head, this._header, this._chunk, this._content, this._lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("generate: {} for {} ({},{},{})@{}", new Object[]{result, this, BufferUtil.toSummaryString((ByteBuffer)this._header), BufferUtil.toSummaryString((ByteBuffer)this._content), this._lastContent, HttpConnection.this._generator.getState()});
                }
                switch (result) {
                    case NEED_INFO: {
                        throw new EofException("request lifecycle violation");
                    }
                    case NEED_HEADER: {
                        this._header = HttpConnection.this._bufferPool.acquire(Math.min(HttpConnection.this._config.getResponseHeaderSize(), HttpConnection.this._config.getOutputBufferSize()), false);
                        continue block20;
                    }
                    case HEADER_OVERFLOW: {
                        if (this._header.capacity() >= HttpConnection.this._config.getResponseHeaderSize()) {
                            throw new BadMessageException(500, "Response header too large");
                        }
                        this.releaseHeader();
                        this._header = HttpConnection.this._bufferPool.acquire(HttpConnection.this._config.getResponseHeaderSize(), false);
                        continue block20;
                    }
                    case NEED_CHUNK: {
                        this._chunk = HttpConnection.this._bufferPool.acquire(12, false);
                        continue block20;
                    }
                    case NEED_CHUNK_TRAILER: {
                        this.releaseChunk();
                        this._chunk = HttpConnection.this._bufferPool.acquire(HttpConnection.this._config.getResponseHeaderSize(), false);
                        continue block20;
                    }
                    case FLUSH: {
                        void var1_2;
                        void var3_3;
                        if (this._head || HttpConnection.this._generator.isNoContent()) {
                            BufferUtil.clear((ByteBuffer)this._chunk);
                            BufferUtil.clear((ByteBuffer)this._content);
                        }
                        int gatherWrite = 0;
                        long bytes = 0L;
                        if (BufferUtil.hasContent((ByteBuffer)this._header)) {
                            gatherWrite = 4;
                            bytes = 0L + (long)this._header.remaining();
                        }
                        if (BufferUtil.hasContent((ByteBuffer)this._chunk)) {
                            gatherWrite = (byte)(gatherWrite + 2);
                            bytes += (long)this._chunk.remaining();
                        }
                        if (BufferUtil.hasContent((ByteBuffer)this._content)) {
                            gatherWrite = (byte)(gatherWrite + 1);
                            bytes += (long)this._content.remaining();
                        }
                        HttpConnection.this.bytesOut.add((long)var3_3);
                        switch (var1_2) {
                            case 7: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._header, this._chunk, this._content});
                                break;
                            }
                            case 6: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._header, this._chunk});
                                break;
                            }
                            case 5: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._header, this._content});
                                break;
                            }
                            case 4: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._header});
                                break;
                            }
                            case 3: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._chunk, this._content});
                                break;
                            }
                            case 2: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._chunk});
                                break;
                            }
                            case 1: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._content});
                                break;
                            }
                            default: {
                                this.succeeded();
                            }
                        }
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        this._shutdownOut = true;
                        continue block20;
                    }
                    case DONE: {
                        if (HttpConnection.this.getConnector().isShutdown() && HttpConnection.this._generator.isEnd() && HttpConnection.this._generator.isPersistent()) {
                            this._shutdownOut = true;
                        }
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        continue block20;
                    }
                }
                break;
            }
            throw new IllegalStateException("generateResponse=" + var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private Callback release() {
            void var1_1;
            Callback complete = this._callback;
            this._callback = null;
            this._info = null;
            this._content = null;
            this.releaseHeader();
            this.releaseChunk();
            return var1_1;
        }

        private void releaseHeader() {
            if (this._header != null) {
                HttpConnection.this._bufferPool.release(this._header);
            }
            this._header = null;
        }

        private void releaseChunk() {
            if (this._chunk != null) {
                HttpConnection.this._bufferPool.release(this._chunk);
            }
            this._chunk = null;
        }

        protected void onCompleteSuccess() {
            this.release().succeeded();
            if (this._shutdownOut) {
                HttpConnection.this.getEndPoint().shutdownOutput();
            }
        }

        /*
         * WARNING - void declaration
         */
        public void onCompleteFailure(Throwable x) {
            void var1_1;
            HttpConnection.access$1200(HttpConnection.this, this.release(), (Throwable)var1_1);
            if (this._shutdownOut) {
                HttpConnection.this.getEndPoint().shutdownOutput();
            }
        }

        public String toString() {
            return String.format("%s[i=%s,cb=%s]", super.toString(), this._info, this._callback);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$300(SendCallback x0, MetaData.Response x1, boolean x2, ByteBuffer x3, boolean x4, Callback x5) {
            void var3_3;
            void var2_2;
            void var1_1;
            return x0.reset((MetaData.Response)var1_1, (boolean)var2_2, (ByteBuffer)var3_3, x4, x5);
        }
    }

    private class AsyncReadCallback
    implements Callback {
        private AsyncReadCallback() {
        }

        public void succeeded() {
            if (HttpConnection.this._channel.getState().onReadPossible()) {
                HttpConnection.this._channel.handle();
            }
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            if (HttpConnection.this._input.failed((Throwable)var1_1)) {
                HttpConnection.this._channel.handle();
            }
        }
    }

    private class BlockingReadCallback
    implements Callback {
        private BlockingReadCallback() {
        }

        public void succeeded() {
            HttpConnection.this._input.unblock();
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            HttpConnection.this._input.failed((Throwable)var1_1);
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }

    private class Content
    extends HttpInput.Content {
        /*
         * WARNING - void declaration
         */
        public Content(ByteBuffer content) {
            void var2_2;
            super((ByteBuffer)var2_2);
            HttpConnection.this._contentBufferReferences.incrementAndGet();
        }

        public void succeeded() {
            if (HttpConnection.this._contentBufferReferences.decrementAndGet() == 0) {
                HttpConnection.this.releaseRequestBuffer();
            }
        }

        public void failed(Throwable x) {
            this.succeeded();
        }
    }
}

