/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.MultiPartFormDataCompliance;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.TreeTrie;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="HTTP Configuration")
public class HttpConfiguration
implements Dumpable {
    private static final Logger LOG = Log.getLogger(HttpConfiguration.class);
    public static final String SERVER_VERSION = "Jetty(" + Jetty.VERSION + ")";
    private final List<Customizer> _customizers = new CopyOnWriteArrayList<Customizer>();
    private final Trie<Boolean> _formEncodedMethods = new TreeTrie();
    private int _outputBufferSize = 32768;
    private int _outputAggregationSize = this._outputBufferSize / 4;
    private int _requestHeaderSize = 8192;
    private int _responseHeaderSize = 8192;
    private int _headerCacheSize = 1024;
    private int _securePort;
    private long _idleTimeout = -1L;
    private long _blockingTimeout = -1L;
    private String _secureScheme = HttpScheme.HTTPS.asString();
    private boolean _sendServerVersion = true;
    private boolean _sendXPoweredBy = false;
    private boolean _sendDateHeader = true;
    private boolean _delayDispatchUntilContent = true;
    private boolean _persistentConnectionsEnabled = true;
    private int _maxErrorDispatches = 10;
    private long _minRequestDataRate;
    private long _minResponseDataRate;
    private CookieCompliance _requestCookieCompliance = CookieCompliance.RFC6265;
    private CookieCompliance _responseCookieCompliance = CookieCompliance.RFC6265;
    private MultiPartFormDataCompliance _multiPartCompliance = MultiPartFormDataCompliance.LEGACY;
    private boolean _notifyRemoteAsyncErrors = true;
    private boolean _relativeRedirectAllowed;
    private HostPort _serverAuthority;
    private SocketAddress _localAddress;

    public HttpConfiguration() {
        this._formEncodedMethods.put(HttpMethod.POST.asString(), (Object)Boolean.TRUE);
        this._formEncodedMethods.put(HttpMethod.PUT.asString(), (Object)Boolean.TRUE);
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfiguration(HttpConfiguration config) {
        void var1_1;
        this._customizers.addAll(config._customizers);
        for (String s : config._formEncodedMethods.keySet()) {
            void var3_3;
            this._formEncodedMethods.put((String)var3_3, (Object)Boolean.TRUE);
        }
        this._outputBufferSize = config._outputBufferSize;
        this._outputAggregationSize = config._outputAggregationSize;
        this._requestHeaderSize = config._requestHeaderSize;
        this._responseHeaderSize = config._responseHeaderSize;
        this._headerCacheSize = config._headerCacheSize;
        this._secureScheme = config._secureScheme;
        this._securePort = config._securePort;
        this._idleTimeout = config._idleTimeout;
        this._blockingTimeout = config._blockingTimeout;
        this._sendDateHeader = config._sendDateHeader;
        this._sendServerVersion = config._sendServerVersion;
        this._sendXPoweredBy = config._sendXPoweredBy;
        this._delayDispatchUntilContent = config._delayDispatchUntilContent;
        this._persistentConnectionsEnabled = config._persistentConnectionsEnabled;
        this._maxErrorDispatches = config._maxErrorDispatches;
        this._minRequestDataRate = config._minRequestDataRate;
        this._minResponseDataRate = config._minResponseDataRate;
        this._requestCookieCompliance = config._requestCookieCompliance;
        this._responseCookieCompliance = config._responseCookieCompliance;
        this._multiPartCompliance = config._multiPartCompliance;
        this._notifyRemoteAsyncErrors = config._notifyRemoteAsyncErrors;
        this._relativeRedirectAllowed = config._relativeRedirectAllowed;
        this._serverAuthority = config._serverAuthority;
        this._localAddress = var1_1._localAddress;
    }

    /*
     * WARNING - void declaration
     */
    public void addCustomizer(Customizer customizer) {
        void var1_1;
        this._customizers.add((Customizer)var1_1);
    }

    public List<Customizer> getCustomizers() {
        return this._customizers;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T getCustomizer(Class<T> type) {
        for (Customizer c : this._customizers) {
            void var3_3;
            if (!type.isAssignableFrom(c.getClass())) continue;
            return var3_3;
        }
        return null;
    }

    @ManagedAttribute(value="The size in bytes of the output buffer used to aggregate HTTP output")
    public int getOutputBufferSize() {
        return this._outputBufferSize;
    }

    @ManagedAttribute(value="The maximum size in bytes for HTTP output to be aggregated")
    public int getOutputAggregationSize() {
        return this._outputAggregationSize;
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for an HTTP request header")
    public int getRequestHeaderSize() {
        return this._requestHeaderSize;
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for an HTTP response header")
    public int getResponseHeaderSize() {
        return this._responseHeaderSize;
    }

    @ManagedAttribute(value="The maximum allowed size in Trie nodes for an HTTP header field cache")
    public int getHeaderCacheSize() {
        return this._headerCacheSize;
    }

    @ManagedAttribute(value="The port to which Integral or Confidential security constraints are redirected")
    public int getSecurePort() {
        return this._securePort;
    }

    @ManagedAttribute(value="The scheme with which Integral or Confidential security constraints are redirected")
    public String getSecureScheme() {
        return this._secureScheme;
    }

    @ManagedAttribute(value="Whether persistent connections are enabled")
    public boolean isPersistentConnectionsEnabled() {
        return this._persistentConnectionsEnabled;
    }

    @ManagedAttribute(value="The idle timeout in ms for I/O operations during the handling of an HTTP request")
    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setIdleTimeout(long timeoutMs) {
        void var1_1;
        this._idleTimeout = var1_1;
    }

    @ManagedAttribute(value="Total timeout in ms for blocking I/O operations. DEPRECATED!", readonly=true)
    @Deprecated
    public long getBlockingTimeout() {
        return this._blockingTimeout;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setBlockingTimeout(long blockingTimeout) {
        void var1_1;
        if (blockingTimeout > 0L) {
            LOG.warn("HttpConfiguration.setBlockingTimeout is deprecated!", new Object[0]);
        }
        this._blockingTimeout = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setPersistentConnectionsEnabled(boolean persistentConnectionsEnabled) {
        void var1_1;
        this._persistentConnectionsEnabled = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSendServerVersion(boolean sendServerVersion) {
        void var1_1;
        this._sendServerVersion = var1_1;
    }

    @ManagedAttribute(value="Whether to send the Server header in responses")
    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    /*
     * WARNING - void declaration
     */
    public void writePoweredBy(Appendable out, String preamble, String postamble) throws IOException {
        if (this.getSendServerVersion()) {
            if (preamble != null) {
                void var2_2;
                out.append((CharSequence)var2_2);
            }
            out.append(Jetty.POWERED_BY);
            if (postamble != null) {
                void var3_3;
                void var1_1;
                var1_1.append((CharSequence)var3_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSendXPoweredBy(boolean sendXPoweredBy) {
        void var1_1;
        this._sendXPoweredBy = var1_1;
    }

    @ManagedAttribute(value="Whether to send the X-Powered-By header in responses")
    public boolean getSendXPoweredBy() {
        return this._sendXPoweredBy;
    }

    /*
     * WARNING - void declaration
     */
    public void setSendDateHeader(boolean sendDateHeader) {
        void var1_1;
        this._sendDateHeader = var1_1;
    }

    @ManagedAttribute(value="Whether to send the Date header in responses")
    public boolean getSendDateHeader() {
        return this._sendDateHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setDelayDispatchUntilContent(boolean delay) {
        void var1_1;
        this._delayDispatchUntilContent = var1_1;
    }

    @ManagedAttribute(value="Whether to delay the application dispatch until content is available")
    public boolean isDelayDispatchUntilContent() {
        return this._delayDispatchUntilContent;
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomizers(List<Customizer> customizers) {
        void var1_1;
        this._customizers.clear();
        this._customizers.addAll((Collection<Customizer>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setOutputBufferSize(int outputBufferSize) {
        void var1_1;
        this._outputBufferSize = outputBufferSize;
        this.setOutputAggregationSize((int)(var1_1 / 4));
    }

    /*
     * WARNING - void declaration
     */
    public void setOutputAggregationSize(int outputAggregationSize) {
        void var1_1;
        this._outputAggregationSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestHeaderSize(int requestHeaderSize) {
        void var1_1;
        this._requestHeaderSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setResponseHeaderSize(int responseHeaderSize) {
        void var1_1;
        this._responseHeaderSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setHeaderCacheSize(int headerCacheSize) {
        void var1_1;
        if (headerCacheSize > 65534) {
            throw new IllegalArgumentException("headerCacheSize " + headerCacheSize + " exceeds maximum value of 65534");
        }
        this._headerCacheSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSecurePort(int securePort) {
        void var1_1;
        this._securePort = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSecureScheme(String secureScheme) {
        void var1_1;
        this._secureScheme = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFormEncodedMethods(String ... methods) {
        void var1_1;
        this._formEncodedMethods.clear();
        for (void method : var1_1) {
            this.addFormEncodedMethod((String)method);
        }
    }

    public Set<String> getFormEncodedMethods() {
        return this._formEncodedMethods.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public void addFormEncodedMethod(String method) {
        void var1_1;
        this._formEncodedMethods.put((String)var1_1, (Object)Boolean.TRUE);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFormEncodedMethod(String method) {
        void var1_1;
        return Boolean.TRUE.equals(this._formEncodedMethods.get((String)var1_1));
    }

    @ManagedAttribute(value="The maximum ERROR dispatches for a request for loop prevention (default 10)")
    public int getMaxErrorDispatches() {
        return this._maxErrorDispatches;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxErrorDispatches(int max) {
        void var1_1;
        this._maxErrorDispatches = var1_1;
    }

    @ManagedAttribute(value="The minimum request content data rate in bytes per second")
    public long getMinRequestDataRate() {
        return this._minRequestDataRate;
    }

    /*
     * WARNING - void declaration
     */
    public void setMinRequestDataRate(long bytesPerSecond) {
        void var1_1;
        this._minRequestDataRate = var1_1;
    }

    @ManagedAttribute(value="The minimum response content data rate in bytes per second")
    public long getMinResponseDataRate() {
        return this._minResponseDataRate;
    }

    /*
     * WARNING - void declaration
     */
    public void setMinResponseDataRate(long bytesPerSecond) {
        void var1_1;
        this._minResponseDataRate = var1_1;
    }

    public CookieCompliance getRequestCookieCompliance() {
        return this._requestCookieCompliance;
    }

    public CookieCompliance getResponseCookieCompliance() {
        return this._responseCookieCompliance;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestCookieCompliance(CookieCompliance cookieCompliance) {
        void var1_1;
        this._requestCookieCompliance = cookieCompliance == null ? CookieCompliance.RFC6265 : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setResponseCookieCompliance(CookieCompliance cookieCompliance) {
        void var1_1;
        this._responseCookieCompliance = cookieCompliance == null ? CookieCompliance.RFC6265 : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setCookieCompliance(CookieCompliance compliance) {
        void var1_1;
        this.setRequestCookieCompliance((CookieCompliance)var1_1);
    }

    @Deprecated
    public CookieCompliance getCookieCompliance() {
        return this.getRequestCookieCompliance();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean isCookieCompliance(CookieCompliance compliance) {
        void var1_1;
        return this._requestCookieCompliance.equals((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMultiPartFormDataCompliance(MultiPartFormDataCompliance multiPartCompliance) {
        void var1_1;
        this._multiPartCompliance = multiPartCompliance == null ? MultiPartFormDataCompliance.LEGACY : var1_1;
    }

    public MultiPartFormDataCompliance getMultipartFormDataCompliance() {
        return this._multiPartCompliance;
    }

    /*
     * WARNING - void declaration
     */
    public void setNotifyRemoteAsyncErrors(boolean notifyRemoteAsyncErrors) {
        void var1_1;
        this._notifyRemoteAsyncErrors = var1_1;
    }

    @ManagedAttribute(value="Whether remote errors, when detected, are notified to async applications")
    public boolean isNotifyRemoteAsyncErrors() {
        return this._notifyRemoteAsyncErrors;
    }

    /*
     * WARNING - void declaration
     */
    public void setRelativeRedirectAllowed(boolean allowed) {
        void var1_1;
        this._relativeRedirectAllowed = var1_1;
    }

    @ManagedAttribute(value="Whether relative redirection locations are allowed")
    public boolean isRelativeRedirectAllowed() {
        return this._relativeRedirectAllowed;
    }

    @ManagedAttribute(value="Local SocketAddress override")
    public SocketAddress getLocalAddress() {
        return this._localAddress;
    }

    /*
     * WARNING - void declaration
     */
    public void setLocalAddress(SocketAddress localAddress) {
        void var1_1;
        this._localAddress = var1_1;
    }

    @ManagedAttribute(value="The server authority if none provided by requests")
    public HostPort getServerAuthority() {
        return this._serverAuthority;
    }

    /*
     * WARNING - void declaration
     */
    public void setServerAuthority(HostPort authority) {
        void var1_1;
        if (authority == null) {
            this._serverAuthority = null;
            return;
        }
        if (!authority.hasHost()) {
            throw new IllegalStateException("Server Authority must have host declared");
        }
        this._serverAuthority = var1_1;
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        Dumpable.dumpObjects((Appendable)out, (String)var2_2, (Object)this, (Object[])new Object[]{new DumpableCollection("customizers", this._customizers), new DumpableCollection("formEncodedMethods", (Collection)this._formEncodedMethods.keySet()), "outputBufferSize=" + this._outputBufferSize, "outputAggregationSize=" + this._outputAggregationSize, "requestHeaderSize=" + this._requestHeaderSize, "responseHeaderSize=" + this._responseHeaderSize, "headerCacheSize=" + this._headerCacheSize, "secureScheme=" + this._secureScheme, "securePort=" + this._securePort, "idleTimeout=" + this._idleTimeout, "blockingTimeout=" + this._blockingTimeout, "sendDateHeader=" + this._sendDateHeader, "sendServerVersion=" + this._sendServerVersion, "sendXPoweredBy=" + this._sendXPoweredBy, "delayDispatchUntilContent=" + this._delayDispatchUntilContent, "persistentConnectionsEnabled=" + this._persistentConnectionsEnabled, "maxErrorDispatches=" + this._maxErrorDispatches, "minRequestDataRate=" + this._minRequestDataRate, "minResponseDataRate=" + this._minResponseDataRate, "cookieCompliance=" + this._requestCookieCompliance, "setRequestCookieCompliance=" + this._responseCookieCompliance, "notifyRemoteAsyncErrors=" + this._notifyRemoteAsyncErrors, "relativeRedirectAllowed=" + this._relativeRedirectAllowed});
    }

    public String toString() {
        return String.format("%s@%x{%d/%d,%d/%d,%s://:%d,%s}", this.getClass().getSimpleName(), this.hashCode(), this._outputBufferSize, this._outputAggregationSize, this._requestHeaderSize, this._responseHeaderSize, this._secureScheme, this._securePort, this._customizers);
    }

    public static interface ConnectionFactory {
        public HttpConfiguration getHttpConfiguration();
    }

    public static interface Customizer {
        public void customize(Connector var1, HttpConfiguration var2, Request var3);
    }
}

