/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannelState {
    private static final Logger LOG = Log.getLogger(HttpChannelState.class);
    private static final long DEFAULT_TIMEOUT = Long.getLong("org.eclipse.jetty.server.HttpChannelState.DEFAULT_TIMEOUT", 30000L);
    private final HttpChannel _channel;
    private List<AsyncListener> _asyncListeners;
    private State _state = State.IDLE;
    private RequestState _requestState = RequestState.BLOCKING;
    private OutputState _outputState = OutputState.OPEN;
    private InputState _inputState = InputState.IDLE;
    private boolean _initial = true;
    private boolean _sendError;
    private boolean _asyncWritePossible;
    private long _timeoutMs = DEFAULT_TIMEOUT;
    private AsyncContextEvent _event;
    private Thread _onTimeoutThread;

    /*
     * WARNING - void declaration
     */
    protected HttpChannelState(HttpChannel channel) {
        void var1_1;
        this._channel = var1_1;
    }

    public State getState() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(AsyncListener listener) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            void var1_1;
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add((AsyncListener)var1_1);
            return;
        }
    }

    public boolean hasListener(AsyncListener listener) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._asyncListeners == null) {
                return false;
            }
            for (AsyncListener l : this._asyncListeners) {
                if (l == listener) {
                    return true;
                }
                if (!(l instanceof AsyncContextState.WrappedAsyncListener) || ((AsyncContextState.WrappedAsyncListener)l).getListener() != listener) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isSendError() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._sendError;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeout(long ms) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            void var1_1;
            this._timeoutMs = var1_1;
            return;
        }
    }

    public long getTimeout() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._timeoutMs;
        }
    }

    public AsyncContextEvent getAsyncContextEvent() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._event;
        }
    }

    public String toString() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this.toStringLocked();
        }
    }

    private String toStringLocked() {
        return String.format("%s@%x{%s}", this.getClass().getSimpleName(), this.hashCode(), this.getStatusStringLocked());
    }

    private String getStatusStringLocked() {
        return String.format("s=%s rs=%s os=%s is=%s awp=%b se=%b i=%b al=%d", new Object[]{this._state, this._requestState, this._outputState, this._inputState, this._asyncWritePossible, this._sendError, this._initial, this._asyncListeners == null ? 0 : this._asyncListeners.size()});
    }

    public String getStatusString() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this.getStatusStringLocked();
        }
    }

    public boolean commitResponse() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._outputState) {
                case OPEN: {
                    this._outputState = OutputState.COMMITTED;
                    return true;
                }
            }
            return false;
        }
    }

    public boolean partialResponse() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._outputState) {
                case COMMITTED: {
                    this._outputState = OutputState.OPEN;
                    return true;
                }
            }
            return false;
        }
    }

    public boolean completeResponse() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._outputState) {
                case OPEN: 
                case COMMITTED: {
                    this._outputState = OutputState.COMPLETED;
                    return true;
                }
            }
            return false;
        }
    }

    public boolean isResponseCommitted() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._outputState) {
                case OPEN: {
                    return false;
                }
            }
            return true;
        }
    }

    public boolean isResponseCompleted() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._outputState == OutputState.COMPLETED;
        }
    }

    public boolean abortResponse() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._outputState) {
                case ABORTED: {
                    return false;
                }
                case OPEN: {
                    this._channel.getResponse().setStatus(500);
                    this._outputState = OutputState.ABORTED;
                    return true;
                }
            }
            this._outputState = OutputState.ABORTED;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Action handling() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("handling {}", new Object[]{this.toStringLocked()});
            }
            switch (this._state) {
                case IDLE: {
                    if (this._requestState != RequestState.BLOCKING) {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                    this._initial = true;
                    this._state = State.HANDLING;
                    return Action.DISPATCH;
                }
                case WOKEN: {
                    void var2_2;
                    if (this._event != null && this._event.getThrowable() != null && !this._sendError) {
                        this._state = State.HANDLING;
                        return Action.ASYNC_ERROR;
                    }
                    Action action = this.nextAction(true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("nextAction(true) {} {}", new Object[]{action, this.toStringLocked()});
                    }
                    return var2_2;
                }
            }
            throw new IllegalStateException(this.getStatusStringLocked());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Action unhandle() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            void var2_2;
            if (LOG.isDebugEnabled()) {
                LOG.debug("unhandle {}", new Object[]{this.toStringLocked()});
            }
            if (this._state != State.HANDLING) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            this._initial = false;
            Action action = this.nextAction(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("nextAction(false) {} {}", new Object[]{action, this.toStringLocked()});
            }
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Action nextAction(boolean handling) {
        this._state = State.HANDLING;
        if (this._sendError) {
            switch (this._requestState) {
                case BLOCKING: 
                case ASYNC: 
                case COMPLETE: 
                case DISPATCH: 
                case COMPLETING: {
                    this._requestState = RequestState.BLOCKING;
                    this._sendError = false;
                    return Action.SEND_ERROR;
                }
            }
        }
        switch (this._requestState) {
            case BLOCKING: {
                if (handling) {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                this._requestState = RequestState.COMPLETING;
                return Action.COMPLETE;
            }
            case ASYNC: {
                switch (this._inputState) {
                    case POSSIBLE: {
                        this._inputState = InputState.PRODUCING;
                        return Action.READ_PRODUCE;
                    }
                    case READY: {
                        this._inputState = InputState.IDLE;
                        return Action.READ_CALLBACK;
                    }
                    case REGISTER: 
                    case PRODUCING: {
                        this._inputState = InputState.REGISTERED;
                        return Action.READ_REGISTER;
                    }
                    case IDLE: 
                    case REGISTERED: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                }
                if (this._asyncWritePossible) {
                    this._asyncWritePossible = false;
                    return Action.WRITE_CALLBACK;
                }
                Scheduler scheduler = this._channel.getScheduler();
                if (scheduler != null && this._timeoutMs > 0L && !this._event.hasTimeoutTask()) {
                    void var1_2;
                    this._event.setTimeoutTask(var1_2.schedule((Runnable)this._event, this._timeoutMs, TimeUnit.MILLISECONDS));
                }
                this._state = State.WAITING;
                return Action.WAIT;
            }
            case DISPATCH: {
                this._requestState = RequestState.BLOCKING;
                return Action.ASYNC_DISPATCH;
            }
            case EXPIRE: {
                this._requestState = RequestState.EXPIRING;
                return Action.ASYNC_TIMEOUT;
            }
            case EXPIRING: {
                void var1_1;
                if (var1_1 != false) {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                this.sendError(500, "AsyncContext timeout");
                this._requestState = RequestState.BLOCKING;
                this._sendError = false;
                return Action.SEND_ERROR;
            }
            case COMPLETE: {
                this._requestState = RequestState.COMPLETING;
                return Action.COMPLETE;
            }
            case COMPLETING: {
                this._state = State.WAITING;
                return Action.WAIT;
            }
            case COMPLETED: {
                this._state = State.IDLE;
                return Action.TERMINATED;
            }
        }
        throw new IllegalStateException(this.getStatusStringLocked());
    }

    /*
     * WARNING - void declaration
     */
    public void startAsync(AsyncContextEvent event) {
        List<AsyncListener> lastAsyncListeners;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("startAsync {}", new Object[]{this.toStringLocked()});
            }
            if (this._state != State.HANDLING || this._requestState != RequestState.BLOCKING) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            this._requestState = RequestState.ASYNC;
            this._event = event;
            lastAsyncListeners = this._asyncListeners;
            this._asyncListeners = null;
        }
        if (lastAsyncListeners != null) {
            void var1_1;
            void var2_4;
            Runnable callback = new Runnable(this, (List)var2_4, event){
                final /* synthetic */ List val$lastAsyncListeners;
                final /* synthetic */ AsyncContextEvent val$event;
                final /* synthetic */ HttpChannelState this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lastAsyncListeners = list;
                    this.val$event = asyncContextEvent;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    for (AsyncListener listener : this.val$lastAsyncListeners) {
                        try {
                            listener.onStartAsync((AsyncEvent)this.val$event);
                        }
                        catch (Throwable e) {
                            void var2_3;
                            LOG.warn((Throwable)var2_3);
                        }
                    }
                }

                public String toString() {
                    return "startAsync";
                }
            };
            this.runInContext((AsyncContextEvent)var1_1, (Runnable)((Object)httpChannelState));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dispatch(ServletContext context, String path) {
        void var3_4;
        void var1_1;
        boolean dispatch = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("dispatch {} -> {}", new Object[]{this.toStringLocked(), path});
            }
            switch (this._requestState) {
                case ASYNC: {
                    break;
                }
                case EXPIRING: {
                    if (Thread.currentThread() == this._onTimeoutThread) break;
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            if (context != null) {
                this._event.setDispatchContext(context);
            }
            if (path != null) {
                void var2_3;
                this._event.setDispatchPath((String)var2_3);
            }
            if (this._requestState == RequestState.ASYNC && this._state == State.WAITING) {
                this._state = State.WOKEN;
                dispatch = true;
            }
            this._requestState = RequestState.DISPATCH;
            AsyncContextEvent event = this._event;
        }
        this.cancelTimeout((AsyncContextEvent)var1_1);
        if (var3_4 != false) {
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void timeout() {
        void var1_1;
        boolean dispatch = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timeout {}", new Object[]{this.toStringLocked()});
            }
            if (this._requestState != RequestState.ASYNC) {
                return;
            }
            this._requestState = RequestState.EXPIRE;
            if (this._state == State.WAITING) {
                this._state = State.WOKEN;
                dispatch = true;
            }
        }
        if (var1_1 != false) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatch after async timeout {}", new Object[]{this});
            }
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onTimeout() {
        List<AsyncListener> listeners;
        AsyncContextEvent event;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onTimeout {}", new Object[]{this.toStringLocked()});
            }
            if (this._requestState != RequestState.EXPIRING || this._state != State.HANDLING) {
                throw new IllegalStateException(this.toStringLocked());
            }
            event = this._event;
            listeners = this._asyncListeners;
            this._onTimeoutThread = Thread.currentThread();
        }
        try {
            if (listeners != null) {
                HttpChannelState httpChannelState2;
                void var1_3;
                Runnable task = new Runnable(this, (List)var1_3, event){
                    final /* synthetic */ List val$listeners;
                    final /* synthetic */ AsyncContextEvent val$event;
                    final /* synthetic */ HttpChannelState this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$listeners = list;
                        this.val$event = asyncContextEvent;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void run() {
                        for (AsyncListener listener : this.val$listeners) {
                            try {
                                listener.onTimeout((AsyncEvent)this.val$event);
                            }
                            catch (Throwable x) {
                                void var3_3;
                                void var2_2;
                                LOG.warn("{} while invoking onTimeout listener {}", new Object[]{x, var2_2, var3_3});
                            }
                        }
                    }

                    public String toString() {
                        return "onTimeout";
                    }
                };
                this.runInContext((AsyncContextEvent)((Object)httpChannelState2), (Runnable)((Object)httpChannelState));
            }
        }
        finally {
            httpChannelState = this;
            synchronized (httpChannelState) {
                this._onTimeoutThread = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void complete() {
        void var1_1;
        AsyncContextEvent event;
        boolean handle = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("complete {}", new Object[]{this.toStringLocked()});
            }
            event = this._event;
            switch (this._requestState) {
                case EXPIRING: {
                    if (Thread.currentThread() != this._onTimeoutThread) {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                    this._requestState = this._sendError ? RequestState.BLOCKING : RequestState.COMPLETE;
                    break;
                }
                case ASYNC: {
                    this._requestState = this._sendError ? RequestState.BLOCKING : RequestState.COMPLETE;
                    break;
                }
                case COMPLETE: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            if (this._state == State.WAITING) {
                handle = true;
                this._state = State.WOKEN;
            }
        }
        this.cancelTimeout(event);
        if (var1_1 != false) {
            void var2_4;
            this.runInContext((AsyncContextEvent)var2_4, this._channel);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void asyncError(Throwable failure) {
        AsyncContextEvent event = null;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("asyncError " + this.toStringLocked(), failure);
            }
            if (this._state == State.WAITING && this._requestState == RequestState.ASYNC) {
                this._state = State.WOKEN;
                this._event.addThrowable(failure);
                event = this._event;
            } else {
                if (!(failure instanceof QuietException)) {
                    LOG.warn(failure.toString(), new Object[0]);
                }
                if (LOG.isDebugEnabled()) {
                    void var1_1;
                    LOG.debug((Throwable)var1_1);
                }
            }
        }
        if (event != null) {
            void var2_3;
            this.cancelTimeout(event);
            this.runInContext((AsyncContextEvent)var2_3, this._channel);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onError(Throwable th) {
        void var2_5;
        void var3_6;
        AsyncContextEvent asyncEvent;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("thrownException " + this.getStatusStringLocked(), th);
            }
            if (this._state != State.HANDLING) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            if (this._sendError) {
                LOG.warn("unhandled due to prior sendError", th);
                return;
            }
            switch (this._requestState) {
                case BLOCKING: {
                    this.sendError(th);
                    return;
                }
                case ASYNC: 
                case COMPLETE: 
                case DISPATCH: {
                    if (this._asyncListeners == null || this._asyncListeners.isEmpty()) {
                        this.sendError(th);
                        return;
                    }
                    asyncEvent = this._event;
                    asyncEvent.addThrowable(th);
                    List<AsyncListener> asyncListeners = this._asyncListeners;
                    break;
                }
                default: {
                    LOG.warn("unhandled in state " + (Object)((Object)this._requestState), (Throwable)new IllegalStateException(th));
                    return;
                }
            }
        }
        this.runInContext(asyncEvent, () -> HttpChannelState.lambda$onError$0((List)var3_6, (AsyncContextEvent)var2_5));
        httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._requestState == RequestState.ASYNC && !this._sendError) {
                this.sendError(th);
            } else if (this._requestState != RequestState.COMPLETE) {
                void var1_1;
                LOG.warn("unhandled in state " + (Object)((Object)this._requestState), (Throwable)new IllegalStateException((Throwable)var1_1));
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendError(Throwable th) {
        void var1_1;
        void var2_2;
        void var3_4;
        void code2;
        String message;
        int code2;
        Request request = this._channel.getRequest();
        Throwable cause = this._channel.unwrap(th, BadMessageException.class, UnavailableException.class);
        if (cause == null) {
            code2 = 500;
            message = th.toString();
        } else if (code2 instanceof BadMessageException) {
            BadMessageException bme = (BadMessageException)code2;
            code2 = bme.getCode();
            message = bme.getReason();
        } else if (code2 instanceof UnavailableException) {
            message = code2.toString();
            code2 = ((UnavailableException)code2).isPermanent() ? 404 : 503;
        } else {
            code2 = 500;
            message = null;
        }
        this.sendError((int)var3_4, message);
        request.setAttribute("javax.servlet.error.exception", th);
        var2_2.setAttribute("javax.servlet.error.exception_type", var1_1.getClass());
        this._requestState = RequestState.BLOCKING;
    }

    /*
     * WARNING - void declaration
     */
    public void sendError(int code, String message) {
        Request request = this._channel.getRequest();
        Response response = this._channel.getResponse();
        if (message == null) {
            message = HttpStatus.getMessage((int)code);
        }
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            void var3_5;
            Throwable cause;
            void var2_4;
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendError {}", new Object[]{this.toStringLocked()});
            }
            if (this._outputState != OutputState.OPEN) {
                throw new IllegalStateException(this._outputState.toString());
            }
            switch (this._state) {
                case WOKEN: 
                case HANDLING: 
                case WAITING: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            response.setStatus(code);
            response.errorClose();
            request.setAttribute("org.eclipse.jetty.server.error_context", (Object)request.getErrorContext());
            request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
            request.setAttribute("javax.servlet.error.servlet_name", request.getServletName());
            request.setAttribute("javax.servlet.error.status_code", code);
            request.setAttribute("javax.servlet.error.message", var2_4);
            this._sendError = true;
            if (this._event != null && (cause = (Throwable)var3_5.getAttribute("javax.servlet.error.exception")) != null) {
                void var1_2;
                this._event.addThrowable((Throwable)var1_2);
            }
            return;
        }
    }

    protected void completing() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("completing {}", new Object[]{this.toStringLocked()});
            }
            switch (this._requestState) {
                case COMPLETED: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._requestState = RequestState.COMPLETING;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void completed(Throwable failure) {
        void var1_1;
        AsyncContextEvent event;
        List<AsyncListener> aListeners;
        boolean handle = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("completed {}", new Object[]{this.toStringLocked()});
            }
            if (this._requestState != RequestState.COMPLETING) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            if (this._event == null) {
                this._requestState = RequestState.COMPLETED;
                aListeners = null;
                event = null;
                if (this._state == State.WAITING) {
                    this._state = State.WOKEN;
                    handle = true;
                }
            } else {
                aListeners = this._asyncListeners;
                event = this._event;
            }
        }
        this._channel.getResponse().getHttpOutput().completed((Throwable)var1_1);
        if (event != null) {
            void var3_7;
            this.cancelTimeout(event);
            if (aListeners != null) {
                void var2_6;
                this.runInContext(event, () -> HttpChannelState.lambda$completed$1((List)var2_6, event));
            }
            var3_7.completed();
            httpChannelState = this;
            synchronized (httpChannelState) {
                this._requestState = RequestState.COMPLETED;
                if (this._state == State.WAITING) {
                    this._state = State.WOKEN;
                    handle = true;
                }
            }
        }
        if (handle) {
            this._channel.handle();
        }
    }

    protected void recycle() {
        this.cancelTimeout();
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("recycle {}", new Object[]{this.toStringLocked()});
            }
            switch (this._state) {
                case HANDLING: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                case UPGRADED: {
                    return;
                }
            }
            this._asyncListeners = null;
            this._state = State.IDLE;
            this._requestState = RequestState.BLOCKING;
            this._outputState = OutputState.OPEN;
            this._initial = true;
            this._inputState = InputState.IDLE;
            this._asyncWritePossible = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
            return;
        }
    }

    public void upgrade() {
        this.cancelTimeout();
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("upgrade {}", new Object[]{this.toStringLocked()});
            }
            switch (this._state) {
                case IDLE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._asyncListeners = null;
            this._state = State.UPGRADED;
            this._requestState = RequestState.BLOCKING;
            this._initial = true;
            this._inputState = InputState.IDLE;
            this._asyncWritePossible = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
            return;
        }
    }

    protected void scheduleDispatch() {
        this._channel.execute(this._channel);
    }

    /*
     * WARNING - void declaration
     */
    protected void cancelTimeout() {
        void var1_2;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            AsyncContextEvent event = this._event;
        }
        this.cancelTimeout((AsyncContextEvent)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void cancelTimeout(AsyncContextEvent event) {
        if (event != null) {
            void var1_1;
            var1_1.cancelTimeoutTask();
        }
    }

    public boolean isIdle() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state == State.IDLE;
        }
    }

    public boolean isExpired() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._requestState == RequestState.EXPIRE || this._requestState == RequestState.EXPIRING;
        }
    }

    public boolean isInitial() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._initial;
        }
    }

    public boolean isSuspended() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state == State.WAITING || this._state == State.HANDLING && this._requestState == RequestState.ASYNC;
        }
    }

    boolean isCompleted() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._requestState == RequestState.COMPLETED;
        }
    }

    public boolean isAsyncStarted() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._state == State.HANDLING) {
                return this._requestState != RequestState.BLOCKING;
            }
            return this._requestState == RequestState.ASYNC || this._requestState == RequestState.EXPIRING;
        }
    }

    public boolean isAsync() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return !this._initial || this._requestState != RequestState.BLOCKING;
        }
    }

    public Request getBaseRequest() {
        return this._channel.getRequest();
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    /*
     * WARNING - void declaration
     */
    public ContextHandler getContextHandler() {
        void var1_2;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            AsyncContextEvent event = this._event;
        }
        return this.getContextHandler((AsyncContextEvent)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    ContextHandler getContextHandler(AsyncContextEvent event) {
        ContextHandler.Context context;
        if (event != null && (context = (ContextHandler.Context)event.getServletContext()) != null) {
            void var1_1;
            return var1_1.getContextHandler();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ServletResponse getServletResponse() {
        void var1_2;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            AsyncContextEvent event = this._event;
        }
        return this.getServletResponse((AsyncContextEvent)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public ServletResponse getServletResponse(AsyncContextEvent event) {
        if (event != null && event.getSuppliedResponse() != null) {
            void var1_1;
            return var1_1.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    /*
     * WARNING - void declaration
     */
    void runInContext(AsyncContextEvent event, Runnable runnable) {
        void var2_2;
        void var1_1;
        ContextHandler contextHandler = this.getContextHandler(event);
        if (contextHandler == null) {
            runnable.run();
            return;
        }
        var1_1.handle(this._channel.getRequest(), (Runnable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String name) {
        void var1_1;
        return this._channel.getRequest().getAttribute((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeAttribute(String name) {
        void var1_1;
        this._channel.getRequest().removeAttribute((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String name, Object attribute) {
        void var2_2;
        void var1_1;
        this._channel.getRequest().setAttribute((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void onReadUnready() {
        void var1_1;
        boolean interested = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onReadUnready {}", new Object[]{this.toStringLocked()});
            }
            switch (this._inputState) {
                case READY: 
                case IDLE: {
                    if (this._state == State.WAITING) {
                        interested = true;
                        this._inputState = InputState.REGISTERED;
                        break;
                    }
                    this._inputState = InputState.REGISTER;
                }
            }
        }
        if (var1_1 != false) {
            this._channel.onAsyncWaitForContent();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean onContentAdded() {
        void var1_1;
        boolean woken = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onContentAdded {}", new Object[]{this.toStringLocked()});
            }
            switch (this._inputState) {
                case READY: 
                case IDLE: {
                    break;
                }
                case PRODUCING: {
                    this._inputState = InputState.READY;
                    break;
                }
                case REGISTER: 
                case REGISTERED: {
                    this._inputState = InputState.READY;
                    if (this._state != State.WAITING) break;
                    woken = true;
                    this._state = State.WOKEN;
                    break;
                }
                case POSSIBLE: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onReadReady() {
        void var1_1;
        boolean woken = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onReadReady {}", new Object[]{this.toStringLocked()});
            }
            switch (this._inputState) {
                case IDLE: {
                    this._inputState = InputState.READY;
                    if (this._state != State.WAITING) break;
                    woken = true;
                    this._state = State.WOKEN;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onReadPossible() {
        void var1_1;
        boolean woken = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onReadPossible {}", new Object[]{this.toStringLocked()});
            }
            switch (this._inputState) {
                case REGISTERED: {
                    this._inputState = InputState.POSSIBLE;
                    if (this._state != State.WAITING) break;
                    woken = true;
                    this._state = State.WOKEN;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onReadEof() {
        void var1_1;
        boolean woken = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onEof {}", new Object[]{this.toStringLocked()});
            }
            this._inputState = InputState.READY;
            if (this._state == State.WAITING) {
                woken = true;
                this._state = State.WOKEN;
            }
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onWritePossible() {
        void var1_1;
        boolean wake = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onWritePossible {}", new Object[]{this.toStringLocked()});
            }
            this._asyncWritePossible = true;
            if (this._state == State.WAITING) {
                this._state = State.WOKEN;
                wake = true;
            }
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$completed$1(List aListeners, AsyncContextEvent event) {
        for (AsyncListener listener : aListeners) {
            try {
                listener.onComplete((AsyncEvent)event);
            }
            catch (Throwable e) {
                void var3_3;
                void var2_2;
                LOG.warn(e + " while invoking onComplete listener " + var2_2, new Object[0]);
                LOG.debug((Throwable)var3_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$onError$0(List asyncListeners, AsyncContextEvent asyncEvent) {
        for (AsyncListener listener : asyncListeners) {
            try {
                listener.onError((AsyncEvent)asyncEvent);
            }
            catch (Throwable x) {
                void var3_3;
                void var2_2;
                LOG.warn(x + " while invoking onError listener " + var2_2, new Object[0]);
                LOG.debug((Throwable)var3_3);
            }
        }
    }

    public static enum Action {
        DISPATCH,
        ASYNC_DISPATCH,
        SEND_ERROR,
        ASYNC_ERROR,
        ASYNC_TIMEOUT,
        WRITE_CALLBACK,
        READ_REGISTER,
        READ_PRODUCE,
        READ_CALLBACK,
        COMPLETE,
        TERMINATED,
        WAIT;

    }

    private static enum OutputState {
        OPEN,
        COMMITTED,
        COMPLETED,
        ABORTED;

    }

    private static enum InputState {
        IDLE,
        REGISTER,
        REGISTERED,
        POSSIBLE,
        PRODUCING,
        READY;

    }

    private static enum RequestState {
        BLOCKING,
        ASYNC,
        DISPATCH,
        EXPIRE,
        EXPIRING,
        COMPLETE,
        COMPLETING,
        COMPLETED;

    }

    public static enum State {
        IDLE,
        HANDLING,
        WAITING,
        WOKEN,
        UPGRADED;

    }
}

