/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpComplianceSection;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpInputOverHTTP;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpChannelOverHttp
extends HttpChannel
implements HttpParser.ComplianceHandler,
HttpParser.RequestHandler {
    private static final Logger LOG = Log.getLogger(HttpChannelOverHttp.class);
    private static final HttpField PREAMBLE_UPGRADE_H2C = new HttpField(HttpHeader.UPGRADE, "h2c");
    private final HttpFields _fields = new HttpFields();
    private final MetaData.Request _metadata = new MetaData.Request(this._fields);
    private final HttpConnection _httpConnection;
    private HttpField _connection;
    private HttpField _upgrade = null;
    private boolean _delayedForContent;
    private boolean _unknownExpectation = false;
    private boolean _expect100Continue = false;
    private boolean _expect102Processing = false;
    private List<String> _complianceViolations;
    private HttpFields _trailers;

    /*
     * WARNING - void declaration
     */
    public HttpChannelOverHttp(HttpConnection httpConnection, Connector connector, HttpConfiguration config, EndPoint endPoint, HttpTransport transport) {
        super((Connector)var2_2, (HttpConfiguration)var3_3, endPoint, transport);
        void var1_1;
        void var3_3;
        void var2_2;
        this._httpConnection = var1_1;
        this._metadata.setURI(new HttpURI());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected HttpInput newHttpInput(HttpChannelState state) {
        void var1_1;
        return new HttpInputOverHTTP((HttpChannelState)var1_1);
    }

    @Override
    public void recycle() {
        super.recycle();
        this._unknownExpectation = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        this._metadata.recycle();
        this._connection = null;
        this._fields.clear();
        this._upgrade = null;
        this._trailers = null;
    }

    @Override
    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    @Override
    public boolean isExpecting102Processing() {
        return this._expect102Processing;
    }

    /*
     * WARNING - void declaration
     */
    public boolean startRequest(String method, String requestTarget, HttpVersion version) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._metadata.setMethod(method);
        this._metadata.getURI().parseRequestTarget((String)var1_1, (String)var2_2);
        this._metadata.setHttpVersion((HttpVersion)var3_3);
        this._unknownExpectation = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void parsedHeader(HttpField field) {
        block15: {
            header = field.getHeader();
            value = field.getValue();
            if (header == null) break block15;
            block0 : switch (1.$SwitchMap$org$eclipse$jetty$http$HttpHeader[header.ordinal()]) {
                case 1: {
                    this._connection = field;
                    break;
                }
                case 2: {
                    if (HttpMethod.CONNECT.is(this._metadata.getMethod()) || this._metadata.getURI().isAbsolute() || !(field instanceof HostPortHttpField)) break;
                    hp = (HostPortHttpField)field;
                    this._metadata.getURI().setAuthority(hp.getHost(), hp.getPort());
                    break;
                }
                case 3: {
                    if (this._metadata.getHttpVersion() != HttpVersion.HTTP_1_1) break;
                    expect = (HttpHeaderValue)HttpHeaderValue.CACHE.get(value);
                    switch (1.$SwitchMap$org$eclipse$jetty$http$HttpHeaderValue[(expect == null ? HttpHeaderValue.UNKNOWN : expect).ordinal()]) {
                        case 1: {
                            this._expect100Continue = true;
                            break block0;
                        }
                        case 2: {
                            this._expect102Processing = true;
                            break block0;
                        }
                    }
                    values = field.getValues();
                    block14: for (i = 0; values != null && i < values.length; ++i) {
                        expect = (HttpHeaderValue)HttpHeaderValue.CACHE.get(values[i].trim());
                        if (expect == null) ** GOTO lbl-1000
                        switch (1.$SwitchMap$org$eclipse$jetty$http$HttpHeaderValue[var2_2.ordinal()]) {
                            case 1: {
                                this._expect100Continue = true;
                                continue block14;
                            }
                            case 2: {
                                this._expect102Processing = true;
                                continue block14;
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                this._unknownExpectation = true;
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    this._upgrade = field;
                }
            }
        }
        this._fields.add((HttpField)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void parsedTrailer(HttpField field) {
        void var1_1;
        if (this._trailers == null) {
            this._trailers = new HttpFields();
        }
        this._trailers.add((HttpField)var1_1);
    }

    @Override
    public void continue100(int available) throws IOException {
        if (((HttpChannel)this).isExpecting100Continue()) {
            boolean bl;
            this._expect100Continue = false;
            if (!bl) {
                if (this.getResponse().isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                bl = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!bl) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    public void earlyEOF() {
        this._httpConnection.getGenerator().setPersistent(false);
        if (this._metadata.getMethod() == null) {
            this._httpConnection.close();
            return;
        }
        if (this.onEarlyEOF() || this._delayedForContent) {
            this._delayedForContent = false;
            this.handle();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean content(ByteBuffer content) {
        void var1_2;
        HttpInput.Content c = this._httpConnection.newContent(content);
        boolean handle = this.onContent(c) || this._delayedForContent;
        this._delayedForContent = false;
        return (boolean)var1_2;
    }

    @Override
    public void onAsyncWaitForContent() {
        this._httpConnection.asyncReadFillInterested();
    }

    @Override
    public void onBlockWaitForContent() {
        this._httpConnection.blockingReadFillInterested();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onBlockWaitForContentFailure(Throwable failure) {
        void var1_1;
        this._httpConnection.blockingReadFailure((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void badMessage(BadMessageException failure) {
        void var1_1;
        this._httpConnection.getGenerator().setPersistent(false);
        try {
            HttpChannelOverHttp httpChannelOverHttp = this;
            httpChannelOverHttp.onRequest(httpChannelOverHttp._metadata);
            this.getRequest().getHttpInput().earlyEOF();
        }
        catch (Exception e) {
            void var2_2;
            LOG.ignore((Throwable)var2_2);
        }
        this.onBadMessage((BadMessageException)var1_1);
    }

    /*
     * Unable to fully structure code
     */
    public boolean headerComplete() {
        if (this._complianceViolations != null && !this._complianceViolations.isEmpty()) {
            this.getRequest().setAttribute("org.eclipse.jetty.http.compliance.violations", this._complianceViolations);
            this._complianceViolations = null;
        }
        switch (1.$SwitchMap$org$eclipse$jetty$http$HttpVersion[this._metadata.getHttpVersion().ordinal()]) {
            case 1: {
                persistent = false;
                break;
            }
            case 2: {
                persistent = this.getHttpConfiguration().isPersistentConnectionsEnabled() ? (this._connection != null ? (this._connection.contains(HttpHeaderValue.KEEP_ALIVE.asString()) ? true : this._fields.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString())) : false) : false;
                if (!persistent) {
                    persistent = HttpMethod.CONNECT.is(this._metadata.getMethod());
                }
                if (!persistent) break;
                this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE);
                break;
            }
            case 3: {
                if (this._unknownExpectation) {
                    this.badMessage(new BadMessageException(417));
                    return false;
                }
                if (!this.getHttpConfiguration().isPersistentConnectionsEnabled()) ** GOTO lbl26
                if (this._connection == null) ** GOTO lbl24
                if (this._connection.contains(HttpHeaderValue.CLOSE.asString())) ** GOTO lbl26
                persistent = this._fields.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString()) == false;
                ** GOTO lbl27
lbl24:
                // 1 sources

                persistent = true;
                ** GOTO lbl27
lbl26:
                // 2 sources

                persistent = false;
lbl27:
                // 3 sources

                if (!persistent) {
                    persistent = HttpMethod.CONNECT.is(this._metadata.getMethod());
                }
                if (!persistent) {
                    this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                }
                if (this._upgrade == null || !this.upgrade()) break;
                return true;
            }
            case 4: {
                this._upgrade = HttpChannelOverHttp.PREAMBLE_UPGRADE_H2C;
                if (HttpMethod.PRI.is(this._metadata.getMethod()) && "*".equals(this._metadata.getURI().toString()) && this._fields.size() == 0 && this.upgrade()) {
                    return true;
                }
                this.badMessage(new BadMessageException(426));
                this._httpConnection.getParser().close();
                return false;
            }
            default: {
                throw new IllegalStateException("unsupported version " + this._metadata.getHttpVersion());
            }
        }
        if (var1_1 == false) {
            this._httpConnection.getGenerator().setPersistent(false);
        }
        v0 = this;
        v0.onRequest(v0._metadata);
        v1 = this._delayedForContent = this.getHttpConfiguration().isDelayDispatchUntilContent() != false && (this._httpConnection.getParser().getContentLength() > 0L || this._httpConnection.getParser().isChunking() != false) && this.isExpecting100Continue() == false && this.isCommitted() == false && this._httpConnection.isRequestBufferEmpty() != false;
        return this._delayedForContent == false;
    }

    /*
     * WARNING - void declaration
     */
    boolean onIdleTimeout(Throwable timeout) {
        if (this._delayedForContent) {
            void var1_1;
            this._delayedForContent = false;
            this.getRequest().getHttpInput().onIdleTimeout((Throwable)var1_1);
            HttpChannelOverHttp httpChannelOverHttp = this;
            httpChannelOverHttp.execute(httpChannelOverHttp);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean upgrade() throws BadMessageException {
        boolean isUpgradedH2C;
        if (LOG.isDebugEnabled()) {
            LOG.debug("upgrade {} {}", new Object[]{this, this._upgrade});
        }
        if (!((isUpgradedH2C = this._upgrade == PREAMBLE_UPGRADE_H2C) || this._connection != null && this._connection.contains("upgrade"))) {
            throw new BadMessageException(400);
        }
        ConnectionFactory.Upgrading factory = null;
        Iterator<ConnectionFactory> iterator = this.getConnector().getConnectionFactories().iterator();
        while (iterator.hasNext()) {
            ConnectionFactory f = iterator.next();
            if (!(f instanceof ConnectionFactory.Upgrading) || !f.getProtocols().contains(this._upgrade.getValue())) continue;
            factory = (ConnectionFactory.Upgrading)f;
            break;
        }
        if (factory == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No factory for {} in {}", new Object[]{this._upgrade, this.getConnector()});
            }
            return false;
        }
        HttpFields response101 = new HttpFields();
        Connection upgradeConnection = factory.upgradeConnection(this.getConnector(), this.getEndPoint(), this._metadata, response101);
        if (upgradeConnection == null) {
            if (LOG.isDebugEnabled()) {
                void var2_3;
                LOG.debug("Upgrade ignored for {} by {}", new Object[]{this._upgrade, var2_3});
            }
            return false;
        }
        try {
            if (!isUpgradedH2C) {
                this.sendResponse(new MetaData.Response(HttpVersion.HTTP_1_1, 101, iterator, 0L), null, true);
            }
        }
        catch (IOException e) {
            void var1_2;
            throw new BadMessageException(500, null, (Throwable)var1_2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Upgrade from {} to {}", new Object[]{this.getEndPoint().getConnection(), upgradeConnection});
        }
        this.getRequest().setAttribute("org.eclipse.jetty.server.HttpConnection.UPGRADE", upgradeConnection);
        this.getResponse().setStatus(101);
        this.getHttpTransport().onCompleted();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void handleException(Throwable x) {
        void var1_1;
        this._httpConnection.getGenerator().setPersistent(false);
        super.handleException((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void abort(Throwable failure) {
        void var1_1;
        super.abort((Throwable)var1_1);
        this._httpConnection.getGenerator().setPersistent(false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean contentComplete() {
        void var1_1;
        boolean handle = this.onContentComplete() || this._delayedForContent;
        this._delayedForContent = false;
        return (boolean)var1_1;
    }

    public boolean messageComplete() {
        if (this._trailers != null) {
            HttpChannelOverHttp httpChannelOverHttp = this;
            httpChannelOverHttp.onTrailers(httpChannelOverHttp._trailers);
        }
        return this.onRequestComplete();
    }

    public int getHeaderCacheSize() {
        return this.getHttpConfiguration().getHeaderCacheSize();
    }

    /*
     * WARNING - void declaration
     */
    public void onComplianceViolation(HttpCompliance compliance, HttpComplianceSection violation, String reason) {
        if (this._httpConnection.isRecordHttpComplianceViolations()) {
            void var3_3;
            void var2_2;
            if (this._complianceViolations == null) {
                this._complianceViolations = new ArrayList<String>();
            }
            String record = String.format("%s (see %s) in mode %s for %s in %s", violation.getDescription(), var2_2.getURL(), compliance, var3_3, this.getHttpTransport());
            this._complianceViolations.add(record);
            if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug((String)var1_1, new Object[0]);
            }
        }
    }
}

