/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpChannelListeners
implements HttpChannel.Listener {
    static final Logger LOG = Log.getLogger(HttpChannel.class);
    public static HttpChannel.Listener NOOP = new HttpChannel.Listener(){};
    private final NotifyRequest onRequestBegin;
    private final NotifyRequest onBeforeDispatch;
    private final NotifyFailure onDispatchFailure;
    private final NotifyRequest onAfterDispatch;
    private final NotifyContent onRequestContent;
    private final NotifyRequest onRequestContentEnd;
    private final NotifyRequest onRequestTrailers;
    private final NotifyRequest onRequestEnd;
    private final NotifyFailure onRequestFailure;
    private final NotifyRequest onResponseBegin;
    private final NotifyRequest onResponseCommit;
    private final NotifyContent onResponseContent;
    private final NotifyRequest onResponseEnd;
    private final NotifyFailure onResponseFailure;
    private final NotifyRequest onComplete;

    /*
     * WARNING - void declaration
     */
    public HttpChannelListeners(Collection<HttpChannel.Listener> listeners) {
        try {
            void var3_4;
            Iterator iterator;
            NotifyRequest onRequestBegin = NotifyRequest.NOOP;
            NotifyRequest onBeforeDispatch = NotifyRequest.NOOP;
            NotifyFailure onDispatchFailure = NotifyFailure.NOOP;
            NotifyRequest onAfterDispatch = NotifyRequest.NOOP;
            NotifyContent onRequestContent = NotifyContent.NOOP;
            NotifyRequest onRequestContentEnd = NotifyRequest.NOOP;
            NotifyRequest onRequestTrailers = NotifyRequest.NOOP;
            NotifyRequest onRequestEnd = NotifyRequest.NOOP;
            NotifyFailure onRequestFailure = NotifyFailure.NOOP;
            NotifyRequest onResponseBegin = NotifyRequest.NOOP;
            NotifyRequest onResponseCommit = NotifyRequest.NOOP;
            NotifyContent onResponseContent = NotifyContent.NOOP;
            NotifyRequest onResponseEnd = NotifyRequest.NOOP;
            NotifyFailure onResponseFailure = NotifyFailure.NOOP;
            NotifyRequest onComplete = NotifyRequest.NOOP;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                HttpChannel.Listener listener = (HttpChannel.Listener)iterator.next();
                if (!listener.getClass().getMethod("onRequestBegin", Request.class).isDefault()) {
                    onRequestBegin = HttpChannelListeners.combine(onRequestBegin, listener::onRequestBegin);
                }
                if (!listener.getClass().getMethod("onBeforeDispatch", Request.class).isDefault()) {
                    onBeforeDispatch = HttpChannelListeners.combine(onBeforeDispatch, listener::onBeforeDispatch);
                }
                if (!listener.getClass().getMethod("onDispatchFailure", Request.class, Throwable.class).isDefault()) {
                    onDispatchFailure = HttpChannelListeners.combine(onDispatchFailure, listener::onDispatchFailure);
                }
                if (!listener.getClass().getMethod("onAfterDispatch", Request.class).isDefault()) {
                    onAfterDispatch = HttpChannelListeners.combine(onAfterDispatch, listener::onAfterDispatch);
                }
                if (!listener.getClass().getMethod("onRequestContent", Request.class, ByteBuffer.class).isDefault()) {
                    onRequestContent = HttpChannelListeners.combine(onRequestContent, listener::onRequestContent);
                }
                if (!listener.getClass().getMethod("onRequestContentEnd", Request.class).isDefault()) {
                    onRequestContentEnd = HttpChannelListeners.combine(onRequestContentEnd, listener::onRequestContentEnd);
                }
                if (!listener.getClass().getMethod("onRequestTrailers", Request.class).isDefault()) {
                    onRequestTrailers = HttpChannelListeners.combine(onRequestTrailers, listener::onRequestTrailers);
                }
                if (!listener.getClass().getMethod("onRequestEnd", Request.class).isDefault()) {
                    onRequestEnd = HttpChannelListeners.combine(onRequestEnd, listener::onRequestEnd);
                }
                if (!listener.getClass().getMethod("onRequestFailure", Request.class, Throwable.class).isDefault()) {
                    onRequestFailure = HttpChannelListeners.combine(onRequestFailure, listener::onRequestFailure);
                }
                if (!listener.getClass().getMethod("onResponseBegin", Request.class).isDefault()) {
                    onResponseBegin = HttpChannelListeners.combine(onResponseBegin, listener::onResponseBegin);
                }
                if (!listener.getClass().getMethod("onResponseCommit", Request.class).isDefault()) {
                    onResponseCommit = HttpChannelListeners.combine(onResponseCommit, listener::onResponseCommit);
                }
                if (!listener.getClass().getMethod("onResponseContent", Request.class, ByteBuffer.class).isDefault()) {
                    onResponseContent = HttpChannelListeners.combine(onResponseContent, listener::onResponseContent);
                }
                if (!listener.getClass().getMethod("onResponseEnd", Request.class).isDefault()) {
                    onResponseEnd = HttpChannelListeners.combine(onResponseEnd, listener::onResponseEnd);
                }
                if (!listener.getClass().getMethod("onResponseFailure", Request.class, Throwable.class).isDefault()) {
                    onResponseFailure = HttpChannelListeners.combine(onResponseFailure, listener::onResponseFailure);
                }
                if (listener.getClass().getMethod("onComplete", Request.class).isDefault()) continue;
                onComplete = HttpChannelListeners.combine(onComplete, listener::onComplete);
            }
            this.onRequestBegin = onRequestBegin;
            this.onBeforeDispatch = var3_4;
            this.onDispatchFailure = onDispatchFailure;
            this.onAfterDispatch = onAfterDispatch;
            this.onRequestContent = onRequestContent;
            this.onRequestContentEnd = onRequestContentEnd;
            this.onRequestTrailers = onRequestTrailers;
            this.onRequestEnd = onRequestEnd;
            this.onRequestFailure = onRequestFailure;
            this.onResponseBegin = onResponseBegin;
            this.onResponseCommit = onResponseCommit;
            this.onResponseContent = onResponseContent;
            this.onResponseEnd = onResponseEnd;
            this.onResponseFailure = onResponseFailure;
            this.onComplete = onComplete;
            return;
        }
        catch (Exception e) {
            void var2_3;
            throw new RuntimeException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onRequestBegin(Request request) {
        void var1_1;
        this.onRequestBegin.onRequest((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onBeforeDispatch(Request request) {
        void var1_1;
        this.onBeforeDispatch.onRequest((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onDispatchFailure(Request request, Throwable failure) {
        void var2_2;
        void var1_1;
        this.onDispatchFailure.onFailure((Request)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onAfterDispatch(Request request) {
        void var1_1;
        this.onAfterDispatch.onRequest((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onRequestContent(Request request, ByteBuffer content) {
        void var2_2;
        void var1_1;
        this.onRequestContent.onContent((Request)var1_1, (ByteBuffer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onRequestContentEnd(Request request) {
        void var1_1;
        this.onRequestContentEnd.onRequest((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onRequestTrailers(Request request) {
        void var1_1;
        this.onRequestTrailers.onRequest((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onRequestEnd(Request request) {
        void var1_1;
        this.onRequestEnd.onRequest((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onRequestFailure(Request request, Throwable failure) {
        void var2_2;
        void var1_1;
        this.onRequestFailure.onFailure((Request)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onResponseBegin(Request request) {
        void var1_1;
        this.onResponseBegin.onRequest((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onResponseCommit(Request request) {
        void var1_1;
        this.onResponseCommit.onRequest((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onResponseContent(Request request, ByteBuffer content) {
        void var2_2;
        void var1_1;
        this.onResponseContent.onContent((Request)var1_1, (ByteBuffer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onResponseEnd(Request request) {
        void var1_1;
        this.onResponseEnd.onRequest((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onResponseFailure(Request request, Throwable failure) {
        void var2_2;
        void var1_1;
        this.onResponseFailure.onFailure((Request)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onComplete(Request request) {
        void var1_1;
        this.onComplete.onRequest((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static NotifyRequest combine(NotifyRequest first, NotifyRequest second) {
        void var1_1;
        NotifyRequest notifyRequest;
        if (first == NotifyRequest.NOOP) {
            return second;
        }
        if (second == NotifyRequest.NOOP) {
            return first;
        }
        return arg_0 -> HttpChannelListeners.lambda$combine$0(notifyRequest, (NotifyRequest)var1_1, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private static NotifyFailure combine(NotifyFailure first, NotifyFailure second) {
        void var1_1;
        NotifyFailure notifyFailure;
        if (first == NotifyFailure.NOOP) {
            return second;
        }
        if (second == NotifyFailure.NOOP) {
            return first;
        }
        return (arg_0, arg_1) -> HttpChannelListeners.lambda$combine$1(notifyFailure, (NotifyFailure)var1_1, arg_0, arg_1);
    }

    /*
     * WARNING - void declaration
     */
    private static NotifyContent combine(NotifyContent first, NotifyContent second) {
        void var1_1;
        NotifyContent notifyContent;
        if (first == NotifyContent.NOOP) {
            return (request, content) -> {
                void var2_2;
                void var1_1;
                second.onContent((Request)var1_1, var2_2.slice());
            };
        }
        if (second == NotifyContent.NOOP) {
            return (request, content) -> {
                void var2_2;
                void var1_1;
                first.onContent((Request)var1_1, var2_2.slice());
            };
        }
        return (arg_0, arg_1) -> HttpChannelListeners.lambda$combine$4(notifyContent, (NotifyContent)var1_1, arg_0, arg_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$combine$4(NotifyContent first, NotifyContent second, Request request, ByteBuffer content) {
        void var3_3;
        void var2_2;
        void var1_1;
        NotifyContent notifyContent;
        content = content.slice();
        notifyContent.onContent(request, content);
        var1_1.onContent((Request)var2_2, (ByteBuffer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$combine$1(NotifyFailure first, NotifyFailure second, Request request, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        first.onFailure(request, throwable);
        var1_1.onFailure((Request)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$combine$0(NotifyRequest first, NotifyRequest second, Request request) {
        void var2_2;
        void var1_1;
        first.onRequest(request);
        var1_1.onRequest((Request)var2_2);
    }

    private static interface NotifyContent {
        public static final NotifyContent NOOP = (request, content) -> {};

        public void onContent(Request var1, ByteBuffer var2);
    }

    private static interface NotifyFailure {
        public static final NotifyFailure NOOP = (request, failure) -> {};

        public void onFailure(Request var1, Throwable var2);
    }

    private static interface NotifyRequest {
        public static final NotifyRequest NOOP = request -> {};

        public void onRequest(Request var1);
    }
}

