/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogCollection;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannel
implements Runnable,
HttpOutput.Interceptor {
    public static Listener NOOP_LISTENER = new Listener(){};
    private static final Logger LOG = Log.getLogger(HttpChannel.class);
    private final AtomicLong _requests = new AtomicLong();
    private final Connector _connector;
    private final Executor _executor;
    private final HttpConfiguration _configuration;
    private final EndPoint _endPoint;
    private final HttpTransport _transport;
    private final HttpChannelState _state;
    private final Request _request;
    private final Response _response;
    private final Listener _combinedListener;
    @Deprecated
    private final List<Listener> _transientListeners = new ArrayList<Listener>();
    private HttpFields _trailers;
    private final Supplier<HttpFields> _trailerSupplier = () -> this._trailers;
    private MetaData.Response _committedMetaData;
    private RequestLog _requestLog;
    private long _oldIdleTimeout;
    private long _written;

    /*
     * WARNING - void declaration
     */
    public HttpChannel(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport) {
        void var1_1;
        void var3_3;
        void var2_2;
        this._connector = connector;
        this._configuration = (HttpConfiguration)Objects.requireNonNull(var2_2);
        this._endPoint = var3_3;
        this._transport = transport;
        this._state = new HttpChannelState(this);
        HttpChannel httpChannel = this;
        this._request = new Request(httpChannel, httpChannel.newHttpInput(this._state));
        HttpChannel httpChannel2 = this;
        this._response = new Response(httpChannel2, httpChannel2.newHttpOutput());
        this._executor = connector.getServer().getThreadPool();
        this._requestLog = connector.getServer().getRequestLog();
        Listener listener = this._combinedListener = connector instanceof AbstractConnector ? ((AbstractConnector)var1_1).getHttpChannelListeners() : NOOP_LISTENER;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new {} -> {},{},{}", new Object[]{this, this._endPoint, this._endPoint == null ? null : this._endPoint.getConnection(), this._state});
        }
    }

    public boolean isSendError() {
        return this._state.isSendError();
    }

    protected String formatAddrOrHost(String addr) {
        return HostPort.normalizeHost((String)addr);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpInput newHttpInput(HttpChannelState state) {
        void var1_1;
        return new HttpInput((HttpChannelState)var1_1);
    }

    protected HttpOutput newHttpOutput() {
        return new HttpOutput(this);
    }

    public HttpChannelState getState() {
        return this._state;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean addListener(Listener listener) {
        void var1_1;
        return this._transientListeners.add((Listener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean removeListener(Listener listener) {
        void var1_1;
        return this._transientListeners.remove(var1_1);
    }

    @Deprecated
    public List<Listener> getTransientListeners() {
        return this._transientListeners;
    }

    public long getBytesWritten() {
        return this._written;
    }

    public long getRequests() {
        return this._requests.get();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpTransport getHttpTransport() {
        return this._transport;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestLog(RequestLog requestLog) {
        void var1_1;
        this._requestLog = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addRequestLog(RequestLog requestLog) {
        void var1_1;
        if (this._requestLog == null) {
            this._requestLog = requestLog;
            return;
        }
        if (this._requestLog instanceof RequestLogCollection) {
            ((RequestLogCollection)this._requestLog).add(requestLog);
            return;
        }
        this._requestLog = new RequestLogCollection(new RequestLog[]{this._requestLog, var1_1});
    }

    public MetaData.Response getCommittedMetaData() {
        return this._committedMetaData;
    }

    public long getIdleTimeout() {
        return this._endPoint.getIdleTimeout();
    }

    /*
     * WARNING - void declaration
     */
    public void setIdleTimeout(long timeoutMs) {
        void var1_1;
        this._endPoint.setIdleTimeout((long)var1_1);
    }

    public ByteBufferPool getByteBufferPool() {
        return this._connector.getByteBufferPool();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._configuration;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return this.getHttpTransport().isOptimizedForDirectBuffers();
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public Connection getConnection() {
        return this._endPoint.getConnection();
    }

    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    /*
     * WARNING - void declaration
     */
    public String getLocalName() {
        SocketAddress localAddress;
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null && (localAddress = httpConfiguration.getLocalAddress()) instanceof InetSocketAddress) {
            return ((InetSocketAddress)localAddress).getHostName();
        }
        InetSocketAddress local = this.getLocalAddress();
        if (local != null) {
            void var1_1;
            return var1_1.getHostString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public int getLocalPort() {
        void var1_1;
        SocketAddress localAddress;
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null && (localAddress = httpConfiguration.getLocalAddress()) instanceof InetSocketAddress) {
            return ((InetSocketAddress)localAddress).getPort();
        }
        InetSocketAddress local = this.getLocalAddress();
        if (local == null) {
            return 0;
        }
        return var1_1.getPort();
    }

    /*
     * WARNING - void declaration
     */
    public InetSocketAddress getLocalAddress() {
        SocketAddress localAddress;
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null && (localAddress = httpConfiguration.getLocalAddress()) instanceof InetSocketAddress) {
            void var1_1;
            return (InetSocketAddress)var1_1;
        }
        return this._endPoint.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this._endPoint.getRemoteAddress();
    }

    /*
     * WARNING - void declaration
     */
    public HostPort getServerAuthority() {
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null) {
            void var1_1;
            return var1_1.getServerAuthority();
        }
        return null;
    }

    public void continue100(int available) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void recycle() {
        this._request.recycle();
        this._response.recycle();
        this._committedMetaData = null;
        this._requestLog = this._connector == null ? null : this._connector.getServer().getRequestLog();
        this._written = 0L;
        this._trailers = null;
        this._oldIdleTimeout = 0L;
        this._transientListeners.clear();
    }

    public void onAsyncWaitForContent() {
    }

    public void onBlockWaitForContent() {
    }

    /*
     * WARNING - void declaration
     */
    public void onBlockWaitForContentFailure(Throwable failure) {
        void var1_1;
        this.getRequest().getHttpInput().failed((Throwable)var1_1);
    }

    @Override
    public void run() {
        this.handle();
    }

    /*
     * Unable to fully structure code
     */
    public boolean handle() {
        if (HttpChannel.LOG.isDebugEnabled()) {
            HttpChannel.LOG.debug("handle {} {} ", new Object[]{this._request.getHttpURI(), this});
        }
        action = this._state.handling();
        block24: while (!this.getServer().isStopped()) {
            try {
                if (HttpChannel.LOG.isDebugEnabled()) {
                    HttpChannel.LOG.debug("action {} {}", new Object[]{action, this});
                }
                switch (2.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$Action[action.ordinal()]) {
                    case 1: {
                        this.onCompleted();
                        break block24;
                    }
                    case 2: {
                        break block24;
                    }
                    case 3: {
                        if (!this._request.hasMetaData()) {
                            throw new IllegalStateException("state=" + this._state);
                        }
                        this.dispatch(DispatcherType.REQUEST, (Dispatchable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handle$1(), ()V)((HttpChannel)this));
                        break;
                    }
                    case 4: {
                        this.dispatch(DispatcherType.ASYNC, (Dispatchable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handle$2(), ()V)((HttpChannel)this));
                        break;
                    }
                    case 5: {
                        this._state.onTimeout();
                        break;
                    }
                    case 6: {
                        try {
                            this._response.resetContent();
                            code = (Integer)this._request.getAttribute("javax.servlet.error.status_code");
                            if (code == null) {
                                code = 500;
                            }
                            this._response.setStatus(code);
                            this.ensureConsumeAllOrNotPersistent();
                            context = (ContextHandler.Context)this._request.getAttribute("org.eclipse.jetty.server.error_context");
                            errorHandler = ErrorHandler.getErrorHandler(this.getServer(), context == null ? null : context.getContextHandler());
                            if (HttpStatus.hasNoBody((int)this._response.getStatus()) || errorHandler == null || !errorHandler.errorPageForMethod(this._request.getMethod())) {
                                this.sendResponseAndComplete();
                            } else {
                                this.dispatch(DispatcherType.ERROR, (Dispatchable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handle$3(org.eclipse.jetty.server.handler.ErrorHandler ), ()V)((HttpChannel)this, (ErrorHandler)errorHandler));
                            }
                            break;
                        }
                        catch (Throwable x) {
                            if (HttpChannel.LOG.isDebugEnabled()) {
                                HttpChannel.LOG.debug("Could not perform ERROR dispatch, aborting", x);
                            }
                            if (this._state.isResponseCommitted()) {
                                this.abort(x);
                            } else {
                                try {
                                    this._response.resetContent();
                                    this.sendResponseAndComplete();
                                }
                                catch (Throwable t) {
                                    if (x != t) {
                                        x.addSuppressed((Throwable)var2_7);
                                    }
                                    this.abort(x);
                                }
                            }
                            break;
                        }
                        finally {
                            this._request.removeAttribute("org.eclipse.jetty.server.error_context");
                        }
                    }
                    case 7: {
                        throw this._state.getAsyncContextEvent().getThrowable();
                    }
                    case 8: {
                        this.onAsyncWaitForContent();
                        break;
                    }
                    case 9: {
                        this._request.getHttpInput().asyncReadProduce();
                        break;
                    }
                    case 10: {
                        handler = this._state.getContextHandler();
                        if (handler != null) {
                            handler.handle(this._request, this._request.getHttpInput());
                        } else {
                            this._request.getHttpInput().run();
                        }
                        break;
                    }
                    case 11: {
                        handler = this._state.getContextHandler();
                        if (handler != null) {
                            handler.handle(this._request, this._response.getHttpOutput());
                        } else {
                            this._response.getHttpOutput().run();
                        }
                        break;
                    }
                    case 12: {
                        if (!this._response.isCommitted()) {
                            if (!this._request.isHandled() && !this._response.getHttpOutput().isClosed()) {
                                this._response.sendError(404);
                                break;
                            }
                            if (this._response.getStatus() >= 200) {
                                this.ensureConsumeAllOrNotPersistent();
                            }
                        }
                        if (this._request.isHead() || this._response.getStatus() == 304 || this._response.isContentComplete(this._response.getHttpOutput().getWritten())) ** GOTO lbl92
                        if (!this.isCommitted()) {
                            this._response.sendError(500, "insufficient content written");
                        } else {
                            this.abort(new IOException("insufficient content written"));
lbl92:
                            // 2 sources

                            this._response.completeOutput(Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, (Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handle$4(), ()V)((HttpChannel)this), (Consumer<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, completed(java.lang.Throwable ), (Ljava/lang/Throwable;)V)((HttpChannelState)this._state)));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.toString());
                    }
                }
            }
            catch (Throwable failure) {
                if ("org.eclipse.jetty.continuation.ContinuationThrowable".equals(failure.getClass().getName())) {
                    HttpChannel.LOG.ignore(failure);
                }
                this.handleException((Throwable)var1_4);
            }
            var1_1 = this._state.unhandle();
        }
        if (HttpChannel.LOG.isDebugEnabled()) {
            HttpChannel.LOG.debug("!handle {} {}", new Object[]{var1_1, this});
        }
        return (var1_5 = var1_1 == HttpChannelState.Action.WAIT) == false;
    }

    public void ensureConsumeAllOrNotPersistent() {
        switch (this._request.getHttpVersion()) {
            case HTTP_1_0: {
                if (this._request.getHttpInput().consumeAll()) {
                    return;
                }
                this._response.getHttpFields().computeField(HttpHeader.CONNECTION, (h, fields) -> {
                    Object object;
                    void var1_1;
                    if (fields == null || fields.isEmpty()) {
                        return null;
                    }
                    Object v = var1_1.stream().flatMap(field -> Stream.of(field.getValues()).filter(s -> {
                        String string;
                        return !HttpHeaderValue.KEEP_ALIVE.is(string);
                    })).collect(Collectors.joining(", "));
                    if (StringUtil.isEmpty((String)v)) {
                        return null;
                    }
                    return new HttpField(HttpHeader.CONNECTION, (String)object);
                });
                return;
            }
            case HTTP_1_1: {
                if (this._request.getHttpInput().consumeAll()) {
                    return;
                }
                this._response.getHttpFields().computeField(HttpHeader.CONNECTION, (h, fields) -> {
                    void var1_1;
                    if (fields == null || fields.isEmpty()) {
                        return HttpConnection.CONNECTION_CLOSE;
                    }
                    if (fields.stream().anyMatch(f -> f.contains(HttpHeaderValue.CLOSE.asString()))) {
                        HttpHeader f2;
                        if (fields.size() == 1 && HttpConnection.CONNECTION_CLOSE.equals((Object)(f2 = (HttpField)fields.get(0)))) {
                            HttpHeader httpHeader;
                            return httpHeader;
                        }
                        return new HttpField(HttpHeader.CONNECTION, fields.stream().flatMap(field -> Stream.of(field.getValues()).filter(s -> {
                            String string;
                            return !HttpHeaderValue.KEEP_ALIVE.is(string);
                        })).collect(Collectors.joining(", ")));
                    }
                    return new HttpField(HttpHeader.CONNECTION, Stream.concat(var1_1.stream().flatMap(field -> Stream.of(field.getValues()).filter(s -> {
                        String string;
                        return !HttpHeaderValue.KEEP_ALIVE.is(string);
                    })), Stream.of(HttpHeaderValue.CLOSE.asString())).collect(Collectors.joining(", ")));
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void dispatch(DispatcherType type, Dispatchable dispatchable) throws IOException, ServletException {
        try {
            void var2_4;
            this._request.setHandled(false);
            this._response.reopen();
            this._request.setDispatcherType(type);
            this._combinedListener.onBeforeDispatch(this._request);
            var2_4.dispatch();
            return;
        }
        catch (Throwable x) {
            void var1_2;
            this._combinedListener.onDispatchFailure(this._request, x);
            throw var1_2;
        }
        finally {
            this._combinedListener.onAfterDispatch(this._request);
            this._request.setDispatcherType(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void handleException(Throwable failure) {
        void var1_1;
        void var2_2;
        Throwable quiet = this.unwrap(failure, QuietException.class);
        Throwable noStack = this.unwrap(failure, BadMessageException.class, IOException.class, TimeoutException.class);
        if (var2_2 != null || !this.getServer().isRunning()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this._request.getRequestURI(), failure);
            }
        } else if (noStack != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("handleException " + this._request.getRequestURI(), failure);
            } else {
                void var3_3;
                LOG.warn("handleException {} {}", new Object[]{this._request.getRequestURI(), var3_3.toString()});
            }
        } else {
            LOG.warn(this._request.getRequestURI(), failure);
        }
        if (this.isCommitted()) {
            this.abort(failure);
            return;
        }
        this._state.onError((Throwable)var1_1);
    }

    protected Throwable unwrap(Throwable failure, Class<?> ... targets) {
        while (failure != null) {
            Class<?>[] classArray = targets;
            int n = targets.length;
            for (int i = 0; i < n; ++i) {
                Class<?> clazz = classArray[i];
                if (!clazz.isInstance(failure)) continue;
                return failure;
            }
            failure = failure.getCause();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void sendResponseAndComplete() {
        try {
            this._request.setHandled(true);
            this._state.completing();
            this.sendResponse(null, this._response.getHttpOutput().getBuffer(), true, Callback.from(() -> this._state.completed(null), this._state::completed));
            return;
        }
        catch (Throwable x) {
            void var1_1;
            this.abort((Throwable)var1_1);
            return;
        }
    }

    public boolean isExpecting100Continue() {
        return false;
    }

    public boolean isExpecting102Processing() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        long timeStamp = this._request.getTimeStamp();
        return String.format("%s@%x{s=%s,r=%s,c=%b/%b,a=%s,uri=%s,age=%d}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state, this._requests, this.isRequestCompleted(), this.isResponseCompleted(), this._state.getState(), this._request.getHttpURI(), timeStamp == 0L ? 0L : System.currentTimeMillis() - var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public void onRequest(MetaData.Request request) {
        this._requests.incrementAndGet();
        this._request.setTimeStamp(System.currentTimeMillis());
        HttpFields fields = this._response.getHttpFields();
        if (this._configuration.getSendDateHeader() && !fields.contains(HttpHeader.DATE)) {
            void var2_2;
            var2_2.put(this._connector.getServer().getDateField());
        }
        long idleTO = this._configuration.getIdleTimeout();
        this._oldIdleTimeout = this.getIdleTimeout();
        if (idleTO >= 0L && this._oldIdleTimeout != idleTO) {
            void var3_3;
            this.setIdleTimeout((long)var3_3);
        }
        request.setTrailerSupplier(this._trailerSupplier);
        this._request.setMetaData(request);
        this._request.setSecure(HttpScheme.HTTPS.is(request.getURI().getScheme()));
        this._combinedListener.onRequestBegin(this._request);
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("REQUEST for {} on {}{}{} {} {}{}{}", new Object[]{request.getURIString(), this, System.lineSeparator(), request.getMethod(), request.getURIString(), request.getHttpVersion(), System.lineSeparator(), var1_1.getFields()});
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean onContent(HttpInput.Content content) {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onContent {} {}", new Object[]{this, content});
        }
        this._combinedListener.onRequestContent(this._request, content.getByteBuffer());
        return this._request.getHttpInput().addContent((HttpInput.Content)var1_1);
    }

    public boolean onContentComplete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onContentComplete {}", new Object[]{this});
        }
        this._combinedListener.onRequestContentEnd(this._request);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void onTrailers(HttpFields trailers) {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTrailers {} {}", new Object[]{this, trailers});
        }
        this._trailers = var1_1;
        this._combinedListener.onRequestTrailers(this._request);
    }

    /*
     * WARNING - void declaration
     */
    public boolean onRequestComplete() {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onRequestComplete {}", new Object[]{this});
        }
        boolean result = this._request.getHttpInput().eof();
        this._combinedListener.onRequestEnd(this._request);
        return (boolean)var1_1;
    }

    public void onCompleted() {
        long l;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onCompleted for {} written={}", new Object[]{this.getRequest().getRequestURI(), this.getBytesWritten()});
        }
        if (this._requestLog != null) {
            this._requestLog.log(this._request, this._response);
        }
        if ((l = this._configuration.getIdleTimeout()) >= 0L && this.getIdleTimeout() != this._oldIdleTimeout) {
            HttpChannel httpChannel = this;
            httpChannel.setIdleTimeout(httpChannel._oldIdleTimeout);
        }
        this._request.onCompleted();
        this._combinedListener.onComplete(this._request);
        this._transport.onCompleted();
    }

    public boolean onEarlyEOF() {
        return this._request.getHttpInput().earlyEOF();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void onBadMessage(BadMessageException failure) {
        block14: {
            void var1_1;
            void var3_5;
            HttpChannelState.Action action;
            int status = failure.getCode();
            String reason = failure.getReason();
            if (status < 400 || status > 599) {
                failure = new BadMessageException(400, reason, (Throwable)failure);
            }
            this._combinedListener.onRequestFailure(this._request, (Throwable)failure);
            try {
                action = this._state.handling();
            }
            catch (Throwable e) {
                this.abort(e);
                throw failure;
            }
            if (action != HttpChannelState.Action.DISPATCH) break block14;
            ByteBuffer content = null;
            HttpFields fields = new HttpFields();
            ErrorHandler handler = (ErrorHandler)this.getServer().getBean(ErrorHandler.class);
            if (handler != null) {
                content = handler.badMessageError(status, reason, fields);
            }
            this.sendResponse(new MetaData.Response(HttpVersion.HTTP_1_1, status, (String)var3_5, (HttpFields)var1_1, (long)BufferUtil.length((ByteBuffer)content)), content, true);
        }
        try {
            this.onCompleted();
            return;
        }
        catch (Throwable e) {
            LOG.debug(e);
            this.abort(e);
            return;
        }
        catch (IOException e) {
            try {
                LOG.debug((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.onCompleted();
                }
                catch (Throwable e2) {
                    void var2_4;
                    LOG.debug(e2);
                    this.abort((Throwable)var2_4);
                }
                throw throwable;
            }
            try {
                this.onCompleted();
                return;
            }
            catch (Throwable e3) {
                LOG.debug(e3);
                this.abort(e3);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean sendResponse(MetaData.Response info, ByteBuffer content, boolean complete, Callback callback) {
        void var4_4;
        void var1_1;
        boolean committing = this._state.commitResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendResponse info={} content={} complete={} committing={} callback={}", new Object[]{info, BufferUtil.toDetailString((ByteBuffer)content), complete, committing, callback});
        }
        if (committing) {
            if (info == null) {
                info = this._response.newResponseMetaData();
            }
            this.commit(info);
            this._combinedListener.onResponseBegin(this._request);
            this._request.onResponseCommit();
            int status = info.getStatus();
            SendCallback committed = status < 200 && status >= 100 ? new Send100Callback(callback) : new SendCallback(callback, content, true, complete);
            this._transport.send(info, this._request.isHead(), content, complete, (Callback)committed);
        } else if (var1_1 == null) {
            void var3_3;
            void var2_2;
            this._transport.send(null, this._request.isHead(), content, complete, (Callback)new SendCallback((Callback)var4_4, (ByteBuffer)var2_2, false, (boolean)var3_3));
        } else {
            var4_4.failed((Throwable)new IllegalStateException("committed"));
        }
        return committing;
    }

    /*
     * WARNING - void declaration
     */
    public boolean sendResponse(MetaData.Response info, ByteBuffer content, boolean complete) throws IOException {
        void var2_5;
        block9: {
            SharedBlockingCallback.Blocker blocker = this._response.getHttpOutput().acquireWriteBlockingCallback();
            try {
                void var1_2;
                void var3_7;
                void var2_4;
                boolean committing = this.sendResponse(info, (ByteBuffer)var2_4, (boolean)var3_7, (Callback)blocker);
                blocker.block();
                var2_5 = var1_2;
                if (blocker == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (blocker != null) {
                        try {
                            blocker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable failure) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(failure);
                    }
                    this.abort(failure);
                    throw failure;
                }
            }
            blocker.close();
        }
        return (boolean)var2_5;
    }

    /*
     * WARNING - void declaration
     */
    protected void commit(MetaData.Response info) {
        this._committedMetaData = info;
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("COMMIT for {} on {}{}{} {} {}{}{}", new Object[]{this.getRequest().getRequestURI(), this, System.lineSeparator(), info.getStatus(), info.getReason(), info.getHttpVersion(), System.lineSeparator(), var1_1.getFields()});
        }
    }

    public boolean isCommitted() {
        return this._state.isResponseCommitted();
    }

    public boolean isRequestCompleted() {
        return this._state.isCompleted();
    }

    public boolean isResponseCompleted() {
        return this._state.isResponseCompleted();
    }

    public boolean isPersistent() {
        return this._endPoint.isOpen();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(ByteBuffer content, boolean complete, Callback callback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.sendResponse(null, (ByteBuffer)var1_1, (boolean)var2_2, (Callback)var3_3);
    }

    @Override
    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
    }

    @Override
    public HttpOutput.Interceptor getNextInterceptor() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void execute(Runnable task) {
        void var1_1;
        this._executor.execute((Runnable)var1_1);
    }

    public Scheduler getScheduler() {
        return this._connector.getScheduler();
    }

    public boolean useDirectBuffers() {
        return this.getEndPoint() instanceof ChannelEndPoint;
    }

    /*
     * WARNING - void declaration
     */
    public void abort(Throwable failure) {
        if (this._state.abortResponse()) {
            void var1_1;
            this._combinedListener.onResponseFailure(this._request, failure);
            this._transport.abort((Throwable)var1_1);
        }
    }

    private void notifyEvent1(Function<Listener, Consumer<Request>> function, Request request) {
        for (Listener listener : this._transientListeners) {
            try {
                function.apply(listener).accept(request);
            }
            catch (Throwable x) {
                LOG.debug("Failure invoking listener " + listener, x);
            }
        }
    }

    private void notifyEvent2(Function<Listener, BiConsumer<Request, ByteBuffer>> function, Request request, ByteBuffer content) {
        for (Listener listener : this._transientListeners) {
            ByteBuffer view = content.slice();
            try {
                function.apply(listener).accept(request, view);
            }
            catch (Throwable x) {
                LOG.debug("Failure invoking listener " + listener, x);
            }
        }
    }

    private void notifyEvent2(Function<Listener, BiConsumer<Request, Throwable>> function, Request request, Throwable failure) {
        for (Listener listener : this._transientListeners) {
            try {
                function.apply(listener).accept(request, failure);
            }
            catch (Throwable x) {
                LOG.debug("Failure invoking listener " + listener, x);
            }
        }
    }

    private /* synthetic */ void lambda$handle$4() {
        this._state.completed(null);
    }

    private /* synthetic */ void lambda$handle$3(ErrorHandler errorHandler) throws IOException, ServletException {
        ((AbstractHandler)errorHandler).handle(null, this._request, this._request, this._response);
        this._request.setHandled(true);
    }

    private /* synthetic */ void lambda$handle$2() throws IOException, ServletException {
        this.getServer().handleAsync(this);
    }

    private /* synthetic */ void lambda$handle$1() throws IOException, ServletException {
        for (HttpConfiguration.Customizer customizer : this._configuration.getCustomizers()) {
            customizer.customize(this.getConnector(), this._configuration, this._request);
            if (!this._request.isHandled()) continue;
            return;
        }
        this.getServer().handle(this);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$214(HttpChannel x0, long x1) {
        void var1_1;
        return x0._written += var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$900(HttpChannel x0, Function x1, Request x2) {
        void var2_2;
        void var1_1;
        x0.notifyEvent1((Function<Listener, Consumer<Request>>)var1_1, (Request)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1000(HttpChannel x0, Function x1, Request x2, Throwable x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.notifyEvent2((Function<Listener, BiConsumer<Request, Throwable>>)var1_1, (Request)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1100(HttpChannel x0, Function x1, Request x2, ByteBuffer x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.notifyEvent2((Function<Listener, BiConsumer<Request, ByteBuffer>>)var1_1, (Request)var2_2, (ByteBuffer)var3_3);
    }

    @Deprecated
    public static class TransientListeners
    implements Listener {
        /*
         * WARNING - void declaration
         */
        @Override
        public void onRequestBegin(Request request) {
            void var1_1;
            HttpChannel.access$900(request.getHttpChannel(), listener -> listener::onRequestBegin, (Request)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onBeforeDispatch(Request request) {
            void var1_1;
            HttpChannel.access$900(request.getHttpChannel(), listener -> listener::onBeforeDispatch, (Request)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onDispatchFailure(Request request, Throwable failure) {
            void var2_2;
            void var1_1;
            HttpChannel.access$1000(request.getHttpChannel(), listener -> listener::onDispatchFailure, (Request)var1_1, (Throwable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onAfterDispatch(Request request) {
            void var1_1;
            HttpChannel.access$900(request.getHttpChannel(), listener -> listener::onAfterDispatch, (Request)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onRequestContent(Request request, ByteBuffer content) {
            void var2_2;
            void var1_1;
            HttpChannel.access$1100(request.getHttpChannel(), listener -> listener::onRequestContent, (Request)var1_1, (ByteBuffer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onRequestContentEnd(Request request) {
            void var1_1;
            HttpChannel.access$900(request.getHttpChannel(), listener -> listener::onRequestContentEnd, (Request)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onRequestTrailers(Request request) {
            void var1_1;
            HttpChannel.access$900(request.getHttpChannel(), listener -> listener::onRequestTrailers, (Request)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onRequestEnd(Request request) {
            void var1_1;
            HttpChannel.access$900(request.getHttpChannel(), listener -> listener::onRequestEnd, (Request)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onRequestFailure(Request request, Throwable failure) {
            void var2_2;
            void var1_1;
            HttpChannel.access$1000(request.getHttpChannel(), listener -> listener::onRequestFailure, (Request)var1_1, (Throwable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onResponseBegin(Request request) {
            void var1_1;
            HttpChannel.access$900(request.getHttpChannel(), listener -> listener::onResponseBegin, (Request)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onResponseCommit(Request request) {
            void var1_1;
            HttpChannel.access$900(request.getHttpChannel(), listener -> listener::onResponseCommit, (Request)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onResponseContent(Request request, ByteBuffer content) {
            void var2_2;
            void var1_1;
            HttpChannel.access$1100(request.getHttpChannel(), listener -> listener::onResponseContent, (Request)var1_1, (ByteBuffer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onResponseEnd(Request request) {
            void var1_1;
            HttpChannel.access$900(request.getHttpChannel(), listener -> listener::onResponseEnd, (Request)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onResponseFailure(Request request, Throwable failure) {
            void var2_2;
            void var1_1;
            HttpChannel.access$1000(request.getHttpChannel(), listener -> listener::onResponseFailure, (Request)var1_1, (Throwable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onComplete(Request request) {
            void var1_1;
            HttpChannel.access$900(request.getHttpChannel(), listener -> listener::onComplete, (Request)var1_1);
        }
    }

    private class Send100Callback
    extends SendCallback {
        /*
         * WARNING - void declaration
         */
        private Send100Callback(Callback callback) {
            void var2_2;
            super((Callback)var2_2, null, false, false);
        }

        @Override
        public void succeeded() {
            if (HttpChannel.this._state.partialResponse()) {
                super.succeeded();
                return;
            }
            super.failed(new IllegalStateException());
        }
    }

    private class SendCallback
    extends Callback.Nested {
        private final ByteBuffer _content;
        private final int _length;
        private final boolean _commit;
        private final boolean _complete;

        /*
         * WARNING - void declaration
         */
        private SendCallback(Callback callback, ByteBuffer content, boolean commit, boolean complete) {
            void var3_3;
            void var2_2;
            super((Callback)var2_2);
            this._content = content == null ? BufferUtil.EMPTY_BUFFER : var3_3.slice();
            this._length = this._content.remaining();
            this._commit = commit;
            this._complete = complete;
        }

        public void succeeded() {
            HttpChannel.access$214(HttpChannel.this, this._length);
            if (this._commit) {
                HttpChannel.this._combinedListener.onResponseCommit(HttpChannel.this._request);
            }
            if (this._length > 0) {
                HttpChannel.this._combinedListener.onResponseContent(HttpChannel.this._request, this._content);
            }
            if (this._complete && HttpChannel.this._state.completeResponse()) {
                HttpChannel.this._combinedListener.onResponseEnd(HttpChannel.this._request);
            }
            super.succeeded();
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Commit failed", x);
            }
            if (x instanceof BadMessageException) {
                SendCallback sendCallback = this;
                HttpChannel.this._transport.send(HttpGenerator.RESPONSE_500_INFO, false, null, true, (Callback)new Callback.Nested(sendCallback, sendCallback, x){
                    final /* synthetic */ Throwable val$x;
                    final /* synthetic */ SendCallback this$1;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$x = throwable;
                        super((Callback.Nested)var2_2);
                    }

                    public void succeeded() {
                        this.this$1.HttpChannel.this._response.getHttpOutput().completed(null);
                        1 v0 = this;
                        super.failed(v0.val$x);
                    }

                    public void failed(Throwable th) {
                        this.this$1.HttpChannel.this.abort(this.val$x);
                        1 v0 = this;
                        super.failed(v0.val$x);
                    }
                });
                return;
            }
            HttpChannel.this.abort(x);
            super.failed((Throwable)var1_1);
        }
    }

    public static interface Listener
    extends EventListener {
        default public void onRequestBegin(Request request) {
        }

        default public void onBeforeDispatch(Request request) {
        }

        default public void onDispatchFailure(Request request, Throwable failure) {
        }

        default public void onAfterDispatch(Request request) {
        }

        default public void onRequestContent(Request request, ByteBuffer content) {
        }

        default public void onRequestContentEnd(Request request) {
        }

        default public void onRequestTrailers(Request request) {
        }

        default public void onRequestEnd(Request request) {
        }

        default public void onRequestFailure(Request request, Throwable failure) {
        }

        default public void onResponseBegin(Request request) {
        }

        default public void onResponseCommit(Request request) {
        }

        default public void onResponseContent(Request request, ByteBuffer content) {
        }

        default public void onResponseEnd(Request request) {
        }

        default public void onResponseFailure(Request request, Throwable failure) {
        }

        default public void onComplete(Request request) {
        }
    }

    static interface Dispatchable {
        public void dispatch() throws IOException, ServletException;
    }
}

