/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.QuotedCSVParser;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;

public class ForwardedRequestCustomizer
implements HttpConfiguration.Customizer {
    private HostPortHttpField _forcedHost;
    private boolean _proxyAsAuthority = false;
    private boolean _forwardedPortAsAuthority = true;
    private String _forwardedHeader = HttpHeader.FORWARDED.toString();
    private String _forwardedHostHeader = HttpHeader.X_FORWARDED_HOST.toString();
    private String _forwardedServerHeader = HttpHeader.X_FORWARDED_SERVER.toString();
    private String _forwardedProtoHeader = HttpHeader.X_FORWARDED_PROTO.toString();
    private String _forwardedForHeader = HttpHeader.X_FORWARDED_FOR.toString();
    private String _forwardedPortHeader = HttpHeader.X_FORWARDED_PORT.toString();
    private String _forwardedHttpsHeader = "X-Proxied-Https";
    private String _forwardedCipherSuiteHeader = "Proxy-auth-cert";
    private String _forwardedSslSessionIdHeader = "Proxy-ssl-id";
    private boolean _sslIsSecure = true;
    private Trie<MethodHandle> _handles;

    public ForwardedRequestCustomizer() {
        this.updateHandles();
    }

    public boolean getProxyAsAuthority() {
        return this._proxyAsAuthority;
    }

    /*
     * WARNING - void declaration
     */
    public void setProxyAsAuthority(boolean proxyAsAuthority) {
        void var1_1;
        this._proxyAsAuthority = var1_1;
    }

    public void setForwardedOnly(boolean rfc7239only) {
        if (rfc7239only) {
            if (this._forwardedHeader == null) {
                this._forwardedHeader = HttpHeader.FORWARDED.toString();
            }
            this._forwardedHostHeader = null;
            this._forwardedServerHeader = null;
            this._forwardedForHeader = null;
            this._forwardedPortHeader = null;
            this._forwardedProtoHeader = null;
            this._forwardedHttpsHeader = null;
        } else {
            if (this._forwardedHostHeader == null) {
                this._forwardedHostHeader = HttpHeader.X_FORWARDED_HOST.toString();
            }
            if (this._forwardedServerHeader == null) {
                this._forwardedServerHeader = HttpHeader.X_FORWARDED_SERVER.toString();
            }
            if (this._forwardedForHeader == null) {
                this._forwardedForHeader = HttpHeader.X_FORWARDED_FOR.toString();
            }
            if (this._forwardedPortHeader == null) {
                this._forwardedPortHeader = HttpHeader.X_FORWARDED_PORT.toString();
            }
            if (this._forwardedProtoHeader == null) {
                this._forwardedProtoHeader = HttpHeader.X_FORWARDED_PROTO.toString();
            }
            if (this._forwardedHttpsHeader == null) {
                this._forwardedHttpsHeader = "X-Proxied-Https";
            }
        }
        this.updateHandles();
    }

    public String getForcedHost() {
        return this._forcedHost.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setForcedHost(String hostAndPort) {
        void var1_1;
        this._forcedHost = new HostPortHttpField((String)var1_1);
    }

    public String getForwardedHeader() {
        return this._forwardedHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setForwardedHeader(String forwardedHeader) {
        if (this._forwardedHeader == null || !this._forwardedHeader.equals(forwardedHeader)) {
            void var1_1;
            this._forwardedHeader = var1_1;
            this.updateHandles();
        }
    }

    public String getForwardedHostHeader() {
        return this._forwardedHostHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setForwardedHostHeader(String forwardedHostHeader) {
        if (this._forwardedHostHeader == null || !this._forwardedHostHeader.equalsIgnoreCase(forwardedHostHeader)) {
            void var1_1;
            this._forwardedHostHeader = var1_1;
            this.updateHandles();
        }
    }

    public String getForwardedServerHeader() {
        return this._forwardedServerHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setForwardedServerHeader(String forwardedServerHeader) {
        if (this._forwardedServerHeader == null || !this._forwardedServerHeader.equalsIgnoreCase(forwardedServerHeader)) {
            void var1_1;
            this._forwardedServerHeader = var1_1;
            this.updateHandles();
        }
    }

    public String getForwardedForHeader() {
        return this._forwardedForHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setForwardedForHeader(String forwardedRemoteAddressHeader) {
        if (this._forwardedForHeader == null || !this._forwardedForHeader.equalsIgnoreCase(forwardedRemoteAddressHeader)) {
            void var1_1;
            this._forwardedForHeader = var1_1;
            this.updateHandles();
        }
    }

    public String getForwardedPortHeader() {
        return this._forwardedPortHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setForwardedPortHeader(String forwardedPortHeader) {
        if (this._forwardedPortHeader == null || !this._forwardedPortHeader.equalsIgnoreCase(forwardedPortHeader)) {
            void var1_1;
            this._forwardedPortHeader = var1_1;
            this.updateHandles();
        }
    }

    public boolean getForwardedPortAsAuthority() {
        return this._forwardedPortAsAuthority;
    }

    /*
     * WARNING - void declaration
     */
    public void setForwardedPortAsAuthority(boolean forwardedPortAsAuthority) {
        void var1_1;
        this._forwardedPortAsAuthority = var1_1;
    }

    public String getForwardedProtoHeader() {
        return this._forwardedProtoHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setForwardedProtoHeader(String forwardedProtoHeader) {
        if (this._forwardedProtoHeader == null || !this._forwardedProtoHeader.equalsIgnoreCase(forwardedProtoHeader)) {
            void var1_1;
            this._forwardedProtoHeader = var1_1;
            this.updateHandles();
        }
    }

    public String getForwardedCipherSuiteHeader() {
        return this._forwardedCipherSuiteHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setForwardedCipherSuiteHeader(String forwardedCipherSuiteHeader) {
        if (this._forwardedCipherSuiteHeader == null || !this._forwardedCipherSuiteHeader.equalsIgnoreCase(forwardedCipherSuiteHeader)) {
            void var1_1;
            this._forwardedCipherSuiteHeader = var1_1;
            this.updateHandles();
        }
    }

    public String getForwardedSslSessionIdHeader() {
        return this._forwardedSslSessionIdHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setForwardedSslSessionIdHeader(String forwardedSslSessionIdHeader) {
        if (this._forwardedSslSessionIdHeader == null || !this._forwardedSslSessionIdHeader.equalsIgnoreCase(forwardedSslSessionIdHeader)) {
            void var1_1;
            this._forwardedSslSessionIdHeader = var1_1;
            this.updateHandles();
        }
    }

    public String getForwardedHttpsHeader() {
        return this._forwardedHttpsHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setForwardedHttpsHeader(String forwardedHttpsHeader) {
        if (this._forwardedHttpsHeader == null || !this._forwardedHttpsHeader.equalsIgnoreCase(forwardedHttpsHeader)) {
            void var1_1;
            this._forwardedHttpsHeader = var1_1;
            this.updateHandles();
        }
    }

    public boolean isSslIsSecure() {
        return this._sslIsSecure;
    }

    /*
     * WARNING - void declaration
     */
    public void setSslIsSecure(boolean sslIsSecure) {
        void var1_1;
        this._sslIsSecure = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void customize(Connector connector, HttpConfiguration config, Request request) {
        HttpFields httpFields = request.getHttpFields();
        Forwarded forwarded = new Forwarded(request, config);
        boolean match = false;
        for (HttpField field : httpFields) {
            try {
                MethodHandle handle = (MethodHandle)this._handles.get(field.getName());
                if (handle == null) continue;
                match = true;
                handle.invoke(forwarded, field);
            }
            catch (Throwable t) {
                this.onError(field, t);
            }
        }
        if (match) {
            if (forwarded.isSecure()) {
                request.setSecure(true);
            }
            if (forwarded._proto != null) {
                request.setScheme(forwarded._proto);
            } else if (forwarded._secureScheme) {
                void var2_2;
                request.setScheme(var2_2.getSecureScheme());
            }
            if (forwarded._authority != null) {
                String host = forwarded._authority._host;
                int port = forwarded._authority._port;
                HttpURI requestURI = request.getMetaData().getURI();
                if (requestURI != null) {
                    if (host == null) {
                        host = requestURI.getHost();
                    }
                    if (port == -1) {
                        port = requestURI.getPort();
                    }
                    if (!host.equalsIgnoreCase(requestURI.getHost()) || port != requestURI.getPort()) {
                        void var1_1;
                        var1_1.put((HttpField)new HostPortHttpField(host, port));
                        request.setAuthority(host, port);
                    }
                }
            }
            if (forwarded.hasFor()) {
                void var3_3;
                int forPort = forwarded._for._port > 0 ? forwarded._for._port : request.getRemotePort();
                var3_3.setRemoteAddr(InetSocketAddress.createUnresolved(forwarded._for._host, forPort));
            }
        }
    }

    protected static int getSecurePort(HttpConfiguration config) {
        if (config.getSecurePort() > 0) {
            HttpConfiguration httpConfiguration;
            return httpConfiguration.getSecurePort();
        }
        return 443;
    }

    /*
     * WARNING - void declaration
     */
    protected void onError(HttpField field, Throwable t) {
        void var2_2;
        void var1_1;
        throw new BadMessageException("Bad header value for " + var1_1.getName(), (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static String getLeftMost(String headerValue) {
        void var1_1;
        String string;
        if (headerValue == null) {
            return null;
        }
        int commaIndex = headerValue.indexOf(44);
        if (commaIndex == -1) {
            return headerValue;
        }
        return string.substring(0, (int)var1_1).trim();
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    @Deprecated
    public String getHostHeader() {
        return this._forcedHost.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setHostHeader(String hostHeader) {
        void var1_1;
        this._forcedHost = new HostPortHttpField((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void updateHandles() {
        int size = 0;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            do {
                this._handles = new ArrayTrie(size += 128);
            } while (this.updateForwardedHandle(lookup, this.getForwardedHeader(), "handleRFC7239") || this.updateForwardedHandle(lookup, this.getForwardedHostHeader(), "handleForwardedHost") || this.updateForwardedHandle(lookup, this.getForwardedForHeader(), "handleForwardedFor") || this.updateForwardedHandle(lookup, this.getForwardedPortHeader(), "handleForwardedPort") || this.updateForwardedHandle(lookup, this.getForwardedProtoHeader(), "handleProto") || this.updateForwardedHandle(lookup, this.getForwardedHttpsHeader(), "handleHttps") || this.updateForwardedHandle(lookup, this.getForwardedServerHeader(), "handleForwardedServer") || this.updateForwardedHandle(lookup, this.getForwardedCipherSuiteHeader(), "handleCipherSuite") || this.updateForwardedHandle(lookup, this.getForwardedSslSessionIdHeader(), "handleSslSessionId"));
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            void var1_2;
            throw new IllegalStateException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateForwardedHandle(MethodHandles.Lookup lookup, String headerName, String forwardedMethodName) throws NoSuchMethodException, IllegalAccessException {
        void var3_3;
        void var1_1;
        void var2_2;
        MethodType type = MethodType.methodType(Void.TYPE, HttpField.class);
        if (StringUtil.isBlank((String)headerName)) {
            return false;
        }
        return !this._handles.put((String)var2_2, (Object)var1_1.findVirtual(Forwarded.class, (String)var3_3, type));
    }

    private class Forwarded
    extends QuotedCSVParser {
        HttpConfiguration _config;
        Request _request;
        MutableHostPort _authority;
        MutableHostPort _for;
        String _proto;
        Source _protoSource;
        Boolean _secure;
        boolean _secureScheme;

        /*
         * WARNING - void declaration
         */
        public Forwarded(Request request, HttpConfiguration config) {
            void var3_3;
            void var2_2;
            super(false);
            this._protoSource = Source.UNSET;
            this._secureScheme = false;
            this._request = var2_2;
            this._config = var3_3;
            if (ForwardedRequestCustomizer.this._forcedHost != null) {
                this.getAuthority().setHostPort(ForwardedRequestCustomizer.this._forcedHost.getHostPort().getHost(), ForwardedRequestCustomizer.this._forcedHost.getHostPort().getPort(), Source.FORCED);
            }
        }

        public boolean isSecure() {
            return this._secure != null && this._secure != false;
        }

        public boolean hasFor() {
            return this._for != null && this._for._host != null;
        }

        private MutableHostPort getAuthority() {
            if (this._authority == null) {
                this._authority = new MutableHostPort();
            }
            return this._authority;
        }

        private MutableHostPort getFor() {
            if (this._for == null) {
                this._for = new MutableHostPort();
            }
            return this._for;
        }

        /*
         * WARNING - void declaration
         */
        public void handleCipherSuite(HttpField field) {
            void var1_1;
            this._request.setAttribute("javax.servlet.request.cipher_suite", var1_1.getValue());
            if (ForwardedRequestCustomizer.this.isSslIsSecure()) {
                this._secure = Boolean.TRUE;
                this._secureScheme = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void handleSslSessionId(HttpField field) {
            void var1_1;
            this._request.setAttribute("javax.servlet.request.ssl_session_id", var1_1.getValue());
            if (ForwardedRequestCustomizer.this.isSslIsSecure()) {
                this._secure = Boolean.TRUE;
                this._secureScheme = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void handleForwardedHost(HttpField field) {
            void var1_1;
            this.updateAuthority(ForwardedRequestCustomizer.getLeftMost(var1_1.getValue()), Source.XFORWARDED_HOST);
        }

        /*
         * WARNING - void declaration
         */
        public void handleForwardedFor(HttpField field) {
            void var1_1;
            HostPort hostField = new HostPort(ForwardedRequestCustomizer.getLeftMost(field.getValue()));
            this.getFor().setHostPort((HostPort)var1_1, Source.XFORWARDED_FOR);
        }

        /*
         * WARNING - void declaration
         */
        public void handleForwardedServer(HttpField field) {
            void var1_1;
            if (ForwardedRequestCustomizer.this.getProxyAsAuthority()) {
                return;
            }
            this.updateAuthority(ForwardedRequestCustomizer.getLeftMost(var1_1.getValue()), Source.XFORWARDED_SERVER);
        }

        /*
         * WARNING - void declaration
         */
        public void handleForwardedPort(HttpField field) {
            void var1_2;
            int port = HostPort.parsePort((String)ForwardedRequestCustomizer.getLeftMost(field.getValue()));
            this.updatePort((int)var1_2, Source.XFORWARDED_PORT);
        }

        /*
         * WARNING - void declaration
         */
        public void handleProto(HttpField field) {
            void var1_1;
            this.updateProto(ForwardedRequestCustomizer.getLeftMost(var1_1.getValue()), Source.XFORWARDED_PROTO);
        }

        /*
         * WARNING - void declaration
         */
        public void handleHttps(HttpField field) {
            void var1_1;
            if ("on".equalsIgnoreCase(field.getValue()) || "true".equalsIgnoreCase(field.getValue())) {
                this._secure = Boolean.TRUE;
                this.updateProto(HttpScheme.HTTPS.asString(), Source.XPROXIED_HTTPS);
                Forwarded forwarded = this;
                forwarded.updatePort(ForwardedRequestCustomizer.getSecurePort(forwarded._config), Source.XPROXIED_HTTPS);
                return;
            }
            if ("off".equalsIgnoreCase(field.getValue()) || "false".equalsIgnoreCase(field.getValue())) {
                this._secure = Boolean.FALSE;
                this.updateProto(HttpScheme.HTTP.asString(), Source.XPROXIED_HTTPS);
                this.updatePort(0, Source.XPROXIED_HTTPS);
                return;
            }
            throw new BadMessageException("Invalid value for " + var1_1.getName());
        }

        /*
         * WARNING - void declaration
         */
        public void handleRFC7239(HttpField field) {
            void var1_1;
            this.addValue(var1_1.getValue());
        }

        /*
         * WARNING - void declaration
         */
        protected void parsedParam(StringBuffer buffer, int valueLength, int paramName, int paramValue) {
            if (valueLength == 0 && paramValue > paramName) {
                void var2_3;
                int n;
                String name = StringUtil.asciiToLowerCase((String)buffer.substring(n, paramValue - 1));
                String value = buffer.substring(paramValue);
                n = -1;
                switch (var2_3.hashCode()) {
                    case 3159: {
                        if (!var2_3.equals("by")) break;
                        n = 0;
                        break;
                    }
                    case 101577: {
                        if (!var2_3.equals("for")) break;
                        n = 1;
                        break;
                    }
                    case 3208616: {
                        if (!var2_3.equals("host")) break;
                        n = 2;
                        break;
                    }
                    case 106940904: {
                        if (!var2_3.equals("proto")) break;
                        n = 3;
                    }
                }
                switch (n) {
                    case 0: {
                        if (!ForwardedRequestCustomizer.this.getProxyAsAuthority() || value.startsWith("_") || "unknown".equals(value)) break;
                        HostPort hostField = new HostPort(value);
                        this.getAuthority().setHostPort(hostField.getHost(), hostField.getPort(), Source.FORWARDED);
                        return;
                    }
                    case 1: {
                        HostPort hostField;
                        if (hostField.startsWith("_") || "unknown".equals(hostField)) break;
                        hostField = new HostPort((String)hostField);
                        this.getFor().setHostPort(hostField.getHost(), hostField.getPort(), Source.FORWARDED);
                        return;
                    }
                    case 2: {
                        void var1_1;
                        HostPort hostField;
                        if (hostField.startsWith("_") || "unknown".equals(hostField)) break;
                        hostField = new HostPort((String)hostField);
                        this.getAuthority().setHostPort(hostField.getHost(), var1_1.getPort(), Source.FORWARDED);
                        return;
                    }
                    case 3: {
                        void var1_1;
                        this.updateProto((String)var1_1, Source.FORWARDED);
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void updateAuthority(String value, Source source) {
            void var2_2;
            void var1_1;
            HostPort hostField = new HostPort(value);
            this.getAuthority().setHostPort((HostPort)var1_1, (Source)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void updatePort(int port, Source source) {
            void var2_2;
            void var1_1;
            if (ForwardedRequestCustomizer.this.getForwardedPortAsAuthority()) {
                this.getAuthority().setPort(port, source);
                return;
            }
            this.getFor().setPort((int)var1_1, (Source)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void updateProto(String proto, Source source) {
            if (source.priority() > this._protoSource.priority()) {
                void var2_2;
                void var1_1;
                this._proto = var1_1;
                this._protoSource = var2_2;
                if (this._proto.equalsIgnoreCase(this._config.getSecureScheme())) {
                    this._secure = Boolean.TRUE;
                }
            }
        }
    }

    public static enum Source {
        UNSET,
        XPROXIED_HTTPS,
        XFORWARDED_PROTO,
        XFORWARDED_SERVER,
        XFORWARDED_PORT,
        XFORWARDED_FOR,
        XFORWARDED_HOST,
        FORWARDED,
        FORCED;


        final int priority() {
            return this.ordinal();
        }
    }

    private static class MutableHostPort {
        public static final int UNSET = -1;
        public static final int IMPLIED = 0;
        String _host;
        Source _hostSource = Source.UNSET;
        int _port = -1;
        Source _portSource = Source.UNSET;

        private MutableHostPort() {
        }

        /*
         * WARNING - void declaration
         */
        public void setHostPort(String host, int port, Source source) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.setHost((String)var1_1, source);
            this.setPort((int)var2_2, (Source)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public void setHost(String host, Source source) {
            if (source.priority() > this._hostSource.priority()) {
                void var2_2;
                void var1_1;
                this._host = var1_1;
                this._hostSource = var2_2;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setPort(int port, Source source) {
            if (source.priority() > this._portSource.priority()) {
                void var2_2;
                void var1_1;
                this._port = var1_1;
                this._portSource = var2_2;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setHostPort(HostPort hostPort, Source source) {
            int n;
            if (source.priority() > this._hostSource.priority()) {
                this._host = hostPort.getHost();
                this._hostSource = source;
            }
            if ((n = hostPort.getPort()) > 0 && source.priority() > this._portSource.priority()) {
                void var2_2;
                void var1_1;
                this._port = var1_1.getPort();
                this._portSource = var2_2;
                return;
            }
            if (this._port == -1) {
                this._port = 0;
            }
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder sb = new StringBuilder("MutableHostPort{");
            sb.append("host='").append(this._host).append("'/").append((Object)this._hostSource);
            sb.append(", port=").append(this._port);
            sb.append("/").append((Object)this._portSource);
            sb.append('}');
            return var1_1.toString();
        }
    }
}

