/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ServletRequestHttpWrapper;
import org.eclipse.jetty.server.ServletResponseHttpWrapper;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Dispatcher
implements RequestDispatcher {
    private static final Logger LOG = Log.getLogger(Dispatcher.class);
    public static final String __INCLUDE_PREFIX = "javax.servlet.include.";
    public static final String __FORWARD_PREFIX = "javax.servlet.forward.";
    private final ContextHandler _contextHandler;
    private final HttpURI _uri;
    private final String _pathInContext;
    private final String _named;

    /*
     * WARNING - void declaration
     */
    public Dispatcher(ContextHandler contextHandler, HttpURI uri, String pathInContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._contextHandler = var1_1;
        this._uri = var2_2;
        this._pathInContext = var3_3;
        this._named = null;
    }

    /*
     * WARNING - void declaration
     */
    public Dispatcher(ContextHandler contextHandler, String name) throws IllegalStateException {
        void var2_2;
        void var1_1;
        this._contextHandler = var1_1;
        this._uri = null;
        this._pathInContext = null;
        this._named = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        void var2_2;
        void var1_1;
        this.forward((ServletRequest)var1_1, (ServletResponse)var2_2, DispatcherType.FORWARD);
    }

    /*
     * WARNING - void declaration
     */
    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        void var2_2;
        void var1_1;
        this.forward((ServletRequest)var1_1, (ServletResponse)var2_2, DispatcherType.ERROR);
    }

    /*
     * WARNING - void declaration
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request baseRequest = Objects.requireNonNull(Request.getBaseRequest(request));
        if (!(request instanceof HttpServletRequest)) {
            request = new ServletRequestHttpWrapper((ServletRequest)request);
        }
        if (!(response instanceof HttpServletResponse)) {
            response = new ServletResponseHttpWrapper((ServletResponse)response);
        }
        DispatcherType old_type = baseRequest.getDispatcherType();
        Attributes old_attr = baseRequest.getAttributes();
        MultiMap<String> old_query_params = baseRequest.getQueryParameters();
        try {
            baseRequest.setDispatcherType(DispatcherType.INCLUDE);
            baseRequest.getResponse().include();
            if (this._named != null) {
                ((AbstractHandler)this._contextHandler).handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                void var2_3;
                void var1_1;
                Objects.requireNonNull(this._uri);
                Dispatcher.checkUriViolations(this._uri, baseRequest);
                IncludeAttributes attr = new IncludeAttributes(old_attr);
                IncludeAttributes.access$002(attr, this._uri.getPath());
                IncludeAttributes.access$102(attr, this._contextHandler.getRequestContextPath());
                IncludeAttributes.access$202(attr, null);
                IncludeAttributes.access$302(attr, this._pathInContext);
                IncludeAttributes.access$402(attr, this._uri.getQuery());
                if (attr._query != null) {
                    Request request2 = baseRequest;
                    request2.mergeQueryParameters(request2.getQueryString(), attr._query, false);
                }
                baseRequest.setAttributes((Attributes)attr);
                ((AbstractHandler)this._contextHandler).handle(this._pathInContext, baseRequest, (HttpServletRequest)var1_1, (HttpServletResponse)var2_3);
            }
            baseRequest.setAttributes(old_attr);
            baseRequest.getResponse().included();
            baseRequest.setQueryParameters(old_query_params);
            baseRequest.resetParameters();
            baseRequest.setDispatcherType(old_type);
            return;
        }
        catch (Throwable throwable) {
            void var3_4;
            baseRequest.setAttributes(old_attr);
            baseRequest.getResponse().included();
            baseRequest.setQueryParameters(old_query_params);
            baseRequest.resetParameters();
            var3_4.setDispatcherType(old_type);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void forward(ServletRequest request, ServletResponse response, DispatcherType dispatch) throws ServletException, IOException {
        Request baseRequest = Objects.requireNonNull(Request.getBaseRequest(request));
        Response baseResponse = baseRequest.getResponse();
        baseResponse.resetForForward();
        if (!(request instanceof HttpServletRequest)) {
            request = new ServletRequestHttpWrapper((ServletRequest)request);
        }
        if (!(response instanceof HttpServletResponse)) {
            response = new ServletResponseHttpWrapper((ServletResponse)response);
        }
        HttpURI old_uri = baseRequest.getHttpURI();
        String old_context_path = baseRequest.getContextPath();
        String old_servlet_path = baseRequest.getServletPath();
        String old_path_info = baseRequest.getPathInfo();
        MultiMap<String> old_query_params = baseRequest.getQueryParameters();
        Attributes old_attr = baseRequest.getAttributes();
        DispatcherType old_type = baseRequest.getDispatcherType();
        try {
            baseRequest.setDispatcherType(dispatch);
            if (this._named != null) {
                ((AbstractHandler)this._contextHandler).handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                void var1_1;
                Objects.requireNonNull(this._uri);
                Dispatcher.checkUriViolations(this._uri, baseRequest);
                ForwardAttributes attr = new ForwardAttributes(old_attr);
                if (old_attr.getAttribute("javax.servlet.forward.request_uri") != null) {
                    ForwardAttributes.access$502(attr, (String)old_attr.getAttribute("javax.servlet.forward.path_info"));
                    ForwardAttributes.access$602(attr, (String)old_attr.getAttribute("javax.servlet.forward.query_string"));
                    ForwardAttributes.access$702(attr, (String)old_attr.getAttribute("javax.servlet.forward.request_uri"));
                    ForwardAttributes.access$802(attr, (String)old_attr.getAttribute("javax.servlet.forward.context_path"));
                    ForwardAttributes.access$902(attr, (String)old_attr.getAttribute("javax.servlet.forward.servlet_path"));
                } else {
                    ForwardAttributes.access$502(attr, old_path_info);
                    ForwardAttributes.access$602(attr, old_uri.getQuery());
                    ForwardAttributes.access$702(attr, old_uri.getPath());
                    ForwardAttributes.access$802(attr, old_context_path);
                    ForwardAttributes.access$902(attr, old_servlet_path);
                }
                HttpURI uri = new HttpURI(old_uri, this._uri);
                baseRequest.setHttpURI(uri);
                baseRequest.setContextPath(this._contextHandler.getContextPath());
                baseRequest.setServletPath(null);
                baseRequest.setPathInfo(this._pathInContext);
                if (this._uri.getQuery() != null || old_uri.getQuery() != null) {
                    try {
                        baseRequest.mergeQueryParameters(old_uri.getQuery(), this._uri.getQuery(), true);
                    }
                    catch (BadMessageException e) {
                        void var3_4;
                        if (var3_4 != DispatcherType.ERROR) {
                            throw e;
                        }
                        LOG.warn("Ignoring Original Bad Request Query String: " + old_uri, (Throwable)e);
                    }
                }
                baseRequest.setAttributes((Attributes)attr);
                ((AbstractHandler)this._contextHandler).handle(this._pathInContext, baseRequest, (HttpServletRequest)var1_1, (HttpServletResponse)response);
                if (!baseRequest.getHttpChannelState().isAsync() && !baseResponse.getHttpOutput().isClosed()) {
                    try {
                        response.getOutputStream().close();
                    }
                    catch (IllegalStateException illegalStateException) {
                        void var2_3;
                        var2_3.getWriter().close();
                    }
                }
            }
            return;
        }
        finally {
            baseRequest.setHttpURI(old_uri);
            baseRequest.setContextPath(old_context_path);
            baseRequest.setServletPath(old_servlet_path);
            baseRequest.setPathInfo(old_path_info);
            baseRequest.setQueryParameters(old_query_params);
            baseRequest.resetParameters();
            baseRequest.setAttributes(old_attr);
            baseRequest.setDispatcherType(old_type);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkUriViolations(HttpURI uri, Request baseRequest) {
        void var2_2;
        HttpChannel channel;
        Connection connection;
        HttpCompliance httpCompliance;
        Object illegalState;
        if (uri.hasViolations() && (illegalState = HttpCompliance.checkUriCompliance((HttpCompliance)(httpCompliance = (connection = (channel = baseRequest.getHttpChannel()) == null ? null : channel.getConnection()) instanceof HttpConnection ? ((HttpConnection)var2_2).getHttpCompliance() : (channel != null ? (HttpCompliance)httpCompliance.getConnector().getBean(HttpCompliance.class) : null)), (HttpURI)uri)) != null) {
            Object object;
            throw new IllegalStateException((String)object);
        }
    }

    public String toString() {
        return String.format("Dispatcher@0x%x{%s,%s}", this.hashCode(), this._named, this._uri);
    }

    private class IncludeAttributes
    extends Attributes.Wrapper {
        private String _requestURI;
        private String _contextPath;
        private String _servletPath;
        private String _pathInfo;
        private String _query;

        /*
         * WARNING - void declaration
         */
        IncludeAttributes(Attributes attributes) {
            void var2_2;
            super((Attributes)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public Object getAttribute(String key) {
            void var1_1;
            if (Dispatcher.this._named == null) {
                switch (key) {
                    case "javax.servlet.include.path_info": {
                        return this._pathInfo;
                    }
                    case "javax.servlet.include.servlet_path": {
                        return this._servletPath;
                    }
                    case "javax.servlet.include.context_path": {
                        return this._contextPath;
                    }
                    case "javax.servlet.include.query_string": {
                        return this._query;
                    }
                    case "javax.servlet.include.request_uri": {
                        return this._requestURI;
                    }
                }
            } else if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attributes.getAttribute((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Set<String> getAttributeNameSet() {
            void var1_1;
            HashSet<String> set = new HashSet<String>();
            super.getAttributeNameSet().stream().filter(name -> !name.startsWith(Dispatcher.__INCLUDE_PREFIX)).forEach(set::add);
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set.add("javax.servlet.include.path_info");
                }
                if (this._requestURI != null) {
                    set.add("javax.servlet.include.request_uri");
                }
                if (this._servletPath != null) {
                    set.add("javax.servlet.include.servlet_path");
                }
                if (this._contextPath != null) {
                    set.add("javax.servlet.include.context_path");
                }
                if (this._query != null) {
                    set.add("javax.servlet.include.query_string");
                }
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setAttribute(String key, Object value) {
            void var2_2;
            void var1_1;
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                switch (key) {
                    case "javax.servlet.include.path_info": {
                        this._pathInfo = (String)value;
                        return;
                    }
                    case "javax.servlet.include.request_uri": {
                        this._requestURI = (String)value;
                        return;
                    }
                    case "javax.servlet.include.servlet_path": {
                        this._servletPath = (String)value;
                        return;
                    }
                    case "javax.servlet.include.context_path": {
                        this._contextPath = (String)value;
                        return;
                    }
                    case "javax.servlet.include.query_string": {
                        this._query = (String)value;
                        return;
                    }
                    default: {
                        if (value == null) {
                            this._attributes.removeAttribute(key);
                            return;
                        }
                        this._attributes.setAttribute(key, value);
                        return;
                    }
                }
            }
            if (value == null) {
                this._attributes.removeAttribute(key);
                return;
            }
            this._attributes.setAttribute((String)var1_1, (Object)var2_2);
        }

        public String toString() {
            return "INCLUDE+" + this._attributes.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        /*
         * WARNING - void declaration
         */
        public void removeAttribute(String name) {
            void var1_1;
            this.setAttribute((String)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$002(IncludeAttributes x0, String x1) {
            void var1_1;
            x0._requestURI = var1_1;
            return x0._requestURI;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$102(IncludeAttributes x0, String x1) {
            void var1_1;
            x0._contextPath = var1_1;
            return x0._contextPath;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$202(IncludeAttributes x0, String x1) {
            void var1_1;
            x0._servletPath = var1_1;
            return x0._servletPath;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$302(IncludeAttributes x0, String x1) {
            void var1_1;
            x0._pathInfo = var1_1;
            return x0._pathInfo;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$402(IncludeAttributes x0, String x1) {
            void var1_1;
            x0._query = var1_1;
            return x0._query;
        }
    }

    private class ForwardAttributes
    extends Attributes.Wrapper {
        private String _requestURI;
        private String _contextPath;
        private String _servletPath;
        private String _pathInfo;
        private String _query;

        /*
         * WARNING - void declaration
         */
        ForwardAttributes(Attributes attributes) {
            void var2_2;
            super((Attributes)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public Object getAttribute(String key) {
            void var1_1;
            if (Dispatcher.this._named == null) {
                switch (key) {
                    case "javax.servlet.forward.path_info": {
                        return this._pathInfo;
                    }
                    case "javax.servlet.forward.request_uri": {
                        return this._requestURI;
                    }
                    case "javax.servlet.forward.servlet_path": {
                        return this._servletPath;
                    }
                    case "javax.servlet.forward.context_path": {
                        return this._contextPath;
                    }
                    case "javax.servlet.forward.query_string": {
                        return this._query;
                    }
                }
            }
            if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attributes.getAttribute((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Set<String> getAttributeNameSet() {
            void var1_1;
            HashSet<String> set = new HashSet<String>();
            super.getAttributeNameSet().stream().filter(name -> !name.startsWith(Dispatcher.__INCLUDE_PREFIX)).filter(name -> !name.startsWith(Dispatcher.__FORWARD_PREFIX)).forEach(set::add);
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set.add("javax.servlet.forward.path_info");
                }
                if (this._requestURI != null) {
                    set.add("javax.servlet.forward.request_uri");
                }
                if (this._servletPath != null) {
                    set.add("javax.servlet.forward.servlet_path");
                }
                if (this._contextPath != null) {
                    set.add("javax.servlet.forward.context_path");
                }
                if (this._query != null) {
                    set.add("javax.servlet.forward.query_string");
                }
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setAttribute(String key, Object value) {
            void var2_2;
            void var1_1;
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                switch (key) {
                    case "javax.servlet.forward.path_info": {
                        this._pathInfo = (String)value;
                        return;
                    }
                    case "javax.servlet.forward.request_uri": {
                        this._requestURI = (String)value;
                        return;
                    }
                    case "javax.servlet.forward.servlet_path": {
                        this._servletPath = (String)value;
                        return;
                    }
                    case "javax.servlet.forward.context_path": {
                        this._contextPath = (String)value;
                        return;
                    }
                    case "javax.servlet.forward.query_string": {
                        this._query = (String)value;
                        return;
                    }
                    default: {
                        if (value == null) {
                            this._attributes.removeAttribute(key);
                            return;
                        }
                        this._attributes.setAttribute(key, value);
                        return;
                    }
                }
            }
            if (value == null) {
                this._attributes.removeAttribute(key);
                return;
            }
            this._attributes.setAttribute((String)var1_1, (Object)var2_2);
        }

        public String toString() {
            return "FORWARD+" + this._attributes.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        /*
         * WARNING - void declaration
         */
        public void removeAttribute(String name) {
            void var1_1;
            this.setAttribute((String)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$502(ForwardAttributes x0, String x1) {
            void var1_1;
            x0._pathInfo = var1_1;
            return x0._pathInfo;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$602(ForwardAttributes x0, String x1) {
            void var1_1;
            x0._query = var1_1;
            return x0._query;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$702(ForwardAttributes x0, String x1) {
            void var1_1;
            x0._requestURI = var1_1;
            return x0._requestURI;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$802(ForwardAttributes x0, String x1) {
            void var1_1;
            x0._contextPath = var1_1;
            return x0._contextPath;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$902(ForwardAttributes x0, String x1) {
            void var1_1;
            x0._servletPath = var1_1;
            return x0._servletPath;
        }
    }
}

