/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DetectorConnectionFactory
extends AbstractConnectionFactory
implements ConnectionFactory.Detecting {
    private static final Logger LOG = Log.getLogger(DetectorConnectionFactory.class);
    private final List<ConnectionFactory.Detecting> _detectingConnectionFactories;

    /*
     * WARNING - void declaration
     */
    public DetectorConnectionFactory(ConnectionFactory.Detecting ... detectingConnectionFactories) {
        super(DetectorConnectionFactory.toProtocolString(detectingConnectionFactories));
        void var1_1;
        this._detectingConnectionFactories = Arrays.asList(detectingConnectionFactories);
        for (void detectingConnectionFactory : var1_1) {
            this.addBean(detectingConnectionFactory);
        }
    }

    private static String toProtocolString(ConnectionFactory.Detecting ... detectingConnectionFactories) {
        Object object;
        if (((ConnectionFactory.Detecting[])detectingConnectionFactories).length == 0) {
            throw new IllegalArgumentException("At least one detecting instance is required");
        }
        detectingConnectionFactories = Arrays.stream(detectingConnectionFactories).map(ConnectionFactory::getProtocol).collect(Collectors.toCollection(LinkedHashSet::new));
        Object protocol = detectingConnectionFactories.stream().collect(Collectors.joining("|", "[", "]"));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detector generated protocol name : {}", new Object[]{protocol});
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConnectionFactory.Detecting.Detection detect(ByteBuffer buffer) {
        void var2_2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detector {} detecting from buffer {} using {}", new Object[]{this.getProtocol(), BufferUtil.toHexString((ByteBuffer)buffer), this._detectingConnectionFactories});
        }
        boolean needMoreBytes = true;
        for (ConnectionFactory.Detecting detecting : this._detectingConnectionFactories) {
            ConnectionFactory.Detecting.Detection detection = detecting.detect(buffer);
            if (detection == ConnectionFactory.Detecting.Detection.RECOGNIZED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detector {} recognized bytes using {}", new Object[]{this.getProtocol(), detection});
                }
                return ConnectionFactory.Detecting.Detection.RECOGNIZED;
            }
            needMoreBytes &= detection == ConnectionFactory.Detecting.Detection.NEED_MORE_BYTES;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detector {} {}", new Object[]{this.getProtocol(), needMoreBytes ? "requires more bytes" : "failed to recognize bytes"});
        }
        if (var2_2 != false) {
            return ConnectionFactory.Detecting.Detection.NEED_MORE_BYTES;
        }
        return ConnectionFactory.Detecting.Detection.NOT_RECOGNIZED;
    }

    /*
     * WARNING - void declaration
     */
    protected static void upgradeToConnectionFactory(ConnectionFactory connectionFactory, Connector connector, EndPoint endPoint) throws IllegalStateException {
        void var1_1;
        void var2_2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Upgrading to connection factory {}", new Object[]{connectionFactory});
        }
        if (connectionFactory == null) {
            throw new IllegalStateException("Cannot upgrade: connection factory must not be null for " + endPoint);
        }
        Connection nextConnection = connectionFactory.newConnection(connector, endPoint);
        if (!(nextConnection instanceof Connection.UpgradeTo)) {
            throw new IllegalStateException("Cannot upgrade: " + nextConnection + " does not implement " + Connection.UpgradeTo.class.getName() + " for " + endPoint);
        }
        var2_2.upgrade((Connection)var1_1);
        if (LOG.isDebugEnabled()) {
            ConnectionFactory connectionFactory2;
            LOG.debug("Upgraded to connection factory {} and released buffer", new Object[]{connectionFactory2});
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void nextProtocol(Connector connector, EndPoint endPoint, ByteBuffer buffer) throws IllegalStateException {
        void var2_2;
        void var1_1;
        void var3_3;
        String nextProtocol = this.findNextProtocol(connector);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detector {} detection unsuccessful, found '{}' as the next protocol to upgrade to", new Object[]{this.getProtocol(), nextProtocol});
        }
        if (nextProtocol == null) {
            throw new IllegalStateException("Cannot find protocol following '" + this.getProtocol() + "' in connector's protocol list " + connector.getProtocols() + " for " + endPoint);
        }
        DetectorConnectionFactory.upgradeToConnectionFactory(connector.getConnectionFactory((String)var3_3), (Connector)var1_1, (EndPoint)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        void var2_2;
        void var1_1;
        return this.configure(new DetectorConnection(endPoint, connector), (Connector)var1_1, (EndPoint)var2_2);
    }

    private static class DetectionFailureException
    extends RuntimeException {
        /*
         * WARNING - void declaration
         */
        public DetectionFailureException(Throwable cause) {
            super((Throwable)var1_1);
            void var1_1;
        }
    }

    private class DetectorConnection
    extends AbstractConnection
    implements Connection.UpgradeFrom,
    Connection.UpgradeTo {
        private final Connector _connector;
        private final ByteBuffer _buffer;

        /*
         * WARNING - void declaration
         */
        private DetectorConnection(EndPoint endp, Connector connector) {
            void var3_3;
            void var2_2;
            super((EndPoint)var2_2, connector.getExecutor());
            this._connector = connector;
            this._buffer = var3_3.getByteBufferPool().acquire(this.getInputBufferSize(), true);
        }

        /*
         * WARNING - void declaration
         */
        public void onUpgradeTo(ByteBuffer buffer) {
            void var1_1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detector {} copying unconsumed buffer {}", new Object[]{DetectorConnectionFactory.this.getProtocol(), BufferUtil.toDetailString((ByteBuffer)buffer)});
            }
            BufferUtil.append((ByteBuffer)this._buffer, (ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public ByteBuffer onUpgradeFrom() {
            if (this._buffer.hasRemaining()) {
                void var1_1;
                ByteBuffer unconsumed = ByteBuffer.allocateDirect(this._buffer.remaining());
                unconsumed.put(this._buffer);
                unconsumed.flip();
                this._connector.getByteBufferPool().release(this._buffer);
                return var1_1;
            }
            return null;
        }

        public void onOpen() {
            super.onOpen();
            if (!this.detectAndUpgrade()) {
                this.fillInterested();
            }
        }

        /*
         * WARNING - void declaration
         */
        public void onFillable() {
            try {
                while (BufferUtil.space((ByteBuffer)this._buffer) > 0) {
                    int fill = this.getEndPoint().fill(this._buffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Detector {} filled buffer with {} bytes", new Object[]{DetectorConnectionFactory.this.getProtocol(), fill});
                    }
                    if (fill < 0) {
                        this._connector.getByteBufferPool().release(this._buffer);
                        this.getEndPoint().shutdownOutput();
                        return;
                    }
                    if (fill == 0) {
                        this.fillInterested();
                        return;
                    }
                    if (!this.detectAndUpgrade()) continue;
                    return;
                }
                LOG.warn("Detector {} failed to detect upgrade target on {} for {}", new Object[]{DetectorConnectionFactory.this.getProtocol(), DetectorConnectionFactory.this._detectingConnectionFactories, this.getEndPoint()});
                this.releaseAndClose();
                return;
            }
            catch (Throwable x) {
                void var1_2;
                LOG.warn("Detector {} error for {}", new Object[]{DetectorConnectionFactory.this.getProtocol(), this.getEndPoint(), var1_2});
                this.releaseAndClose();
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean detectAndUpgrade() {
            int n;
            if (BufferUtil.isEmpty((ByteBuffer)this._buffer)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detector {} skipping detection on an empty buffer", new Object[]{DetectorConnectionFactory.this.getProtocol()});
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detector {} performing detection with {} bytes", new Object[]{DetectorConnectionFactory.this.getProtocol(), this._buffer.remaining()});
            }
            boolean notRecognized = true;
            for (ConnectionFactory.Detecting detectingConnectionFactory : DetectorConnectionFactory.this._detectingConnectionFactories) {
                ConnectionFactory.Detecting.Detection detection = detectingConnectionFactory.detect(this._buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detector {} performed detection from {} with {} which returned {}", new Object[]{DetectorConnectionFactory.this.getProtocol(), BufferUtil.toDetailString((ByteBuffer)this._buffer), detectingConnectionFactory, detection});
                }
                if (detection == ConnectionFactory.Detecting.Detection.RECOGNIZED) {
                    try {
                        void var3_6;
                        Connection nextConnection = var3_6.newConnection(this._connector, this.getEndPoint());
                        if (!(nextConnection instanceof Connection.UpgradeTo)) {
                            throw new IllegalStateException("Cannot upgrade: " + nextConnection + " does not implement " + Connection.UpgradeTo.class.getName());
                        }
                        this.getEndPoint().upgrade(nextConnection);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Detector {} upgraded to {}", new Object[]{DetectorConnectionFactory.this.getProtocol(), nextConnection});
                        }
                        return true;
                    }
                    catch (DetectionFailureException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Detector {} failed to upgrade, rethrowing", new Object[]{DetectorConnectionFactory.this.getProtocol(), e});
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        void var1_4;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Detector {} failed to upgrade", new Object[]{DetectorConnectionFactory.this.getProtocol()});
                        }
                        this.releaseAndClose();
                        throw new DetectionFailureException((Throwable)var1_4);
                    }
                }
                n &= detection == ConnectionFactory.Detecting.Detection.NOT_RECOGNIZED ? 1 : 0;
            }
            if (n != 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detector {} failed to detect a known protocol, falling back to nextProtocol()", new Object[]{DetectorConnectionFactory.this.getProtocol()});
                }
                DetectorConnectionFactory.this.nextProtocol(this._connector, this.getEndPoint(), this._buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detector {} call to nextProtocol() succeeded, assuming upgrade performed", new Object[]{DetectorConnectionFactory.this.getProtocol()});
                }
                return true;
            }
            return false;
        }

        private void releaseAndClose() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detector {} releasing buffer and closing", new Object[]{DetectorConnectionFactory.this.getProtocol()});
            }
            this._connector.getByteBufferPool().release(this._buffer);
            this.close();
        }
    }
}

